/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.workspace.Workspace;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.SwingUtilities;

public abstract class RSCursorMover
implements Runnable {
    private ViewDataModel m_ViewDataModel = null;
    private int m_CurRow = 0;
    private int m_DestRow = 0;
    private int m_TimeCost = 0;
    private boolean m_AbsoluteSucessfully = false;

    public ViewDataModel getViewDataModel() {
        return this.m_ViewDataModel;
    }

    public int getCurrentRow() {
        return this.m_CurRow;
    }

    public int getDestRow() {
        return this.m_DestRow;
    }

    RSCursorMover(int curRow, int destRow, ViewDataModel model) {
        this.m_ViewDataModel = model;
        this.m_CurRow = curRow;
        this.m_DestRow = destRow;
    }

    protected abstract void runInEventDispatchThread();

    protected void runInNonEventDispatchThread() {
        ResultSet rs = this.m_ViewDataModel.getDataManager().getResultSet();
        long tBegin = 0L;
        long tEnd = 0L;
        tBegin = System.currentTimeMillis();
        try {
            int destRow = this.m_DestRow - (this.m_DestRow - 1) % rs.getFetchSize();
            this.m_AbsoluteSucessfully = rs.absolute(destRow);
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        tEnd = System.currentTimeMillis();
        this.m_TimeCost = (int)(tEnd - tBegin);
    }

    @Override
    public void run() {
        this.runInNonEventDispatchThread();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RSCursorMover.this.m_AbsoluteSucessfully) {
                    RSCursorMover.this.m_ViewDataModel.getRSAbsoluteEstimator().UpdateAbsolutingRSTime(RSCursorMover.this.m_CurRow, RSCursorMover.this.m_DestRow, RSCursorMover.this.m_TimeCost);
                }
                RSCursorMover.this.runInEventDispatchThread();
            }
        });
    }
}

