/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.workspace.Workspace;
import java.sql.ResultSet;
import java.sql.SQLException;

class RSAbsoluteEstimator {
    private static final int NEW_THREAD_LOWER_OFFSET = 30000;
    private static final int NEW_THREAD_UPPER_OFFSET = 3000000;
    private static final int LONG_RUNNING_TIME = 3000;
    private static final int ADJUSTING_TIME_FOR_ABSOLUTING = 30;
    private ViewDataModel m_ViewDataModel = null;
    private long m_UpTime = -1L;
    private long m_UpRowCount = -1L;
    private long m_DownTime = -1L;
    private long m_DownRowCount = -1L;

    public RSAbsoluteEstimator(ViewDataModel model) {
        this.m_ViewDataModel = model;
    }

    public boolean needNewThread(int curRow, int destRow) {
        boolean isNeeded = false;
        int offsetRow = Math.abs(curRow - destRow);
        int time = 0;
        if (offsetRow < 30000) {
            isNeeded = false;
        } else if (offsetRow > 3000000) {
            isNeeded = true;
        } else if (curRow > destRow) {
            if (this.m_UpTime < 0L) {
                isNeeded = offsetRow > 30000;
            } else {
                time = (int)((double)offsetRow / (double)this.m_UpRowCount * (double)this.m_UpTime);
                time = time < 30 ? 30 : time;
                isNeeded = time > 3000;
            }
        } else if (this.m_DownTime < 0L) {
            isNeeded = offsetRow > 30000;
        } else {
            time = (int)((double)offsetRow / (double)this.m_DownRowCount * (double)this.m_DownTime);
            time = time < 30 ? 30 : time;
            isNeeded = time > 3000;
        }
        return isNeeded;
    }

    public boolean needLongRunningDialog(int curRow, int destRow) {
        boolean isNeeded = false;
        boolean bPromptInfo = Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("ViewData.PromptForLongRunningNavigation", false);
        if (bPromptInfo) {
            int rowCountWithLongRunMsg = Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt("ViewData.OffsetThresholdValue", 10000);
            if (Math.abs(curRow - destRow) >= rowCountWithLongRunMsg) {
                isNeeded = true;
            }
        }
        return isNeeded;
    }

    public void UpdateAbsolutingRSTime(int curRow, int destRow) {
        int timeCost = -1;
        boolean isSucessful = false;
        try {
            ResultSet rs = this.m_ViewDataModel.getDataManager().getResultSet();
            int destRowNumber = destRow - (destRow - 1) % rs.getFetchSize();
            long timeBegin = System.currentTimeMillis();
            isSucessful = rs.absolute(destRowNumber);
            long timeEnd = System.currentTimeMillis();
            timeCost = (int)(timeEnd - timeBegin);
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        if (isSucessful) {
            this.UpdateAbsolutingRSTime(curRow, destRow, timeCost);
        }
    }

    public void UpdateAbsolutingRSTime(int curRow, int destRow, int timeCost) {
        int absOffset = Math.abs(curRow - destRow);
        if (absOffset > 30000) {
            if ((double)timeCost * 3000000.0 < 3000.0 * (double)absOffset) {
                timeCost = 30;
                absOffset = 30000;
            }
            if (curRow > destRow) {
                this.m_UpRowCount = absOffset;
                this.m_UpTime = timeCost;
            } else {
                this.m_DownRowCount = absOffset;
                this.m_DownTime = timeCost;
            }
        }
    }
}

