/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.Properties;

public abstract class AbstractConnectionManager
implements ConnectionManager {
    private static WAdminResource bundle = WAdminResource.getBundle(AbstractConnectionManager.class);
    private WsAppServer m_appServer;
    private String m_sAssignedSQLID;
    private boolean m_localAppServer;
    private boolean m_bEditable;

    public AbstractConnectionManager(WsAppServer appServer, boolean bEditable) {
        this.m_appServer = appServer;
        this.m_localAppServer = appServer == null;
        this.m_bEditable = bEditable;
    }

    @Override
    public Connection getConnection() throws ViewDataException {
        if (this.m_sAssignedSQLID == null || this.m_appServer.getAssignedSQLConnection(this.m_sAssignedSQLID) == null) {
            throw new ViewDataException(bundle.getString("AbstractConnectionManager.NotInitialized.txt"));
        }
        return this.m_appServer.getAssignedSQLConnection(this.m_sAssignedSQLID);
    }

    @Override
    public void dispose() {
        if (this.m_appServer == null) {
            return;
        }
        this.m_appServer.closeAssignedSQLConnection(this.m_sAssignedSQLID);
        if (this.m_localAppServer) {
            this.m_appServer.dispose();
        }
        this.m_appServer = null;
    }

    @Override
    public WsAppServer getAppServer() {
        return this.m_appServer;
    }

    @Override
    public void setAppServer(WsAppServer server) {
        this.m_appServer = server;
    }

    protected String getServerSQLID() {
        return this.m_sAssignedSQLID;
    }

    protected void setServerSQLID(String id) {
        this.m_sAssignedSQLID = id;
    }

    @Override
    public boolean isEditable() {
        return this.m_bEditable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.m_bEditable = editable;
    }

    protected boolean isParameterized() throws MdException, RemoteException {
        String sMacroCode = this.getMacroDeclarationCode();
        return sMacroCode != null && sMacroCode.length() > 0;
    }

    protected Properties getConnectionProperties() throws MdException, RemoteException {
        Properties connProps = new Properties();
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        String permFormats = this.isEditable() ? "false" : file.getPropertyString("ViewData.ShowPermanentFormats", "true");
        connProps.put("applyFormats", permFormats);
        connProps.put("coerceNumericTypes", "true");
        if (this.isParameterized()) {
            connProps.put("sasifyTableNames", "none");
        }
        return connProps;
    }

    @Override
    public void init() throws ViewDataException {
        try {
            String sType = this.getPublicType();
            if (!this.m_localAppServer && ("ExternalFile".equals(sType) || this.m_appServer.getServerFQID().equals(this.getTableServerID()) && this.m_appServer.isOpen() || this.m_appServer.isOpen() && this.m_appServer.getOperatingSystem().equals("MVS"))) {
                this.initExistingAppServerConnection();
            } else {
                this.initNewAppServerConnection();
            }
            this.submitSASCode(this.getMacroDeclarationCode());
            if (this.isTableSpecialCharacters()) {
                this.submitSASCode("options VALIDVARNAME = ANY VALIDMEMNAME = EXTEND;");
            }
        }
        catch (MdException e) {
            throw new ViewDataException(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (WsAppServerFailException e) {
            throw new ViewDataException(e);
        }
        catch (WsAppServerCodeException e) {
            throw new ViewDataException(e);
        }
        catch (WsAppServerLibraryException e) {
            throw new ViewDataException(e);
        }
    }

    @Override
    public void submitSASCode(String code) throws WsAppServerFailException, WsAppServerCodeException {
        if (code != null && code.length() > 0) {
            this.m_appServer.submitSASCode(code);
        }
    }
}

