/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.viewdata.ColumnDisplayLabelHelper;
import com.sas.wadmin.viewdata.JDBCTableModel;
import com.sas.wadmin.viewdata.JDBCTableModelAdapter;
import com.sas.wadmin.viewdata.JDBCTableModelException;
import com.sas.wadmin.visuals.Pageable;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDefaultTableColumnHeader;
import com.sas.workspace.WsDefaultTableColumnHeaderRenderer;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ViewDataTable
extends WsTable
implements Pageable {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataTable.class);
    private JDBCTableModel m_pagedModel;
    private ColumnDisplayLabelHelper m_labelHelper;
    private boolean m_hasErrors;
    private JPopupMenu m_tablePopup;

    public ViewDataTable(JDBCTableModel mdl, ColumnDisplayLabelHelper helper) {
        super((WsAbstractTableModel)mdl);
        this.setEditable(false);
        this.setColumnAutoResizeMode(4);
        this.m_pagedModel = mdl;
        this.m_labelHelper = helper;
        this.m_pagedModel.addModelListener(new ModelListener());
        this.m_labelHelper.addPropertyChangeListener(new LabelChangeListener());
        ViewDataTablePopupListener popupListener = new ViewDataTablePopupListener();
        this.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)popupListener);
        this.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)popupListener);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new ViewDataTableColumnHeader(this.getColumnModel());
    }

    public void setJPopupMenu(JPopupMenu popupMenu) {
        this.m_tablePopup = popupMenu;
    }

    public JPopupMenu createTablePopupMenu() {
        return this.m_tablePopup;
    }

    public void reconstructModel() throws JDBCTableModelException {
        try {
            this.m_pagedModel.constructModel();
        }
        catch (JDBCTableModelException e) {
            this.m_hasErrors = true;
            throw e;
        }
    }

    protected void clear() {
        this.clearSelection();
        this.m_actReleaseAllRows.actionPerformed(null);
    }

    public boolean fetchData() {
        this.clear();
        this.m_hasErrors = false;
        try {
            this.m_pagedModel.fetchData();
        }
        catch (JDBCTableModelException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            if (cause instanceof MdException) {
                MessageUtil.displayMetadataExceptionMessage((MdException)((MdException)cause), (String)"Reading");
            } else {
                MessageUtil.displayMessage((String)cause.getLocalizedMessage(), (int)0);
            }
            this.m_hasErrors = true;
            this.firePageNumberChange();
            return false;
        }
        return true;
    }

    public void showColumn(int iModelIndex, int iPosition) {
        super.showColumn(iModelIndex, iPosition);
        this.getColumnHeader().sizeColumnToFit(iPosition);
    }

    @Override
    public void nextPage() {
        this.m_hasErrors = false;
        this.clear();
        try {
            boolean bLoadingResult = this.m_pagedModel.loadNextPage();
            if (!bLoadingResult) {
                this.m_hasErrors = true;
                MessageUtil.displayMessage((String)bundle.getString("ViewDataTable.TableLoadError.txt"), (int)0);
            } else {
                this.firePageNumberChange();
            }
        }
        catch (JDBCTableModelException e) {
            this.m_hasErrors = true;
            MessageUtil.displayMessage((String)e.getMessage(), (int)0);
        }
    }

    @Override
    public void previousPage() {
        this.m_hasErrors = false;
        this.clear();
        try {
            boolean bLoadingResult = this.m_pagedModel.loadPreviousPage();
            if (!bLoadingResult) {
                this.m_hasErrors = true;
                MessageUtil.displayMessage((String)bundle.getString("ViewDataTable.TableLoadError.txt"), (int)0);
            } else {
                this.firePageNumberChange();
            }
        }
        catch (JDBCTableModelException e) {
            this.m_hasErrors = true;
            MessageUtil.displayMessage((String)e.getMessage(), (int)0);
        }
    }

    @Override
    public void firstPage() {
        this.m_hasErrors = false;
        this.clear();
        try {
            boolean bLoadingResult = this.m_pagedModel.loadFirstPage();
            if (!bLoadingResult) {
                this.m_hasErrors = true;
                MessageUtil.displayMessage((String)bundle.getString("ViewDataTable.TableLoadError.txt"), (int)0);
            } else {
                this.firePageNumberChange();
            }
        }
        catch (JDBCTableModelException e) {
            this.m_hasErrors = true;
            MessageUtil.displayMessage((String)e.getMessage(), (int)0);
        }
    }

    @Override
    public void lastPage() {
        this.m_hasErrors = false;
        this.clear();
        try {
            boolean bLoadingResult = this.m_pagedModel.loadLastPage();
            if (!bLoadingResult) {
                this.m_hasErrors = true;
                MessageUtil.displayMessage((String)bundle.getString("ViewDataTable.TableLoadError.txt"), (int)0);
            } else {
                this.firePageNumberChange();
            }
        }
        catch (JDBCTableModelException e) {
            this.m_hasErrors = true;
            MessageUtil.displayMessage((String)e.getMessage(), (int)0);
        }
    }

    @Override
    public void gotoPage(int pageNo) {
        this.m_hasErrors = false;
        this.clear();
        try {
            boolean bLoadingResult = this.m_pagedModel.loadPage(pageNo);
            if (!bLoadingResult) {
                this.m_hasErrors = true;
                MessageUtil.displayMessage((String)bundle.getString("ViewDataTable.TableLoadError.txt"), (int)0);
            } else {
                this.firePageNumberChange();
            }
        }
        catch (JDBCTableModelException e) {
            this.m_hasErrors = true;
            MessageUtil.displayMessage((String)e.getMessage(), (int)0);
        }
    }

    public void gotoRow(int rowNo) {
        this.m_hasErrors = false;
        this.clear();
        try {
            boolean bLoadingResult = this.m_pagedModel.loadRow(rowNo);
            if (!bLoadingResult) {
                this.m_hasErrors = true;
                MessageUtil.displayMessage((String)bundle.getString("ViewDataTable.TableLoadError.txt"), (int)0);
            } else {
                this.firePageNumberChange();
                this.selectRow(this.convertRowIndexToView(this.m_pagedModel.convertToPageRowNumber(rowNo)));
            }
        }
        catch (JDBCTableModelException e) {
            this.m_hasErrors = true;
            MessageUtil.displayMessage((String)e.getMessage(), (int)0);
        }
    }

    public void gotoCell(int rowNo, int columnModelIndex) {
        this.gotoRow(rowNo);
        if (!this.hasErrors()) {
            int colNo = this.convertColumnIndexToView(columnModelIndex);
            rowNo = this.m_pagedModel.convertToPageRowNumber(rowNo);
            this.selectCell(rowNo, colNo);
        }
    }

    @Override
    public int getCurrentPageNumber() {
        return this.m_pagedModel.getCurrentPageNumber();
    }

    @Override
    public boolean isAtLastPage() {
        return this.m_pagedModel.isAtLastPage();
    }

    @Override
    public boolean isAtFirstPage() {
        return this.m_pagedModel.isAtFirstPage();
    }

    @Override
    public void addPageChangeListener(PropertyChangeListener lsnr) {
        this.addPropertyChangeListener("PageNumber", lsnr);
    }

    @Override
    public void removePageChangeListener(PropertyChangeListener lsnr) {
        this.addPropertyChangeListener("PageNumber", lsnr);
    }

    public void firePageNumberChange() {
        this.firePropertyChange("PageNumber", null, null);
    }

    public boolean isColumnHidden(int modelColumnIndex) {
        List hCols = this.getHiddenColumns();
        for (int i = 0; i < hCols.size(); ++i) {
            if (((TableColumn)hCols.get(i)).getModelIndex() != modelColumnIndex) continue;
            return true;
        }
        return false;
    }

    public int[] convertToModelIndex(int[] viewIndices) {
        int[] modelIndices = new int[viewIndices.length];
        for (int i = 0; i < viewIndices.length; ++i) {
            modelIndices[i] = this.convertColumnIndexToModel(viewIndices[i]);
        }
        return modelIndices;
    }

    protected PageFormat getPageFormat() {
        PageFormat pageFormat;
        try {
            PrinterJob pjob = PrinterJob.getPrinterJob();
            if (!Workspace.getWorkspace().isPrinterConnected(pjob)) {
                return null;
            }
            pageFormat = pjob.defaultPage();
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            pageFormat = null;
        }
        return pageFormat;
    }

    public boolean hasErrors() {
        return this.m_hasErrors;
    }

    public void removeAllColumns() {
        this.m_pagedModel.removeAllColumns();
    }

    public void sort(int[] aColumns, int[] aDirections) {
        if (this.getRowModel() instanceof WsDefaultTableRowModel) {
            if (this.m_pagedModel.isFetchDataRunning()) {
                return;
            }
            if (aColumns == null) {
                if (this.m_pagedModel.getSortedColumns() == null || this.m_pagedModel.getSortedColumns().length == 0) {
                    return;
                }
                Object aModelColumns = null;
                this.m_aSortColumns = aColumns;
                this.m_aSortDirections = aDirections;
                this.m_pagedModel.clearSortColumns();
            } else {
                int nColumns = aColumns.length;
                int[] aModelColumns = new int[nColumns];
                this.m_aSortColumns = new int[nColumns];
                for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                    this.m_aSortColumns[iColumn] = this.convertColumnIndexToModel(aColumns[iColumn]);
                    aModelColumns[iColumn] = this.m_pagedModel.getDisplayColumns()[this.m_aSortColumns[iColumn]];
                }
                this.m_aSortDirections = aDirections;
                if (this.m_pagedModel.getSortedColumns() != null && this.m_pagedModel.getSortedColumns().length == aModelColumns.length) {
                    boolean changed = false;
                    for (int i = 0; i < aModelColumns.length; ++i) {
                        if (aModelColumns[i] == this.m_pagedModel.getSortedColumns()[i] && this.m_aSortDirections[i] == this.m_pagedModel.getSortedColumnOrder()[i]) continue;
                        changed = true;
                        break;
                    }
                    if (!changed) {
                        return;
                    }
                }
                this.m_pagedModel.setSortedColumns(aModelColumns, this.m_aSortDirections);
            }
            this.fetchData();
        }
    }

    protected void updateColumnHeaderText() {
        int count = this.getColumnModel().getColumnCount();
        for (int i = 0; i < count; ++i) {
            String title = this.m_pagedModel.getColumnDisplayName(this.m_pagedModel.getDisplayColumns()[this.convertColumnIndexToModel(i)]);
            this.getColumnModel().getColumn(i).setHeaderValue(title);
        }
        this.sizeColumnsToFit();
        List list = this.getHiddenColumns();
        for (TableColumn tableColumn : list) {
            String title = this.m_pagedModel.getColumnDisplayName(this.m_pagedModel.getDisplayColumns()[tableColumn.getModelIndex()]);
            tableColumn.setHeaderValue(title);
        }
    }

    static /* synthetic */ int[] access$302(ViewDataTable x0, int[] x1) {
        x0.m_aSortColumns = x1;
        return x1;
    }

    static /* synthetic */ int[] access$402(ViewDataTable x0, int[] x1) {
        x0.m_aSortDirections = x1;
        return x1;
    }

    static /* synthetic */ int[] access$502(ViewDataTable x0, int[] x1) {
        x0.m_aSortColumns = x1;
        return x1;
    }

    static /* synthetic */ int[] access$602(ViewDataTable x0, int[] x1) {
        x0.m_aSortDirections = x1;
        return x1;
    }

    protected class ModelListener
    extends JDBCTableModelAdapter {
        protected ModelListener() {
        }

        @Override
        public void fetchSuccessful() {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ViewDataTable.this.firstPage();
                    int[] sortColumns = null;
                    int[] sortDir = null;
                    boolean sortColumnShown = false;
                    if (ViewDataTable.this.m_pagedModel.getSortedColumns() != null && ViewDataTable.this.m_pagedModel.getSortedColumns().length != 0) {
                        sortColumns = new int[]{ViewDataTable.this.m_pagedModel.getSortedColumns()[0]};
                        for (int i = 0; i < ViewDataTable.this.m_pagedModel.getDisplayColumns().length; ++i) {
                            if (sortColumns[0] != ViewDataTable.this.m_pagedModel.getDisplayColumns()[i]) continue;
                            sortColumns[0] = i;
                            sortDir = new int[]{ViewDataTable.this.m_pagedModel.getSortedColumnOrder()[0]};
                            sortColumnShown = true;
                            break;
                        }
                    }
                    if (sortColumnShown) {
                        ViewDataTable.access$302(ViewDataTable.this, sortColumns);
                        ViewDataTable.access$402(ViewDataTable.this, sortDir);
                    } else {
                        ViewDataTable.access$502(ViewDataTable.this, null);
                        ViewDataTable.access$602(ViewDataTable.this, null);
                    }
                    ViewDataTable.this.repaint();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }

        @Override
        public void fetchError(String msg, JDBCTableModelException e) {
            ViewDataTable.this.m_hasErrors = true;
            ViewDataTable.this.firePageNumberChange();
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            } else {
                if (cause instanceof MdException) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)((MdException)cause), (String)"Accessing");
                    return;
                }
                if (cause instanceof WsAppServerCodeException) {
                    this.displayErrorWithSASLog((WsAppServerCodeException)cause);
                    return;
                }
            }
            MessageUtil.displayMessage((String)cause.getMessage(), (int)0);
        }

        private void displayErrorWithSASLog(WsAppServerCodeException sce) {
            WsLogPropertyTab logPropertyTab = new WsLogPropertyTab(1);
            try {
                logPropertyTab.appendText(ViewDataTable.this.m_pagedModel.getAppServer().getLog());
                logPropertyTab.scrollToTop();
                MessageUtil.displayDetailsMessage((String)sce.getLocalizedMessage(), (int)0, (JComponent)logPropertyTab);
            }
            catch (WsAppServerFailException e) {
                MessageUtil.displayMessage((String)bundle.formatString("ViewDataTable.CodeSubmitLogNotAvailable.txt", (Object)e.getLocalizedMessage()), (int)0);
            }
        }
    }

    private class LabelChangeListener
    implements PropertyChangeListener {
        private LabelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("DisplayFormat")) {
                ViewDataTable.this.updateColumnHeaderText();
            }
        }
    }

    protected class ViewDataTablePopupListener
    extends WsTable.cDefaultTablePopupMenuRequestListener {
        protected ViewDataTablePopupListener() {
            super((WsTable)ViewDataTable.this);
        }

        public void popupMenuRequested(MouseEvent e) {
            if (ViewDataTable.this.m_tablePopup != null) {
                ViewDataTable.this.m_tablePopup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    protected static class ViewDataTableColumnHeader
    extends WsDefaultTableColumnHeader {
        public ViewDataTableColumnHeader(TableColumnModel mdlColumns) {
            super(mdlColumns);
        }

        protected TableCellRenderer createDefaultRenderer() {
            return new cExtendedColumnHeaderRenderer();
        }
    }

    protected static class cExtendedColumnHeaderRenderer
    extends WsDefaultTableColumnHeaderRenderer {
        private Icon m_iconType;

        protected cExtendedColumnHeaderRenderer() {
        }

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (this.m_iconType != null) {
                dim.width += this.m_iconType.getIconWidth() + this.getIconTextGap();
            }
            return dim;
        }

        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            JDBCTableModel mdl = (JDBCTableModel)((Object)tbl.getModel());
            if (mdl.getColumnCount() < 1) {
                this.m_iconType = null;
            } else {
                int displayIndex = mdl.getDisplayColumns()[tbl.convertColumnIndexToModel(iCol)];
                this.m_iconType = WsColumnMetadataUtil.getColumnTypeIcon((String)mdl.getColumnType(displayIndex));
            }
            return super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
        }

        protected void paintComponent(Graphics g) {
            int y;
            String sText;
            FontMetrics fm;
            int cxText;
            int cxMaxText;
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.getForeground());
            g.setFont(this.getFont());
            Insets insets = this.getInsets();
            int cxComp = this.getWidth() - insets.left - insets.right;
            Icon iconRight = this.getIcon();
            int cxIconsAndGaps = 0;
            if (this.m_iconType != null) {
                cxIconsAndGaps += this.m_iconType.getIconWidth() + this.getIconTextGap();
            }
            if (iconRight != null) {
                cxIconsAndGaps += iconRight.getIconWidth() + this.getIconTextGap();
            }
            if ((cxMaxText = cxComp - cxIconsAndGaps) < (cxText = SwingUtilities.computeStringWidth(fm = g.getFontMetrics(), sText = this.getText()))) {
                int iEnd = sText.length();
                while (cxMaxText < (cxText = fm.stringWidth(sText = sText.substring(0, --iEnd) + "...")) && iEnd > 2) {
                }
            }
            int cxSpace = cxComp - cxIconsAndGaps - cxText;
            int x = insets.left + cxSpace / 2;
            if (this.m_iconType != null) {
                y = (this.getHeight() - this.m_iconType.getIconHeight()) / 2;
                this.m_iconType.paintIcon((Component)((Object)this), g, x, y);
                x += this.m_iconType.getIconWidth() + this.getIconTextGap();
            }
            y = (this.getHeight() - fm.getHeight()) / 2 + fm.getAscent();
            g.drawString(sText, x, y);
            if (iconRight != null) {
                y = (this.getHeight() - iconRight.getIconHeight()) / 2;
                iconRight.paintIcon((Component)((Object)this), g, x += cxText + this.getIconTextGap(), y);
            }
        }
    }
}

