/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata;

import com.sas.metadata.remote.Column;
import com.sas.wadmin.viewdata.ColumnDisplayLabelHelper;
import com.sas.wadmin.viewdata.ViewDataFindComparable;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsCheckBoxScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class ViewDataFindPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataFindPanel.class);
    private static final String SEARCH_STRINGS_KEY = "ViewDataFindPanel.SearchString.";
    private static final int SEARCH_STRINGS_MAX = 8;
    private static final String SELECTALL_ACTION_COMMAND = "_SELECTALL_";
    private static final String CLEARALL_ACTION_COMMAND = "_CLEARALL_";
    private WAComboBox m_cmbFindText;
    private JCheckBox m_chkMatchCase;
    private WAComboBox m_cmbFindType;
    private JRadioButton m_btnUp;
    private JRadioButton m_btnDown;
    private WsCheckBoxScrollPane m_scrollColumns;
    private JButton m_btnSelectAll;
    private JButton m_btnClearAll;
    private List m_columnList;
    private ColumnDisplayLabelHelper m_labelHelper;
    public ActionListener m_actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(ViewDataFindPanel.SELECTALL_ACTION_COMMAND)) {
                ViewDataFindPanel.this.m_scrollColumns.setStatusAll(true);
            } else if (e.getActionCommand().equals(ViewDataFindPanel.CLEARALL_ACTION_COMMAND)) {
                ViewDataFindPanel.this.m_scrollColumns.setStatusAll(false);
            }
        }
    };
    private PropertyChangeListener m_labelChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("DisplayFormat")) {
                ViewDataFindPanel.this.resetCheckBoxLabels();
            }
        }
    };

    public ViewDataFindPanel(List sColumnList, ColumnDisplayLabelHelper labelHelper) {
        this.m_columnList = sColumnList;
        this.initialize();
        this.layoutWidgets();
        this.setColumnDisplayLabelHelper(labelHelper);
    }

    protected void initialize() {
        this.m_cmbFindText = new WAComboBox();
        this.m_cmbFindText.setEditable(true);
        this.m_cmbFindText.setPreferredSize(new Dimension(175, 20));
        this.m_chkMatchCase = new JCheckBox(bundle.getString("ViewDataFindPanel.MatchCase.txt"));
        this.m_chkMatchCase.setMnemonic(bundle.getString("ViewDataFindPanel.MatchCase.mnem").charAt(0));
        this.m_chkMatchCase.setToolTipText(bundle.getString("ViewDataFindPanel.MatchCase.tooltip.txt"));
        this.m_chkMatchCase.setSelected(Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("ViewDataFindPanel.CaseSensitive", false));
        this.m_cmbFindType = new WAComboBox();
        this.m_cmbFindType.addItem((Object)bundle.getString("ViewDataFindPanel.Equals.txt"));
        this.m_cmbFindType.addItem((Object)bundle.getString("ViewDataFilterTab.Contains.txt"));
        this.m_cmbFindType.addItem((Object)bundle.getString("ViewDataFilterTab.Begins.txt"));
        ButtonGroup m_grpDirection = new ButtonGroup();
        this.m_btnUp = new JRadioButton(bundle.getString("ViewDataFindPanel.Up.txt"));
        this.m_btnUp.setMnemonic(bundle.getString("ViewDataFindPanel.Up.mnem").charAt(0));
        this.m_btnUp.setToolTipText(bundle.getString("ViewDataFindPanel.Up.tooltip.txt"));
        m_grpDirection.add(this.m_btnUp);
        this.m_btnDown = new JRadioButton(bundle.getString("ViewDataFindPanel.Down.txt"));
        this.m_btnDown.setMnemonic(bundle.getString("ViewDataFindPanel.Down.mnem").charAt(0));
        this.m_btnDown.setToolTipText(bundle.getString("ViewDataFindPanel.Down.tooltip.txt"));
        this.m_btnDown.setSelected(true);
        m_grpDirection.add(this.m_btnDown);
        this.m_scrollColumns = new WsCheckBoxScrollPane();
        this.m_scrollColumns.setRowCount(5);
        for (int i = 0; i < this.m_columnList.size(); ++i) {
            this.m_scrollColumns.addElement((JCheckBox)new ColumnCheckBox((Column)this.m_columnList.get(i)));
        }
        this.m_scrollColumns.redisplay();
        this.m_scrollColumns.setPreferredSize(new Dimension(200, this.m_scrollColumns.getPreferredSize().height));
        this.m_btnSelectAll = new JButton(bundle.getString("ViewDataFindPanel.SelectAll.txt"));
        this.m_btnSelectAll.setMnemonic(bundle.getString("ViewDataFindPanel.SelectAll.mnem").charAt(0));
        this.m_btnSelectAll.setToolTipText(bundle.getString("ViewDataFindPanel.SelectAll.tooltip.txt"));
        this.m_btnSelectAll.setActionCommand(SELECTALL_ACTION_COMMAND);
        this.m_btnClearAll = new JButton(bundle.getString("ViewDataFindPanel.ClearAll.txt"));
        this.m_btnClearAll.setMnemonic(bundle.getString("ViewDataFindPanel.ClearAll.mnem").charAt(0));
        this.m_btnClearAll.setToolTipText(bundle.getString("ViewDataFindPanel.ClearAll.tooltip.txt"));
        this.m_btnClearAll.setActionCommand(CLEARALL_ACTION_COMMAND);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        WAPanel pnlDirection = new WAPanel();
        pnlDirection.setLayout((LayoutManager)new GridBagLayout());
        pnlDirection.setBorder((Border)new TitledBorder(bundle.getString("ViewDataFindPanel.DirectionPanelTitle.txt")));
        pnlDirection.add((Component)this.m_btnUp, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        pnlDirection.add((Component)this.m_btnDown, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblFindText = new JLabel(bundle.getString("ViewDataFindPanel.FindTextLabel.txt"));
        lblFindText.setLabelFor((Component)this.m_cmbFindText);
        lblFindText.setDisplayedMnemonic(bundle.getString("ViewDataFindPanel.FindTextLabel.mnem").charAt(0));
        JLabel lblFindType = new JLabel(bundle.getString("ViewDataFindPanel.FindTypeLabel.txt"));
        lblFindType.setLabelFor((Component)this.m_cmbFindType);
        lblFindType.setDisplayedMnemonic(bundle.getString("ViewDataFindPanel.FindTypeLabel.mnem").charAt(0));
        JLabel lblColumns = new JLabel(bundle.getString("ViewDataFindPanel.ColumnsLabel.txt"));
        lblColumns.setLabelFor((Component)this.m_scrollColumns);
        lblColumns.setDisplayedMnemonic(bundle.getString("ViewDataFindPanel.ColumnsLabel.mnem").charAt(0));
        this.add(lblFindText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbFindText, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(this.m_chkMatchCase, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(lblFindType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbFindType, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 5, 5), 0, 0));
        this.add((Component)pnlDirection, new GridBagConstraints(2, 1, 1, 2, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        this.add(lblColumns, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_scrollColumns, new GridBagConstraints(1, 3, 2, 3, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_btnSelectAll, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_btnClearAll, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.m_cmbFindText.requestFocus();
        this.m_btnSelectAll.addActionListener(this.m_actionListener);
        this.m_btnClearAll.addActionListener(this.m_actionListener);
        this.setHelpProduct("wdb");
        this.setHelpTopic("view_data_find");
    }

    public void moveDataToView() {
        this.m_cmbFindText.loadItems(SEARCH_STRINGS_KEY, 8);
        if (this.m_cmbFindText.getItemCount() == 0) {
            this.m_cmbFindText.setSelectedIndex(-1);
        } else {
            this.m_cmbFindText.setSelectedIndex(0);
        }
    }

    public void moveDataToStore() {
        String text = this.m_cmbFindText.getText();
        this.m_cmbFindText.saveItems(SEARCH_STRINGS_KEY, 8);
        this.m_cmbFindText.removeAllItems();
        this.m_cmbFindText.loadItems(SEARCH_STRINGS_KEY, 8);
        this.m_cmbFindText.setSelectedItem((Object)text);
        this.m_cmbFindText.requestFocus();
    }

    public void setSearchString(String searchString) {
        if (searchString != null) {
            this.m_cmbFindText.setSelectedItem((Object)searchString);
        }
    }

    public void setColumnDisplayLabelHelper(ColumnDisplayLabelHelper lblHelper) {
        if (this.m_labelHelper != null) {
            this.m_labelHelper.removePropertyChangeListener(this.m_labelChangeListener);
        }
        this.m_labelHelper = lblHelper;
        this.m_labelHelper.addPropertyChangeListener(this.m_labelChangeListener);
        this.resetCheckBoxLabels();
    }

    public boolean hasFindCondition() {
        String s = this.m_cmbFindText.getText();
        if (s == null || "".equals(s)) {
            return false;
        }
        return this.getSelectedColumns().length != 0;
    }

    public ViewDataFindComparable getFindComparable() {
        if (!this.hasFindCondition()) {
            return null;
        }
        String s = this.m_cmbFindText.getText();
        String soperator = this.m_cmbFindType.getSelectedItem().toString();
        int operator = 1;
        if (soperator.equals(bundle.getString("ViewDataFindPanel.Equals.txt"))) {
            operator = 1;
        } else if (soperator.equals(bundle.getString("ViewDataFilterTab.Contains.txt"))) {
            operator = 2;
        } else if (soperator.equals(bundle.getString("ViewDataFilterTab.Begins.txt"))) {
            operator = 3;
        }
        boolean caseSensitive = this.m_chkMatchCase.isSelected();
        return new ViewDataFindComparable(s, operator, caseSensitive);
    }

    public Column[] getSelectedColumns() {
        ArrayList<Column> selectedList = new ArrayList<Column>();
        int size = this.m_columnList.size();
        for (int i = 0; i < size; ++i) {
            if (!this.m_scrollColumns.getCheckBox(i).isSelected()) continue;
            selectedList.add(((ColumnCheckBox)this.m_scrollColumns.getCheckBox(i)).getColumn());
        }
        return selectedList.toArray(new Column[0]);
    }

    public boolean isForwardSearch() {
        return this.m_btnDown.isSelected();
    }

    private void resetCheckBoxLabels() {
        int colCount = this.m_columnList.size();
        for (int i = 0; i < colCount; ++i) {
            ColumnCheckBox checkBox = (ColumnCheckBox)this.m_scrollColumns.getCheckBox(i);
            checkBox.setText();
        }
        this.m_scrollColumns.redisplay();
    }

    private class ColumnCheckBox
    extends JCheckBox {
        private Column m_column;

        ColumnCheckBox(Column column) {
            this.m_column = column;
            this.setSelected(true);
            this.setText();
        }

        Column getColumn() {
            return this.m_column;
        }

        void setText() {
            try {
                if (ViewDataFindPanel.this.m_labelHelper != null) {
                    this.setText(ViewDataFindPanel.this.m_labelHelper.getColumnDisplayName(this.m_column));
                } else {
                    this.setText(this.m_column.getSASColumnName());
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
    }
}

