/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.viewdata.JDBCTableModel;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.ExpressionBuilderTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class ViewDataFilterTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataFilterTab.class);
    private JRadioButton m_btnNone;
    private JRadioButton m_btnSimple;
    private WAComboBox m_cmbColumn;
    private WAComboBox m_cmbFilterType;
    private WATextField m_txtSimpleValue;
    private JCheckBox m_chkApplyNOT;
    private JRadioButton m_btnComplex;
    private WATextArea m_txtComplexExpression;
    private JButton m_btnBuildExpression;
    private JButton m_btnValidate;
    private JDBCTableModel m_model;
    private ArrayList m_columnWrappers;
    private String m_filterClause;

    public ViewDataFilterTab(JDBCTableModel model) {
        this.m_model = model;
        this.m_columnWrappers = new ArrayList();
        this.constructColumnWrappers();
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        super.initialize();
        this.m_btnNone = new JRadioButton(bundle.getString("ViewDataFilterTab.None.txt"));
        this.m_btnNone.setMnemonic(bundle.getString("ViewDataFilterTab.None.mnem").charAt(0));
        this.m_btnNone.setToolTipText(bundle.getString("ViewDataFilterTab.None.tooltip.txt"));
        this.m_btnNone.setSelected(true);
        this.m_btnNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewDataFilterTab.this.setSimpleEnable(false);
                ViewDataFilterTab.this.setComplexEnable(false);
            }
        });
        this.m_btnSimple = new JRadioButton(bundle.getString("ViewDataFilterTab.Simple.txt"));
        this.m_btnSimple.setMnemonic(bundle.getString("ViewDataFilterTab.Simple.mnem").charAt(0));
        this.m_btnSimple.setToolTipText(bundle.getString("ViewDataFilterTab.Simple.tooltip.txt"));
        this.m_btnSimple.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewDataFilterTab.this.setSimpleEnable(true);
                ViewDataFilterTab.this.setComplexEnable(false);
            }
        });
        this.m_cmbColumn = new WAComboBox();
        this.m_cmbColumn.setSorted(true);
        this.m_cmbColumn.setPreferredSize(new Dimension(175, 20));
        this.addColumns();
        this.m_cmbColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewDataFilterTab.this.m_cmbFilterType.removeAllItems();
                ViewDataFilterTab.this.m_cmbFilterType.addItem((Object)FilterType.FILTERTYPE_EQUALS);
                ViewDataFilterTab.this.m_cmbFilterType.addItem((Object)FilterType.FILTERTYPE_LESSTHAN);
                ViewDataFilterTab.this.m_cmbFilterType.addItem((Object)FilterType.FILTERTYPE_LESSTHANEQUALS);
                ViewDataFilterTab.this.m_cmbFilterType.addItem((Object)FilterType.FILTERTYPE_GREATERTHAN);
                ViewDataFilterTab.this.m_cmbFilterType.addItem((Object)FilterType.FILTERTYPE_GREATERTAHNEQUALS);
                ViewDataFilterTab.this.m_cmbFilterType.addItem((Object)FilterType.FILTERTYPE_NOTEQUALS);
                String sasColType = ViewDataFilterTab.this.m_model.getColumnType(((ColumnWrapper)ViewDataFilterTab.this.m_cmbColumn.getSelectedItem()).getModelIndex());
                if ("C".equals(sasColType)) {
                    ViewDataFilterTab.this.m_cmbFilterType.addItem((Object)FilterType.FILTERTYPE_BEGINSWITH);
                    ViewDataFilterTab.this.m_cmbFilterType.addItem((Object)FilterType.FILTERTYPE_CONTAINS);
                }
            }
        });
        this.m_cmbFilterType = new WAComboBox();
        this.m_txtSimpleValue = new WATextField();
        this.m_txtSimpleValue.setToolTipText(bundle.getString("ViewDataFilterTab.ValueLabel.tooltip.txt"));
        this.m_chkApplyNOT = new JCheckBox(bundle.getString("ViewDataFilterTab.ApplyNOT.txt"));
        this.m_chkApplyNOT.setMnemonic(bundle.getString("ViewDataFilterTab.ApplyNOT.mnem").charAt(0));
        this.m_chkApplyNOT.setToolTipText(bundle.getString("ViewDataFilterTab.ApplyNOT.tooltip.txt"));
        this.m_btnComplex = new JRadioButton(bundle.getString("ViewDataFilterTab.Complex.txt"));
        this.m_btnComplex.setMnemonic(bundle.getString("ViewDataFilterTab.Complex.mnem").charAt(0));
        this.m_btnComplex.setToolTipText(bundle.getString("ViewDataFilterTab.Complex.tooltip.txt"));
        this.m_btnComplex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewDataFilterTab.this.setSimpleEnable(false);
                ViewDataFilterTab.this.setComplexEnable(true);
            }
        });
        this.m_txtComplexExpression = new WATextArea(5, 20);
        this.m_btnBuildExpression = new JButton(bundle.getString("ViewDataFilterTab.BuildExpression.txt"));
        this.m_btnBuildExpression.setMnemonic(bundle.getString("ViewDataFilterTab.BuildExpression.mnem").charAt(0));
        this.m_btnBuildExpression.setToolTipText(bundle.getString("ViewDataFilterTab.BuildExpression.tooltip.txt"));
        this.m_btnBuildExpression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewDataFilterTab.this.showExpressionBuilder();
            }
        });
        this.m_btnValidate = new JButton(bundle.getString("ViewDataFilterTab.Validate.txt"));
        this.m_btnValidate.setMnemonic(bundle.getString("ViewDataFilterTab.Validate.mnem").charAt(0));
        this.m_btnValidate.setToolTipText(bundle.getString("ViewDataFilterTab.Validate.tooltip.txt"));
        this.m_btnValidate.setVisible(false);
        ButtonGroup ckgroup = new ButtonGroup();
        ckgroup.add(this.m_btnNone);
        ckgroup.add(this.m_btnSimple);
        ckgroup.add(this.m_btnComplex);
        this.m_cmbColumn.setSelectedIndex(0);
        this.setSimpleEnable(false);
        this.setComplexEnable(false);
        this.setHelpProduct("wdb");
        this.setHelpTopic("view_data_filter");
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        JPanel pnlSimple = new JPanel();
        JLabel lblColumn = new JLabel(bundle.getString("ViewDataFilterTab.ColumnLabel.txt"));
        lblColumn.setLabelFor((Component)this.m_cmbColumn);
        lblColumn.setDisplayedMnemonic(bundle.getString("ViewDataFilterTab.ColumnLabel.mnem").charAt(0));
        JLabel lblFilterType = new JLabel(bundle.getString("ViewDataFilterTab.FilterTypeLabel.txt"));
        lblFilterType.setLabelFor((Component)this.m_cmbFilterType);
        lblFilterType.setDisplayedMnemonic(bundle.getString("ViewDataFilterTab.FilterTypeLabel.mnem").charAt(0));
        JLabel lblSimpleValue = new JLabel(bundle.getString("ViewDataFilterTab.ValueLabel.txt"));
        lblSimpleValue.setLabelFor((Component)this.m_txtSimpleValue);
        lblSimpleValue.setDisplayedMnemonic(bundle.getString("ViewDataFilterTab.ValueLabel.mnem").charAt(0));
        lblSimpleValue.setToolTipText(bundle.getString("ViewDataFilterTab.ValueLabel.tooltip.txt"));
        pnlSimple.setLayout(new GridBagLayout());
        pnlSimple.add((Component)lblColumn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 5, 0), 0, 0));
        pnlSimple.add((Component)this.m_cmbColumn, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 2, new Insets(5, 30, 5, 0), 0, 0));
        pnlSimple.add((Component)lblFilterType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 5, 0), 0, 0));
        pnlSimple.add((Component)this.m_cmbFilterType, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 30, 5, 0), 0, 0));
        pnlSimple.add((Component)lblSimpleValue, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 5, 0), 0, 0));
        pnlSimple.add((Component)this.m_txtSimpleValue, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 30, 5, 0), 0, 0));
        pnlSimple.add((Component)this.m_chkApplyNOT, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 5, 0), 0, 0));
        JScrollPane scroll = new JScrollPane((Component)this.m_txtComplexExpression);
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)scroll);
        JPanel pnlComplex = new JPanel();
        pnlComplex.setLayout(new GridBagLayout());
        pnlComplex.add((Component)scroll, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(5, 30, 5, 5), 0, 0));
        pnlComplex.add((Component)this.m_btnBuildExpression, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        pnlComplex.add((Component)this.m_btnValidate, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_btnNone, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_btnSimple, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add(pnlSimple, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_btnComplex, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.add(pnlComplex, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 30, 5, 5), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void constructColumnWrappers() {
        for (int i = 0; i < this.m_model.getColumnMetadata().size(); ++i) {
            this.m_columnWrappers.add(new ColumnWrapper(i));
        }
    }

    public String getFilterClause() {
        if (this.m_btnSimple.isSelected()) {
            try {
                int selectedIndex = this.m_cmbColumn.getSelectedIndex();
                if (selectedIndex == -1) {
                    return null;
                }
                Column column = this.m_model.getColumnMetadata(((ColumnWrapper)this.m_cmbColumn.getSelectedItem()).getModelIndex());
                String columnName = this.getSQLColumnName(column.getSASColumnName());
                String filterType = ((FilterType)this.m_cmbFilterType.getSelectedItem()).getOperator();
                String filterExpression = this.m_txtSimpleValue.getText();
                String sasColType = this.m_model.getColumnType(((ColumnWrapper)this.m_cmbColumn.getSelectedItem()).getModelIndex());
                if ("N".equals(sasColType) && (filterExpression == null || "".equals(filterExpression))) {
                    filterExpression = ".";
                    this.m_txtSimpleValue.setText(".");
                }
                String clause = filterType.equals("BW") ? columnName + " like '" + filterExpression + "%'" : (filterType.equals("CO") ? columnName + " like '%" + filterExpression + "%'" : columnName + " " + filterType + " " + this.quoteSimpleClauseValue(filterExpression, column));
                if (this.m_chkApplyNOT.isSelected()) {
                    clause = "NOT(" + clause + ")";
                }
                return clause;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        } else if (this.m_btnComplex.isSelected()) {
            return this.m_txtComplexExpression.getText();
        }
        return null;
    }

    private String quoteSimpleClauseValue(String value, Column column) {
        try {
            String sasColType = column.getSASColumnType();
            if ("C".equals(sasColType)) {
                return "'" + value + "'";
            }
            return value;
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return "";
        }
    }

    private void showExpressionBuilder() {
        try {
            List columnWrappers = this.sortColumnsByColumnName();
            ArrayList<Column> columns = new ArrayList<Column>(columnWrappers.size());
            for (int i = 0; i < columnWrappers.size(); ++i) {
                columns.add(this.m_model.getColumnMetadata(((ColumnWrapper)columnWrappers.get(i)).getModelIndex()));
            }
            ExpressionBuilderTab tabExpressionBuilder = new ExpressionBuilderTab(columns, true);
            tabExpressionBuilder.setExpression(this.m_txtComplexExpression.getText());
            tabExpressionBuilder.setUseQuotes(this.tableNeedsQuotes());
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.formatString("ViewDataExpressionBuilderDialog.Title.fmt.txt", (Object)this.m_model.getTableDisplayName()), true, (WAPanel)tabExpressionBuilder);
            dialog.setResizable(true);
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                String strExpr = tabExpressionBuilder.getExpression();
                this.m_txtComplexExpression.setText(strExpr);
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private List sortColumnsByColumnName() {
        try {
            ColumnWrapper[] columnWrappers = this.m_columnWrappers.toArray(new ColumnWrapper[0]);
            boolean swapped = false;
            for (int i = 0; i < columnWrappers.length; ++i) {
                String sASColNamei = this.m_model.getColumnMetadata(columnWrappers[i].m_columnModelIndex).getSASColumnName();
                for (int j = 0; j < this.m_columnWrappers.size(); ++j) {
                    String sASColNamej = this.m_model.getColumnMetadata(columnWrappers[j].m_columnModelIndex).getSASColumnName();
                    if (sASColNamei.compareTo(sASColNamej) >= 0) continue;
                    ColumnWrapper temp = columnWrappers[i];
                    columnWrappers[i] = columnWrappers[j];
                    columnWrappers[j] = temp;
                    swapped = true;
                }
            }
            if (swapped) {
                return new ArrayList<ColumnWrapper>(Arrays.asList(columnWrappers));
            }
            return this.m_columnWrappers;
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return null;
        }
    }

    private void addColumns() {
        int i;
        if (this.m_cmbColumn == null) {
            return;
        }
        ActionListener[] listeners = this.m_cmbColumn.getActionListeners();
        for (i = 0; i < listeners.length; ++i) {
            this.m_cmbColumn.removeActionListener(listeners[i]);
        }
        this.m_cmbColumn.removeAllItems();
        for (i = 0; i < this.m_columnWrappers.size(); ++i) {
            this.m_cmbColumn.addItem(this.m_columnWrappers.get(i));
        }
        this.m_cmbColumn.setSelectedIndex(0);
        for (i = 0; i < listeners.length; ++i) {
            this.m_cmbColumn.addActionListener(listeners[i]);
        }
    }

    void updateColumnLabels() {
        ColumnWrapper wrapper = (ColumnWrapper)this.m_cmbColumn.getSelectedItem();
        this.addColumns();
        this.m_cmbColumn.setSelectedItem((Object)wrapper);
    }

    public boolean hasClauseChanged() {
        String clause = this.getFilterClause();
        if (clause == null) {
            return clause != this.m_filterClause;
        }
        return !this.getFilterClause().equals(this.m_filterClause);
    }

    public String saveClause() {
        this.m_filterClause = this.getFilterClause();
        return this.m_filterClause;
    }

    private void setSimpleEnable(boolean enabled) {
        this.m_cmbColumn.setEnabled(enabled);
        this.m_cmbFilterType.setEnabled(enabled);
        this.m_txtSimpleValue.setEnabled(enabled);
        this.m_chkApplyNOT.setEnabled(enabled);
    }

    private void setComplexEnable(boolean enabled) {
        this.m_txtComplexExpression.setEnabled(enabled);
        this.m_btnBuildExpression.setEnabled(enabled);
        this.m_btnValidate.setEnabled(enabled);
    }

    private String getSQLColumnName(String name) throws MdException, RemoteException {
        return DBMSNamesUtil.getQuotedString((String)name, (DataTable)this.m_model.getDataTable());
    }

    private boolean tableNeedsQuotes() throws MdException, RemoteException {
        String specChar = DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)this.m_model.getDataTable());
        String preserveCase = DBMSNamesPropertyHandler.getCasePropertyValue((Root)this.m_model.getDataTable());
        return specChar.compareToIgnoreCase("Y") == 0 || preserveCase.compareToIgnoreCase("Y") == 0;
    }

    static /* synthetic */ WAdminResource access$1700() {
        return bundle;
    }

    private static class FilterType {
        private static final String OPERATOR_BEGINSWITH = "BW";
        private static final String OPERATOR_CONTAINS = "CO";
        private static final FilterType FILTERTYPE_EQUALS = new FilterType(ViewDataFilterTab.access$1700().getString("ViewDataFilterTab.Equals.txt"), "=");
        private static final FilterType FILTERTYPE_LESSTHAN = new FilterType(ViewDataFilterTab.access$1700().getString("ViewDataFilterTab.LessThan.txt"), "<");
        private static final FilterType FILTERTYPE_LESSTHANEQUALS = new FilterType(ViewDataFilterTab.access$1700().getString("ViewDataFilterTab.LessThanOrEquals.txt"), "<=");
        private static final FilterType FILTERTYPE_GREATERTHAN = new FilterType(ViewDataFilterTab.access$1700().getString("ViewDataFilterTab.GreaterThan.txt"), ">");
        private static final FilterType FILTERTYPE_GREATERTAHNEQUALS = new FilterType(ViewDataFilterTab.access$1700().getString("ViewDataFilterTab.GreaterThanOrEquals.txt"), ">=");
        private static final FilterType FILTERTYPE_NOTEQUALS = new FilterType(ViewDataFilterTab.access$1700().getString("ViewDataFilterTab.NotEqual.txt"), "NE");
        private static final FilterType FILTERTYPE_BEGINSWITH = new FilterType(ViewDataFilterTab.access$1700().getString("ViewDataFilterTab.BeginsWith.txt"), "BW");
        private static final FilterType FILTERTYPE_CONTAINS = new FilterType(ViewDataFilterTab.access$1700().getString("ViewDataFilterTab.Contains.txt"), "CO");
        private String m_displayName;
        private String m_operator;

        private FilterType(String displayName, String operator) {
            this.m_displayName = displayName;
            this.m_operator = operator;
        }

        private String getDisplayName() {
            return this.m_displayName;
        }

        private String getOperator() {
            return this.m_operator;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    private class ColumnWrapper
    implements Comparable {
        private int m_columnModelIndex;

        private ColumnWrapper(int columnModelIndex) {
            this.m_columnModelIndex = columnModelIndex;
        }

        protected int getModelIndex() {
            return this.m_columnModelIndex;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ColumnWrapper) {
                return ((ColumnWrapper)obj).m_columnModelIndex == this.m_columnModelIndex;
            }
            return false;
        }

        public int hashcode() {
            return super.hashCode();
        }

        public String toString() {
            return ViewDataFilterTab.this.m_model.getColumnDisplayName(this.m_columnModelIndex);
        }

        public int compareTo(Object o) {
            if (!(o instanceof ColumnWrapper)) {
                throw new ClassCastException("Illegal compare with ColumnWrapper");
            }
            return this.toString().compareTo(o.toString());
        }
    }
}

