/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata;

import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.wadmin.viewdata.JDBCTableModel;
import com.sas.wadmin.viewdata.RowCountListener;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class RowCount {
    private ArrayList listeners = new ArrayList();
    private ArrayList threads = new ArrayList();

    public void getRowCount(String libname, String sQLTableName, JDBCTableModel model) throws MdException, RemoteException {
        String query = "select nobs - delobs from Sashelp.Vtable where libname = '" + libname.toUpperCase() + "' and memname = " + RowCount.quoteSQLTableNameValue(model.getDataTable()) + " and memtype = 'DATA'";
        int count = new Counter(query, model.getDataTable(), model.getAppServer()).getRowCount();
        if (count >= 0) {
            this.notifyRowCountListeners(count);
            return;
        }
        query = "select count(*) from " + libname + "." + sQLTableName;
        Counter counter = new Counter(query, model.getDataTable());
        this.addThread(counter);
        counter.start();
    }

    private static String quoteSQLTableNameValue(DataTable table) throws MdException, RemoteException {
        if (table instanceof PhysicalTable) {
            return DBMSNamesUtil.getQuotedString((String)((PhysicalTable)table).getSASTableName());
        }
        return DBMSNamesUtil.getQuotedString((String)table.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WsAppServer createNewAppServer(DataTable table) throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        WsAppServer defAppServer = WsAppServer.createDefaultAppServer();
        if (defAppServer == null) {
            Workspace.getDefaultLogger().warn((Object)"Default appserver null.");
            return null;
        }
        WsAppServer appServer = null;
        try {
            ServerContext iDefault = defAppServer.getServerContext();
            SASLibrary iLib = LibraryUtil.getLibrary((DataTable)table, (ServerContext)iDefault);
            if (iLib == null) {
                Workspace.getDefaultLogger().warn((Object)"Library null.");
                WsAppServer wsAppServer = null;
                return wsAppServer;
            }
            SASLibrary m_library = LibraryUtil.getClientLibrary((SASLibrary)iLib, (ServerContext)iDefault);
            appServer = LibraryUtil.interactiveAccessPath((SASLibrary)m_library, (WsAppServer)defAppServer);
            if (appServer == null) {
                Workspace.getDefaultLogger().warn((Object)"Could not fetch appserver.");
                WsAppServer wsAppServer = null;
                return wsAppServer;
            }
            appServer.openSQLConnection();
            this.handleParameterizedTables(table, appServer);
            WsAppServer wsAppServer = appServer;
            return wsAppServer;
        }
        finally {
            if (appServer != defAppServer) {
                defAppServer.dispose();
            }
        }
    }

    private void handleParameterizedTables(DataTable table, WsAppServer appServer) throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException {
        StringBuffer buffer = new ParametersModel((Root)table).getParameterMacroCode();
        if (buffer == null) {
            return;
        }
        appServer.submitSASCode(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowCountListener(RowCountListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRowCountListener(RowCountListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRowCountListeners(int rowCount) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((RowCountListener)this.listeners.get(i)).updateRowCount(rowCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThread(Counter counter) {
        ArrayList arrayList = this.threads;
        synchronized (arrayList) {
            this.threads.add(counter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThread(Counter counter) {
        ArrayList arrayList = this.threads;
        synchronized (arrayList) {
            this.listeners.remove(counter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList arrayList = this.threads;
        synchronized (arrayList) {
            for (int i = 0; i < this.threads.size(); ++i) {
                ((Counter)this.threads.get(i)).dispose();
            }
        }
    }

    static /* synthetic */ WsAppServer access$000(RowCount x0, DataTable x1) throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        return x0.createNewAppServer(x1);
    }

    static /* synthetic */ ArrayList access$100(RowCount x0) {
        return x0.threads;
    }

    private class Counter
    implements Runnable {
        private String m_query;
        private DataTable m_table;
        private WsAppServer m_appServer;
        private byte[] semaphore = new byte[0];
        private boolean m_disposed = false;

        private Counter(String query, DataTable table) {
            this.m_query = query;
            this.m_table = table;
        }

        private Counter(String query, DataTable table, WsAppServer appServer) {
            this.m_query = query;
            this.m_table = table;
            this.m_appServer = appServer;
        }

        @Override
        public void run() {
            RowCount.this.notifyRowCountListeners(this.getRowCount());
        }

        public void start() {
            new Thread(this).start();
        }

        /*
         * Exception decompiling
         */
        private int getRowCount() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            byte[] byArray = this.semaphore;
            synchronized (this.semaphore) {
                if (this.m_appServer != null) {
                    this.m_appServer.close();
                    this.m_appServer.dispose();
                }
                this.m_disposed = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

