/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.xmlwriter;

import com.sas.codegen.AutoExtract;
import com.sas.codegen.CodeConditionOptionsUtil;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DataTableCG;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

public class XMLWriterCodegen {
    private static WAdminResource bundle = WAdminResource.getBundle(XMLWriterCodegen.class);
    private static final String ADDITIONAL_OPTIONS = "AdditionalOptions";

    public XMLWriterCodegen() {
        Workspace.getDefaultLogger().info((Object)"This is an XML table with an XML loader..");
    }

    public static void codegen(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        XMLWriterCodegen.doUWProcess(cgReq, classifierMap, "PreProcess");
        cgReq.checkTargetsForExternalTable(classifierMap);
        cgReq.checkSourceAndTarget(classifierMap);
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        DataTable sourceTable = cgReq.getSourceTable(classifierMap);
        OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)classifierMap);
        OP.setUsePropertySet(true);
        String workTableName = "work." + cgReq.getUniqueWorkTableName();
        DataTableCG sourceTableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceTable);
        String sourceTableName = sourceTableCG.getDataLocation(cgReq);
        boolean columnMapped = AutoExtract.columnMapping(classifierMap, cgReq, true, cgReq.getTargetTable(classifierMap), workTableName);
        if (columnMapped) {
            sourceTableName = workTableName;
        }
        PhysicalTableCG targetTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)cgReq.getTargetTable(classifierMap));
        String addOpts = OP.getSpecificOptionValue(ADDITIONAL_OPTIONS).toString() + " " + targetTableCG.getTargetTableOptions();
        String targetTableName = targetTableCG.getDataLocation(cgReq);
        StringBuffer tOptions = new StringBuffer();
        if (addOpts.length() > 1) {
            tOptions.append("(").append(addOpts.trim()).append(")");
        }
        cgReq.addSourceCode("data ").addSourceCode(targetTableName).addSourceCode(tOptions.toString());
        cgReq.addSourceCode(";\n");
        cgReq.indent().addSourceCode("set ").addSourceCode(sourceTableName).addSourceCode(";\n");
        cgReq.unIndent().addSourceCode("run; \n\n");
        XMLWriterCodegen.doUWProcess(cgReq, classifierMap, "PostProcess");
        cgReq.genRCSetCall("&syserr");
        if (cgReq.getJobStatus()) {
            cgReq.addCommentLine(bundle.getString("XMLWriterCodegen.JobStatus.txt"));
            cgReq.addSourceCode("%let etls_recordsBefore = 0; \n");
            if (sourceTable instanceof PhysicalTable) {
                cgReq.addSourceCode("\n").genGetNumRows((PhysicalTable)sourceTable, "etls_recordsAfter");
            } else {
                cgReq.addSourceCode("%let etls_recordsAfter = 0; \n");
            }
            cgReq.addSourceCode("%let etls_table = %nrquote(").addSourceCode(PhysicalTableCG.getTableName(targetTableName)).addSourceCode(");\n\n");
            cgReq.addSourceCode("%let etls_lib = %nrquote(").addSourceCode(PhysicalTableCG.getLibref(targetTableName)).addSourceCode(");\n\n");
        }
        XMLWriterCodegen.genCodeConditionCheck(cgReq, classifierMap);
    }

    private static void doUWProcess(CodegenRequest cgReq, ClassifierMap cm, String type) throws MdException, RemoteException {
        AssociationList transList;
        AssociationList stepList = cm.getSteps(false);
        TransformationStep ts = null;
        if (stepList != null) {
            if (stepList.size() > 0) {
                ts = (TransformationStep)stepList.get(0);
            }
        } else {
            return;
        }
        if (type.equals("PreProcess")) {
            transList = ts.getTransformationSources();
        } else if (type.equals("PostProcess")) {
            transList = ts.getTransformationTargets();
        } else {
            return;
        }
        for (int i = 0; i < transList.size(); ++i) {
            Transformation step;
            Root root = (Root)transList.get(i);
            if (!(root instanceof Transformation) || !(step = (Transformation)root).getTransformRole().equals(type)) continue;
            if (step.getIsActive() != 1) break;
            cgReq.genUWC((AbstractTransformation)step, true);
            break;
        }
    }

    public static void genCodeConditionCheck(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        TransformationStep oStep = (TransformationStep)classifierMap.getSteps(false).get(0);
        AssociationList alTriggeredEvents = oStep.getTriggeredEvents();
        if (alTriggeredEvents.isEmpty()) {
            return;
        }
        cgReq.addCommentLine(bundle.getString("XMLWriterCodegen.RCCheck.msg.txt"));
        cgReq.addSourceCode("%macro etls_writerCheck; \n\n").indent();
        for (int iEvent = 0; iEvent < alTriggeredEvents.size(); ++iEvent) {
            Event lEvent = (Event)alTriggeredEvents.get(iEvent);
            String eventRole = lEvent.getEventRole();
            if (!eventRole.equals("Condition1") && !eventRole.equals("Condition2") && !eventRole.equals("Condition3")) continue;
            String lEventCondition = lEvent.getCondition().trim();
            cgReq.addSourceCode(lEventCondition + "\n");
            cgReq.addSourceCode("%do; \n\n").indent();
            if (lEvent.getPropertySets().size() <= 0) {
                throw new CodegenException(bundle.getString("ReturnCodeCheck.NoPropertySets.msg.txt"));
            }
            PropertySet lTruePropertySet = CodeConditionOptionsUtil.getActionsPropertySet(lEvent, true);
            AssociationList lTrueProperties = lTruePropertySet.getSetProperties();
            for (int iAction = 0; iAction < lTrueProperties.size(); ++iAction) {
                Property oAction = (Property)lTrueProperties.get(iAction);
                cgReq.addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(oAction, (AbstractTransformation)oStep));
            }
            cgReq.unIndent().addSourceCode("%end; \n\n");
        }
        cgReq.unIndent().addSourceCode("%mend etls_writerCheck; \n").addSourceCode("%etls_writerCheck; \n\n");
    }
}

