/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.properties;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.sql.ITargetTableOptionsContainer;
import com.sas.wadmin.transforms.sql.properties.TablePropertiesModel;
import com.sas.workspace.WAdminResource;

public class TargetTablePropertiesModel
extends TablePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(TargetTablePropertiesModel.class);
    private static final int OPTIONCOUNT = 3;
    private static final int PROPERTYCOUNT = 5;
    private int m_iBulkload;
    private int m_iBulkloadOptions;
    protected int m_iCreateView;
    private static final String BULKLOADNAME = bundle.getString("TargetTablePropertiesModel.Property.Bulkload.txt");
    private static final String BULKLOADOPTIONSNAME = bundle.getString("TargetTablePropertiesModel.Property.BulkloadOptions.txt");
    protected static final String CREATEVIEWNAME = bundle.getString("TablePropertiesModel.Property.CreateView.txt");
    private static final Integer NO_VALUE = new Integer(Integer.MIN_VALUE);
    private IPhysicalTable m_target;
    private ITargetTableOptionsContainer m_container;

    public TargetTablePropertiesModel(IPhysicalTable target, ITargetTableOptionsContainer container) {
        super((ITable)target);
        this.m_target = target;
        this.m_container = container;
        this.setProperty(this.m_iBulkload, BULKLOADNAME, this.m_container.isUploadUsingBulkload(), TargetTablePropertiesModel.getDefaultBooleanRenderer(), true, TargetTablePropertiesModel.getDefaultBooleanEditor());
        this.setProperty(this.m_iBulkloadOptions, BULKLOADOPTIONSNAME, this.m_container.getBulkloadOptions(), TargetTablePropertiesModel.getDefaultRenderer(), true, TargetTablePropertiesModel.getDefaultEditor());
        this.setProperty(this.m_iCreateView, CREATEVIEWNAME, this.m_target.isView(), TargetTablePropertiesModel.getDefaultBooleanRenderer(), true, TargetTablePropertiesModel.getDefaultBooleanEditor());
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iCreateView = 2;
        this.m_iBulkload = 3;
        this.m_iBulkloadOptions = 4;
    }

    @Override
    protected IModelListener createListener() {
        return new QueryModelListener();
    }

    @Override
    public int getNumberOfProperties() {
        return 5;
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty == this.m_iBulkload) {
            this.m_container.setUploadUsingBulkload(((Boolean)value).booleanValue());
        } else if (iProperty == this.m_iBulkloadOptions) {
            this.m_container.setBulkloadOptions((String)value);
        } else if (iProperty == this.m_iCreateView) {
            this.m_target.setView(((Boolean)value).booleanValue());
        } else {
            super.setPropertyValue(iProperty, value);
        }
    }

    @Override
    protected void handleChange(String sAction) {
        if ("SQLTargetTable:BulkloadChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iBulkload, this.m_container.isUploadUsingBulkload());
        } else if ("SQLTargetTable:BulkloadOptionsChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iBulkloadOptions, this.m_container.getBulkloadOptions());
        } else if ("Table:ViewChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iCreateView, this.m_target.isView());
        } else {
            super.handleChange(sAction);
        }
    }

    private class QueryModelListener
    implements IModelListener {
        private QueryModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (ev.getModelObject() != TargetTablePropertiesModel.this.getTable() && ev.getModelObject() != TargetTablePropertiesModel.this.m_container) {
                return;
            }
            String sAction = ev.getType();
            if (sAction == null) {
                return;
            }
            TargetTablePropertiesModel.this.handleChange(sAction);
        }
    }
}

