/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.properties;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.wadmin.transforms.sql.properties.BaseClausePropertiesModel;
import com.sas.workspace.WAdminResource;

public class SelectPropertiesModel
extends BaseClausePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(SelectPropertiesModel.class);
    private int m_iDistinct;
    private int m_iImplicit;
    private static final int PROPERTYCOUNT = 2;
    private static final String DISTINCTNAME = bundle.getString("SelectPropertiesModel.Property.Distinct.txt");
    private static final String IMPLICITNAME = bundle.getString("SelectPropertiesModel.Property.Implicit.txt");
    private IQuery m_query;

    public SelectPropertiesModel(IQuery query) {
        super((IClause)query);
        this.m_query = query;
        this.setProperty(this.m_iDistinct, DISTINCTNAME, this.m_query.useDistinct(), SelectPropertiesModel.getDefaultBooleanRenderer(), true, SelectPropertiesModel.getDefaultBooleanEditor());
        this.setProperty(this.m_iImplicit, IMPLICITNAME, this.m_query.useImplicit(), SelectPropertiesModel.getDefaultBooleanRenderer(), true, SelectPropertiesModel.getDefaultBooleanEditor());
    }

    @Override
    protected IModelListener createListener() {
        return new QueryModelListener();
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iDistinct = 0;
        this.m_iImplicit = 1;
        super.initializePropertyIndexes();
    }

    @Override
    public int getNumberOfProperties() {
        return 2 + super.getNumberOfProperties();
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty == this.m_iDistinct) {
            this.m_query.setUseDistinct(((Boolean)value).booleanValue());
        } else if (iProperty == this.m_iImplicit) {
            this.m_query.setUseImplicit(((Boolean)value).booleanValue());
        } else {
            super.setPropertyValue(iProperty, value);
        }
    }

    @Override
    protected void handleChange(String sAction) {
        if ("SelectResults:UseDistinctChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iDistinct, this.m_query.useDistinct());
        } else if ("SelectResults:UseImplicitChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iImplicit, this.m_query.useImplicit());
        } else {
            super.handleChange(sAction);
        }
    }

    private class QueryModelListener
    implements IModelListener {
        private QueryModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (ev.getModelObject() != SelectPropertiesModel.this.m_query) {
                return;
            }
            String sAction = ev.getType();
            if (sAction == null) {
                return;
            }
            SelectPropertiesModel.this.handleChange(sAction);
        }
    }
}

