/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.properties;

import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLCreateStatement;
import com.sas.wadmin.transforms.sql.properties.BaseClausePropertiesModel;
import com.sas.workspace.WAdminResource;

public class CreatePropertiesModel
extends BaseClausePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(CreatePropertiesModel.class);
    private int m_iTarget;
    private static final int PROPERTYCOUNT = 1;
    private static final String TARGETPROPERTY = bundle.getString("CreatePropertiesModel.Property.Target.txt");
    private IQuery m_query;

    public CreatePropertiesModel(ISQLCreateStatement create) {
        super((IClause)create.getQuery());
        this.m_query = create.getQuery();
        this.setProperty(this.m_iTarget, TARGETPROPERTY, this.getTargetTableName(), CreatePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iDescription, DESCRIPTIONPROPERTY, this.m_query.getTransformModel().getCreateDescription(), CreatePropertiesModel.getDefaultRenderer(), true, CreatePropertiesModel.getDefaultEditor());
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iTarget = 0;
        super.initializePropertyIndexes();
    }

    @Override
    public int getNumberOfProperties() {
        return 1 + super.getNumberOfProperties();
    }

    @Override
    protected void handleChange(String sAction) {
        if ("DataTransform.DataTargetAdded".equals(sAction) || "DataTransform.DataTargetRemoved".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iTarget, this.getTargetTableName());
        } else if ("SQLJoinTransformMOdel:CreateDescriptionChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iDescription, this.m_query.getTransformModel().getCreateDescription());
        }
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty != this.m_iDescription) {
            throw new UnsupportedOperationException("Unknown property index: " + iProperty);
        }
        this.m_query.getTransformModel().setCreateDescription((String)value);
    }

    private String getTargetTableName() {
        IPhysicalTable table = (IPhysicalTable)this.m_query.getTargetTable();
        return table == null ? "" : table.getSASTableName();
    }
}

