/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.pfd;

import com.sas.wadmin.transforms.sql.model.JoinType;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.pfd.ClauseNode;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class SelectNode
extends ClauseNode {
    private static WAdminResource bundle = WAdminResource.getBundle(SelectNode.class);
    private WsAbstractToggleAction m_actSelectStar;
    private WsAbstractToggleAction m_actDistinct;

    public SelectNode(SelectResults select) {
        super(select);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_actDistinct = new DistinctAction();
        this.m_actSelectStar = new SelectStarAction();
    }

    @Override
    public void addPopupMenuItems(JPopupMenu menuPopup) {
        SelectResults select = (SelectResults)this.getClause();
        this.m_actDistinct.setSelected(select.useDistinct());
        this.m_actSelectStar.setSelected(select.useImplicit());
        menuPopup.add((Action)this.m_actEdit);
        menuPopup.add((Action)this.m_actDelete);
        menuPopup.addSeparator();
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actDistinct));
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actSelectStar));
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_actDistinct.setEnabled(bEditable);
        this.m_actSelectStar.setEnabled(bEditable);
        this.m_actDelete.setEnabled(false);
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        this.m_actDistinct.setActive(bActive);
        this.m_actSelectStar.setActive(bActive);
    }

    @Override
    public boolean isDropValid(Point ptEvent, List lObjects) {
        if (lObjects.size() != 1) {
            return false;
        }
        return lObjects.get(0) instanceof JoinType;
    }

    @Override
    public boolean drop(Point ptEvent, List lObjects) {
        if (lObjects.size() != 1) {
            return false;
        }
        Object obj = lObjects.get(0);
        if (obj instanceof JoinType) {
            SourceTableInterface src = this.getClause().getParentQuery().getFrom().getSource();
            this.getClause().getParentQuery().insertJoin(((JoinType)obj).getJoinType(), src);
            return true;
        }
        return false;
    }

    private class DistinctAction
    extends WsAbstractToggleAction {
        public DistinctAction() {
            super(bundle, "SelectNode.Action.SelectDistinct", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            ((SelectResults)SelectNode.this.getClause()).setUseDistinct(this.isSelected());
        }
    }

    private class SelectStarAction
    extends WsAbstractToggleAction {
        public SelectStarAction() {
            super(bundle, "SelectNode.Action.SelectStar", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            ((SelectResults)SelectNode.this.getClause()).setUseImplicit(this.isSelected());
        }
    }
}

