/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.ClauseType;
import com.sas.wadmin.transforms.sql.model.From;
import com.sas.wadmin.transforms.sql.model.Join;
import com.sas.wadmin.transforms.sql.model.JoinType;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.QueryChangeEvent;
import com.sas.wadmin.transforms.sql.model.QueryChangeListener;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.pfd.ClauseNode;
import com.sas.wadmin.transforms.sql.pfd.ColumnsListModel;
import com.sas.wadmin.transforms.sql.pfd.ColumnsListNode;
import com.sas.wadmin.transforms.sql.pfd.JoinNode;
import com.sas.wadmin.transforms.sql.pfd.SelectNode;
import com.sas.wadmin.transforms.sql.pfd.TableIconNode;
import com.sas.wadmin.transforms.sql.pfd.TableNode;
import com.sas.wadmin.transforms.sql.pfd.TemplateNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.pfd.WsPFDLink;
import com.sas.workspace.visuals.pfd.WsPFDModel;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import com.sas.workspace.visuals.pfd.WsPFDTemplateNode;
import java.awt.Point;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;

public class QueryPFDModel
extends WsPFDModel {
    private static WAdminResource bundle = WAdminResource.getBundle(QueryPFDModel.class);
    public static final int SHOW_NO_COLUMNS = 0;
    public static final int SHOW_KEYED_COLUMNS = 1;
    public static final int SHOW_ALL_COLUMNS = 2;
    private Query m_mdlQuery;
    private List m_lTableNodes;
    private QueryChangeListener m_lsnrQuery = this.createQueryModelListener();
    private boolean m_bShowColumns = true;
    private Action m_actDefault;

    public QueryPFDModel() {
        this.m_lTableNodes = new ArrayList(2);
    }

    protected QueryChangeListener createQueryModelListener() {
        return new QueryModelListener();
    }

    public void setQueryModel(Query query) {
        if (this.m_mdlQuery != null) {
            this.m_mdlQuery.getSQLModel().removeChangeListener(this.m_lsnrQuery);
        }
        this.m_mdlQuery = query;
        if (this.m_mdlQuery != null) {
            this.m_mdlQuery.getSQLModel().addChangeListener(this.m_lsnrQuery);
        }
    }

    public Query getQueryModel() {
        return this.m_mdlQuery;
    }

    public void setShowColumns(boolean bShowColumns) {
        if (this.m_bShowColumns == bShowColumns) {
            return;
        }
        this.m_bShowColumns = bShowColumns;
        this.updateTableNodes();
    }

    public boolean isShowColumns() {
        return this.m_bShowColumns;
    }

    public void setDefaultAction(Action actDefault) {
        if (this.m_actDefault == actDefault) {
            return;
        }
        this.m_actDefault = actDefault;
        for (int iPrimitive = 0; iPrimitive < this.getNumPrimitives(); ++iPrimitive) {
            PFDPrimitive primitive = this.getPrimitive(iPrimitive);
            if (!(primitive instanceof WsPFDPrimitive)) continue;
            ((WsPFDPrimitive)primitive).setDefaultAction(actDefault);
        }
    }

    public Action getDefaultAction() {
        return this.m_actDefault;
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.removeAllPrimitives();
        this.m_lTableNodes.clear();
        ClauseNode nodePrevious = null;
        ClauseNode nodeSelect = null;
        List lClauses = this.m_mdlQuery.getClauses();
        for (int iClause = 0; iClause < lClauses.size(); ++iClause) {
            ClauseInterface clause = (ClauseInterface)lClauses.get(iClause);
            if (clause == null) continue;
            if (clause instanceof From) {
                if (nodeSelect == null) continue;
                PFDAbstractNode nodeSource = this.createSourceNodes(((From)clause).getSource());
                this.addLink(nodeSource, (PFDLink)this.createLink(), (PFDAbstractNode)nodeSelect);
                continue;
            }
            ClauseNode nodeCurrent = null;
            if (clause instanceof SelectResults) {
                nodeSelect = nodeCurrent = new SelectNode((SelectResults)clause);
            } else {
                nodeCurrent = new ClauseNode(clause);
            }
            nodeCurrent.setEditable(this.isEditable());
            nodeCurrent.setDefaultAction(this.m_actDefault);
            this.addKeyedNode(clause, (PFDAbstractNode)nodeCurrent);
            if (nodePrevious != null) {
                this.addLink((PFDAbstractNode)nodePrevious, (PFDLink)this.createLink(), (PFDAbstractNode)nodeCurrent);
            }
            nodePrevious = nodeCurrent;
        }
        if (!(this.m_mdlQuery instanceof SubQuery)) {
            this.createTargetNodeAndLink(nodePrevious);
        }
        this.fireModelChange(1000, null, null);
    }

    private PFDAbstractNode createSourceNodes(SourceTableInterface source) throws MdException, RemoteException {
        Object nodeSource;
        if (source == null) {
            nodeSource = new TemplateNode(bundle.getString("QueryPFDModel.SourceTableTemplate.txt"), this.m_mdlQuery, true);
        } else if (source instanceof SourceTable) {
            nodeSource = this.createTableNode((SourceTable)source, true);
            this.m_lTableNodes.add(nodeSource);
        } else if (source instanceof SubQuery) {
            nodeSource = new ClauseNode((SubQuery)source);
        } else if (source instanceof Join) {
            nodeSource = new JoinNode((Join)source);
        } else {
            throw new UnsupportedOperationException("Source is an unknown type");
        }
        this.addKeyedNode(source, (PFDAbstractNode)nodeSource);
        ((WsPFDPrimitive)nodeSource).setEditable(this.isEditable());
        ((WsPFDPrimitive)nodeSource).setDefaultAction(this.m_actDefault);
        if (source instanceof Join) {
            Join join = (Join)source;
            this.addLinkToJoin(this.createSourceNodes(join.getLeftSide()), (PFDAbstractNode)nodeSource, "leftPort");
            this.addLinkToJoin(this.createSourceNodes(join.getRightSide()), (PFDAbstractNode)nodeSource, "rightPort");
        }
        return nodeSource;
    }

    private void addLinkToJoin(PFDAbstractNode nodeSource, PFDAbstractNode nodeJoin, String sInput) {
        WsPFDLink link = this.createLink();
        link.setFromPort(nodeSource.getOutputPort());
        link.setToPort(nodeJoin.getPort(sInput));
        this.addLink((PFDLink)link);
    }

    private void createTargetNodeAndLink(ClauseNode nodePrevious) throws MdException, RemoteException {
        PFDAbstractNode nodeTable;
        TargetTable table = this.m_mdlQuery.getTargetTable();
        if (table != null) {
            nodeTable = this.createTableNode(table, false);
            this.m_lTableNodes.add(nodeTable);
        } else {
            nodeTable = new WsPFDTemplateNode(bundle.getString("QueryPFDModel.TargetTableTemplate.txt"));
        }
        this.addKeyedNode(table, nodeTable);
        ((WsPFDPrimitive)nodeTable).setEditable(this.isEditable());
        ((WsPFDPrimitive)nodeTable).setDefaultAction(this.m_actDefault);
        this.addLink((PFDAbstractNode)nodePrevious, (PFDLink)this.createLink(), nodeTable);
    }

    private PFDAbstractNode createTableNode(TableInterface table, boolean bSource) throws MdException, RemoteException {
        if (this.m_bShowColumns) {
            ColumnsListModel mdl = new ColumnsListModel(table.getDataTable());
            mdl.moveDataToModel();
            return new ColumnsListNode(table, this.m_mdlQuery, mdl, bSource);
        }
        return new TableIconNode(table, this.m_mdlQuery, bSource);
    }

    private WsPFDLink createLink() {
        WsPFDLink link = new WsPFDLink();
        link.setSelectable(false);
        return link;
    }

    public void dispose() {
    }

    private void updateTableNodes() {
        try {
            for (int iNode = 0; iNode < this.m_lTableNodes.size(); ++iNode) {
                PFDAbstractNode node = (PFDAbstractNode)this.m_lTableNodes.get(iNode);
                TableInterface table = ((TableNode)node).getTable();
                PFDAbstractNode nodeNew = this.createTableNode(table, ((TableNode)node).isSource());
                nodeNew.setCenterLocation(node.getCenterLocation());
                Vector lInputLinks = node.getInputPort().getToLinks();
                for (int iLink = 0; iLink < lInputLinks.size(); ++iLink) {
                    ((PFDLink)lInputLinks.get(iLink)).setToPort(nodeNew.getInputPort());
                }
                Vector lOutputLinks = node.getOutputPort().getFromLinks();
                for (int iLink = 0; iLink < lOutputLinks.size(); ++iLink) {
                    ((PFDLink)lOutputLinks.get(iLink)).setFromPort(nodeNew.getOutputPort());
                }
                this.removeKeyedNode(table);
                this.addKeyedNode(table, nodeNew);
                ((WsPFDPrimitive)nodeNew).setEditable(this.isEditable());
                ((WsPFDPrimitive)nodeNew).setDefaultAction(this.m_actDefault);
                this.m_lTableNodes.set(iNode, nodeNew);
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public boolean isDropValid(Point ptEvent, List lObjects) {
        if (lObjects.size() > 1) {
            return false;
        }
        Object obj = lObjects.get(0);
        if (obj instanceof ClauseType && !(obj instanceof JoinType) && obj != ClauseType.SUBQUERY) {
            ClauseType type = (ClauseType)obj;
            return this.m_mdlQuery.getClause(type) == null;
        }
        return false;
    }

    public boolean drop(Point ptEvent, List lObjects) {
        if (lObjects.size() > 1) {
            return false;
        }
        Object obj = lObjects.get(0);
        if (obj instanceof ClauseType) {
            ClauseType type = (ClauseType)obj;
            this.m_mdlQuery.addClause(type);
            return true;
        }
        return false;
    }

    protected class QueryModelListener
    implements QueryChangeListener {
        protected QueryModelListener() {
        }

        @Override
        public void queryChanged(QueryChangeEvent ev) {
            TableNode node;
            AbstractTable tbl;
            String sAction;
            System.out.println("QueryModelChange:" + ev.getAction() + ":" + ev.getClause());
            ClauseInterface clause = ev.getClause();
            ClauseInterface clauseParent = ev.getParentClause();
            if (clauseParent == null) {
                ClauseInterface clauseInterface = clauseParent = clause != null ? clause.getParentQuery() : null;
            }
            if ("unknownChanges".equals(sAction = ev.getAction()) || "ClauseAdded".equals(sAction) && clauseParent == QueryPFDModel.this.m_mdlQuery || "ClauseRemoved".equals(sAction) && clauseParent == QueryPFDModel.this.m_mdlQuery || "targetChanged".equals(sAction) && clauseParent == QueryPFDModel.this.m_mdlQuery || "targetRemoved".equals(sAction) && clauseParent == QueryPFDModel.this.m_mdlQuery || "SourceChanged".equals(sAction) && clauseParent == QueryPFDModel.this.m_mdlQuery || "SourceRemoved".equals(sAction) && clauseParent == QueryPFDModel.this.m_mdlQuery || "LeftSideChanged".equals(sAction) && clauseParent == QueryPFDModel.this.m_mdlQuery || "RightSideChanged".equals(sAction) && clauseParent == QueryPFDModel.this.m_mdlQuery || "UseImplicitChanged".equals(sAction) && clauseParent == QueryPFDModel.this.m_mdlQuery || "JoinTypeChanged".equals(sAction) && clauseParent == QueryPFDModel.this.m_mdlQuery || "AliasChanged".equals(sAction) && clauseParent == QueryPFDModel.this.m_mdlQuery) {
                try {
                    QueryPFDModel.this.moveDataToModel();
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            } else if ("JoinTypeChanged".equals(sAction)) {
                JoinNode node2 = (JoinNode)QueryPFDModel.this.getKeyedNode(clause);
                if (node2 != null) {
                    node2.refresh();
                }
            } else if (("AliasChanged".equals(sAction) || "MemberTypeChanged".equals(sAction)) && (tbl = (AbstractTable)ev.getTable()) != null && (node = (TableNode)QueryPFDModel.this.getKeyedNode(tbl)) != null) {
                node.refresh(sAction);
            }
        }
    }
}

