/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.pfd;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Key;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsCompoundIcon;
import java.rmi.RemoteException;
import javax.swing.DefaultListModel;
import javax.swing.Icon;

public class ColumnsListModel
extends DefaultListModel {
    public static final int ORIGINAL_SORT = 0;
    public static final int KEYED_SORT = 1;
    public static final int ASCENDING_SORT = 2;
    public static final int DESCENDING_SORT = 3;
    private static final int UNIQUE_KEY = 1;
    private static final int FOREIGN_KEY = 2;
    private static final int INDEX = 3;
    private static final int NONE = 4;
    private static final Icon UNIQUEKEYICON = WAdminResource.getTypeIcon((String)"UniqueKey", (boolean)true);
    private static final Icon FOREIGNKEYICON = WAdminResource.getTypeIcon((String)"ForeignKey", (boolean)true);
    private static final Icon INDEXICON = WAdminResource.getTypeIcon((String)"Index", (boolean)true);
    private static final Icon NONEICON = WAdminResource.getBlankIcon();
    private DataTable m_mdoTable;
    private ColumnValue[] m_aColumns;
    private int m_eSortOrder;

    public ColumnsListModel(DataTable mdoTable) {
        this.m_mdoTable = mdoTable;
        this.m_eSortOrder = 1;
    }

    public void setSortOrder(int eSortOrder) {
        if (this.m_eSortOrder == eSortOrder) {
            return;
        }
        this.m_eSortOrder = eSortOrder;
        this.moveDataToModelImpl();
    }

    public int getSortOrder() {
        return this.m_eSortOrder;
    }

    public void moveDataToModel() throws MdException, RemoteException {
        AssociationList lColumns = this.m_mdoTable.getColumns();
        this.m_aColumns = new ColumnValue[lColumns.size()];
        for (int iColumn = 0; iColumn < lColumns.size(); ++iColumn) {
            Column mdoColumn = (Column)lColumns.get(iColumn);
            ColumnValue column = new ColumnValue();
            column.m_sName = mdoColumn.getSASColumnName();
            column.m_eKeyType = this.getKeyedColumnType(mdoColumn);
            column.m_iconType = WsColumnMetadataUtil.getColumnTypeIcon((Column)mdoColumn);
            this.m_aColumns[iColumn] = column;
        }
        this.moveDataToModelImpl();
    }

    public Icon getIcon(Object value) {
        Icon iconKeyType;
        ColumnValue column = (ColumnValue)value;
        switch (column.m_eKeyType) {
            case 1: {
                iconKeyType = UNIQUEKEYICON;
                break;
            }
            case 2: {
                iconKeyType = FOREIGNKEYICON;
                break;
            }
            case 3: {
                iconKeyType = INDEXICON;
                break;
            }
            default: {
                iconKeyType = NONEICON;
            }
        }
        WsCompoundIcon iconCompound = new WsCompoundIcon();
        iconCompound.addIcon(iconKeyType);
        iconCompound.addIcon(column.m_iconType);
        return iconCompound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getKeyedColumnType(Column mdoColumn) throws MdException, RemoteException {
        boolean bGoToServer = mdoColumn.getObjectStore().getIsGoToServerForMetadata();
        try {
            AssociationList lKeys;
            if (!bGoToServer) {
                mdoColumn.getObjectStore().setIsGotToServerForMetadata(true);
            }
            if (!(lKeys = mdoColumn.getKeys(true)).isEmpty()) {
                for (int iKey = 0; iKey < lKeys.size(); ++iKey) {
                    Key mdoKey = (Key)lKeys.get(iKey);
                    if (!mdoKey.getCMetadataType().equals("UniqueKey")) continue;
                    int n = 1;
                    return n;
                }
                int n = 2;
                return n;
            }
            if (!mdoColumn.getIndexes(true).isEmpty()) {
                int n = 3;
                return n;
            }
            int n = 4;
            return n;
        }
        finally {
            if (!bGoToServer) {
                mdoColumn.getObjectStore().setIsGotToServerForMetadata(false);
            }
        }
    }

    private void moveDataToModelImpl() {
        this.clear();
        if (this.m_eSortOrder == 0) {
            for (int iColumn = 0; iColumn < this.m_aColumns.length; ++iColumn) {
                this.addElement(this.m_aColumns[iColumn]);
            }
        } else {
            for (int iColumn = 0; iColumn < this.m_aColumns.length; ++iColumn) {
                this.addSorted(this.m_aColumns[iColumn]);
            }
        }
    }

    private void addSorted(ColumnValue columnInsert) {
        ColumnValue column;
        int iColumn;
        for (iColumn = 0; iColumn < this.getSize() && !this.shouldInsertBefore(column = (ColumnValue)this.get(iColumn), columnInsert); ++iColumn) {
        }
        this.add(iColumn, columnInsert);
    }

    private boolean shouldInsertBefore(ColumnValue columnTest, ColumnValue columnInsert) {
        if (this.m_eSortOrder == 1) {
            return columnTest.m_eKeyType > columnInsert.m_eKeyType;
        }
        if (this.m_eSortOrder == 2) {
            return columnTest.m_sName.compareToIgnoreCase(columnInsert.m_sName) > 0;
        }
        return columnTest.m_sName.compareToIgnoreCase(columnInsert.m_sName) < 0;
    }

    private static class ColumnValue {
        protected int m_eKeyType;
        protected String m_sName;
        protected Icon m_iconType;

        private ColumnValue() {
        }

        public String toString() {
            return this.m_sName;
        }
    }
}

