/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Variable;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.OperandInterface;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLObjectInterface;
import com.sas.wadmin.transforms.sql.model.SimpleExpressionInterface;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.ExpressionParser;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TextOperand
implements OperandInterface,
SQLObjectInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(TextOperand.class);
    private static final String OPERANDEXPFEATUREMAP = "SQLTextOperand";
    private String m_text = "";
    private String m_tokenizedText = "";
    private HashMap m_tokenizedVarObjects = new HashMap();
    private SimpleExpressionInterface m_parent;
    private boolean m_bHasMissingToken;
    private FeatureMap m_featureMap;

    public TextOperand(SimpleExpressionInterface parent, String text) {
        this.m_parent = parent;
        this.m_text = text;
        try {
            this.tokenizeText();
        }
        catch (MdException exc) {
            if (this.m_parent.getSQLModel().isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public TextOperand(SimpleExpressionInterface parent, FeatureMap featureMap) {
        this.m_parent = parent;
        this.m_featureMap = featureMap;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
        try {
            this.tokenizeText();
        }
        catch (MdException exc) {
            if (this.m_parent.getSQLModel().isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public void setParent(SimpleExpressionInterface expression) {
        this.m_parent = expression;
    }

    @Override
    public CodegenRequest appendCode(CodegenRequest cgReq, boolean resetPosition) {
        cgReq.addSourceCode(this.getSQLCode(cgReq, resetPosition));
        return cgReq;
    }

    @Override
    public boolean hasText() {
        return this.m_text.trim().length() > 0;
    }

    @Override
    public String getSQLCode(CodegenRequest cgReq, boolean resetPosition) {
        StringBuffer sb = new StringBuffer();
        try {
            this.m_text = this.detokenizeText();
            this.tokenizeText();
            sb.append(this.m_text);
            if (this.m_text.length() > 200) {
                sb.insert(0, "\n");
                sb.append("\n");
            }
        }
        catch (MdException exc) {
            if (this.m_parent.getSQLModel().isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return sb.toString();
    }

    @Override
    public Root getMetadataObject() {
        return this.m_featureMap;
    }

    @Override
    public String getOperandType() {
        return "TextOperand";
    }

    @Override
    public OperandInterface copyOperand() {
        return new TextOperand(this.m_parent, this.m_text);
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        this.m_bHasMissingToken = false;
        if (this.m_featureMap == null) {
            return;
        }
        TextStore textStore = (TextStore)this.m_featureMap.getSourceCode();
        if (textStore == null) {
            if (!this.m_parent.getSQLModel().isSilentModeEnabled()) {
                MessageUtil.displayMessage((String)bundle.getString("TextOperand.TextStoreMissing.Error.txt"));
            }
            return;
        }
        this.m_tokenizedText = textStore.getStoredText().trim();
        this.m_tokenizedVarObjects.clear();
        AssociationList subVars = this.m_featureMap.getSubstitutionVariables();
        if (subVars.isEmpty()) {
            this.m_text = this.m_tokenizedText;
        } else {
            for (int i = 0; i < subVars.size(); ++i) {
                Variable var = (Variable)subVars.get(i);
                this.m_tokenizedVarObjects.put(var.getMarker(), this.findObject(var.getAssociatedObject()));
            }
            this.m_text = this.detokenizeText();
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        TextStore textStore;
        SQLModel model = this.m_parent.getSQLModel();
        MdObjectStore store = model.getObjectStore();
        String reposId = model.getRepositoryId();
        if (this.m_featureMap == null) {
            this.createNewMetadata(store, reposId);
        }
        if ((textStore = (TextStore)this.m_featureMap.getSourceCode()) == null) {
            textStore = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(store, OPERANDEXPFEATUREMAP, "TextStore", reposId);
            textStore.setName(OPERANDEXPFEATUREMAP);
            textStore.setTextRole("TextOperand");
            this.m_featureMap.setSourceCode((Text)textStore);
        }
        textStore.setStoredText(this.m_tokenizedText);
        AssociationList subVars = this.m_featureMap.getSubstitutionVariables();
        if (!subVars.isEmpty()) {
            store.removeObjectsFromStore((List)subVars);
        }
        for (String marker : this.m_tokenizedVarObjects.keySet()) {
            Root object = this.getMetadataObject(this.m_tokenizedVarObjects.get(marker));
            if (object == null) continue;
            Variable var = (Variable)Workspace.getMdFactory().createComplexMetadataObject(store, "TextOperand", "Variable", reposId);
            var.setMarker(marker);
            var.setAssociatedObject(object);
            var.setValueType("TextOperand");
            var.setOwningTransformation((AbstractTransformation)this.m_featureMap);
        }
    }

    private void createNewMetadata(MdObjectStore store, String reposId) throws MdException, RemoteException {
        this.m_featureMap = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject(store, OPERANDEXPFEATUREMAP, "FeatureMap", reposId);
        this.m_featureMap.setName(OPERANDEXPFEATUREMAP);
        this.m_featureMap.setTransformRole("TextOperand");
    }

    @Override
    public void dispose() {
        MdObjectStore store = null;
        if (this.m_parent != null) {
            store = this.m_parent.getSQLModel().getObjectStore();
        }
        if (this.m_featureMap != null) {
            try {
                AssociationList subVars;
                TextStore text;
                if (store == null) {
                    store = (MdObjectStore)this.m_featureMap.getObjectStore();
                }
                if ((text = (TextStore)this.m_featureMap.getSourceCode()) != null) {
                    store.removeObjectFromStore((CMetadata)text, null);
                }
                if (!(subVars = this.m_featureMap.getSubstitutionVariables()).isEmpty()) {
                    store.removeObjectsFromStore((List)subVars);
                }
                store.removeObjectFromStore((CMetadata)this.m_featureMap, null);
                this.m_featureMap = null;
            }
            catch (MdException me) {
                if (this.m_parent.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(me.getLocalizedMessage());
                } else {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Deleting");
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        this.m_text = null;
        this.m_tokenizedText = null;
        this.m_parent = null;
        this.m_tokenizedVarObjects.clear();
    }

    @Override
    public boolean validate() {
        int max = 255;
        if (this.m_text.length() < max) {
            return true;
        }
        int pos = this.m_text.indexOf("\n");
        if (pos == -1) {
            return false;
        }
        int start = 0;
        while (pos > -1) {
            int line = pos - start;
            if (line > max) {
                return false;
            }
            start = pos;
            pos = this.m_text.indexOf("\n", start + 2);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof TextOperand)) {
            return false;
        }
        TextOperand textOp = (TextOperand)o;
        return this.m_text.equals(textOp.getText());
    }

    public int hashcode() {
        return super.hashCode();
    }

    @Override
    public boolean containsSourceTable(TableInterface table) {
        for (String marker : this.m_tokenizedVarObjects.keySet()) {
            AbstractTable tbl;
            Object tokenObject = this.m_tokenizedVarObjects.get(marker);
            if (!(tokenObject instanceof TableColumn ? (tbl = ((TableColumn)tokenObject).getParent()) != null && tbl.equals(table) : tokenObject instanceof TableInterface && tokenObject.equals(table))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMissingTokens() {
        return this.m_bHasMissingToken;
    }

    private void tokenizeText() throws MdException, RemoteException {
        ArrayList<TableColumn> objectList = new ArrayList<TableColumn>();
        ArrayList<Boolean> foundList = new ArrayList<Boolean>();
        ArrayList<String> textList = new ArrayList<String>();
        if (this.m_parent == null) {
            return;
        }
        SQLModel sqlModel = this.m_parent.getSQLModel();
        CodegenRequest cgReq = sqlModel.getCodegenRequest();
        boolean isPassThru = sqlModel.isPassThrough();
        ArrayList<TargetTable> tables = new ArrayList<TargetTable>();
        tables.add(this.m_parent.getParentQuery().getTargetTable());
        tables.addAll(this.m_parent.getParentQuery().getAllSourceTables());
        for (int i = 0; i < tables.size(); ++i) {
            AbstractTable abTable = (AbstractTable)tables.get(i);
            List columns = abTable.getTableColumns();
            if (abTable.getDataTable() == null) continue;
            String realTableName = abTable.getDataTableName(cgReq);
            String unquotedRealTableName = abTable.getDataTableName();
            for (int k = 0; k < columns.size(); ++k) {
                TableColumn col = (TableColumn)columns.get(k);
                String colName = col.getName();
                String quotedColName = "";
                quotedColName = DBMSNamesUtil.getQuotedName((String)colName, (DataTable)abTable.getDataTable(), (boolean)true, (boolean)isPassThru);
                textList.add(colName);
                foundList.add(false);
                objectList.add(col);
                textList.add(quotedColName);
                foundList.add(false);
                objectList.add(col);
                String fullColName = "";
                fullColName = unquotedRealTableName.length() > 0 ? unquotedRealTableName + "." + colName : colName;
                String quotedFullColName = "";
                quotedFullColName = realTableName.length() > 0 ? realTableName + "." + quotedColName : quotedColName;
                textList.add(fullColName);
                foundList.add(false);
                objectList.add(col);
                textList.add(quotedFullColName);
                foundList.add(false);
                objectList.add(col);
            }
            textList.add(realTableName);
            foundList.add(false);
            textList.add(unquotedRealTableName);
            foundList.add(false);
            if (abTable.isAliased()) {
                objectList.add((TableColumn)abTable.getQueryTable());
                objectList.add((TableColumn)abTable.getQueryTable());
                continue;
            }
            objectList.add((TableColumn)abTable.getDataTable());
            objectList.add((TableColumn)abTable.getDataTable());
        }
        boolean bCase = cgReq.getCase();
        this.m_tokenizedText = ExpressionParser.tokenizeString((String)this.m_text, textList, foundList, (boolean)bCase, (char)'\"', (!isPassThru ? 1 : 0) != 0);
        if (this.m_tokenizedVarObjects == null) {
            this.m_tokenizedVarObjects = new HashMap();
        }
        this.m_tokenizedVarObjects.clear();
        for (int i = 0; i < foundList.size(); ++i) {
            if (!((Boolean)foundList.get(i)).booleanValue()) continue;
            StringBuffer varKey = new StringBuffer();
            varKey.append("[").append(i).append("]");
            Object obj = objectList.get(i);
            this.m_tokenizedVarObjects.put(varKey.toString(), obj);
        }
        this.m_text = this.detokenizeText();
    }

    private String detokenizeText() throws MdException, RemoteException {
        return this.detokenizeText(false);
    }

    private String detokenizeText(boolean useFullNameText) throws MdException, RemoteException {
        int size = this.m_tokenizedVarObjects.size();
        ArrayList<String> tokens = new ArrayList<String>(size);
        ArrayList<String> subTexts = new ArrayList<String>(size);
        for (String marker : this.m_tokenizedVarObjects.keySet()) {
            tokens.add(marker);
            Object object = this.m_tokenizedVarObjects.get(marker);
            if (object == null) {
                this.m_bHasMissingToken = true;
                continue;
            }
            subTexts.add(this.getSubstitutionText(object, useFullNameText));
        }
        if (this.m_tokenizedText == null) {
            return "";
        }
        return ExpressionParser.detokenizeString((String)this.m_tokenizedText, tokens, subTexts);
    }

    private String getSubstitutionText(Object object, boolean useFullNameText) throws MdException, RemoteException {
        String text = "";
        SQLModel model = this.m_parent.getSQLModel();
        CodegenRequest cgReq = model.getCodegenRequest();
        if (object != null) {
            if (object instanceof TableColumn) {
                TableColumn col = (TableColumn)object;
                if (col.getParent() != null) {
                    text = !useFullNameText ? col.getCodegenColumnName(cgReq, this.m_parent.getParentQuery()).toString() : col.getFullColumnName();
                } else {
                    this.m_bHasMissingToken = true;
                }
            } else if (object instanceof AbstractTable) {
                text = ((AbstractTable)object).getDataTableName(cgReq);
            }
        }
        return text;
    }

    public List getMetadataSubstitutionObjects() throws MdException, RemoteException {
        ArrayList<Root> newList = new ArrayList<Root>();
        Iterator iterKeys = this.m_tokenizedVarObjects.keySet().iterator();
        while (iterKeys.hasNext()) {
            Root meta = this.getMetadataObject(this.m_tokenizedVarObjects.get(iterKeys.next()));
            newList.add(meta);
        }
        return newList;
    }

    @Override
    public List getTableColumns() {
        ArrayList newList = new ArrayList();
        Iterator iterKeys = this.m_tokenizedVarObjects.keySet().iterator();
        while (iterKeys.hasNext()) {
            Object meta = this.m_tokenizedVarObjects.get(iterKeys.next());
            if (!(meta instanceof TableColumn)) continue;
            newList.add(meta);
        }
        return newList;
    }

    private Object findObject(Root obj) throws MdException, RemoteException {
        SQLObjectInterface ret = null;
        if (obj == null) {
            this.m_bHasMissingToken = true;
            return ret;
        }
        String objType = obj.getCMetadataType();
        if (objType.equalsIgnoreCase("Column")) {
            Column col = (Column)obj;
            DataTable dTable = col.getTable();
            AbstractTable table = null;
            if (dTable != null) {
                table = this.m_parent.getParentQuery().findTable(dTable);
            }
            if (table != null) {
                ret = table.findTableColumn(col);
            } else {
                this.m_bHasMissingToken = true;
            }
        } else if (objType.equalsIgnoreCase("QueryTable")) {
            QueryTable aliasTable = (QueryTable)obj;
            ret = this.m_parent.getParentQuery().findSourceTable(aliasTable);
        } else if (obj instanceof DataTable && (ret = this.m_parent.getParentQuery().findSourceTable((DataTable)obj)) == null) {
            this.m_bHasMissingToken = true;
        }
        return ret;
    }

    private Root getMetadataObject(Object obj) throws MdException, RemoteException {
        if (obj instanceof AbstractTable) {
            return ((AbstractTable)obj).getQueryTable();
        }
        if (obj instanceof TableColumn) {
            TableColumn col = (TableColumn)obj;
            Column metaColumn = col.getColumn();
            if (metaColumn == null) {
                col.moveDataToStore();
            }
            return col.getColumn();
        }
        if (obj instanceof Root) {
            return (Root)obj;
        }
        return null;
    }

    public String getFullNamedText() {
        String text = this.m_text;
        try {
            text = this.detokenizeText(true);
        }
        catch (MdException exc) {
            if (this.m_parent.getSQLModel().isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return text;
    }

    public String toString() {
        return this.getFullNamedText();
    }
}

