/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;

public class TargetTable
extends AbstractTable {
    public static final String BULKLOADCHANGED = "bulkloadChanged";
    public static final String BULKLOADOPTIONSCHANGED = "bulkloadOptionsChanged";
    public static final String INSERTBUFFCHANGED = "insertBuffChanged";
    private static final String PROPERTY_SET_ROLE = "TargetTableOptions";
    private static final String PROPERTY_NAME_BULKLOAD = "bulkload";
    private static final String PROPERTY_NAME_INSERTBUFF = "insertbuff";
    private static final String PROPERTY_NAME_BULKLOAD_OPTIONS = "bulkloadOptions";
    private static final boolean DEFAULT_BULKLOAD = false;
    private static final String DEFAULT_BLANK_STRING = "";
    private boolean m_bulkload = false;
    private String m_insertBuff = "";
    private String m_bulkloadOptions = "";

    public TargetTable(DataTable table) {
        super(table);
    }

    @Override
    public void dispose() {
        if (this.m_columns != null) {
            for (int i = 0; i < this.m_columns.size(); ++i) {
                TableColumn qCol = (TableColumn)this.m_columns.get(i);
                qCol.dispose();
            }
            this.m_columns.clear();
        }
        if (this.m_alias != null) {
            this.m_alias.dispose();
            this.m_alias = null;
        }
        this.m_table = null;
    }

    @Override
    public void remove() {
        try {
            PropertyHandler pHandler = this.createPropertyHandler((ClassifierMap)this.getParentQuery().getSelectObject());
            ArrayList<PropertySet> deleteProps = new ArrayList<PropertySet>();
            PropertySet propSet = pHandler.getPropertySet();
            if (propSet != null) {
                deleteProps.add(propSet);
                deleteProps.addAll((Collection<PropertySet>)pHandler.getPropertyList());
                MdObjectStore store = (MdObjectStore)this.getParentQuery().getSelectObject().getObjectStore();
                store.removeObjectsFromStore(deleteProps);
            }
        }
        catch (MdException exc) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.setParent(null);
        this.dispose();
    }

    public void genDeleteTable(CodegenRequest cgReq) {
        if (this.m_table != null) {
            try {
                cgReq.genTableDelete(this.m_table);
            }
            catch (MdException exc) {
                if (this.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(exc.getLocalizedMessage());
                } else {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    @Override
    public void genTableOptions(CodegenRequest cgReq) {
        if (this.hasTableOptions()) {
            cgReq.addSourceCode("\n");
            cgReq.indent();
            cgReq.addSourceCode("(\n");
            cgReq.indent();
            boolean targetPT = this.m_model.isTargetPassThru();
            if (this.m_bulkload && !targetPT) {
                cgReq.addSourceCode("bulkload = yes\n");
            }
            if (this.m_bulkloadOptions.length() > 0 && !targetPT) {
                cgReq.addSourceCode("bl_options = ").addSourceCode(this.m_bulkloadOptions).addSourceCode("\n");
            }
            if (this.m_insertBuff.length() > 0 && !targetPT) {
                cgReq.addSourceCode("insertbuff = ").addSourceCode(this.m_insertBuff).addSourceCode("\n");
            }
            if (this.m_options.length() > 0) {
                cgReq.addSourceCode(this.m_options).addSourceCode("\n");
            }
            cgReq.unIndent();
            cgReq.addSourceCode(")");
            cgReq.unIndent();
        }
    }

    @Override
    public boolean hasTableOptions() {
        boolean targetPT = this.m_model.isTargetPassThru();
        if (super.hasTableOptions()) {
            return true;
        }
        if (this.m_bulkload && !targetPT) {
            return true;
        }
        if (this.m_insertBuff.length() > 0 && !targetPT) {
            return true;
        }
        return this.m_bulkloadOptions.length() > 0 && !targetPT;
    }

    @Override
    public String getDataTableName() {
        String tableName = DEFAULT_BLANK_STRING;
        tableName = this.isAliased() ? this.m_alias.getAliasName() : super.getDataTableName();
        return tableName;
    }

    @Override
    public String getDataTableName(CodegenRequest cgReq) {
        String tableName;
        block6: {
            tableName = DEFAULT_BLANK_STRING;
            if (this.m_table instanceof PhysicalTable) {
                try {
                    PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)this.m_table);
                    tableName = tableCG.getTableName(cgReq, true, this.getSQLModel().isPassThrough());
                }
                catch (MdException exc) {
                    if (this.getSQLModel().isSilentModeEnabled()) {
                        System.out.print(exc.getLocalizedMessage());
                        break block6;
                    }
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            } else {
                tableName = this.getDataTableName();
            }
        }
        return tableName;
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        super.moveDataToModel();
        Select select = this.getParentQuery().getSelectObject();
        if (select != null) {
            PropertyHandler pHandler = this.createPropertyHandler((ClassifierMap)select);
            this.m_bulkload = pHandler.stringToBoolean(pHandler.getSpecificOptionValue(PROPERTY_NAME_BULKLOAD), false);
            this.m_options = pHandler.getSpecificOptionValue("AdditionalOptions");
            this.m_insertBuff = pHandler.getSpecificOptionValue(PROPERTY_NAME_INSERTBUFF);
            this.m_bulkloadOptions = pHandler.getSpecificOptionValue(PROPERTY_NAME_BULKLOAD_OPTIONS);
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        super.moveDataToStore();
        Select select = this.getParentQuery().getSelectObject();
        if (select != null) {
            PropertyHandler pHandler = this.createPropertyHandler((ClassifierMap)select);
            pHandler.setSpecificProperty(PROPERTY_NAME_BULKLOAD, pHandler.booleanToString(this.m_bulkload), PROPERTY_NAME_BULKLOAD, "=", 0, null);
            pHandler.setSpecificProperty("AdditionalOptions", this.m_options, "AdditionalOptions", DEFAULT_BLANK_STRING, 1, null);
            pHandler.setSpecificProperty(PROPERTY_NAME_INSERTBUFF, this.m_insertBuff, PROPERTY_NAME_INSERTBUFF, "=", 0, null);
            pHandler.setSpecificProperty(PROPERTY_NAME_BULKLOAD_OPTIONS, this.m_bulkloadOptions, PROPERTY_NAME_BULKLOAD_OPTIONS, DEFAULT_BLANK_STRING, 1, null);
        }
        this.updateColumnList();
    }

    private void updateColumnList() throws MdException, RemoteException {
        int size = this.m_columns.size();
        AssociationList aList = this.m_table.getColumns();
        aList.flushAll();
        aList.clear();
        for (int i = 0; i < size; ++i) {
            TableColumn tColumn = (TableColumn)this.m_columns.get(i);
            aList.addElement((Object)tColumn.getColumn());
        }
    }

    public void setColumnNumber(TableColumn tColumn, int newIndex) {
        this.m_columns.remove(tColumn);
        if (newIndex > this.m_columns.size()) {
            newIndex = this.m_columns.size();
        } else if (newIndex < 0) {
            newIndex = 0;
        }
        this.m_columns.add(newIndex, tColumn);
    }

    private PropertyHandler createPropertyHandler(ClassifierMap classifier) throws MdException, RemoteException {
        if (classifier != null) {
            return new PropertyHandler((Root)classifier, PROPERTY_SET_ROLE, true);
        }
        return null;
    }

    public boolean isBulkload() {
        return this.m_bulkload;
    }

    public void setBulkload(boolean bulkload) {
        if (this.m_bulkload == bulkload) {
            return;
        }
        this.m_bulkload = bulkload;
        this.m_model.fireChangeEvent(this, BULKLOADCHANGED);
    }

    public String getBulkloadOptions() {
        return this.m_bulkloadOptions;
    }

    public void setBulkloadOptions(String bulkloadOptions) {
        if (this.m_bulkloadOptions == bulkloadOptions) {
            return;
        }
        this.m_bulkloadOptions = bulkloadOptions;
        this.m_model.fireChangeEvent(this, BULKLOADOPTIONSCHANGED);
    }

    public String getInsertBuff() {
        return this.m_insertBuff;
    }

    public void setInsertBuff(String insertBuff) {
        if (this.m_insertBuff == insertBuff) {
            return;
        }
        this.m_insertBuff = insertBuff;
        this.m_model.fireChangeEvent(this, INSERTBUFFCHANGED);
    }

    @Override
    public boolean isChangeViewSupported() {
        return true;
    }
}

