/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ColumnCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.KeyAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.UniqueKey;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.transforms.sql.model.AbstractExpression;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.ClauseType;
import com.sas.wadmin.transforms.sql.model.Expression;
import com.sas.wadmin.transforms.sql.model.From;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SimpleExpressionInterface;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.model.TextOperand;
import com.sas.wadmin.transforms.sql.model.Where;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class Join
extends AbstractExpression
implements SourceTableInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(Join.class);
    public static final String INNERJOIN = "Inner";
    public static final String LEFTJOIN = "Left";
    public static final String RIGHTJOIN = "Right";
    public static final String FULLJOIN = "Full";
    public static final String CROSSJOIN = "Cross";
    public static final String UNIONJOIN = "Union";
    public static final String LEFTSIDECHANGED = "LeftSideChanged";
    public static final String RIGHTSIDECHANGED = "RightSideChanged";
    public static final String USEPARENTHESESCHANGED = "UseParenthesesChanged";
    public static final String USEIMPLICITCHANGED = "UseImplicitChanged";
    public static final String JOINTYPECHANGED = "JoinTypeChanged";
    private static final Icon s_iconInner = bundle.getImageIcon("Join.InnerJoin.node.image");
    private static final Icon s_iconLeft = bundle.getImageIcon("Join.LeftJoin.node.image");
    private static final Icon s_iconRight = bundle.getImageIcon("Join.RightJoin.node.image");
    private static final Icon s_iconFull = bundle.getImageIcon("Join.OuterJoin.node.image");
    private static final Icon s_iconCross = bundle.getImageIcon("Join.CrossJoin.node.image");
    private static final Icon s_iconUnion = bundle.getImageIcon("Join.UnionJoin.node.image");
    private SourceTableInterface m_leftSide;
    private SourceTableInterface m_rightSide;
    private boolean m_useImplicit = true;
    private boolean m_useParentheses = false;
    private String m_joinType;
    private ClauseInterface m_parent;
    private boolean m_hasDefaultJoinRun = false;
    private boolean m_bSkipLeftCodeGen = false;
    private static final String JOINTYPE = "JoinType";
    private static final String IMPLICITJOIN = "Implicit";
    private static final String PARENTHESIS = "Parenthesis";
    private static final String VALUE_TRUE = "YES";
    private static final String VALUE_FALSE = "NO";

    public static Icon getIcon(String joinType) {
        if (joinType == null) {
            return s_iconInner;
        }
        if (joinType.length() == 0) {
            return s_iconInner;
        }
        if (joinType.equalsIgnoreCase(INNERJOIN)) {
            return s_iconInner;
        }
        if (joinType.equalsIgnoreCase(LEFTJOIN)) {
            return s_iconLeft;
        }
        if (joinType.equalsIgnoreCase(RIGHTJOIN)) {
            return s_iconRight;
        }
        if (joinType.equalsIgnoreCase(FULLJOIN)) {
            return s_iconFull;
        }
        if (joinType.equalsIgnoreCase(CROSSJOIN)) {
            return s_iconCross;
        }
        if (joinType.equalsIgnoreCase(UNIONJOIN)) {
            return s_iconUnion;
        }
        throw new UnsupportedOperationException("Invalid join type value");
    }

    public Join(ClassifierMap classifierMap) {
        super(classifierMap);
    }

    public Join(String joinType) {
        this.m_joinType = joinType;
        if (this.m_joinType != INNERJOIN) {
            this.m_useImplicit = false;
        }
    }

    @Override
    public String getName() {
        return this.getJoinType();
    }

    @Override
    public Icon getIcon() {
        return Join.getIcon(this.m_joinType);
    }

    protected void setSkipLeftCodeGen(boolean bSkipLeft) {
        this.m_bSkipLeftCodeGen = bSkipLeft;
    }

    @Override
    public void appendClauseCode(CodegenRequest cgReq, boolean resetPosition) {
        String desc;
        if (resetPosition) {
            this.setStartingPosition(cgReq.getSourceBuffer().length());
        }
        if ((desc = this.getDescription()).length() > 0) {
            cgReq.addCommentLine(desc);
        }
        if (this.m_useParentheses && !this.m_useImplicit) {
            cgReq.addSourceCode("(");
        }
        if (this.m_leftSide != null) {
            if (this.m_bSkipLeftCodeGen && this.m_leftSide instanceof Join) {
                ((Join)this.m_leftSide).setSkipLeftCodeGen(true);
                this.m_leftSide.appendClauseCode(cgReq, resetPosition);
            }
            if (!this.m_bSkipLeftCodeGen) {
                this.m_leftSide.appendClauseCode(cgReq, resetPosition);
            }
        } else {
            cgReq.addCommentLine(bundle.getString("Join.LeftTableMissing.txt"));
        }
        if (this.m_useImplicit) {
            cgReq.addSourceCode(", ");
        } else if (this.m_joinType.equalsIgnoreCase(INNERJOIN)) {
            cgReq.addSourceCode(" inner join ");
        } else if (this.m_joinType.equalsIgnoreCase(LEFTJOIN)) {
            cgReq.addSourceCode(" left join ");
        } else if (this.m_joinType.equalsIgnoreCase(RIGHTJOIN)) {
            cgReq.addSourceCode(" right join ");
        } else if (this.m_joinType.equalsIgnoreCase(FULLJOIN)) {
            cgReq.addSourceCode(" full join ");
        } else if (this.m_joinType.equalsIgnoreCase(CROSSJOIN)) {
            cgReq.addSourceCode(" cross join ");
        } else if (this.m_joinType.equalsIgnoreCase(UNIONJOIN)) {
            cgReq.addSourceCode(" union join ");
        } else {
            throw new UnsupportedOperationException("Invalid join join type during codegen: " + this.m_joinType);
        }
        cgReq.addSourceCode("\n");
        if (this.m_rightSide != null) {
            if (this.m_useImplicit) {
                this.m_rightSide.appendClauseCode(cgReq, resetPosition);
                this.genExplicitOnClause(cgReq, resetPosition);
            } else if (this.m_rightSide instanceof Join) {
                List tables = this.m_rightSide.getSourceTables();
                if (!tables.isEmpty()) {
                    SourceTableInterface source = (SourceTableInterface)tables.get(0);
                    source.appendClauseCode(cgReq, resetPosition);
                }
                this.genExplicitOnClause(cgReq, resetPosition);
                ((Join)this.m_rightSide).setSkipLeftCodeGen(true);
                this.m_rightSide.appendClauseCode(cgReq, resetPosition);
            } else {
                this.m_rightSide.appendClauseCode(cgReq, resetPosition);
                this.genExplicitOnClause(cgReq, resetPosition);
            }
        } else {
            cgReq.addCommentLine(bundle.getString("Join.RightTableMissing.txt"));
        }
        if (this.m_useParentheses && !this.m_useImplicit) {
            cgReq.addSourceCode(")");
        }
        if (resetPosition) {
            this.setEndingPosition(cgReq.getSourceBuffer().length());
        }
        this.m_bSkipLeftCodeGen = false;
    }

    private void genExplicitOnClause(CodegenRequest cgReq, boolean resetPosition) {
        if (this.m_joinType.equalsIgnoreCase(INNERJOIN) && !this.m_useImplicit || this.m_joinType.equalsIgnoreCase(LEFTJOIN) || this.m_joinType.equalsIgnoreCase(RIGHTJOIN) || this.m_joinType.equalsIgnoreCase(FULLJOIN)) {
            cgReq.addSourceCode("\n").indent().addSourceCode("on\n").addSourceCode("(\n").indent();
            if (!this.m_userWritten) {
                this.appendCode(cgReq, resetPosition);
            } else {
                cgReq.addSourceCode(this.m_userWrittenCode);
            }
            cgReq.unIndent().addSourceCode(")").unIndent();
        }
    }

    @Override
    public CodegenRequest appendCode(CodegenRequest cgReq, boolean resetPosition) {
        if (!this.m_userWritten && this.m_expressions != null && !this.m_expressions.isEmpty()) {
            int tot = this.m_expressions.size();
            for (int i = 0; i < tot; ++i) {
                Expression expr = (Expression)this.m_expressions.get(i);
                expr.appendCode(cgReq, resetPosition);
            }
        }
        return cgReq;
    }

    public SourceTableInterface getLeftSide() {
        return this.m_leftSide;
    }

    public void setLeftSide(SourceTableInterface leftTable) {
        if (this.m_leftSide == leftTable) {
            return;
        }
        if (this.m_leftSide != null) {
            this.m_leftSide.setParent(null);
        } else {
            this.m_hasDefaultJoinRun = false;
        }
        this.m_leftSide = leftTable;
        if (this.m_leftSide != null) {
            this.m_leftSide.setParent(this);
        }
        try {
            this.createDefaultJoinRelationships();
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.getSQLModel().fireChangeEvent(this, LEFTSIDECHANGED);
    }

    public SourceTableInterface getRightSide() {
        return this.m_rightSide;
    }

    public void setRightSide(SourceTableInterface rightTable) {
        if (this.m_rightSide == rightTable) {
            return;
        }
        if (this.m_rightSide != null) {
            this.m_rightSide.setParent(null);
        } else {
            this.m_hasDefaultJoinRun = false;
        }
        this.m_rightSide = rightTable;
        if (this.m_rightSide != null) {
            this.m_rightSide.setParent(this);
        }
        try {
            this.createDefaultJoinRelationships();
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.getSQLModel().fireChangeEvent(this, RIGHTSIDECHANGED);
    }

    public void swapLeftAndRightSides() {
        SourceTableInterface newRight;
        SourceTableInterface newLeft = this.m_rightSide;
        this.m_rightSide = newRight = this.m_leftSide;
        this.m_leftSide = newLeft;
        this.getSQLModel().fireChangeEvent(this, RIGHTSIDECHANGED);
    }

    public boolean useParentheses() {
        return this.m_useParentheses;
    }

    public void setUseParentheses(boolean useParentheses) {
        if (this.m_useParentheses == useParentheses) {
            return;
        }
        this.m_useParentheses = useParentheses;
        this.getSQLModel().fireChangeEvent(this, USEPARENTHESESCHANGED);
    }

    public boolean useImplicit() {
        return this.m_useImplicit;
    }

    public void setUseImplicit(boolean useImplicit) {
        if (!this.m_joinType.equalsIgnoreCase(INNERJOIN) && useImplicit) {
            throw new UnsupportedOperationException("Implicit can only be set to true for inner joins");
        }
        if (this.m_useImplicit == useImplicit) {
            return;
        }
        this.m_useImplicit = useImplicit;
        SQLModel model = this.getSQLModel();
        if (this.m_useImplicit) {
            if (this.m_expressions.size() > 0) {
                this.addExpressionsToWhereClause();
            }
        } else if (!this.getSQLModel().isSilentModeEnabled() && this.m_joinType.equalsIgnoreCase(INNERJOIN)) {
            this.runAutoJoin();
        }
        model.fireChangeEvent(this, USEIMPLICITCHANGED);
    }

    @Override
    public boolean hasImplicitJoin() {
        if (this.useImplicit()) {
            return true;
        }
        if (this.m_rightSide.hasImplicitJoin()) {
            return true;
        }
        return this.m_leftSide.hasImplicitJoin();
    }

    public String getJoinType() {
        if (this.m_joinType == null) {
            return INNERJOIN;
        }
        return this.m_joinType;
    }

    public void setJoinType(String joinType) {
        if (this.m_joinType.equalsIgnoreCase(joinType)) {
            return;
        }
        if (joinType == null) {
            this.m_joinType = INNERJOIN;
            this.setUseImplicit(true);
        }
        if (joinType.length() == 0) {
            this.m_joinType = INNERJOIN;
            this.setUseImplicit(true);
        }
        String oldType = this.m_joinType;
        this.m_joinType = joinType;
        boolean oldUseImplicit = this.m_useImplicit;
        if (!this.m_joinType.equalsIgnoreCase(INNERJOIN)) {
            this.setUseImplicit(false);
        } else {
            this.setUseImplicit(true);
        }
        SQLModel model = this.getSQLModel();
        if (!model.isSilentModeEnabled() && oldType.equalsIgnoreCase(INNERJOIN) && oldUseImplicit && (this.m_joinType.equalsIgnoreCase(LEFTJOIN) || this.m_joinType.equalsIgnoreCase(RIGHTJOIN) || this.m_joinType.equalsIgnoreCase(FULLJOIN))) {
            this.runAutoJoin();
        }
        if ((this.m_joinType.equalsIgnoreCase(CROSSJOIN) || this.m_joinType.equalsIgnoreCase(UNIONJOIN)) && this.m_expressions.size() > 0) {
            for (int i = 0; i < this.m_expressions.size(); ++i) {
                Expression expr = (Expression)this.m_expressions.get(i);
                expr.dispose();
            }
            this.m_expressions.clear();
        }
        model.fireChangeEvent(this, JOINTYPECHANGED);
    }

    @Override
    public void setParent(ClauseInterface clause) {
        if (this.m_parent == clause) {
            return;
        }
        if (this.m_parent instanceof From) {
            ((From)this.m_parent).removeSource(this);
        } else if (this.m_parent instanceof Join) {
            ((Join)this.m_parent).removeSource(this);
        }
        this.m_parent = clause;
    }

    @Override
    public ClauseInterface getParent() {
        return this.m_parent;
    }

    @Override
    public void remove() {
        if (this.m_leftSide != null) {
            this.m_leftSide.remove();
        }
        if (this.m_rightSide != null) {
            this.m_rightSide.remove();
        }
        this.setParent(null);
        this.dispose();
    }

    protected void removeSource(SourceTableInterface source) {
        if (source == null) {
            return;
        }
        TableInterface removedTable = null;
        if (source instanceof SubQuery) {
            removedTable = ((SubQuery)source).getTargetTable();
        } else if (source instanceof TableInterface) {
            removedTable = (TableInterface)((Object)source);
        }
        if (removedTable != null) {
            Query query = this.getParentQuery();
            query.removeExpressionsContainingSourceTable(removedTable);
            this.removeExpressionsContainingSourceTable(removedTable);
            if (query instanceof SubQuery && query.getParentClause() instanceof Query) {
                query.getParentQuery().removeExpressionsContainingSourceTable(removedTable);
            }
        }
        if (this.m_leftSide == source) {
            this.m_leftSide = null;
            this.m_hasDefaultJoinRun = false;
            this.getSQLModel().fireChangeEvent(this, LEFTSIDECHANGED);
        } else if (this.m_rightSide == source) {
            this.m_rightSide = null;
            this.m_hasDefaultJoinRun = false;
            this.getSQLModel().fireChangeEvent(this, RIGHTSIDECHANGED);
        }
    }

    protected void resetTransformRole() {
        try {
            if (this.m_classifierMap != null) {
                this.m_classifierMap.setTransformRole("Join");
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void runAutoJoin() {
        int retValue = MessageUtil.displayMessage((String)bundle.getString("Join.RerunAutoJoin.txt"), (String)bundle.getString("Join.RerunAutoJoin.Title.txt"), (int)3, (int)0);
        if (retValue == 0) {
            try {
                Query query;
                Where where;
                this.m_hasDefaultJoinRun = false;
                this.createDefaultJoinRelationships();
                if (this.m_expressions.size() > 0 && (where = (query = this.getParentQuery()).getWhere()) != null) {
                    List whereExprs = where.getExpressions();
                    ArrayList<Expression> duplExpr = new ArrayList<Expression>();
                    block3: for (int i = 0; i < whereExprs.size(); ++i) {
                        Expression expr = (Expression)whereExprs.get(i);
                        for (int j = 0; j < this.m_expressions.size(); ++j) {
                            Expression newExpr = (Expression)this.m_expressions.get(j);
                            if (!expr.equals(newExpr)) continue;
                            duplExpr.add(expr);
                            continue block3;
                        }
                    }
                    int dupSize = duplExpr.size();
                    if (dupSize > 0) {
                        for (int i = 0; i < dupSize; ++i) {
                            Expression dupExpr = (Expression)duplExpr.get(i);
                            where.removeExpression(dupExpr);
                        }
                        where.fixUpLogicalOperator();
                    }
                    if (whereExprs.size() == 0) {
                        query.removeClause(where);
                    }
                }
            }
            catch (MdException me) {
                if (this.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(me.getLocalizedMessage());
                } else {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        this.disableFireEvents();
        Query query = this.getParentQuery();
        if (this.m_classifierMap == null) {
            this.createNewJoinMetadata();
        } else {
            this.m_hasDefaultJoinRun = true;
            AssociationList alProperties = this.m_classifierMap.getProperties();
            this.m_useImplicit = false;
            this.m_useParentheses = false;
            for (int i = 0; i < alProperties.size(); ++i) {
                String value;
                Property prop = (Property)alProperties.get(i);
                if (prop.getPropertyRole().equalsIgnoreCase(JOINTYPE)) {
                    this.m_joinType = prop.getDefaultValue();
                }
                if (prop.getPropertyRole().equalsIgnoreCase(IMPLICITJOIN)) {
                    value = prop.getDefaultValue();
                    this.m_useImplicit = value.equalsIgnoreCase(VALUE_TRUE);
                }
                if (!prop.getPropertyRole().equalsIgnoreCase(PARENTHESIS)) continue;
                value = prop.getDefaultValue();
                this.m_useParentheses = value.equalsIgnoreCase(VALUE_TRUE);
            }
            if (this.m_joinType == null) {
                this.m_joinType = INNERJOIN;
            }
            AssociationList alTransSources = this.m_classifierMap.getTransformationSources();
            boolean wasFound = false;
            for (int i = 0; i < alTransSources.size(); ++i) {
                Root source = (Root)alTransSources.get(i);
                if (!source.getCMetadataType().equalsIgnoreCase("ClassifierMap") || !((ClassifierMap)source).getTransformRole().equalsIgnoreCase("Join")) continue;
                this.m_leftSide = query.addJoin((ClassifierMap)source);
                wasFound = true;
                break;
            }
            if (!wasFound) {
                AssociationList alClassifierSources = this.m_classifierMap.getClassifierSources();
                DataTable table = null;
                AbstractTable srcTable = null;
                if (!alClassifierSources.isEmpty()) {
                    table = (DataTable)alClassifierSources.get(0);
                    if (table.getCMetadataType().equalsIgnoreCase("QueryTable")) {
                        AssociationList lRoles = table.getRoles();
                        if (!lRoles.isEmpty()) {
                            for (int i = 0; i < lRoles.size(); ++i) {
                                Role role = (Role)lRoles.get(i);
                                if (!role.getContext().equalsIgnoreCase("SubQuery")) continue;
                                this.m_leftSide = query.addSubQuery((QueryTable)table);
                                wasFound = true;
                                break;
                            }
                        }
                        if (!wasFound) {
                            srcTable = query.findSourceTable(table.getTableName());
                        }
                    } else {
                        srcTable = query.findSourceTable(table);
                    }
                    if (this.m_leftSide == null) {
                        this.m_leftSide = srcTable == null ? this.getParentQuery().addSourceTable(table) : (SourceTableInterface)((Object)srcTable);
                    }
                }
            }
            AssociationList alTransTargets = this.m_classifierMap.getTransformationTargets();
            wasFound = false;
            for (int i = 0; i < alTransTargets.size(); ++i) {
                Root source = (Root)alTransTargets.get(i);
                if (!source.getCMetadataType().equalsIgnoreCase("ClassifierMap") || !((ClassifierMap)source).getTransformRole().equalsIgnoreCase("Join")) continue;
                this.m_rightSide = query.addJoin((ClassifierMap)source);
                wasFound = true;
                break;
            }
            if (!wasFound) {
                AssociationList alClassifierTargets = this.m_classifierMap.getClassifierTargets();
                DataTable table = null;
                AbstractTable srcTable = null;
                if (!alClassifierTargets.isEmpty()) {
                    table = (DataTable)alClassifierTargets.get(0);
                    if (table.getCMetadataType().equalsIgnoreCase("QueryTable")) {
                        AssociationList lRoles = table.getRoles();
                        if (!lRoles.isEmpty()) {
                            for (int i = 0; i < lRoles.size(); ++i) {
                                Role role = (Role)lRoles.get(i);
                                if (!role.getContext().equalsIgnoreCase("SubQuery")) continue;
                                this.m_rightSide = query.addSubQuery((QueryTable)table);
                                wasFound = true;
                                break;
                            }
                        }
                        if (!wasFound) {
                            srcTable = query.findSourceTable(table.getTableName());
                        }
                    } else {
                        srcTable = query.findSourceTable(table);
                    }
                    if (this.m_rightSide == null) {
                        this.m_rightSide = srcTable == null ? this.getParentQuery().addSourceTable(table) : (SourceTableInterface)((Object)srcTable);
                    }
                }
            }
        }
        if (this.m_leftSide != null) {
            this.m_leftSide.setParent(this);
            this.m_leftSide.moveDataToModel();
        }
        if (this.m_rightSide != null) {
            this.m_rightSide.setParent(this);
            this.m_rightSide.moveDataToModel();
        }
        super.moveDataToModel();
        this.enableFireEvents();
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        Object table;
        if (this.m_classifierMap == null) {
            this.createNewJoinMetadata();
        }
        super.moveDataToStore();
        this.m_classifierMap.setTransformRole("Join");
        AssociationList alProperties = this.m_classifierMap.getProperties();
        for (int i = 0; i < alProperties.size(); ++i) {
            String value;
            Property prop = (Property)alProperties.get(i);
            if (prop.getPropertyRole().equalsIgnoreCase(JOINTYPE)) {
                prop.setDefaultValue(this.m_joinType);
            }
            if (prop.getPropertyRole().equalsIgnoreCase(IMPLICITJOIN)) {
                value = "";
                value = this.m_useImplicit ? VALUE_TRUE : VALUE_FALSE;
                prop.setDefaultValue(value);
            }
            if (!prop.getPropertyRole().equalsIgnoreCase(PARENTHESIS)) continue;
            value = "";
            value = this.m_useParentheses ? VALUE_TRUE : VALUE_FALSE;
            prop.setDefaultValue(value);
        }
        AssociationList tranSources = this.m_classifierMap.getTransformationSources();
        tranSources.removeAllElements();
        tranSources.flushAll();
        AssociationList clsSources = this.m_classifierMap.getClassifierSources();
        clsSources.removeAllElements();
        clsSources.flushAll();
        AssociationList tranTargets = this.m_classifierMap.getTransformationTargets();
        tranTargets.removeAllElements();
        tranTargets.flushAll();
        AssociationList clsTargets = this.m_classifierMap.getClassifierTargets();
        clsTargets.removeAllElements();
        clsTargets.flushAll();
        if (this.m_leftSide != null) {
            this.m_leftSide.moveDataToStore();
            if (this.m_leftSide instanceof Join) {
                tranSources.add((Object)((Join)this.m_leftSide).getClassifierMap());
            } else if (this.m_leftSide instanceof SourceTable) {
                table = null;
                SourceTable leftSrc = (SourceTable)this.m_leftSide;
                table = leftSrc.isAliased() ? leftSrc.getTableAlias().getQueryTable() : leftSrc.getDataTable();
                clsSources.add(table);
            } else if (this.m_leftSide instanceof SubQuery) {
                clsSources.add((Object)((SubQuery)this.m_leftSide).getTargetDataTable());
            }
        }
        if (this.m_rightSide != null) {
            this.m_rightSide.moveDataToStore();
            if (this.m_rightSide instanceof Join) {
                tranTargets.add((Object)((Join)this.m_rightSide).getClassifierMap());
            } else if (this.m_rightSide instanceof SourceTable) {
                table = null;
                SourceTable rightSrc = (SourceTable)this.m_rightSide;
                table = rightSrc.isAliased() ? rightSrc.getTableAlias().getQueryTable() : rightSrc.getDataTable();
                clsTargets.add(table);
            } else if (this.m_rightSide instanceof SubQuery) {
                clsTargets.add((Object)((SubQuery)this.m_rightSide).getTargetDataTable());
            }
        }
        AssociationList maps = this.m_classifierMap.getFeatureMaps();
        maps.removeAllElements();
        maps.flushAll();
        if (this.m_expressions == null) {
            return;
        }
        for (int i = 0; i < this.m_expressions.size(); ++i) {
            Expression expr = (Expression)this.m_expressions.get(i);
            expr.moveDataToStore();
            maps.add((Object)expr.getFeatureMap());
        }
    }

    @Override
    public void dispose() {
        if (this.m_leftSide != null) {
            this.m_leftSide.dispose();
            this.m_leftSide = null;
        }
        if (this.m_rightSide != null) {
            this.m_rightSide.dispose();
            this.m_rightSide = null;
        }
        String strTemplate = "<ClassifierMap><PropertySets><PropertySet><Properties/><SetProperties/></PropertySet></PropertySets><Properties></Properties></ClassifierMap>";
        try {
            if (this.m_classifierMap != null) {
                Select select = this.getParentQuery().getSelectObject();
                select.getTransformationSources().removeElement((Object)this.m_classifierMap);
                this.getSQLModel().getObjectStore().removeObjectFromStore((CMetadata)this.m_classifierMap, strTemplate);
                this.m_classifierMap = null;
            }
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Deleting");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        super.dispose();
    }

    @Override
    public boolean hasOpenTemplates() {
        if (this.m_leftSide == null) {
            return true;
        }
        if (this.m_rightSide == null) {
            return true;
        }
        if (!(this.m_leftSide instanceof SubQuery) && this.m_leftSide.hasOpenTemplates()) {
            return true;
        }
        return !(this.m_rightSide instanceof SubQuery) && this.m_rightSide.hasOpenTemplates();
    }

    @Override
    public List getSourceObjectsWithOpenTemplates() {
        ArrayList<Join> list = new ArrayList<Join>();
        if (this.m_leftSide != null) {
            list.addAll(this.m_leftSide.getSourceObjectsWithOpenTemplates());
        }
        if (this.m_rightSide != null) {
            list.addAll(this.m_rightSide.getSourceObjectsWithOpenTemplates());
        }
        if (this.m_leftSide == null || this.m_rightSide == null) {
            list.add(this);
        }
        return list;
    }

    @Override
    public List getSubqueries() {
        ArrayList list = new ArrayList();
        if (this.m_leftSide != null) {
            list.addAll(this.m_leftSide.getSubqueries());
        }
        if (this.m_rightSide != null) {
            list.addAll(this.m_rightSide.getSubqueries());
        }
        return list;
    }

    @Override
    public void removeExpressionsContainingQuery(Query query) {
        super.removeExpressionsContainingQuery(query);
        if (this.m_leftSide != null) {
            this.m_leftSide.removeExpressionsContainingQuery(query);
        }
        if (this.m_rightSide != null) {
            this.m_rightSide.removeExpressionsContainingQuery(query);
        }
    }

    @Override
    public List getSourceTables() {
        ArrayList lsources = new ArrayList();
        if (this.m_leftSide != null) {
            lsources.addAll(this.m_leftSide.getSourceTables());
        }
        if (this.m_rightSide != null) {
            lsources.addAll(this.m_rightSide.getSourceTables());
        }
        List lSubQueries = this.getSubQueries();
        for (int i = 0; i < lSubQueries.size(); ++i) {
            lsources.addAll(((SubQuery)lSubQueries.get(i)).getSourceTables());
        }
        return lsources;
    }

    private void createNewJoinMetadata() throws MdException, RemoteException {
        SQLModel model = this.getSQLModel();
        MdObjectStore store = model.getObjectStore();
        String reposId = model.getRepositoryId();
        Select select = this.getParentQuery().getSelectObject();
        this.createClassifierMap("Join");
        this.m_classifierMap.setTransformRole("Join");
        select.getTransformationSources().add((Object)this.m_classifierMap);
        PropertyType propType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(store, JOINTYPE, "PropertyType", reposId);
        propType.setSQLType(12);
        Property property = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, JOINTYPE, "Property", reposId);
        property.setPropertyRole(JOINTYPE);
        property.setDefaultValue(this.getJoinType());
        property.setUseValueOnly(1);
        property.setOwningType(propType);
        this.m_classifierMap.getProperties().add((Object)property);
        property = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, IMPLICITJOIN, "Property", reposId);
        property.setPropertyRole(IMPLICITJOIN);
        String value = VALUE_TRUE;
        value = this.m_useImplicit ? VALUE_TRUE : VALUE_FALSE;
        property.setDefaultValue(value);
        property.setUseValueOnly(1);
        property.setOwningType(propType);
        this.m_classifierMap.getProperties().add((Object)property);
        property = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, PARENTHESIS, "Property", reposId);
        property.setPropertyRole(PARENTHESIS);
        value = this.m_useParentheses ? VALUE_TRUE : VALUE_FALSE;
        property.setDefaultValue(value);
        property.setUseValueOnly(1);
        property.setOwningType(propType);
        this.m_classifierMap.getProperties().add((Object)property);
        if (this.m_leftSide instanceof Join) {
            this.m_classifierMap.getTransformationSources().add((Object)((Join)this.m_leftSide).getClassifierMap());
        } else if (this.m_leftSide instanceof SourceTable) {
            this.m_classifierMap.getClassifierSources().add((Object)((SourceTable)this.m_leftSide).getDataTable());
        } else if (this.m_leftSide instanceof SubQuery) {
            this.m_classifierMap.getClassifierSources().add((Object)((SubQuery)this.m_leftSide).getTargetDataTable());
        }
        if (this.m_rightSide instanceof Join) {
            this.m_classifierMap.getTransformationTargets().add((Object)((Join)this.m_rightSide).getClassifierMap());
        } else if (this.m_rightSide instanceof SourceTable) {
            this.m_classifierMap.getClassifierTargets().add((Object)((SourceTable)this.m_rightSide).getDataTable());
        } else if (this.m_rightSide instanceof SubQuery) {
            this.m_classifierMap.getClassifierTargets().add((Object)((SubQuery)this.m_rightSide).getTargetDataTable());
        }
        this.createDefaultJoinRelationships();
    }

    private void addExpressionsToWhereClause() {
        Query query = this.getParentQuery();
        Where where = query.getWhere();
        if (this.m_expressions.size() == 0) {
            return;
        }
        if (where == null) {
            where = (Where)query.addClause(ClauseType.WHERE);
        }
        List existingExpressions = where.getExpressions();
        if (!this.m_expressions.isEmpty()) {
            for (int i = 0; i < this.m_expressions.size(); ++i) {
                Expression expr = (Expression)this.m_expressions.get(i);
                for (int j = 0; j < existingExpressions.size(); ++j) {
                    Expression existingExpr = (Expression)existingExpressions.get(j);
                    if (!existingExpr.equals(expr)) continue;
                    expr.dispose();
                    expr = null;
                    break;
                }
                if (expr == null) continue;
                expr.setFeatureMap(null);
                if (existingExpressions.size() > 0 && i == 0) {
                    expr.setLogicalOperator("and");
                }
                where.addExpression(expr);
            }
            this.m_expressions.clear();
        }
    }

    private void createDefaultJoinRelationships() throws MdException, RemoteException {
        if (this.m_hasDefaultJoinRun || !this.getSQLModel().getRunDefaultRelationships()) {
            return;
        }
        ArrayList<TargetTable> lLeftTables = new ArrayList<TargetTable>();
        if (this.m_leftSide == null) {
            return;
        }
        if (this.m_leftSide instanceof SubQuery) {
            SubQuery subquery = (SubQuery)this.m_leftSide;
            lLeftTables.add(subquery.getTargetTable());
        } else {
            lLeftTables.addAll(this.m_leftSide.getSourceTables());
        }
        ArrayList<TargetTable> lRightTables = new ArrayList<TargetTable>();
        if (this.m_rightSide == null) {
            return;
        }
        if (this.m_rightSide instanceof SubQuery) {
            SubQuery subquery = (SubQuery)this.m_rightSide;
            lRightTables.add(subquery.getTargetTable());
        } else {
            lRightTables.addAll(this.m_rightSide.getSourceTables());
        }
        this.findJoinRelationships(lLeftTables, lRightTables);
        this.m_hasDefaultJoinRun = true;
        if (this.m_expressions.size() == 0 && !this.m_useImplicit) {
            if (!this.getSQLModel().isSilentModeEnabled()) {
                MessageUtil.displayMessage((String)bundle.getString("Join.Auto.NoMatchesFound.txt"));
            }
            return;
        }
        if (this.m_useImplicit) {
            this.addExpressionsToWhereClause();
        }
    }

    private void findJoinRelationships(List leftTables, List rightTables) throws MdException, RemoteException {
        ArrayList alLeftTables = new ArrayList(leftTables.size());
        alLeftTables.addAll(leftTables);
        ArrayList alRightTables = new ArrayList(rightTables.size());
        alRightTables.addAll(rightTables);
        CodegenRequest cgReq = this.getSQLModel().getCodegenRequest();
        for (int i = 0; i < leftTables.size(); ++i) {
            Column leftCol;
            AbstractTable leftSrcTable = (AbstractTable)leftTables.get(i);
            DataTable leftTable = leftSrcTable.getDataTable();
            if (leftTable == null) continue;
            AssociationList alUniqueKeys = leftTable.getUniqueKeys();
            for (int j = 0; j < alUniqueKeys.size(); ++j) {
                UniqueKey key = (UniqueKey)alUniqueKeys.get(j);
                AssociationList alForeignKeys = key.getForeignKeys();
                block2: for (int k = 0; k < alForeignKeys.size(); ++k) {
                    ForeignKey foreignKey = (ForeignKey)alForeignKeys.get(k);
                    DataTable fkTable = foreignKey.getTable();
                    for (int l = 0; l < rightTables.size(); ++l) {
                        AbstractTable rightSrcTable = (AbstractTable)rightTables.get(l);
                        DataTable rightTable = rightSrcTable.getDataTable();
                        if (!rightTable.getFQID().equalsIgnoreCase(fkTable.getFQID())) continue;
                        AssociationList alFkCols = foreignKey.getKeyedColumns();
                        for (int m = 0; m < alFkCols.size(); ++m) {
                            Column rightCol = (Column)alFkCols.get(m);
                            leftCol = null;
                            AssociationList alFkAssoc = rightCol.getForeignKeyAssociations();
                            if (!alFkAssoc.isEmpty()) {
                                if (this.m_expressions == null) {
                                    this.m_expressions = new ArrayList();
                                }
                                KeyAssociation keyAssoc = (KeyAssociation)alFkAssoc.get(0);
                                leftCol = keyAssoc.getUniqueKeyColumn();
                                String logicalOperator = "";
                                if (this.m_expressions.size() > 0) {
                                    logicalOperator = "and";
                                }
                                StringBuffer leftSb = new StringBuffer();
                                ColumnCG leftColCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)leftCol);
                                leftSb.append(leftSrcTable.getDataTableName(cgReq)).append(".").append(leftColCG.getColumnName(cgReq, this.getSQLModel().isPassThrough()));
                                StringBuffer rightSb = new StringBuffer();
                                ColumnCG rightColCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)rightCol);
                                rightSb.append(rightSrcTable.getDataTableName(cgReq)).append(".").append(rightColCG.getColumnName(cgReq, this.getSQLModel().isPassThrough()));
                                Expression expr = new Expression(logicalOperator, null, "=", null, 0, 0, this);
                                TextOperand left = new TextOperand((SimpleExpressionInterface)expr, leftSb.toString());
                                TextOperand right = new TextOperand((SimpleExpressionInterface)expr, rightSb.toString());
                                expr.setLeftOperand(left);
                                expr.setRightOperand(right);
                                this.addExpression(expr);
                                alLeftTables.remove(leftSrcTable);
                                alRightTables.remove(rightSrcTable);
                                continue;
                            }
                            if (this.getSQLModel().isSilentModeEnabled()) continue;
                            MessageUtil.displayMessage((String)bundle.formatString("Join.Auto.Error.txt", (Object)rightCol));
                        }
                        continue block2;
                    }
                }
            }
            AssociationList alForeignKeys = leftTable.getForeignKeys();
            for (int j = 0; j < alForeignKeys.size(); ++j) {
                ForeignKey foreignKey = (ForeignKey)alForeignKeys.get(j);
                AssociationList alUniqKeys = foreignKey.getPartnerUniqueKeys();
                for (int k = 0; k < alUniqKeys.size(); ++k) {
                    UniqueKey key = (UniqueKey)alUniqKeys.get(k);
                    DataTable ukTable = key.getTable();
                    for (int l = 0; l < rightTables.size(); ++l) {
                        AbstractTable rightSrcTable = (AbstractTable)rightTables.get(l);
                        DataTable rightTable = rightSrcTable.getDataTable();
                        if (!ukTable.getFQID().equalsIgnoreCase(rightTable.getFQID())) continue;
                        AssociationList alFKeyCols = foreignKey.getKeyedColumns();
                        for (int m = 0; m < alFKeyCols.size(); ++m) {
                            leftCol = (Column)alFKeyCols.get(m);
                            Column rightCol = null;
                            AssociationList alFkAssoc = leftCol.getForeignKeyAssociations();
                            if (!alFkAssoc.isEmpty()) {
                                if (this.m_expressions == null) {
                                    this.m_expressions = new ArrayList();
                                }
                                KeyAssociation keyAssoc = (KeyAssociation)alFkAssoc.get(0);
                                rightCol = keyAssoc.getUniqueKeyColumn();
                                String logicalOperator = "";
                                if (this.m_expressions.size() > 0) {
                                    logicalOperator = "and";
                                }
                                StringBuffer leftSb = new StringBuffer();
                                ColumnCG leftColCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)leftCol);
                                leftSb.append(leftSrcTable.getDataTableName(cgReq)).append(".").append(leftColCG.getColumnName(cgReq, this.getSQLModel().isPassThrough()));
                                StringBuffer rightSb = new StringBuffer();
                                ColumnCG rightColCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)rightCol);
                                rightSb.append(rightSrcTable.getDataTableName(cgReq)).append(".").append(rightColCG.getColumnName(cgReq, this.getSQLModel().isPassThrough()));
                                Expression expr = new Expression(logicalOperator, null, "=", null, 0, 0, this);
                                TextOperand left = new TextOperand((SimpleExpressionInterface)expr, leftSb.toString());
                                TextOperand right = new TextOperand((SimpleExpressionInterface)expr, rightSb.toString());
                                expr.setLeftOperand(left);
                                expr.setRightOperand(right);
                                this.addExpression(expr);
                                alLeftTables.remove(leftSrcTable);
                                alRightTables.remove(rightSrcTable);
                                continue;
                            }
                            if (this.getSQLModel().isSilentModeEnabled()) continue;
                            MessageUtil.displayMessage((String)bundle.formatString("Join.Auto.Error.txt", (Object)leftCol));
                        }
                    }
                }
            }
        }
        if (alLeftTables.size() > 0 && alRightTables.size() > 0) {
            this.findIndexRelationships(alLeftTables, alRightTables);
        }
    }

    private void findIndexRelationships(List leftTables, List rightTables) throws MdException, RemoteException {
        Expression existingExpr;
        int n;
        TextOperand right;
        TextOperand left;
        Expression expr;
        ColumnCG rightColCG;
        StringBuffer rightSb;
        ColumnCG leftColCG;
        StringBuffer leftSb;
        String logicalOperator;
        int m;
        int l;
        int k;
        Index index;
        int j;
        AssociationList alIndexes;
        int i;
        ArrayList alLeftTables = new ArrayList(leftTables.size());
        alLeftTables.addAll(leftTables);
        ArrayList alRightTables = new ArrayList(rightTables.size());
        alRightTables.addAll(rightTables);
        CodegenRequest cgReq = this.getSQLModel().getCodegenRequest();
        for (i = 0; i < leftTables.size(); ++i) {
            PhysicalTable table;
            AbstractTable leftSrcTable = (AbstractTable)leftTables.get(i);
            DataTable leftTable = leftSrcTable.getDataTable();
            if (leftTable == null) continue;
            if (leftTable.getCMetadataType().equalsIgnoreCase("PhysicalTable")) {
                table = (PhysicalTable)leftTable;
                alIndexes = table.getIndexes();
            } else {
                if (leftTable.getCMetadataType().equalsIgnoreCase("QueryTable")) break;
                table = (WorkTable)leftTable;
                alIndexes = table.getIndexes();
            }
            for (j = 0; j < alIndexes.size(); ++j) {
                index = (Index)alIndexes.get(j);
                AssociationList alLeftColumns = index.getColumns();
                for (k = 0; k < alLeftColumns.size(); ++k) {
                    Column leftColumn = (Column)alLeftColumns.get(k);
                    String leftName = leftColumn.getSASColumnName();
                    String leftType = leftColumn.getSASColumnType();
                    int leftLength = leftColumn.getSASColumnLength();
                    block3: for (l = 0; l < rightTables.size(); ++l) {
                        AbstractTable rightSrcTable = (AbstractTable)rightTables.get(l);
                        DataTable rightTable = rightSrcTable.getDataTable();
                        boolean matchFound = false;
                        AssociationList alRightColumns = rightTable.getColumns();
                        for (m = 0; m < alRightColumns.size(); ++m) {
                            Column rightColumn = (Column)alRightColumns.get(m);
                            String rightName = rightColumn.getSASColumnName();
                            String rightType = rightColumn.getSASColumnType();
                            int rightLength = rightColumn.getSASColumnLength();
                            if (rightName.equals(leftName) && rightType.equalsIgnoreCase(leftType) && rightLength == leftLength) {
                                if (this.m_expressions == null) {
                                    this.m_expressions = new ArrayList();
                                }
                                logicalOperator = "";
                                if (this.m_expressions.size() > 0) {
                                    logicalOperator = "and";
                                }
                                leftSb = new StringBuffer();
                                leftColCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)leftColumn);
                                leftSb.append(leftSrcTable.getDataTableName(cgReq)).append(".").append(leftColCG.getColumnName(cgReq, this.getSQLModel().isPassThrough()));
                                rightSb = new StringBuffer();
                                rightColCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)rightColumn);
                                rightSb.append(rightSrcTable.getDataTableName(cgReq)).append(".").append(rightColCG.getColumnName(cgReq, this.getSQLModel().isPassThrough()));
                                expr = new Expression(logicalOperator, null, "=", null, 0, 0, this);
                                expr.setParentClause(this);
                                expr.setSQLModel(this.getSQLModel());
                                expr.setParentQuery(this.getParentQuery());
                                left = new TextOperand((SimpleExpressionInterface)expr, leftSb.toString());
                                right = new TextOperand((SimpleExpressionInterface)expr, rightSb.toString());
                                expr.setLeftOperand(left);
                                expr.setRightOperand(right);
                                if (!this.m_expressions.isEmpty()) {
                                    for (n = 0; n < this.m_expressions.size(); ++n) {
                                        existingExpr = (Expression)this.m_expressions.get(n);
                                        if (!existingExpr.equals(expr)) continue;
                                        expr.dispose();
                                        expr = null;
                                        break;
                                    }
                                }
                                if (expr != null) {
                                    this.addExpression(expr);
                                    alLeftTables.remove(leftSrcTable);
                                    alRightTables.remove(rightSrcTable);
                                    matchFound = true;
                                }
                            }
                            if (matchFound) continue block3;
                        }
                    }
                }
            }
        }
        if (alRightTables.size() > 0) {
            for (i = 0; i < rightTables.size(); ++i) {
                PhysicalTable table;
                AbstractTable rightSrcTable = (AbstractTable)rightTables.get(i);
                DataTable rightTable = rightSrcTable.getDataTable();
                if (rightTable == null) continue;
                if (rightTable.getCMetadataType().equalsIgnoreCase("PhysicalTable")) {
                    table = (PhysicalTable)rightTable;
                    alIndexes = table.getIndexes();
                } else {
                    if (rightTable.getCMetadataType().equalsIgnoreCase("QueryTable")) break;
                    table = (WorkTable)rightTable;
                    alIndexes = table.getIndexes();
                }
                for (j = 0; j < alIndexes.size(); ++j) {
                    index = (Index)alIndexes.get(j);
                    AssociationList alRightColumns = index.getColumns();
                    for (k = 0; k < alRightColumns.size(); ++k) {
                        Column rightColumn = (Column)alRightColumns.get(k);
                        String rightName = rightColumn.getSASColumnName();
                        String rightType = rightColumn.getSASColumnType();
                        int rightLength = rightColumn.getSASColumnLength();
                        block9: for (l = 0; l < leftTables.size(); ++l) {
                            AbstractTable leftSrcTable = (AbstractTable)leftTables.get(l);
                            DataTable leftTable = leftSrcTable.getDataTable();
                            AssociationList alLeftColumns = leftTable.getColumns();
                            boolean matchFound = false;
                            for (m = 0; m < alLeftColumns.size(); ++m) {
                                Column leftColumn = (Column)alLeftColumns.get(m);
                                String leftName = leftColumn.getSASColumnName();
                                String leftType = leftColumn.getSASColumnType();
                                int leftLength = leftColumn.getSASColumnLength();
                                if (rightName.equals(leftName) && rightType.equalsIgnoreCase(leftType) && rightLength == leftLength) {
                                    if (this.m_expressions == null) {
                                        this.m_expressions = new ArrayList();
                                    }
                                    logicalOperator = "";
                                    if (this.m_expressions.size() > 0) {
                                        logicalOperator = "and";
                                    }
                                    leftSb = new StringBuffer();
                                    leftColCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)leftColumn);
                                    leftSb.append(leftSrcTable.getDataTableName(cgReq)).append(".").append(leftColCG.getColumnName(cgReq, this.getSQLModel().isPassThrough()));
                                    rightSb = new StringBuffer();
                                    rightColCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)rightColumn);
                                    rightSb.append(rightSrcTable.getDataTableName(cgReq)).append(".").append(rightColCG.getColumnName(cgReq, this.getSQLModel().isPassThrough()));
                                    expr = new Expression(logicalOperator, null, "=", null, 0, 0, this);
                                    expr.setParentClause(this);
                                    expr.setSQLModel(this.getSQLModel());
                                    expr.setParentQuery(this.getParentQuery());
                                    left = new TextOperand((SimpleExpressionInterface)expr, leftSb.toString());
                                    right = new TextOperand((SimpleExpressionInterface)expr, rightSb.toString());
                                    expr.setLeftOperand(left);
                                    expr.setRightOperand(right);
                                    if (!this.m_expressions.isEmpty()) {
                                        for (n = 0; n < this.m_expressions.size(); ++n) {
                                            existingExpr = (Expression)this.m_expressions.get(n);
                                            if (!existingExpr.equals(expr)) continue;
                                            expr.dispose();
                                            expr = null;
                                            break;
                                        }
                                    }
                                    if (expr != null) {
                                        this.addExpression(expr);
                                        alLeftTables.remove(leftSrcTable);
                                        alRightTables.remove(rightSrcTable);
                                        matchFound = true;
                                    }
                                }
                                if (matchFound) continue block9;
                            }
                        }
                    }
                }
            }
        }
        if (alLeftTables.size() > 0 && alRightTables.size() > 0) {
            this.findColumnRelationships(leftTables, rightTables);
        }
    }

    private void findColumnRelationships(List leftTables, List rightTables) throws MdException, RemoteException {
        ArrayList alLeftTables = new ArrayList(leftTables.size());
        alLeftTables.addAll(leftTables);
        ArrayList alRightTables = new ArrayList(rightTables.size());
        alRightTables.addAll(rightTables);
        CodegenRequest cgReq = this.getSQLModel().getCodegenRequest();
        block0: for (int i = 0; i < leftTables.size(); ++i) {
            AbstractTable leftSrcTable = (AbstractTable)leftTables.get(i);
            List alLeftColumns = leftSrcTable.getTableColumns();
            for (int j = 0; j < alLeftColumns.size(); ++j) {
                boolean matchFound = false;
                TableColumn leftTblCol = (TableColumn)alLeftColumns.get(j);
                Column leftColumn = leftTblCol.getColumn();
                String leftName = leftColumn.getSASColumnName();
                String leftType = leftColumn.getSASColumnType();
                int leftLength = leftColumn.getSASColumnLength();
                block2: for (int k = 0; k < rightTables.size(); ++k) {
                    AbstractTable rightSrcTable = (AbstractTable)rightTables.get(k);
                    List alRightColumns = rightSrcTable.getTableColumns();
                    for (int l = 0; l < alRightColumns.size(); ++l) {
                        TableColumn rightTblCol = (TableColumn)alRightColumns.get(l);
                        Column rightColumn = rightTblCol.getColumn();
                        String rightName = rightColumn.getSASColumnName();
                        String rightType = rightColumn.getSASColumnType();
                        int rightLength = rightColumn.getSASColumnLength();
                        boolean found = false;
                        if (rightName.equalsIgnoreCase(leftName) && rightType.equalsIgnoreCase(leftType)) {
                            if (rightType.equalsIgnoreCase("N")) {
                                if (rightLength == leftLength) {
                                    found = true;
                                }
                            } else {
                                found = true;
                            }
                        }
                        if (!found) continue;
                        if (this.m_expressions == null) {
                            this.m_expressions = new ArrayList();
                        }
                        String logicalOperator = "";
                        if (this.m_expressions.size() > 0) {
                            logicalOperator = "and";
                        }
                        StringBuffer leftSb = leftTblCol.getCodegenColumnName(cgReq, this.getParentQuery());
                        StringBuffer rightSb = rightTblCol.getCodegenColumnName(cgReq, this.getParentQuery());
                        Expression expr = new Expression(logicalOperator, null, "=", null, 0, 0, this);
                        expr.setParentClause(this);
                        expr.setSQLModel(this.getSQLModel());
                        expr.setParentQuery(this.getParentQuery());
                        TextOperand left = new TextOperand((SimpleExpressionInterface)expr, leftSb.toString());
                        TextOperand right = new TextOperand((SimpleExpressionInterface)expr, rightSb.toString());
                        expr.setLeftOperand(left);
                        expr.setRightOperand(right);
                        if (!this.m_expressions.isEmpty()) {
                            for (int n = 0; n < this.m_expressions.size(); ++n) {
                                Expression existingExpr = (Expression)this.m_expressions.get(n);
                                if (!existingExpr.equals(expr)) continue;
                                expr.dispose();
                                expr = null;
                                break;
                            }
                        }
                        if (expr == null) continue;
                        this.addExpression(expr);
                        alLeftTables.remove(leftSrcTable);
                        alRightTables.remove(rightSrcTable);
                        matchFound = true;
                        continue block2;
                    }
                }
                if (matchFound) continue block0;
            }
        }
    }
}

