/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.ClauseType;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.ResultMapping;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class GroupByColumn {
    protected Column m_column;
    protected TableColumn m_tableColumn;
    protected AbstractTable m_table;
    protected boolean m_bDisplayInteger;
    protected Root m_parentObjectForPropertySet;
    protected AbstractClause m_parentClause;
    protected static final String PROPERTY_SET_NAME_COLUMNS = "ColumnProperties";
    protected static final String PROPERTY_NAME_DISPLAY_INTEGER = "DisplayInteger";
    protected static final String PROPERTY_NAME_COLUMN = "Column";
    protected static boolean DISPLAY_INTEGER_DEFAULT = false;

    public GroupByColumn(TableColumn tableColumn, AbstractTable table, AbstractClause parent) {
        this(tableColumn, table, DISPLAY_INTEGER_DEFAULT, parent);
    }

    public GroupByColumn(TableColumn tableColumn, AbstractTable table, boolean displayInteger, AbstractClause parent) {
        this.m_tableColumn = tableColumn;
        this.m_table = table;
        this.m_bDisplayInteger = displayInteger;
        this.m_parentClause = parent;
    }

    public GroupByColumn() {
    }

    public String getSQLCode(CodegenRequest cgReq) {
        try {
            StringBuffer sb = new StringBuffer();
            Query query = this.m_parentClause.getParentQuery();
            SelectResults results = (SelectResults)query.getClause(ClauseType.SELECT);
            ResultMapping map = results.findTargetResultMapping(this.m_tableColumn);
            if (map == null) {
                map = results.findOneToOneResultMappingUsingSourceColumn(this.m_tableColumn);
            }
            boolean found = false;
            if (this.m_bDisplayInteger) {
                if (map != null) {
                    List mappings = results.getResultMappings();
                    int loc = mappings.indexOf(map);
                    sb.append(loc + 1);
                    found = true;
                } else if (!this.m_table.getDataTable().getFQID().equals(query.getTargetTable().getDataTable().getFQID())) {
                    List mappings = results.getResultMappings();
                    for (int i = 0; i < mappings.size(); ++i) {
                        TableColumn srcMapCol;
                        ResultMapping srcMap = (ResultMapping)mappings.get(i);
                        if (!srcMap.getRole().equalsIgnoreCase("ONETOONE") || (srcMapCol = (TableColumn)srcMap.getSourceColumns().get(0)) != this.m_tableColumn) continue;
                        sb.append(i + 1);
                        found = true;
                        break;
                    }
                }
            }
            if (!found) {
                sb.append(this.m_tableColumn.getCodegenColumnName(cgReq, this.m_parentClause.getParentQuery()));
            }
            return sb.toString();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public TableColumn getTableColumn() {
        return this.m_tableColumn;
    }

    public void setParentForPropertySets(Root parentSet) {
        this.m_parentObjectForPropertySet = parentSet;
    }

    public TableInterface getTable() {
        return this.m_table;
    }

    public void setDisplayInteger(boolean displayInteger) {
        this.m_bDisplayInteger = displayInteger;
    }

    public boolean getDisplayInteger() {
        return this.m_bDisplayInteger;
    }

    public boolean containsSourceTable(TableInterface table) {
        return this.m_table.equals(table);
    }

    public void dispose() {
        try {
            PropertySet pSet;
            PropertyHandler pHandler = this.createOrderByColumnPropertyHandler(false);
            if (pHandler != null && (pSet = pHandler.getHandlerPropertySet()) != null) {
                ArrayList<Object> deleteObjects = new ArrayList<Object>();
                MdObjectStore store = (MdObjectStore)this.m_parentObjectForPropertySet.getObjectStore();
                deleteObjects.add(pSet);
                AssociationList props = pHandler.getPropertyList();
                if (props != null) {
                    for (int i = 0; i < props.size(); ++i) {
                        Property prop = (Property)props.get(i);
                        if (!prop.getSpecTargetTransformations().isEmpty()) {
                            deleteObjects.add(prop.getSpecTargetTransformations().get(0));
                        }
                        deleteObjects.add(prop);
                    }
                }
                if (!deleteObjects.isEmpty()) {
                    store.removeObjectsFromStore(deleteObjects);
                }
            }
        }
        catch (MdException exc) {
            if (this.m_parentClause.getSQLModel().isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void moveDataToModel() throws MdException, RemoteException {
        if (this.m_parentObjectForPropertySet == null) {
            return;
        }
        PropertyHandler pHandler = this.createOrderByColumnPropertyHandler(false);
        this.m_bDisplayInteger = pHandler.stringToBoolean(pHandler.getSpecificOptionValue(PROPERTY_NAME_DISPLAY_INTEGER), DISPLAY_INTEGER_DEFAULT);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_parentObjectForPropertySet == null) {
            return;
        }
        Column column = this.m_tableColumn.getColumn();
        if (column == null) {
            this.m_tableColumn.moveDataToStore();
            column = this.m_tableColumn.getColumn();
        }
        PropertyHandler pHandler = this.createOrderByColumnPropertyHandler(true);
        pHandler.setSpecificProperty(PROPERTY_NAME_DISPLAY_INTEGER, pHandler.booleanToString(this.m_bDisplayInteger), PROPERTY_NAME_DISPLAY_INTEGER, "", 1, null);
        pHandler.setPropertyMetadataObject((MdObjectStore)column.getObjectStore(), PROPERTY_NAME_COLUMN, (CMetadata)column);
    }

    protected PropertyHandler createOrderByColumnPropertyHandler(boolean createSet) throws MdException, RemoteException {
        PropertyHandler phandler = null;
        if (this.m_parentObjectForPropertySet != null) {
            AssociationList sets = this.m_parentObjectForPropertySet.getPropertySets();
            phandler = new PropertyHandler(this.m_parentObjectForPropertySet);
            phandler.setUseSetProperties(true);
            phandler.setSetRole(PROPERTY_SET_NAME_COLUMNS);
            for (int i = 0; i < sets.size(); ++i) {
                PropertySet tempSet = (PropertySet)sets.get(i);
                phandler.setPropertySet(tempSet);
                Column column = (Column)phandler.getPropertyMetadataObject(PROPERTY_NAME_COLUMN);
                Column col = this.m_tableColumn.getColumn();
                if (col == null || column == null || !column.getFQID().equals(col.getFQID())) continue;
                return phandler;
            }
            phandler.setPropertySet(null);
            if (createSet) {
                phandler.createPropertySet(true);
            }
        }
        return phandler;
    }
}

