/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.AbstractSimpleExpression;
import com.sas.wadmin.transforms.sql.model.CaseExpression;
import com.sas.wadmin.transforms.sql.model.CaseStatementChangeEvent;
import com.sas.wadmin.transforms.sql.model.CaseStatementChangeListener;
import com.sas.wadmin.transforms.sql.model.OperandInterface;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLObjectInterface;
import com.sas.wadmin.transforms.sql.model.SimpleExpressionInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TextOperand;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CaseStatement
extends AbstractSimpleExpression
implements OperandInterface {
    public static final String CASESTATEMENTCHANGED = "CaseStatementChanged";
    protected static final String TRANSFORMROLE = "CaseStatement";
    private static final String CASEFEATUREMAPROLE = "CaseExpression";
    private static final String ELSEFEATUREMAPROLE = "CaseElse";
    private SimpleExpressionInterface m_parent;
    private AbstractClause m_parentClause;
    private OperandInterface m_caseOperand;
    private List m_caseExpressions = new ArrayList();
    private List m_invalidExpressionPositions;
    private OperandInterface m_elseOperand;
    private List m_listeners = new ArrayList();
    private ClassifierMap m_classifierMap;

    public CaseStatement() {
    }

    public CaseStatement(ClassifierMap classifierMap) {
        this();
        this.m_classifierMap = classifierMap;
    }

    public void setCaseOperand(OperandInterface operand) {
        if (this.m_caseOperand != null) {
            this.m_caseOperand.dispose();
        }
        this.m_caseOperand = this.setOperandImpl(operand);
        this.fireChangeEvent(this, CASESTATEMENTCHANGED);
    }

    public void undoableSetCaseOperand(OperandInterface operand) {
        if (this.m_caseOperand != null) {
            this.m_caseOperand.setParent(null);
            this.getSQLModel().addUndoableObject((SQLObjectInterface)((Object)this.m_caseOperand));
        }
        this.m_caseOperand = this.setOperandImpl(operand);
        this.getSQLModel().removeUndoableObject((SQLObjectInterface)((Object)operand));
        this.fireChangeEvent(this, CASESTATEMENTCHANGED);
    }

    public OperandInterface getCaseOperand() {
        return this.m_caseOperand;
    }

    public void setElseOperand(OperandInterface operand) {
        if (this.m_elseOperand != null) {
            this.m_elseOperand.dispose();
        }
        this.m_elseOperand = this.setOperandImpl(operand);
        this.fireChangeEvent(this, CASESTATEMENTCHANGED);
    }

    public void undoableSetElseOperand(OperandInterface operand) {
        if (this.m_elseOperand != null) {
            this.m_elseOperand.setParent(null);
            this.getSQLModel().addUndoableObject((SQLObjectInterface)((Object)this.m_elseOperand));
        }
        this.m_elseOperand = this.setOperandImpl(operand);
        this.getSQLModel().removeUndoableObject((SQLObjectInterface)((Object)operand));
        this.fireChangeEvent(this, CASESTATEMENTCHANGED);
    }

    public OperandInterface getElseOperand() {
        return this.m_elseOperand;
    }

    private OperandInterface setOperandImpl(OperandInterface operand) {
        operand.setParent(this);
        if (operand instanceof CaseStatement) {
            ((CaseStatement)operand).setSQLModel(this.getSQLModel());
            ((CaseStatement)operand).setParentQuery(this.getParentQuery());
            ((CaseStatement)operand).setParentClause(this.getParentClause());
        }
        if (operand instanceof SubQuery) {
            ((SubQuery)operand).setSQLModel(this.getSQLModel());
            ((SubQuery)operand).setParentQuery(this.getParentQuery());
            ((SubQuery)operand).setParentClause(this.getParentClause());
        }
        return operand;
    }

    public List getExpressions() {
        return this.m_caseExpressions;
    }

    @Override
    public List getTableColumns() {
        ArrayList newList = new ArrayList();
        if (this.m_caseExpressions != null) {
            for (int i = 0; i < this.m_caseExpressions.size(); ++i) {
                CaseExpression expr = (CaseExpression)this.m_caseExpressions.get(i);
                newList.addAll(expr.getTableColumns());
            }
        }
        if (this.m_caseOperand != null) {
            newList.addAll(this.m_caseOperand.getTableColumns());
        }
        if (this.m_elseOperand != null) {
            newList.addAll(this.m_elseOperand.getTableColumns());
        }
        return newList;
    }

    public void setExpressions(List expressions) {
        if (expressions == null) {
            return;
        }
        if (this.m_caseExpressions == null) {
            this.m_caseExpressions = new ArrayList();
        } else {
            this.m_caseExpressions.clear();
        }
        for (int i = 0; i < expressions.size(); ++i) {
            CaseExpression expr = (CaseExpression)expressions.get(i);
            expr.setParent(this);
            expr.setParentQuery(this.getParentQuery());
            expr.setSQLModel(this.getSQLModel());
            this.m_caseExpressions.add(expr);
        }
        this.fireChangeEvent(this, CASESTATEMENTCHANGED);
    }

    public void addExpression(CaseExpression expression) {
        if (expression == null) {
            return;
        }
        if (this.m_caseExpressions == null) {
            this.m_caseExpressions = new ArrayList();
        }
        expression.setParent(this);
        expression.setSQLModel(this.getSQLModel());
        expression.setParentQuery(this.getParentQuery());
        this.m_caseExpressions.add(expression);
        this.getSQLModel().removeUndoableObject(expression);
        this.fireChangeEvent(this, CASESTATEMENTCHANGED);
    }

    public void addExpression(int index, CaseExpression expression) {
        if (expression == null) {
            return;
        }
        if (this.m_caseExpressions == null) {
            this.m_caseExpressions = new ArrayList();
        }
        expression.setParent(this);
        expression.setSQLModel(this.getSQLModel());
        expression.setParentQuery(this.getParentQuery());
        this.m_caseExpressions.add(index, expression);
        this.getSQLModel().removeUndoableObject(expression);
        this.fireChangeEvent(this, CASESTATEMENTCHANGED);
    }

    public void moveCaseExpression(int oldIndex, int newIndex) {
        CaseExpression expression = (CaseExpression)this.m_caseExpressions.remove(oldIndex);
        this.m_caseExpressions.add(newIndex, expression);
        this.fireChangeEvent(this, CASESTATEMENTCHANGED);
    }

    public void removeExpression(CaseExpression expression) {
        this.m_caseExpressions.remove(expression);
        expression.dispose();
        expression = null;
        this.fireChangeEvent(this, CASESTATEMENTCHANGED);
    }

    public void undoableRemoveExpression(CaseExpression expression) {
        this.m_caseExpressions.remove(expression);
        expression.setParent(null);
        this.getSQLModel().addUndoableObject(expression);
        this.fireChangeEvent(this, CASESTATEMENTCHANGED);
    }

    public void removeExpression(int index) {
        CaseExpression expression = (CaseExpression)this.m_caseExpressions.remove(index);
        expression.dispose();
        expression = null;
        this.fireChangeEvent(this, CASESTATEMENTCHANGED);
    }

    public void undoableRemoveExpression(int index) {
        CaseExpression expression = (CaseExpression)this.m_caseExpressions.remove(index);
        expression.setParent(null);
        this.getSQLModel().addUndoableObject(expression);
        this.fireChangeEvent(this, CASESTATEMENTCHANGED);
    }

    public ClassifierMap getClassifierMap() {
        return this.m_classifierMap;
    }

    @Override
    public String getSQLCode(CodegenRequest cgReq, boolean resetPosition) {
        StringBuffer sb = new StringBuffer();
        sb.append("case ");
        if (this.m_caseOperand != null) {
            sb.append(this.m_caseOperand.getSQLCode(cgReq, resetPosition));
        }
        sb.append("\n");
        for (int i = 0; i < this.m_caseExpressions.size(); ++i) {
            CaseExpression caseExpr = (CaseExpression)this.m_caseExpressions.get(i);
            sb.append(caseExpr.getSQLCode(cgReq, resetPosition));
        }
        if (this.m_elseOperand != null) {
            sb.append("else ").append(this.m_elseOperand.getSQLCode(cgReq, resetPosition)).append("\n");
        }
        sb.append("end\n");
        return sb.toString();
    }

    @Override
    public CodegenRequest appendCode(CodegenRequest cgReq, boolean resetPosition) {
        String text;
        cgReq.addSourceCode("case ");
        if (this.m_caseOperand != null && this.m_caseOperand instanceof TextOperand && (text = ((TextOperand)this.m_caseOperand).getText()).length() > 0) {
            this.m_caseOperand.appendCode(cgReq, resetPosition);
        }
        cgReq.addSourceCode("\n").indent();
        for (int i = 0; i < this.m_caseExpressions.size(); ++i) {
            CaseExpression caseExpr = (CaseExpression)this.m_caseExpressions.get(i);
            caseExpr.appendCode(cgReq, resetPosition);
        }
        if (this.m_elseOperand != null && this.m_elseOperand instanceof TextOperand && (text = ((TextOperand)this.m_elseOperand).getText()).length() > 0) {
            cgReq.addSourceCode("else ");
            this.m_elseOperand.appendCode(cgReq, resetPosition).addSourceCode("\n");
        }
        cgReq.unIndent().addSourceCode("end");
        return cgReq;
    }

    @Override
    public boolean hasText() {
        return true;
    }

    @Override
    public Root getMetadataObject() {
        return this.m_classifierMap;
    }

    @Override
    public String getOperandType() {
        return "CaseOperand";
    }

    @Override
    public boolean hasMissingTokens() {
        if (this.m_caseOperand != null && this.m_caseOperand.hasMissingTokens()) {
            return true;
        }
        if (this.m_elseOperand != null && this.m_elseOperand.hasMissingTokens()) {
            return true;
        }
        for (int i = 0; i < this.m_caseExpressions.size(); ++i) {
            CaseExpression expr = (CaseExpression)this.m_caseExpressions.get(i);
            if (!expr.getWhenOperand().hasMissingTokens() && !expr.getThenOperand().hasMissingTokens()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("case ");
        if (this.m_caseOperand != null) {
            sb.append(this.m_caseOperand.toString());
        }
        sb.append("\n");
        for (int i = 0; i < this.m_caseExpressions.size(); ++i) {
            CaseExpression caseExpr = (CaseExpression)this.m_caseExpressions.get(i);
            sb.append(caseExpr.toString()).append("\n");
        }
        if (this.m_elseOperand != null) {
            sb.append("else ").append(this.m_elseOperand.toString()).append("\n");
        }
        sb.append("end\n");
        return sb.toString();
    }

    @Override
    public OperandInterface copyOperand() {
        CaseStatement caseStmt = new CaseStatement();
        caseStmt.setSQLModel(this.getSQLModel());
        caseStmt.setParentQuery(this.getParentQuery());
        caseStmt.setParentClause(this.getParentClause());
        for (int i = 0; i < this.m_caseExpressions.size(); ++i) {
            CaseExpression expr = (CaseExpression)this.m_caseExpressions.get(i);
            CaseExpression newExpr = (CaseExpression)expr.copyExpression();
            newExpr.setParent(caseStmt);
            caseStmt.addExpression(newExpr);
        }
        if (this.m_caseOperand != null) {
            caseStmt.setCaseOperand(this.m_caseOperand.copyOperand());
        }
        if (this.m_elseOperand != null) {
            caseStmt.setElseOperand(this.m_elseOperand.copyOperand());
        }
        return caseStmt;
    }

    @Override
    public SimpleExpressionInterface copyExpression() {
        return (SimpleExpressionInterface)((Object)this.copyOperand());
    }

    @Override
    public boolean containsSourceTable(TableInterface table) {
        if (this.m_caseOperand != null && this.m_caseOperand.containsSourceTable(table)) {
            return true;
        }
        for (int i = 0; i < this.m_caseExpressions.size(); ++i) {
            CaseExpression caseExpr = (CaseExpression)this.m_caseExpressions.get(i);
            if (!caseExpr.containsSourceTable(table)) continue;
            return true;
        }
        return this.m_elseOperand != null && this.m_elseOperand.containsSourceTable(table);
    }

    @Override
    public void setParent(SimpleExpressionInterface expression) {
        this.m_parent = expression;
    }

    public SimpleExpressionInterface getParent() {
        return this.m_parent;
    }

    public void setParentClause(AbstractClause clause) {
        this.m_parentClause = clause;
    }

    public AbstractClause getParentClause() {
        return this.m_parentClause;
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        if (this.m_classifierMap == null) {
            return;
        }
        AssociationList featureMaps = this.m_classifierMap.getFeatureMaps();
        if (!featureMaps.isEmpty()) {
            for (int i = 0; i < featureMaps.size(); ++i) {
                AssociationList targetTrans;
                String objectType;
                Root object;
                FeatureMap fM = (FeatureMap)featureMaps.get(i);
                String role = fM.getTransformRole();
                if (role.equalsIgnoreCase("CaseWhenThen")) {
                    CaseExpression caseExpr = new CaseExpression(fM);
                    this.addExpression(caseExpr);
                    caseExpr.moveDataToModel();
                    continue;
                }
                if (role.equalsIgnoreCase(CASEFEATUREMAPROLE)) {
                    AssociationList sourceTrans = fM.getSourceTransformations();
                    if (sourceTrans.isEmpty()) continue;
                    object = (Root)sourceTrans.get(0);
                    objectType = object.getCMetadataType();
                    if (objectType.equalsIgnoreCase("FeatureMap")) {
                        this.setCaseOperand(new TextOperand((SimpleExpressionInterface)this, (FeatureMap)object));
                    } else if (objectType.equalsIgnoreCase("QueryTable")) {
                        this.setCaseOperand(new SubQuery((QueryTable)object));
                    } else if (objectType.equalsIgnoreCase("ClassifierMap")) {
                        this.setCaseOperand(new CaseStatement((ClassifierMap)object));
                    }
                    this.m_caseOperand.moveDataToModel();
                    continue;
                }
                if (!role.equalsIgnoreCase(ELSEFEATUREMAPROLE) || (targetTrans = fM.getSourceTransformations()).isEmpty()) continue;
                object = (Root)targetTrans.get(0);
                objectType = object.getCMetadataType();
                if (objectType.equalsIgnoreCase("FeatureMap")) {
                    this.setElseOperand(new TextOperand((SimpleExpressionInterface)this, (FeatureMap)object));
                } else if (objectType.equalsIgnoreCase("QueryTable")) {
                    this.setElseOperand(new SubQuery((QueryTable)object));
                } else if (objectType.equalsIgnoreCase("ClassifierMap")) {
                    this.setElseOperand(new CaseStatement((ClassifierMap)object));
                }
                this.m_elseOperand.moveDataToModel();
            }
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        int i;
        SQLModel model = this.getSQLModel();
        MdObjectStore store = model.getObjectStore();
        String reposId = model.getRepositoryId();
        Select select = this.getParentQuery().getSelectObject();
        if (this.m_classifierMap == null) {
            this.m_classifierMap = (ClassifierMap)Workspace.getMdFactory().createComplexMetadataObject(store, TRANSFORMROLE, "ClassifierMap", reposId);
            this.m_classifierMap.setTransformRole(TRANSFORMROLE);
            select.getTransformationSources().add((Object)this.m_classifierMap);
        }
        AssociationList featureMaps = this.m_classifierMap.getFeatureMaps();
        for (i = 0; i < featureMaps.size(); ++i) {
            FeatureMap map = (FeatureMap)featureMaps.get(i);
            if (map.getTransformRole().equalsIgnoreCase(CASEFEATUREMAPROLE)) {
                store.removeObjectFromStore((CMetadata)map, null);
            }
            if (!map.getTransformRole().equalsIgnoreCase(ELSEFEATUREMAPROLE)) continue;
            store.removeObjectFromStore((CMetadata)map, null);
        }
        featureMaps.removeAllElements();
        featureMaps.flushAll();
        if (this.m_caseOperand != null) {
            this.m_caseOperand.moveDataToStore();
            FeatureMap fM = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject(store, CASEFEATUREMAPROLE, "FeatureMap", reposId);
            fM.setTransformRole(CASEFEATUREMAPROLE);
            fM.getSourceTransformations().add((Object)this.m_caseOperand.getMetadataObject());
            featureMaps.add((Object)fM);
        }
        if (this.m_elseOperand != null) {
            this.m_elseOperand.moveDataToStore();
            FeatureMap fM = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject(store, ELSEFEATUREMAPROLE, "FeatureMap", reposId);
            fM.setTransformRole(ELSEFEATUREMAPROLE);
            fM.getSourceTransformations().add((Object)this.m_elseOperand.getMetadataObject());
            featureMaps.add((Object)fM);
        }
        for (i = 0; i < this.m_caseExpressions.size(); ++i) {
            CaseExpression caseExpr = (CaseExpression)this.m_caseExpressions.get(i);
            caseExpr.moveDataToStore();
            featureMaps.addElement((Object)caseExpr.getFeatureMap());
        }
    }

    @Override
    public boolean validate() {
        this.m_invalidExpressionPositions = new ArrayList();
        if (this.m_caseOperand != null && !this.m_caseOperand.validate()) {
            return false;
        }
        for (int i = 0; i < this.m_caseExpressions.size(); ++i) {
            CaseExpression expr = (CaseExpression)this.m_caseExpressions.get(i);
            if (expr.validate()) continue;
            this.m_invalidExpressionPositions.add(new Integer(this.m_caseExpressions.indexOf(expr)));
        }
        if (this.m_invalidExpressionPositions.size() > 0) {
            return false;
        }
        return this.m_elseOperand == null || this.m_elseOperand.validate();
    }

    public List getInvalidExpresionPositions() {
        return this.m_invalidExpressionPositions;
    }

    @Override
    public void dispose() {
        MdObjectStore store = this.getSQLModel().getObjectStore();
        if (this.m_caseOperand != null) {
            this.m_caseOperand.dispose();
            this.m_caseOperand = null;
        }
        if (this.m_elseOperand != null) {
            this.m_elseOperand.dispose();
            this.m_elseOperand = null;
        }
        for (int i = 0; i < this.m_caseExpressions.size(); ++i) {
            CaseExpression caseExpr = (CaseExpression)this.m_caseExpressions.get(i);
            caseExpr.dispose();
        }
        this.m_caseExpressions.clear();
        if (this.m_classifierMap == null) {
            return;
        }
        try {
            Select parentSelect = this.getParentQuery().getSelectObject();
            parentSelect.getTransformationSources().removeElement((Object)this.m_classifierMap);
            AssociationList featureMaps = this.m_classifierMap.getFeatureMaps();
            for (int i = 0; i < featureMaps.size(); ++i) {
                store.removeObjectFromStore((CMetadata)((FeatureMap)featureMaps.get(i)), null);
            }
            if (this.m_classifierMap != null) {
                store.removeObjectFromStore((CMetadata)this.m_classifierMap, null);
                this.m_classifierMap = null;
            }
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void addChangeListener(CaseStatementChangeListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeChangeListener(CaseStatementChangeListener listener) {
        this.m_listeners.remove(listener);
    }

    public void fireChangeEvent(CaseStatement statement, String action) {
        for (int index = this.m_listeners.size() - 1; index >= 0; --index) {
            CaseStatementChangeListener listener = (CaseStatementChangeListener)this.m_listeners.get(index);
            listener.caseStatementChanged(new CaseStatementChangeEvent(this, statement, action));
        }
    }
}

