/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DBMSSTORE;
import com.sas.codegen.Loader;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.pfd.PFDUtil;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.ClauseType;
import com.sas.wadmin.transforms.sql.model.CreateSelect;
import com.sas.wadmin.transforms.sql.model.From;
import com.sas.wadmin.transforms.sql.model.Join;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLObjectInterface;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.model.TableAlias;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTable
implements TableInterface,
SQLObjectInterface {
    public static final String ALIASCHANGED = "AliasChanged";
    protected DataTable m_table;
    protected TableAlias m_alias;
    protected SQLModel m_model;
    protected String m_options;
    private Query m_parentQuery;
    private ClauseInterface m_parent;
    protected List m_columns;
    protected static final String PROPERTY_NAME_ADDITIONAL_OPTIONS = "AdditionalOptions";
    private static final WAdminResource bundle = WAdminResource.getBundle(AbstractTable.class);

    public AbstractTable(DataTable table) {
        this.m_table = table;
        this.m_options = "";
        this.m_columns = new ArrayList();
    }

    @Override
    public DataTable getDataTable() {
        return this.m_table;
    }

    public void setAlias(String alias) {
        if (this.m_alias == null) {
            this.m_alias = new TableAlias(this.m_table, alias);
            this.m_alias.setParent(this);
            try {
                this.m_alias.moveDataToModel();
                QueryTable qTable = this.m_alias.getQueryTable();
                AssociationList qCols = qTable.getColumns();
                if (!qCols.isEmpty()) {
                    this.syncQueryTableColumns();
                } else {
                    this.moveDataToStore();
                }
            }
            catch (MdException me) {
                if (this.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(me.getLocalizedMessage());
                } else {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            return;
        }
        if (this.m_alias.getAliasName().equals(alias)) {
            return;
        }
        this.m_alias.setAliasName(alias);
        try {
            QueryTable qTable = this.m_alias.getQueryTable();
            AssociationList qCols = qTable.getColumns();
            if (!qCols.isEmpty()) {
                this.syncQueryTableColumns();
            } else {
                this.moveDataToStore();
            }
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void setTableAlias(TableAlias alias) {
        this.m_alias = alias;
        this.m_alias.setParent(this);
    }

    public boolean isAliased() {
        return this.m_alias != null && !"".equals(this.m_alias.getAliasName());
    }

    public String getAlias() {
        if (!this.isAliased()) {
            return "";
        }
        return this.m_alias.getAliasName();
    }

    public TableAlias getTableAlias() {
        return this.m_alias;
    }

    public QueryTable getQueryTable() {
        QueryTable qTable = null;
        if (this.m_alias != null) {
            qTable = this.m_alias.getQueryTable();
        }
        return qTable;
    }

    public List getTableColumns() {
        return this.m_columns;
    }

    public void setSQLModel(SQLModel model) {
        this.m_model = model;
    }

    @Override
    public SQLModel getSQLModel() {
        return this.m_model;
    }

    public void setParent(ClauseInterface parent) {
        if (this.m_parent == parent) {
            return;
        }
        if (this.m_parent instanceof From) {
            ((From)this.m_parent).removeSource((SourceTableInterface)((Object)this));
        } else if (this.m_parent instanceof Join) {
            ((Join)this.m_parent).removeSource((SourceTableInterface)((Object)this));
        } else if (this.m_parent instanceof CreateSelect) {
            ((CreateSelect)this.m_parent).removeTargetTable();
        }
        this.m_parent = parent;
    }

    protected void setParentNoRemove(ClauseInterface parent) {
        if (this.m_parent == parent) {
            return;
        }
        this.m_parent = parent;
    }

    @Override
    public ClauseInterface getParent() {
        return this.m_parent;
    }

    @Override
    public void setOptions(String options) {
        if (this.m_options.equals(options)) {
            return;
        }
        this.m_options = options;
        this.m_model.fireChangeEvent(this, "OptionsChanged");
    }

    public void addTableColumn(TableColumn column) {
        if (column == null) {
            return;
        }
        column.setParent(this);
        this.m_columns.add(column);
        this.m_model.removeUndoableObject(column);
    }

    public void addTableColumn(int index, TableColumn column) {
        if (column == null) {
            return;
        }
        column.setParent(this);
        this.m_columns.add(index, column);
        this.m_model.removeUndoableObject(column);
    }

    public void moveTableColumn(int oldIndex, int newIndex) {
        TableColumn column = (TableColumn)this.m_columns.remove(oldIndex);
        this.m_columns.add(newIndex, column);
    }

    public void removeTableColumn(TableColumn column) {
        int index = this.m_columns.indexOf(column);
        this.removeSourceMapping(this.m_parentQuery.getParentQuery(), column);
        this.m_columns.remove(index);
        column.dispose();
        column = null;
    }

    public void cleanSourceMappings(Query query) {
        int size = this.m_columns.size();
        for (int i = 0; i < size; ++i) {
            this.removeSourceMapping(query, (TableColumn)this.m_columns.get(i));
        }
    }

    private void removeSourceMapping(Query query, TableColumn column) {
        SelectResults sResults;
        if (query != null && (sResults = (SelectResults)query.getClause(ClauseType.SELECT)) != null) {
            sResults.removeSourceFromResultMappings(column);
        }
    }

    public void undoableRemoveTableColumn(TableColumn column) {
        int index = this.m_columns.indexOf(column);
        this.m_columns.remove(index);
        column.setParent(null);
        this.getSQLModel().addUndoableObject(column);
    }

    public void removeTableColumn(int index) {
        TableColumn column = (TableColumn)this.m_columns.get(index);
        this.m_columns.remove(index);
        column.dispose();
        column = null;
    }

    public void undoableRemoveTableColumn(int index) {
        TableColumn column = (TableColumn)this.m_columns.get(index);
        this.m_columns.remove(index);
        column.setParent(null);
        this.getSQLModel().addUndoableObject(column);
    }

    @Override
    public String getOptions() {
        return this.m_options;
    }

    public String getUnderlyingTableName(CodegenRequest cgReq) {
        return this.getDataTableName(cgReq);
    }

    public String getUnderlyingTableName() {
        try {
            if (this.m_table instanceof PhysicalTable) {
                return ((PhysicalTable)this.m_table).getSASTableName();
            }
            return this.m_table.getTableName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public void moveDataToModel() throws MdException, RemoteException {
        if (this.m_alias != null) {
            this.m_alias.moveDataToModel();
        }
        if (this.m_table == null) {
            this.m_table = this.m_alias.getDataTable();
        }
        if (this.m_table == null) {
            this.m_alias.dispose();
            return;
        }
        this.m_columns.clear();
        AssociationList columns = this.m_table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            TableColumn qCol = new TableColumn(column, this);
            qCol.moveDataToModel();
            this.m_columns.add(qCol);
        }
        if (this.m_alias != null) {
            this.syncQueryTableColumns();
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_alias != null) {
            this.m_alias.moveDataToStore();
        }
        for (int i = 0; i < this.m_columns.size(); ++i) {
            TableColumn qCol = (TableColumn)this.m_columns.get(i);
            qCol.moveDataToStore();
        }
        this.syncQueryTableColumns();
    }

    private void syncQueryTableColumns() throws MdException, RemoteException {
        if (this.m_table != null && this.m_alias != null) {
            QueryTable qTable = this.m_alias.getQueryTable();
            if (qTable == null) {
                this.m_alias.moveDataToStore();
                qTable = this.m_alias.getQueryTable();
            }
            MdObjectStore store = (MdObjectStore)qTable.getObjectStore();
            AssociationList columnList = this.m_table.getColumns();
            int size = columnList.size();
            ArrayList<Column> foundList = new ArrayList<Column>();
            for (int i = 0; i < size; ++i) {
                Column col = (Column)columnList.get(i);
                String sasColumnName = col.getSASColumnName();
                AssociationList qColumns = qTable.getColumns();
                int qSize = qColumns.size();
                boolean found = false;
                Column foundQColumn = null;
                for (int j = 0; j < qSize; ++j) {
                    Column qColumn = (Column)qColumns.get(j);
                    if (!qColumn.getSASColumnName().equalsIgnoreCase(sasColumnName)) continue;
                    foundQColumn = qColumn;
                    found = true;
                    break;
                }
                if (!found) continue;
                foundList.add(foundQColumn);
            }
            ArrayList deleteColumns = new ArrayList();
            AssociationList qColumns = qTable.getColumns();
            int qSize = qColumns.size();
            for (int i = 0; i < qSize; ++i) {
                if (foundList.contains(qColumns.get(i))) continue;
                deleteColumns.add(qColumns.get(i));
            }
            store.removeObjectsFromStore(deleteColumns);
        }
    }

    public void appendClauseCode(CodegenRequest cgReq) {
        cgReq.addSourceCode(this.getDataTableName(cgReq));
    }

    @Override
    public String getDataTableName() {
        try {
            String tableName = "";
            if (this.m_table != null) {
                tableName = this.m_table instanceof PhysicalTable ? ((PhysicalTable)this.m_table).getSASTableName() : this.m_table.getTableName();
            }
            return tableName;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public String getDataTableName(CodegenRequest cgReq) {
        String tableName = "";
        if (this.m_table instanceof PhysicalTable) {
            try {
                PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)this.m_table);
                tableName = tableCG.getTableName(cgReq, true, this.getSQLModel().isPassThrough());
            }
            catch (MdException exc) {
                if (this.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(exc.getLocalizedMessage());
                } else {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return tableName;
    }

    public String getDataTableLocation(CodegenRequest cgReq, boolean passthru) {
        return this.getDataTableLocation(cgReq, passthru, true);
    }

    public String getDataTableLocation(CodegenRequest cgReq, boolean passthru, boolean quotes) {
        try {
            String tableLocation = "";
            if (this.m_table instanceof PhysicalTable) {
                MdObjectStore store = (MdObjectStore)this.m_table.getObjectStore();
                try {
                    PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)this.m_table);
                    tableLocation = tableCG.getDataLocation(cgReq, passthru, quotes);
                    this.deleteWorkLibrary(cgReq, store);
                }
                catch (MdException exc) {
                    if (this.getSQLModel().isSilentModeEnabled()) {
                        System.out.print(exc.getLocalizedMessage());
                    } else {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            return tableLocation;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    protected void deleteWorkLibrary(CodegenRequest cgReq, MdObjectStore store) throws MdException, RemoteException {
        SASLibrary lib;
        if (this.m_table instanceof WorkTable && this.m_table.getTablePackage() != null && this.m_table.getTablePackage() instanceof SASLibrary && (lib = (SASLibrary)this.m_table.getTablePackage()).getLibref().equals("work") && lib.getIsPreassigned() == 1 && lib.isNewObject() && this.getSQLModel().isCodeGenSelfOnly()) {
            cgReq.removeObjectFromCache((CMetadata)lib);
            store.removeObjectFromStore((CMetadata)lib, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genAccessPath(CodegenRequest cgReq) {
        block28: {
            try {
                if (this.m_table == null || !(this.m_table instanceof PhysicalTable)) break block28;
                MdObjectStore newStore = Workspace.getMdFactory().createObjectStore(null, "SQL Libname generation store");
                try {
                    PhysicalTable tempTable = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(newStore, this.m_table.getObjectStore(), (CMetadata)this.m_table);
                    tempTable.setTargetClassifierMaps(this.m_table.getTargetClassifierMaps());
                    PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)tempTable);
                    tableCG.accessPath(cgReq, true);
                }
                catch (MdException exc) {
                    if (this.getSQLModel().isSilentModeEnabled()) {
                        System.out.print(exc.getLocalizedMessage());
                    } else if (cgReq.isThrowingExceptions()) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                finally {
                    try {
                        this.deleteWorkLibrary(cgReq, newStore);
                    }
                    catch (MdException exc) {
                        if (this.getSQLModel().isSilentModeEnabled()) {
                            System.out.print(exc.getLocalizedMessage());
                        } else if (cgReq.isThrowingExceptions()) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    if (newStore != null) {
                        newStore.dispose();
                    }
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    public String toString() {
        return this.getDataTableName();
    }

    public Query getParentQuery() {
        return this.m_parentQuery;
    }

    public void setParentQuery(Query parentQuery) {
        this.m_parentQuery = parentQuery;
    }

    @Override
    public boolean hasTableOptions() {
        return this.m_options.trim().length() > 0;
    }

    @Override
    public boolean isTableAView() {
        boolean isView;
        block6: {
            isView = true;
            if (this.m_table instanceof PhysicalTable) {
                try {
                    isView = PFDUtil.isTableView((PhysicalTable)this.m_table);
                }
                catch (MdException exc) {
                    if (this.getSQLModel().isSilentModeEnabled()) {
                        System.out.print(exc.getLocalizedMessage());
                        break block6;
                    }
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            } else {
                isView = false;
            }
        }
        return isView;
    }

    @Override
    public boolean isChangeViewSupported() {
        return false;
    }

    @Override
    public void setIsTableAView(boolean isView) {
        if (this.m_table instanceof PhysicalTable) {
            boolean origViewValue = true;
            try {
                origViewValue = PFDUtil.isTableView((PhysicalTable)this.m_table);
            }
            catch (MdException exc) {
                if (this.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(exc.getLocalizedMessage());
                } else {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            if (origViewValue == isView) {
                return;
            }
            PFDUtil.setTableMemberType((PhysicalTable)this.m_table, isView);
            this.m_model.fireChangeEvent(this, "MemberTypeChanged");
        }
    }

    public TableColumn findTableColumn(Column col) {
        try {
            int size = this.m_columns.size();
            for (int i = 0; i < size; ++i) {
                TableColumn tCol = (TableColumn)this.m_columns.get(i);
                Column lCol = tCol.getColumn();
                if (lCol == null || !lCol.getFQID().equals(col.getFQID())) continue;
                return tCol;
            }
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    @Override
    public String getDisplayTableName() {
        try {
            String sMetadataName = this.getDataTable().getName();
            String sTableName = this.isAliased() ? this.getAlias() : this.getUnderlyingTableName();
            return bundle.formatString("AbstractTable.DisplayTableName.name.txt", (Object)sMetadataName, (Object)sTableName);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    @Override
    public DBMSSTORE getDBMSStore(CodegenRequest cgReq) {
        DBMSSTORE tableCG = null;
        try {
            tableCG = new Loader(cgReq, (PhysicalTable)this.getDataTable()).getDBMSSTORE();
        }
        catch (MdException exc) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return tableCG;
    }
}

