/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DiagramContentHandler;
import com.sas.wadmin.transforms.sql.editor.SQLClauseNode;
import com.sas.wadmin.transforms.sql.editor.SQLPhysicalTableNode;
import com.sas.wadmin.transforms.sql.editor.SQLWorkTableNode;
import java.util.List;
import org.xml.sax.Attributes;

public class SQLDiagramContentHandler
extends DiagramContentHandler {
    public static final String XMLTAG_SQLCLAUSE_NODE = "SQLClauseNode";
    public static final String XMLTAG_SQLWORKTABLE_NODE = "SQLWorkTableNode";
    public static final String XMLTAB_SQLPHYSICALTABLE_NODE = "SQLPhysicalTableNode";
    private IQuery m_query;

    public SQLDiagramContentHandler(IQuery query, List links, List nodes, List notes, IDesignTimeModel jobModel) {
        super(links, nodes, notes, jobModel);
        this.m_query = query;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        String elementName = "";
        if ("".equals(uri)) {
            this.setCurrentValue("");
            elementName = qName;
        } else {
            elementName = name;
        }
        if (XMLTAG_SQLCLAUSE_NODE.equalsIgnoreCase(elementName)) {
            this.setDocumentState(STATE_NODE_STARTED);
            this.setElement(XMLTAG_SQLCLAUSE_NODE);
        }
        if (XMLTAG_SQLWORKTABLE_NODE.equalsIgnoreCase(elementName)) {
            this.setDocumentState(STATE_NODE_STARTED);
            this.setElement(XMLTAG_SQLWORKTABLE_NODE);
        }
        if (XMLTAB_SQLPHYSICALTABLE_NODE.equalsIgnoreCase(elementName)) {
            this.setDocumentState(STATE_NODE_STARTED);
            this.setElement(XMLTAB_SQLPHYSICALTABLE_NODE);
        } else {
            super.startElement(uri, name, qName, atts);
        }
    }

    @Override
    protected void createNode() {
        if (XMLTAG_SQLCLAUSE_NODE.equalsIgnoreCase(this.getElement())) {
            SQLClauseNode cl;
            List lAttrs = this.getAttributeList();
            List lValues = this.getValueList();
            String sClauseType = "";
            int iIndex = -1;
            for (int index = 0; index < lAttrs.size(); ++index) {
                String sAttribute = (String)lAttrs.get(index);
                String sValue = (String)lValues.get(index);
                if (sAttribute.equalsIgnoreCase("ClauseType")) {
                    sClauseType = sValue;
                    continue;
                }
                if (!sAttribute.equalsIgnoreCase("Index")) continue;
                iIndex = Integer.parseInt(sValue);
            }
            if (iIndex == -1) {
                return;
            }
            List clauses = this.m_query.getAllClauses();
            if (iIndex > clauses.size() - 1) {
                return;
            }
            ISelectResultsContainer clause = null;
            if (sClauseType.equalsIgnoreCase("Select")) {
                clause = this.m_query.getSelectResults();
            } else if (sClauseType.equalsIgnoreCase("Where")) {
                clause = this.m_query.getWhere();
            } else if (sClauseType.equalsIgnoreCase("Having")) {
                clause = this.m_query.getHaving();
            } else if (sClauseType.equalsIgnoreCase("Order by")) {
                clause = this.m_query.getOrderBy();
            } else if (sClauseType.equalsIgnoreCase("Group by")) {
                clause = this.m_query.getGroupBy();
            } else {
                clause = (IClause)this.m_query.getAllClauses().get(iIndex);
                if (!sClauseType.equals(clause.getClauseType().getType())) {
                    return;
                }
            }
            if (clause != null && (cl = new SQLClauseNode(this.m_query, lAttrs, lValues)).getAdapter() != null) {
                this.addNode(cl);
            }
        } else if (XMLTAG_SQLWORKTABLE_NODE.equalsIgnoreCase(this.getElement())) {
            SQLWorkTableNode cl;
            List lAttrs = this.getAttributeList();
            List lValues = this.getValueList();
            int iIndex = -1;
            boolean isTarget = false;
            String sJoin = "";
            for (int index = 0; index < lAttrs.size(); ++index) {
                String sAttribute = (String)lAttrs.get(index);
                String sValue = (String)lValues.get(index);
                if (sAttribute.equalsIgnoreCase("Index")) {
                    iIndex = Integer.parseInt(sValue);
                    continue;
                }
                if ("IsTarget".equalsIgnoreCase(sAttribute)) {
                    isTarget = Boolean.parseBoolean(sValue);
                    continue;
                }
                if (!"JoinSide".equalsIgnoreCase(sAttribute)) continue;
                sJoin = sValue;
            }
            if (iIndex == -1 && !isTarget) {
                return;
            }
            if (!isTarget) {
                List sources = this.m_query.getQuerySourceTableList();
                if (sources.size() == 0 || sources.size() - 1 < iIndex) {
                    return;
                }
                ITable source = (ITable)sources.get(iIndex);
                IClause parent = ((ISourceTable)source).getParent();
                if (sJoin.length() > 0 && parent instanceof IJoin) {
                    IJoin join = (IJoin)parent;
                    if (sJoin.equalsIgnoreCase("Left")) {
                        if (join.getLeftSide() != source) {
                            return;
                        }
                    } else if (sJoin.equalsIgnoreCase("Right")) {
                        if (join.getRightSide() != source) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if (!(((ISourceTable)source).getAliasedTable() instanceof IWorkTable)) {
                    return;
                }
            } else {
                ITable target = this.m_query.getTargetTable();
                if (target == null || !(target instanceof IWorkTable)) {
                    return;
                }
            }
            if ((cl = new SQLWorkTableNode(this.m_query, lAttrs, lValues)).getAdapter() != null) {
                this.addNode(cl);
            }
        } else if (XMLTAB_SQLPHYSICALTABLE_NODE.equalsIgnoreCase(this.getElement())) {
            SQLPhysicalTableNode cl;
            List lAttrs = this.getAttributeList();
            List lValues = this.getValueList();
            int iIndex = -1;
            boolean isTarget = false;
            String sJoin = "";
            for (int index = 0; index < lAttrs.size(); ++index) {
                String sAttribute = (String)lAttrs.get(index);
                String sValue = (String)lValues.get(index);
                if (sAttribute.equalsIgnoreCase("Index")) {
                    iIndex = Integer.parseInt(sValue);
                    continue;
                }
                if ("IsTarget".equalsIgnoreCase(sAttribute)) {
                    isTarget = Boolean.parseBoolean(sValue);
                    continue;
                }
                if (!"JoinSide".equalsIgnoreCase(sAttribute)) continue;
                sJoin = sValue;
            }
            if (iIndex == -1 && !isTarget) {
                return;
            }
            if (!isTarget) {
                List sources = this.m_query.getQuerySourceTableList();
                if (sources.size() - 1 < iIndex) {
                    return;
                }
                ITable source = (ITable)sources.get(iIndex);
                IClause parent = ((ISourceTable)source).getParent();
                if (sJoin.length() > 0 && parent instanceof IJoin) {
                    IJoin join = (IJoin)parent;
                    if (sJoin.equalsIgnoreCase("Left")) {
                        if (join.getLeftSide() != source) {
                            return;
                        }
                    } else if (sJoin.equalsIgnoreCase("Right")) {
                        if (join.getRightSide() != source) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if (((ISourceTable)source).getAliasedTable() instanceof IWorkTable) {
                    return;
                }
            } else {
                ITable target = this.m_query.getTargetTable();
                if (target == null || target instanceof IWorkTable) {
                    return;
                }
            }
            if ((cl = new SQLPhysicalTableNode(this.m_query, this.getAttributeList(), this.getValueList())).getAdapter() != null) {
                this.addNode(cl);
            }
        } else {
            super.createNode();
        }
    }
}

