/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.entities.GUID;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.IUIPlacement;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.graphics.components.pfd.PFDAbstractButton;
import com.sas.graphics.components.pfd.PFDButton;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDStatus;
import com.sas.graphics.components.pfd.interfaces.PFDButtonCollection;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataPort;
import com.sas.wadmin.transforms.sql.editor.SQLClauseAdapter;
import com.sas.workspace.WAdminResource;
import java.awt.Point;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class SQLClauseNode
extends PFDCompositeNode
implements IDiagramNode {
    private static final WAdminResource bundle = WAdminResource.getBundle(SQLClauseNode.class);
    private SQLClauseAdapter m_adapter;
    private IQuery m_query;
    private Action m_defaultAction;
    private Action m_deleteAction;
    private boolean m_active = false;
    private static final String LEFT_INPUT = bundle.getString("JoinDiagramNode.LeftInput.txt");
    private static final String RIGHT_INPUT = bundle.getString("JoinDiagramNode.RightInput.txt");
    private String m_sId;
    private boolean m_bCleanUpRequired;
    private int m_eStatus;
    private String m_sStatusContent;

    protected SQLClauseNode(IQuery query, List lAttributes, List lValues) {
        this.m_query = query;
        int x = -1;
        int y = -1;
        int iIndex = -1;
        String sClauseType = "";
        for (int i = 0; i < lAttributes.size(); ++i) {
            String sAttribute = (String)lAttributes.get(i);
            String sValue = (String)lValues.get(i);
            if (sAttribute.equalsIgnoreCase("NodeId")) {
                this.setId(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("ClauseType")) {
                sClauseType = sValue;
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionX")) {
                x = Integer.parseInt(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionY")) {
                y = Integer.parseInt(sValue);
                continue;
            }
            if (!sAttribute.equalsIgnoreCase("Index")) continue;
            iIndex = Integer.parseInt(sValue);
        }
        ISelectResultsContainer clause = null;
        if (sClauseType.equalsIgnoreCase("Select")) {
            clause = this.m_query.getSelectResults();
        } else if (sClauseType.equalsIgnoreCase("Where")) {
            clause = this.m_query.getWhere();
        } else if (sClauseType.equalsIgnoreCase("Having")) {
            clause = this.m_query.getHaving();
        } else if (sClauseType.equalsIgnoreCase("Order by")) {
            clause = this.m_query.getOrderBy();
        } else if (sClauseType.equalsIgnoreCase("Group by")) {
            clause = this.m_query.getGroupBy();
        } else {
            clause = (IClause)this.m_query.getAllClauses().get(iIndex);
            if (!sClauseType.equals(clause.getClauseType().getType())) {
                return;
            }
        }
        if (clause == null) {
            return;
        }
        this.m_adapter = new SQLClauseAdapter((IClause)clause);
        this.setSpotLocation(1, new Point(x, y));
        this.setIndicatorButtons();
        this.initialize();
        this.refresh();
    }

    public SQLClauseNode(SQLClauseAdapter adapter, IQuery query) {
        this.m_adapter = adapter;
        this.m_query = query;
        this.m_sId = GUID.newGUID();
        this.initialize();
        this.refresh();
        this.setIndicatorButtons();
        this.m_eStatus = -1;
    }

    public void setId(String id) {
        this.m_sId = id;
    }

    @Override
    public IObject getObject() {
        return this.getAdapter().getObject();
    }

    @Override
    public void setLocation(Point location) {
        super.setSpotLocation(1, location);
    }

    public void initialize() {
        this.initializePorts();
        this.load();
    }

    public void load() {
        this.loadIcon();
        this.loadStyle();
        this.loadText();
    }

    private void setIndicatorButtons() {
        PFDButtonCollection buttons = this.getIndicatorButtons();
        List indicatorButtons = this.m_adapter.getIndicatorButtons();
        for (int iButton = 0; iButton < indicatorButtons.size(); ++iButton) {
            buttons.addButton((PFDAbstractButton)((PFDButton)indicatorButtons.get(iButton)));
        }
        this.refreshCodeIndicators();
    }

    private void refreshCodeIndicators() {
        this.m_adapter.updateIndicatorButtons();
    }

    private void refreshDesignStatus() {
        String sContent;
        String sTitle;
        String sToolTip;
        int eStatus;
        IObject object = this.m_adapter.getObject();
        if (!object.isComplete()) {
            List lMessages = object.getReasonsIncomplete();
            StringBuffer sbContent = new StringBuffer(128);
            for (int iMessage = 0; iMessage < lMessages.size(); ++iMessage) {
                sbContent.append("- ").append(lMessages.get(iMessage)).append("<br>");
            }
            eStatus = 4;
            sToolTip = bundle.getString("SQLClauseNode.Incomplete.tip");
            sTitle = bundle.getString("SQLClauseNode.Errors.Title.txt");
            sContent = sbContent.toString();
        } else {
            eStatus = 5;
            sToolTip = bundle.getString("SQLClauseNode.Complete.tip");
            sTitle = null;
            sContent = null;
        }
        this.setStatus(eStatus, sToolTip, sTitle, sContent, null);
    }

    public void setStatus(PFDStatus status) {
        String sContent = (String)status.getValue("MessgeContent");
        Integer value = (Integer)status.getValue("ID");
        if (value == this.m_eStatus && (this.m_sStatusContent == null && sContent == null || this.m_sStatusContent != null && this.m_sStatusContent.equals(sContent))) {
            return;
        }
        this.m_eStatus = value;
        this.m_sStatusContent = sContent;
        super.setStatus(status);
    }

    public void loadIcon() {
        this.setNodeIcon(this.m_adapter.getIcon());
    }

    public void loadStyle() {
        IObject element = this.m_adapter.getObject();
        if (element instanceof ITable) {
            ITable table = (ITable)element;
            if (table.getOMRType().equalsIgnoreCase("WorkTable")) {
                this.setNodeStyleContext("NodeStyleWorkTable");
            } else {
                this.setNodeStyleContext("NodeStyle3");
            }
        } else if (element instanceof IJoin) {
            this.setNodeStyleContext("NodeStyle4");
        } else if (element instanceof IClause) {
            this.setNodeStyleContext("NodeStyle2");
        }
    }

    public void loadText() {
        IObject element = this.m_adapter.getObject();
        if (element instanceof IMappingsContainer) {
            this.setTitleText("Select");
            this.setContentText(this.m_query.getDescription());
        } else if (element instanceof ISubquery) {
            this.setTitleText(element.getName());
        } else {
            this.setTitleText(element.getName());
            this.setContentText(element.getDescription());
        }
    }

    public void initializePorts() {
        IObject element = this.m_adapter.getObject();
        this.getInputPortGroup().removeAllPorts();
        this.getOutputPortGroup().removeAllPorts();
        this.getInputPortGroup().addPort((PFDPort)new DataPort());
        this.getOutputPortGroup().addPort((PFDPort)new DataPort());
        if (element instanceof IJoin) {
            this.getInputPortGroup().addPort((PFDPort)new DataPort());
            this.getInputPortGroup().getPort(0).setMaxNumLinks(1);
            this.getInputPortGroup().getPort(0).setToolTipText(LEFT_INPUT);
            this.getInputPortGroup().getPort(1).setMaxNumLinks(1);
            this.getInputPortGroup().getPort(1).setToolTipText(RIGHT_INPUT);
            this.getInputPortGroup().setRenderMode(1);
            this.setForceShowPorts(true);
        } else if (element instanceof ISourceTable || element instanceof ISubquery) {
            this.getInputPort().setMaxNumLinks(0);
        } else {
            this.getInputPort().setMaxNumLinks(1);
        }
    }

    @Override
    public IDiagramNodeAdapter getAdapter() {
        return this.m_adapter;
    }

    @Override
    public PFDPort getInputPort(IObject obj) {
        return null;
    }

    @Override
    public PFDPort getOutputPort(IObject obj) {
        return null;
    }

    @Override
    public void refresh() {
        this.refreshDesignStatus();
        this.refreshCodeIndicators();
        this.loadIcon();
        this.loadText();
    }

    @Override
    public String getId() {
        return this.m_sId;
    }

    @Override
    public String writeToXML(IDesignTimeModel job) {
        StringBuffer outXML = new StringBuffer();
        outXML.append("<SQLClauseNode>");
        outXML.append("<NodeId>");
        outXML.append(this.getId());
        outXML.append("</NodeId>");
        outXML.append("<ClauseType>");
        outXML.append(((IClause)this.getObject()).getClauseType());
        outXML.append("</ClauseType>");
        outXML.append("<Index>");
        outXML.append(this.m_query.getAllClauses().indexOf(this.getObject()));
        outXML.append("</Index>");
        Point point = this.getSpotLocation(1, null);
        outXML.append("<PositionX>");
        outXML.append(String.valueOf(point.x));
        outXML.append("</PositionX>");
        outXML.append("<PositionY>");
        outXML.append(String.valueOf(point.y));
        outXML.append("</PositionY>");
        outXML.append("</SQLClauseNode>");
        return outXML.toString();
    }

    public String toString() {
        return this.getObject().toString();
    }

    public void addPopupMenuItems(JPopupMenu menu) {
    }

    public boolean drop(Point event, List objects) {
        return false;
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void setActive(boolean active) {
        this.m_active = active;
    }

    public boolean isDropValid(Point event, List objects) {
        return false;
    }

    @Override
    public boolean isCleanUpRequired() {
        return this.m_bCleanUpRequired;
    }

    @Override
    public void setCleanUpRequired(boolean bRequired) {
        this.m_bCleanUpRequired = bRequired;
    }

    public Action getDefaultAction() {
        return this.m_defaultAction;
    }

    public void setDefaultAction(Action action) {
        this.m_defaultAction = action;
    }

    public Action getDeleteAction() {
        return this.m_deleteAction;
    }

    public void setDeleteAction(Action action) {
        this.m_deleteAction = action;
    }

    @Override
    public IUIPlacement getUIPlacement() {
        return null;
    }
}

