/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IObject;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.ISQLBooleanExpressionContainer;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.wadmin.jobeditor.diagram.adapters.IIndicatorButton;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.ITransformNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.indicators.UserWrittenIndicatorButton;
import com.sas.wadmin.transforms.sql.editor.JoinEditorIcons;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WsDecoratableIcon;
import java.awt.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class SQLClauseAdapter
implements ITransformNodeAdapter {
    private Action m_actDefault;
    private Action m_actDelete;
    private IClause m_clause;
    private List m_indicatorButtons;
    private IIndicatorButton m_userWrittenIndicator;
    private WsDecoratableIcon m_icon;

    public SQLClauseAdapter(IClause clause) {
        this.m_clause = clause;
        this.m_icon = new WsDecoratableIcon();
        this.createIndicatorButtons();
    }

    @Override
    public IObject getObject() {
        return this.m_clause;
    }

    public void setObject(IClause clause) {
        this.m_clause = clause;
    }

    @Override
    public String getName() {
        return this.m_clause.getName();
    }

    @Override
    public String getTitleText() {
        return this.m_clause.getName();
    }

    public String getDescription() {
        return this.m_clause.getDescription();
    }

    @Override
    public Icon getDecoratedIcon(int size) {
        return this.getIcon(size);
    }

    @Override
    public Icon getIcon() {
        return this.getIcon(16);
    }

    protected void createIndicatorButtons() {
        this.m_indicatorButtons = new ArrayList();
        this.m_userWrittenIndicator = new UserWrittenIndicatorButton();
        this.m_indicatorButtons.add(this.m_userWrittenIndicator);
    }

    @Override
    public List getIndicatorButtons() {
        return this.m_indicatorButtons;
    }

    public void updateIndicatorButtons() {
        boolean visible = false;
        if (this.m_clause instanceof ISQLBooleanExpressionContainer) {
            ISQLBooleanExpressionContainer c = (ISQLBooleanExpressionContainer)this.m_clause;
            visible = c.isUsingUserWrittenCode();
        }
        this.m_userWrittenIndicator.setVisible(visible);
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return JoinEditorIcons.getIconForDiagram(this.getClauseTypeString());
        }
        if (size == 24) {
            return JoinEditorIcons.getIconForDiagram(this.getClauseTypeString());
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    public URL getIconURL() {
        return JoinEditorIcons.getIconURLForDiagram(this.getClauseTypeString());
    }

    public URL getIconURL(int size) {
        if (size == 16) {
            return JoinEditorIcons.getIconURLForDiagram(this.getClauseTypeString());
        }
        if (size == 24) {
            return JoinEditorIcons.getIconURLForDiagram(this.getClauseTypeString());
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    protected String getClauseTypeString() {
        String clause = this.m_clause.getClauseType().getType();
        if (this.m_clause instanceof IJoin) {
            clause = ((IJoin)this.m_clause).getJoinType();
        }
        return clause;
    }

    @Override
    public String getToolTipText() {
        return this.m_clause.getName();
    }

    protected WAPropertyTab[] getPropertyTabs() {
        return null;
    }

    @Override
    public void setDefaultAction(Action actDefault) {
        this.m_actDefault = actDefault;
    }

    @Override
    public Action getDefaultAction() {
        return this.m_actDefault;
    }

    @Override
    public void setDeleteAction(Action actDelete) {
        this.m_actDelete = actDelete;
    }

    @Override
    public Action getDeleteAction() {
        return this.m_actDelete;
    }

    @Override
    public boolean connectToInput(IObject obj, int portIndex) {
        return false;
    }

    @Override
    public boolean connectToOutput(IObject obj, int portIndex) {
        return false;
    }

    @Override
    public boolean disconnectFromInput(IObject obj, int portIndex) {
        return false;
    }

    @Override
    public boolean disconnectFromOutput(IObject obj, int portIndex) {
        return false;
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        return null;
    }

    @Override
    public int getInputPortIndex(IObject obj) {
        if (this.m_clause instanceof IJoin) {
            IJoin join = (IJoin)this.m_clause;
            if (join.getLeftSide() == obj) {
                return 0;
            }
            if (join.getRightSide() == obj) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        return null;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        return null;
    }

    @Override
    public int getOutputPortIndex(IObject obj) {
        return 0;
    }

    @Override
    public void addContextMenuItems(JPopupMenu mnuPopup) {
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        if (this.m_clause instanceof ISubquery) {
            return false;
        }
        return obj instanceof ISQLSource || obj instanceof IClause;
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        return true;
    }

    @Override
    public int showPropertiesDialog(Window wdwParent) {
        return -1;
    }

    @Override
    public boolean isLayoutRequired() {
        return false;
    }

    @Override
    public boolean isAutomaticAddToControlFlow() {
        return false;
    }

    @Override
    public boolean isValidToConnectInputOnRedraw(IObject obj) {
        return true;
    }

    @Override
    public boolean isValidToConnectOutputOnRedraw(IObject obj) {
        return true;
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        return null;
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        return null;
    }

    @Override
    public String getNodeType() {
        return null;
    }

    @Override
    public String getNodeTypeDescription() {
        return null;
    }
}

