/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.expressions.visuals.DataSourceNodeInterface;
import com.sas.expressions.visuals.DataValuesInterface;
import com.sas.expressions.visuals.DistinctValuesInterface;
import com.sas.expressions.visuals.FormattedValuesInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.transforms.sql.model.AbstractSimpleExpression;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.QueryChangeEvent;
import com.sas.wadmin.transforms.sql.model.QueryChangeListener;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLStatementInterface;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsDefaultTreeModel;
import com.sas.workspace.tree.WsTreeModel;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class TableViewTreeModel
extends WsDefaultTreeModel {
    private static WAdminResource bundle = WAdminResource.getBundle(TableViewTreeModel.class);
    protected SQLModel m_mdlSQL;
    protected Query m_mdlQuery;
    protected ClauseInterface m_clause;
    protected AbstractSimpleExpression m_expression;
    protected boolean m_bSourcesAppearFirst = true;
    protected boolean m_bShowSourcesOnly = false;
    protected boolean m_bSortColumns = false;
    private QueryModelListener m_lsnrSQLModel;
    private cTargetTableNode m_targetTableNode;

    public TableViewTreeModel() {
        super(new WsTreeNode("Root"));
    }

    public TableViewTreeModel(boolean bSourcesAppearFirst) {
        this();
        this.m_bSourcesAppearFirst = bSourcesAppearFirst;
    }

    public TableViewTreeModel(SQLModel mdlSQL) {
        super(new WsTreeNode(mdlSQL.getName()));
        this.m_mdlSQL = mdlSQL;
        SQLStatementInterface statement = this.m_mdlSQL.getStatement();
        if (statement != null) {
            this.m_mdlQuery = statement.getQuery();
        }
    }

    public TableViewTreeModel(SQLModel mdlSQL, boolean bSourcesAppearFirst) {
        this(mdlSQL);
        this.m_bSourcesAppearFirst = bSourcesAppearFirst;
    }

    public TableViewTreeModel(ClauseInterface clause) {
        this();
        this.setClause(clause);
    }

    public TableViewTreeModel(ClauseInterface clause, boolean bSourcesAppearFirst) {
        this(clause);
        this.m_bSourcesAppearFirst = bSourcesAppearFirst;
    }

    public TableViewTreeModel(ClauseInterface clause, boolean bSourcesAppearFirst, boolean bShowSourcesOnly) {
        this(clause, bSourcesAppearFirst);
        this.m_bShowSourcesOnly = bShowSourcesOnly;
    }

    public TableViewTreeModel(AbstractSimpleExpression expression) {
        this();
        this.setExpression(expression);
    }

    public TableViewTreeModel(AbstractSimpleExpression expression, boolean bSourcesAppearFirst) {
        this(expression);
        this.m_bSourcesAppearFirst = bSourcesAppearFirst;
    }

    public void setExpression(AbstractSimpleExpression expression) {
        this.m_expression = expression;
        this.m_mdlQuery = expression.getParentQuery();
        this.m_mdlSQL = this.m_mdlQuery.getSQLModel();
    }

    public void setClause(ClauseInterface clause) {
        this.m_clause = clause;
        this.m_mdlQuery = this.m_clause.getParentQuery();
        this.m_mdlSQL = this.m_mdlQuery.getSQLModel();
    }

    public SQLModel getSQLModel() {
        return this.m_mdlSQL;
    }

    public void createModelListener() {
        this.m_lsnrSQLModel = new QueryModelListener();
        if (this.m_mdlSQL != null) {
            this.m_mdlSQL.addChangeListener(this.m_lsnrSQLModel);
        }
    }

    public void dispose() {
        if (this.m_mdlSQL != null) {
            this.m_mdlSQL.removeChangeListener(this.m_lsnrSQLModel);
        }
    }

    public void moveDataToModel() {
        WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
        nodeRoot.setSorted(false);
        this.removeAllChildrenFromTree(nodeRoot);
        this.populateModel(nodeRoot);
        nodeRoot.setHasExpanded(true);
    }

    protected void populateModel(WsTreeNode nodeParent) {
        if (this.m_bSourcesAppearFirst) {
            this.addSources(nodeParent);
            if (!this.m_bShowSourcesOnly) {
                this.addTarget(nodeParent);
            }
        } else {
            if (!this.m_bShowSourcesOnly) {
                this.addTarget(nodeParent);
            }
            this.addSources(nodeParent);
        }
    }

    protected void addSources(WsTreeNode nodeParent) {
        try {
            List l_srcTables = this.m_mdlQuery.getAllSourceTables();
            for (int iTable = 0; iTable < l_srcTables.size(); ++iTable) {
                AbstractTable srcTable = (AbstractTable)l_srcTables.get(iTable);
                DataTable srcDataTable = srcTable.getDataTable();
                cSourceTableNode tableNode = new cSourceTableNode(srcDataTable, srcTable);
                this.appendNode(tableNode, (WsTreeNode)this.getRoot());
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void addTarget(WsTreeNode nodeParent) {
        try {
            DataTable targetDataTable = this.m_mdlQuery.getTargetDataTable();
            TargetTable targetTable = this.m_mdlQuery.getTargetTable();
            this.m_targetTableNode = new cTargetTableNode(targetDataTable, targetTable);
            this.appendNode(this.m_targetTableNode, (WsTreeNode)this.getRoot());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void createNewColumnNode(TableColumn column, WsTreeNode parent) {
        if (parent.getTreeModel() == null) {
            parent.setTreeModel((WsTreeModel)this);
        }
        cColumnTreeNode colnode = new cColumnTreeNode(column, column.getParent());
        parent.addChild((WsTreeNode)colnode);
    }

    public void addListenersToTree(JTree tree) {
        tree.addTreeExpansionListener(this.createTreeExpansionListener());
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new cExpansionListener();
    }

    private void appendNode(WsTreeNode nodeChild, WsTreeNode nodeParent) {
        if (nodeParent.isSorted()) {
            this.addChild(nodeChild, nodeParent);
            return;
        }
        this.insertNodeInto((MutableTreeNode)nodeChild, (MutableTreeNode)nodeParent, nodeParent.getChildCount());
    }

    private void removeAllChildrenFromTree(WsTreeNode nodeParent) {
        int nChildren = nodeParent.getChildCount();
        if (nChildren <= 0) {
            return;
        }
        int[] aChildIndexes = new int[nChildren];
        Object[] aChildNodes = new TreeNode[nChildren];
        for (int iChild = 0; iChild < nChildren; ++iChild) {
            aChildIndexes[iChild] = iChild;
            aChildNodes[iChild] = nodeParent.getChildAt(iChild);
        }
        nodeParent.removeAllChildren();
        this.nodesWereRemoved((TreeNode)nodeParent, aChildIndexes, aChildNodes);
    }

    protected WsTreeNode findTableNodeByFQID(WsTreeNode node, String sFQID) {
        try {
            if (node instanceof WsDataTreeNode && node.getMetadata().getFQID().equals(sFQID)) {
                return node;
            }
            for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
                WsTreeNode nodeFound = this.findTableNodeByFQID((WsTreeNode)node.getChildAt(iChild), sFQID);
                if (nodeFound == null) continue;
                return nodeFound;
            }
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public WsTreeNode findTableNodeByFQID(TableInterface table) {
        try {
            DataTable dataTable = table.getDataTable();
            return this.findTableNodeByFQID((WsTreeNode)this.getRoot(), dataTable.getFQID());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public WsTreeNode findTableNode(TableInterface table) {
        return this.findTableNode((WsTreeNode)this.getRoot(), table);
    }

    protected WsTreeNode findTableNode(WsTreeNode node, TableInterface table) {
        if (node instanceof cTableNode && ((cTableNode)node).getTable() == table) {
            return node;
        }
        for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
            WsTreeNode nodeIt = this.findTableNode((WsTreeNode)node.getChildAt(iChild), table);
            if (nodeIt == null) continue;
            return nodeIt;
        }
        return null;
    }

    protected void updateTableNode(TableInterface table) {
        if (!(table instanceof SourceTable)) {
            return;
        }
        WsTreeNode node = this.findTableNode(table);
        if (node != null) {
            node.setName(table.getDisplayTableName());
            this.nodeChanged((TreeNode)node);
        }
    }

    public void setSortColumns(boolean bSort) {
        if (this.m_bSortColumns == bSort) {
            return;
        }
        this.m_bSortColumns = bSort;
        this.reorderTableColumns((TreeNode)this.getRoot());
    }

    private void reorderTableColumns(TreeNode node) {
        for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
            WsTreeNode nodeChild = (WsTreeNode)node.getChildAt(iChild);
            if (nodeChild instanceof cTableNode) {
                nodeChild.setSorted(this.m_bSortColumns);
                if (!nodeChild.hasExpanded()) continue;
                this.removeAllChildrenFromTree(nodeChild);
                nodeChild.setHasExpanded(false);
                nodeChild.addChildren();
                nodeChild.setHasExpanded(true);
                continue;
            }
            this.reorderTableColumns((TreeNode)nodeChild);
        }
    }

    protected class cTargetTableNode
    extends cTableNode {
        public cTargetTableNode(DataTable targetDataTable, TargetTable targetTable) throws RemoteException {
            super(targetDataTable, targetTable);
        }

        public void addChildren() {
            List l_Columns = this.getTable().getTableColumns();
            for (int iColumn = 0; iColumn < l_Columns.size(); ++iColumn) {
                TableColumn oColumn = (TableColumn)l_Columns.get(iColumn);
                cColumnTreeNode columnNode = new cColumnTreeNode(oColumn, this.m_table);
                TableViewTreeModel.this.appendNode(columnNode, this);
            }
        }
    }

    private class QueryModelListener
    implements QueryChangeListener {
        private QueryModelListener() {
        }

        @Override
        public void queryChanged(QueryChangeEvent ev) {
            String sAction = ev.getAction();
            if ("selectChanged".equals(sAction) && TableViewTreeModel.this.m_targetTableNode != null) {
                TableViewTreeModel.this.removeAllChildrenFromTree(TableViewTreeModel.this.m_targetTableNode);
                if (TableViewTreeModel.this.m_targetTableNode.hasExpanded()) {
                    TableViewTreeModel.this.m_targetTableNode.addChildren();
                }
            }
        }
    }

    protected class cSourceTableNode
    extends cTableNode {
        public cSourceTableNode(DataTable sourceDataTable, AbstractTable sourceTable) throws RemoteException {
            super(sourceDataTable, sourceTable);
            bundle;
            this.setIcon(WAdminResource.getTypeIcon((CMetadata)sourceDataTable, (boolean)false));
        }

        public void addChildren() {
            List l_Columns = this.getTable().getTableColumns();
            for (int iColumn = 0; iColumn < l_Columns.size(); ++iColumn) {
                TableColumn oColumn = (TableColumn)l_Columns.get(iColumn);
                cColumnTreeNode columnNode = new cColumnTreeNode(oColumn, this.m_table);
                TableViewTreeModel.this.appendNode(columnNode, this);
            }
            this.setHasExpanded(true);
        }
    }

    protected class cColumnTreeNode
    extends WsTreeNode
    implements DataSourceNodeInterface {
        private TableColumn m_oColumn;
        private AbstractTable m_table;

        public cColumnTreeNode(TableColumn oColumn, AbstractTable table) {
            super(oColumn.getName());
            this.m_oColumn = oColumn;
            this.m_table = table;
            this.setDragSource(true);
            this.setAllowsChildren(false);
            this.setIcon(WsColumnMetadataUtil.getColumnTypeIcon((String)this.m_oColumn.getType()));
            this.setDragObject(this.m_oColumn.getFullColumnName());
            this.setUserObject(oColumn);
        }

        public void doDefaultAction() {
        }

        public AbstractTable getTable() {
            return this.m_table;
        }

        public TableColumn getTableColumn() {
            return this.m_oColumn;
        }

        public DataValuesInterface getDataValuesInterface() {
            return null;
        }

        public DistinctValuesInterface getDistinctValuesInterface() {
            return null;
        }

        public FormattedValuesInterface getFormattedValuesInterface() {
            return null;
        }

        public String getInsertName() {
            return this.m_oColumn.getFullColumnName() + " ";
        }

        public String getDescription() {
            return this.m_oColumn.getDescription();
        }

        public String getDisplayName() {
            return this.m_oColumn.getName();
        }
    }

    protected class cExpansionListener
    implements TreeExpansionListener {
        protected cExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            WsTreeNode node = (WsTreeNode)e.getPath().getLastPathComponent();
            if (!node.hasExpanded()) {
                node.addChildren();
                node.setHasExpanded(true);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
        }
    }

    protected class cTableNode
    extends WsTreeNode {
        protected AbstractTable m_table;

        public cTableNode(DataTable dataTable, AbstractTable table) throws RemoteException {
            super(dataTable.getName());
            this.m_table = table;
            this.setAllowsChildren(true);
            TableViewTreeModel.this.setAsksAllowsChildren(true);
            this.setDragSource(false);
            this.setSorted(TableViewTreeModel.this.m_bSortColumns);
            this.setUserObject(table);
            if (table instanceof TargetTable) {
                if (dataTable instanceof WorkTable || dataTable instanceof PhysicalTable) {
                    this.setName(bundle.getString("TableViewTreeModel.TargetTableNodeName.txt"));
                }
            } else {
                this.setName(table.getDisplayTableName());
            }
        }

        public void doDefaultAction() {
        }

        public AbstractTable getTable() {
            return this.m_table;
        }
    }

    protected class cTargetContainerNode
    extends WsTreeNode {
        public cTargetContainerNode() {
            super(bundle.getString("TableViewTreeModel.TargetTableNode.txt"));
            this.setDragSource(false);
        }

        public void addChildren() {
            try {
                DataTable targetDataTable = TableViewTreeModel.this.m_mdlQuery.getTargetDataTable();
                TargetTable targetTable = TableViewTreeModel.this.m_mdlQuery.getTargetTable();
                cTargetTableNode ttNode = new cTargetTableNode(targetDataTable, targetTable);
                TableViewTreeModel.this.appendNode(ttNode, this);
                this.setHasExpanded(true);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    protected class cSourcesContainerNode
    extends WsTreeNode {
        public cSourcesContainerNode() {
            super(bundle.getString("TableViewTreeModel.SourceTablesNode.txt"));
            this.setDragSource(false);
            this.setSorted(false);
        }

        public void addChildren() {
            try {
                List l_srcTables = TableViewTreeModel.this.m_mdlQuery.getAllSourceTables();
                for (int iTable = 0; iTable < l_srcTables.size(); ++iTable) {
                    AbstractTable srcTable = (AbstractTable)l_srcTables.get(iTable);
                    DataTable srcDataTable = srcTable.getDataTable();
                    cSourceTableNode tableNode = new cSourceTableNode(srcDataTable, srcTable);
                    TableViewTreeModel.this.appendNode(tableNode, this);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

