/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.sql.SQLCodegen;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.QueryChangeEvent;
import com.sas.wadmin.transforms.sql.model.QueryChangeListener;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceMenuSupport;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsComponentPrinter;
import com.sas.workspace.WsComponentPrinterFactory;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.WsTextComponentAdapter;
import com.sas.workspace.WsTitledPageFormat;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.SubmitType;
import com.sas.workspace.visuals.WsEditorPropertyTab;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class SQLTab
extends WsEditorPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(WsTextComponentAdapter.class);
    private SQLModel m_mdlSQL;
    private ClauseInterface m_clauseSelected;
    private boolean m_bRealEditable = true;
    private boolean m_bPrintable = true;
    private String m_sPrintTitle;
    private QueryChangeListener m_lsnrSQLModel;
    private cPopupMenuListener m_lsnrPopupMenu;
    private WsAbstractAction m_actSubmitValidate;
    private WsAbstractToggleAction m_actRunAllPrior;

    public SQLTab(SQLModel model) {
        this.m_mdlSQL = model;
        this.m_lsnrSQLModel = new QueryModelListener();
        this.m_mdlSQL.addChangeListener(this.m_lsnrSQLModel);
        this.m_txtEditor.addCaretListener((CaretListener)new TextComponentSelectionListener());
        this.m_txtEditor.addPropertyChangeListener((PropertyChangeListener)new TextComponentPropertyChangeListener());
        this.m_lsnrPopupMenu = new cPopupMenuListener();
        this.m_cmpEditor.getPopupMenu().addPopupMenuListener(this.m_lsnrPopupMenu);
        this.setHelpProduct("texteditor");
        this.setHelpTopic("editorspace");
    }

    public String getText() {
        return this.getTextComponent().getText();
    }

    protected void createActions() {
        super.createActions();
        this.m_actOpen.setEnabled(false);
        this.getOpenRemoteAction().setEnabled(false);
        this.m_actCut = new cCutAction();
        this.m_actCopy = new cCopyAction();
        this.m_actPaste = new cPasteAction();
        this.m_actSelectAll = new cSelectAllAction();
        this.m_actClear = new cClearAllAction();
        this.m_actPrint = new cPrintAction();
    }

    public JPopupMenu createDefaultPopupMenu() {
        JPopupMenu menuPopup = this.m_cmpEditor.getPopupMenu();
        menuPopup.removeAll();
        menuPopup.add((Action)this.m_actCut);
        menuPopup.add((Action)this.m_actCopy);
        menuPopup.add((Action)this.m_actPaste);
        menuPopup.addSeparator();
        menuPopup.add((Action)this.m_actSelectAll);
        menuPopup.add((Action)this.m_actClear);
        menuPopup.addSeparator();
        menuPopup.add((Action)this.m_actPrint);
        menuPopup.addSeparator();
        if (this.m_actSubmit != null) {
            menuPopup.add((Action)this.m_actSubmit);
        }
        if (this.m_actSubmitValidate != null) {
            menuPopup.add((Action)this.m_actSubmitValidate);
        }
        if (this.m_actTerminate != null) {
            menuPopup.add((Action)this.m_actTerminate);
        }
        if (this.m_actKill != null) {
            menuPopup.add((Action)this.m_actKill);
        }
        if (this.m_actRunAllPrior != null) {
            menuPopup.addSeparator();
            boolean fState = this.m_mdlSQL.getRunPriorSteps();
            this.m_actRunAllPrior.setSelected(fState);
            menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actRunAllPrior));
            WorkspaceMenuSupport menusupport = Workspace.getWorkspace().getMenuObject();
            if (menusupport != null) {
                menusupport.getMenuBar().setSelectedItemsState("submitpriorsteps", fState);
            }
        }
        return menuPopup;
    }

    protected WsAbstractAction createPopupMenuAction() {
        return new cPopupMenuAction();
    }

    public void setSubmitAction(WsAbstractAction actSubmit) {
        this.m_actSubmit = actSubmit;
    }

    public void setKillAction(WsAbstractAction actKill) {
        this.m_actKill = actKill;
    }

    public void setCancelAction(WsAbstractAction actCancel) {
        this.m_actTerminate = actCancel;
    }

    public void setSubmitValidateAction(WsAbstractAction actSubmitValidation) {
        this.m_actSubmitValidate = actSubmitValidation;
    }

    public void setRunAllPriorStepsAction(WsAbstractToggleAction runAll) {
        this.m_actRunAllPrior = runAll;
    }

    protected void updateActions() {
        boolean bSelectedText = this.m_txtEditor.getSelectedText() != null;
        boolean bEnabled = this.m_txtEditor.isEnabled();
        this.m_actCopy.setEnabled(bEnabled && bSelectedText);
        this.m_actCut.setEnabled(bEnabled && this.isEditable() && bSelectedText);
        this.m_actPaste.setEnabled(bEnabled && this.isEditable());
        this.m_actSelectAll.setEnabled(bEnabled);
        this.m_actClear.setEnabled(bEnabled && this.isEditable());
        this.m_actPrint.setEnabled(bEnabled && this.m_bPrintable);
        this.m_actUndo.setEnabled(bEnabled && this.isEditable());
        this.m_actRedo.setEnabled(bEnabled && this.isEditable());
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_mdlSQL.removeChangeListener(this.m_lsnrSQLModel);
    }

    public void setEditable(boolean bEditable) {
        this.m_bRealEditable = bEditable;
        this.setEditableImpl();
    }

    private void setEditableImpl() {
        super.setEditable(this.m_mdlSQL.isUserWritten() && this.m_bRealEditable);
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (this.m_mdlSQL.isUserWritten()) {
            this.getTextComponent().setText(this.m_mdlSQL.getUserWrittenCode());
            this.getTextComponent().setCaretPosition(0);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_mdlSQL.isUserWritten()) {
            this.m_mdlSQL.setUserWrittenCode(this.getText());
        }
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actClear.setActive(bActive);
        this.m_actEditorMenu.setActive(bActive);
        this.m_actSubmit.setActive(bActive);
        SubmitType.getInstance().setActive(bActive);
        this.m_actRunAllPrior.setActive(bActive);
        this.m_actSubmitValidate.setActive(bActive);
        this.m_actTerminate.setActive(bActive);
        this.m_actKill.setActive(bActive);
    }

    public ClauseInterface getSelectedClause() {
        return this.m_clauseSelected;
    }

    public void setSelectedClause(ClauseInterface clause) {
        if (this.m_clauseSelected == clause) {
            return;
        }
        this.m_clauseSelected = clause;
        if (clause == null) {
            this.clearSelection();
        } else {
            this.selectClauseText(clause);
        }
    }

    public JTextComponent getTextComponent() {
        return this.m_cmpEditor.getEditorPane();
    }

    public void setPrintTitle(String sTitle) {
        this.m_sPrintTitle = sTitle;
    }

    public String getPrintTitle() {
        return this.m_sPrintTitle;
    }

    private void selectClauseText(ClauseInterface clause) {
        if (this.m_mdlSQL.isUserWritten()) {
            return;
        }
        int iStart = clause.getStartingPosition();
        int iEnd = clause.getEndingPosition();
        if (iStart == -1 || iEnd == -1) {
            this.clearSelection();
        } else {
            this.select(iStart, iEnd);
        }
    }

    private void clearSelection() {
        int iStart = this.getTextComponent().getSelectionStart();
        this.select(iStart, iStart);
    }

    private void select(int iStart, int iEnd) {
        this.getTextComponent().select(iStart, iEnd);
        this.getTextComponent().repaint();
    }

    private void updateSQL() {
        if (this.m_mdlSQL.isUserWritten()) {
            return;
        }
        try {
            CodegenRequest cgReq = this.m_mdlSQL.getCodegenRequest();
            this.m_mdlSQL.clearSQL();
            SQLCodegen.generateCode(cgReq, this.m_mdlSQL.getClassifierMap(), this.m_mdlSQL, true);
            this.getTextComponent().setText(cgReq.getSource());
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.getTextComponent().setCaretPosition(0);
        if (this.m_clauseSelected != null) {
            this.selectClauseText(this.m_clauseSelected);
        }
    }

    public void submitCode(WsAppServer wsAppServer, WsServerRequest wsServerRequest, boolean validateSQL) {
        this.submitCode(wsAppServer, wsServerRequest, validateSQL, null);
    }

    public void submitCode(WsAppServer wsAppServer, WsServerRequest wsServerRequest, boolean validateSQL, StringBuffer priorCode) {
        String sSelectedSubmitType = SubmitType.getInstance().getSelectedSubmitType();
        if (wsServerRequest.getSubmitType() == null || wsServerRequest.getPropertyString("jobstatus").length() == 0) {
            wsServerRequest.setSubmitType(sSelectedSubmitType);
        }
        if (wsAppServer != null) {
            StringBuffer codeToSubmit = new StringBuffer();
            if (!validateSQL) {
                if (priorCode != null && priorCode.length() > 0) {
                    codeToSubmit.append(priorCode);
                }
                codeToSubmit.append(this.m_mdlSQL.getAccessPathCode());
                codeToSubmit.append(this.getTextComponent().getText());
            } else {
                codeToSubmit.append(this.m_mdlSQL.getSQLValidateCode());
            }
            if (this.m_SASCodeGeneration == null) {
                this.m_SASCodeGeneration = new SASCodeGeneration();
            }
            this.submitCodeToAppServer(wsAppServer, wsServerRequest, codeToSubmit.toString());
        }
    }

    protected boolean submitCodeToAppServer(WsAppServer wsAppServer, WsServerRequest wsServerRequest, String sSASCode) {
        Workspace.getDefaultLogger().info((Object)"----- Submitting -----");
        String sSelectedSubmitType = wsServerRequest.getSubmitType();
        StringBuffer sbGridCode = new StringBuffer();
        try {
            StringBuffer prefixCode = this.m_SASCodeGeneration.getSubmitToGridPrefix((CMetadata)this.m_mdlSQL.getTransformationStep(), wsAppServer.getServerContext(), sSelectedSubmitType);
            if (prefixCode != null) {
                sbGridCode.append(prefixCode);
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (sbGridCode.length() > 0) {
            sbGridCode.append("\n").append(sSASCode).append("\n").append(this.m_SASCodeGeneration.getSubmitToGridSuffix(wsAppServer.getServerContext(), sSelectedSubmitType));
            Workspace.getDefaultLogger().info((Object)sbGridCode.toString());
            Workspace.getDefaultLogger().info((Object)"----------------------");
            wsServerRequest.setCodeToSubmit(sbGridCode.toString());
        } else {
            Workspace.getDefaultLogger().info((Object)sSASCode);
            Workspace.getDefaultLogger().info((Object)"----------------------");
            wsServerRequest.setCodeToSubmit(sSASCode);
        }
        wsServerRequest.setWsAppServer(wsAppServer);
        this.m_actSubmit.setEnabled(false);
        SubmitType.getInstance().setEnabled(false);
        this.m_actSubmitValidate.setEnabled(false);
        this.m_actTerminate.setEnabled(true);
        this.m_actKill.setEnabled(true);
        wsServerRequest.startCodeSubmit();
        return true;
    }

    public void print() {
        this.m_cmpEditor.printDlg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PageFormat page) {
        try {
            String sTitle = this.getPrintTitle();
            if (sTitle == null) {
                sTitle = bundle.getString("WsTextComponentAdapter.DefaultPrintTitle.txt");
            }
            if (page == null) {
                page = new WsTitledPageFormat(sTitle);
            }
            JTextComponent txtPrint = (JTextComponent)this.m_txtEditor.getClass().newInstance();
            txtPrint.setFont(this.m_txtEditor.getFont());
            txtPrint.setDocument(this.m_txtEditor.getDocument());
            WsComponentPrinter printer = WsComponentPrinterFactory.createComponentPrinter((JComponent)txtPrint, (PageFormat)page);
            try {
                PrinterJob pjob = PrinterJob.getPrinterJob();
                if (!Workspace.getWorkspace().isPrinterConnected(pjob)) {
                    return;
                }
                pjob.setJobName(sTitle);
                pjob.setPageable((Pageable)printer);
                if (pjob.printDialog()) {
                    pjob.print();
                }
            }
            catch (PrinterException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (String)bundle.getString("WsTextComponentAdapter.PrintErrorTitle.txt"), (int)0);
            }
            finally {
                printer.dispose();
            }
        }
        catch (IllegalAccessException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (String)bundle.getString("WsTextComponentAdapter.PrintErrorTitle.txt"), (int)0);
        }
        catch (InstantiationException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (String)bundle.getString("WsTextComponentAdapter.PrintErrorTitle.txt"), (int)0);
        }
    }

    protected class QueryModelListener
    implements QueryChangeListener {
        protected QueryModelListener() {
        }

        @Override
        public void queryChanged(QueryChangeEvent ev) {
            if (ev.getClause() == null && ("userWrittenChanged".equals(ev.getAction()) || "unknownChanges".equals(ev.getAction()))) {
                SQLTab.this.setEditableImpl();
            }
            SQLTab.this.updateSQL();
        }
    }

    private class TextComponentSelectionListener
    implements CaretListener {
        private TextComponentSelectionListener() {
        }

        @Override
        public void caretUpdate(CaretEvent ev) {
            SQLTab.this.updateActions();
        }
    }

    private class TextComponentPropertyChangeListener
    implements PropertyChangeListener {
        private TextComponentPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("editable") || ev.getPropertyName().equals("enabled")) {
                SQLTab.this.updateActions();
            }
        }
    }

    private class cPopupMenuListener
    implements PopupMenuListener {
        private cPopupMenuListener() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            SQLTab.this.createDefaultPopupMenu();
        }
    }

    protected class cCutAction
    extends WsAbstractAction {
        public cCutAction() {
            super(bundle, "WsTextComponentAdapter.Action.Cut", 2);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
            this.setMenuSupportId("cut");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ev) {
            SQLTab.this.m_txtEditor.cut();
        }
    }

    protected class cCopyAction
    extends WsAbstractAction {
        public cCopyAction() {
            super(bundle, "WsTextComponentAdapter.Action.Copy", 2);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
            this.setMenuSupportId("copy");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ev) {
            SQLTab.this.m_txtEditor.copy();
        }
    }

    protected class cPasteAction
    extends WsAbstractAction {
        public cPasteAction() {
            super(bundle, "WsTextComponentAdapter.Action.Paste", 2);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
            this.setMenuSupportId("paste");
        }

        public void actionPerformed(ActionEvent ev) {
            SQLTab.this.m_txtEditor.paste();
        }
    }

    protected class cSelectAllAction
    extends WsAbstractAction {
        public cSelectAllAction() {
            super(bundle, "WsTextComponentAdapter.Action.SelectAll", 1);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
            this.setMenuSupportId("selectall");
        }

        public void actionPerformed(ActionEvent ev) {
            SQLTab.this.m_txtEditor.selectAll();
        }
    }

    protected class cClearAllAction
    extends WsAbstractAction {
        public cClearAllAction() {
            super(bundle, "WsTextComponentAdapter.Action.ClearAll", 1);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 2));
            this.setHidable(true);
            this.setMenuSupportId("clear");
        }

        public void actionPerformed(ActionEvent ev) {
            SQLTab.this.m_txtEditor.setText("");
        }
    }

    protected class cPrintAction
    extends WsAbstractAction {
        public cPrintAction() {
            super(bundle, "WsTextComponentAdapter.Action.Print", 2);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 2));
            this.setMenuSupportId("print");
        }

        public void actionPerformed(ActionEvent ev) {
            SQLTab.this.print();
        }
    }

    protected class cPopupMenuAction
    extends WsAbstractAction {
        protected cPopupMenuAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Rectangle rectCaret;
            try {
                int pos = SQLTab.this.m_txtEditor.getCaretPosition();
                rectCaret = SQLTab.this.m_txtEditor.modelToView(pos);
            }
            catch (BadLocationException ex) {
                rectCaret = new Rectangle(0, 0, 0, 0);
            }
            JPopupMenu menuPopup = SQLTab.this.createDefaultPopupMenu();
            menuPopup.show((Component)SQLTab.this.m_txtEditor, rectCaret.x, rectCaret.y);
        }
    }

    protected class cEditorMenuAction
    extends WsAbstractAction {
        public cEditorMenuAction() {
            this.setMenuSupportId("sqleditormenu");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

