/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.model.TransformationSourceColumnsTableModel;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsObjectTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class SQLSourceColumnsTableModel
extends TransformationSourceColumnsTableModel {
    private List m_lSrcTableInterfaces;
    public static final int TABLECOLUMN_COLUMN = 9;
    protected static final int SQL_HIDDEN_COLUMNS = 2;
    protected List m_lTableColumns = null;
    protected SelectResults m_select = null;

    public SQLSourceColumnsTableModel(SelectResults select, List sourceTableInterfaces) {
        this.m_lSrcTableInterfaces = sourceTableInterfaces;
        this.m_lTableColumns = new ArrayList();
        this.m_select = select;
    }

    @Override
    public int getHiddenColumnCount() {
        return 2;
    }

    @Override
    protected void createColumnDefinitions() {
        super.createColumnDefinitions();
        this.m_aColumns[9] = new WsObjectTableColumn();
    }

    @Override
    protected String getDisplayName(int index) {
        return ((TableInterface)this.m_lSrcTableInterfaces.get(index)).getDataTableName();
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        String sNone = WsColumnMetadataUtil.NONE;
        this.clear();
        this.m_lDataColumns.clear();
        this.m_lTableColumns.clear();
        this.m_lSrcTableInterfaces.clear();
        this.m_lSrcTableInterfaces.addAll(this.m_select.getSourceTables());
        int size = this.m_lSrcTableInterfaces.size();
        for (int iSource = 0; iSource < size; ++iSource) {
            AbstractTable oSource = (AbstractTable)this.m_lSrcTableInterfaces.get(iSource);
            List alColumns = oSource.getTableColumns();
            String sName = this.getDisplayName(iSource);
            int nColumns = alColumns.size();
            for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                TableColumn oColumn = (TableColumn)alColumns.get(iColumn);
                String sInformat = oColumn.getInformat();
                String sFormat = oColumn.getFormat();
                ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
                alRow.add(oColumn.getName());
                alRow.add(oColumn.getDescription());
                alRow.add(sName);
                alRow.add(oSource.getDataTable().getDesc());
                alRow.add(WsColumnMetadataUtil.getColumnViewTypeString((String)oColumn.getType()));
                alRow.add(new Integer(oColumn.getLength()));
                alRow.add(sInformat.length() == 0 ? sNone : sInformat);
                alRow.add(sFormat.length() == 0 ? sNone : sFormat);
                alRow.add(oColumn.getColumn());
                alRow.add(oColumn);
                this.m_lDataColumns.add(oColumn.getColumn());
                this.m_lTableColumns.add(oColumn);
                this.m_lData.add(alRow);
            }
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size();
    }

    public List getTableColumns() {
        return this.m_lTableColumns;
    }

    public void updateSourceTableName(TableInterface table) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            TableColumn tCol = (TableColumn)this.getValueAt(i, 9);
            if (tCol.getParent() != table) continue;
            this.setValueAt(table.getDataTableName(), i, 2);
        }
    }
}

