/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.JTreeDualSelectorAdapter;
import com.sas.swing.visuals.dualselector.TreeListSelector;
import com.sas.wadmin.transforms.sql.TableViewTreeModel;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.visuals.QuickPropagateSelectorPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsDefaultTreeCellRenderer;
import com.sas.workspace.WsTreeNode;
import java.awt.Component;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SQLQuickPropagateSelectorPanel
extends QuickPropagateSelectorPanel {
    protected SelectResults m_select;
    private static final WAdminResource bundle = WAdminResource.getBundle(SQLQuickPropagateSelectorPanel.class);

    public SQLQuickPropagateSelectorPanel(SelectResults select) {
        this.m_bMultipleTargets = false;
        this.m_bMultipleSources = true;
        this.m_select = select;
        this._initialize();
    }

    @Override
    protected DefaultTreeModel createTreeModel() {
        return new TableViewTreeModel(this.m_select, true, true);
    }

    @Override
    protected DefaultTreeCellRenderer createTreeCellRenderer() {
        return new WsDefaultTreeCellRenderer();
    }

    @Override
    protected void addTreeListeners(JTree tree) {
        ((TableViewTreeModel)((Object)this.m_oAvailableTreeModel)).addListenersToTree(tree);
    }

    @Override
    protected TreeListSelector createTreeSelector() {
        return new cSQLTreeListSelector();
    }

    @Override
    protected ListCellRenderer createTargetListCellRenderer() {
        return new SQLTargetListCellRenderer();
    }

    @Override
    public void moveDataToView() {
        ((TableViewTreeModel)((Object)this.m_oAvailableTreeModel)).moveDataToModel();
        WsTreeNode oRootTreeNode = (WsTreeNode)this.m_oAvailableTreeModel.getRoot();
        oRootTreeNode.setAllowsChildren(true);
        oRootTreeNode.setUserObject((Object)"RootNode");
        oRootTreeNode.setName(bundle.getString("SQLQuickPropagateSelectorPanel.Tables.txt"));
        oRootTreeNode.setIcon((Icon)bundle.getImageIcon("Common.Environment.image"));
        ((TableViewTreeModel)((Object)this.m_oAvailableTreeModel)).reload();
        JTree sourcetree = (JTree)this.m_columnsSelector.getSourceComponent();
        this.expandAvailableNodes(sourcetree, this.m_oAvailableTreeModel);
        this.selectImportNodes(sourcetree, this.m_oAvailableTreeModel);
    }

    @Override
    public void moveDataToStore() {
        for (int i = 0; i < this.m_oSelectedListModel.getSize(); ++i) {
            TreePath path = (TreePath)this.m_oSelectedListModel.elementAt(i);
            TableColumn existingColumn = (TableColumn)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            this.m_columns.add(existingColumn);
        }
    }

    private void selectImportNodes(JTree sourceTree, DefaultTreeModel treeModel) {
        int i;
        Object availableRootNode = treeModel.getRoot();
        int numChildren = treeModel.getChildCount(availableRootNode);
        ArrayList<TreePath> SelectedColumns = new ArrayList<TreePath>();
        int nextRow = 0;
        TreePath Path2 = sourceTree.getPathForRow(0);
        ArrayList<String> targetNames = new ArrayList<String>();
        List targetColumns = this.m_select.getTargetTable().getTableColumns();
        int size = targetColumns.size();
        for (i = 0; i < size; ++i) {
            targetNames.add(((TableColumn)targetColumns.get(i)).getName());
        }
        for (i = 0; i <= numChildren; ++i) {
            DefaultMutableTreeNode TreeNode2 = (DefaultMutableTreeNode)Path2.getLastPathComponent();
            Object node = TreeNode2.getUserObject();
            if (node == null) continue;
            if (node instanceof TableInterface) {
                int numNodes = treeModel.getChildCount(TreeNode2);
                for (int iNode = 0; iNode < numNodes; ++iNode) {
                    nextRow = sourceTree.getRowForPath(Path2);
                    DefaultMutableTreeNode ColumnTreeNode = (DefaultMutableTreeNode)(Path2 = sourceTree.getPathForRow(nextRow + 1)).getLastPathComponent();
                    TableColumn tCol = (TableColumn)ColumnTreeNode.getUserObject();
                    if (targetNames.contains(tCol.getName())) continue;
                    SelectedColumns.add(Path2);
                }
            }
            nextRow = sourceTree.getRowForPath(Path2);
            Path2 = sourceTree.getPathForRow(nextRow + 1);
        }
        TreePath[] TreePathArray = SelectedColumns.toArray(new TreePath[0]);
        sourceTree.setSelectionPaths(TreePathArray);
        this.m_columnsSelector.transferSourceItems();
    }

    protected class cSQLTreeListSelector
    extends TreeListSelector {
        protected cSQLTreeListSelector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
            Vector<String> dupNames = new Vector<String>();
            int maxCnt = -1;
            if (fromAdapter == this.sourceAdapter) {
                maxCnt = super.getTargetMaximumCount();
            }
            int selectedCount = fromAdapter.getSelectedCount();
            int index = fromAdapter.getLastSelectedIndex();
            List lSelectedItems = selectedCount > 0 ? fromAdapter.getSelectedItems() : null;
            if (lSelectedItems != null) {
                DualSelectorInterface dualSelectorInterface = fromAdapter;
                synchronized (dualSelectorInterface) {
                    DualSelectorInterface dualSelectorInterface2 = toAdapter;
                    synchronized (dualSelectorInterface2) {
                        int count = lSelectedItems.size() + toAdapter.getCount();
                        if (maxCnt == -1 || count <= maxCnt) {
                            int currentCount;
                            if (!this.copyModeEnabled || this.copyModeEnabled && fromAdapter == this.targetAdapter) {
                                fromAdapter.removeItems(lSelectedItems);
                            }
                            if (!this.copyModeDuplicatesAllowed) {
                                for (int j = 0; j < lSelectedItems.size(); ++j) {
                                    DefaultMutableTreeNode selected_treeNode = (DefaultMutableTreeNode)((TreePath)lSelectedItems.get(j)).getLastPathComponent();
                                    if (selected_treeNode.getUserObject() instanceof TableColumn) {
                                        TableColumn selected_column = (TableColumn)selected_treeNode.getUserObject();
                                        String selected_SASColumnName = selected_column.getName();
                                        if (!this._DupFoundInSelectedItems(lSelectedItems, selected_SASColumnName, j)) continue;
                                        lSelectedItems.remove(j--);
                                        continue;
                                    }
                                    lSelectedItems.remove(j--);
                                }
                                List toItems = toAdapter.getAllItems();
                                int toItemsSize = toItems.size();
                                int size = lSelectedItems.size();
                                block7: for (int j = size - 1; j >= 0; --j) {
                                    DefaultMutableTreeNode selected_treeNode = (DefaultMutableTreeNode)((TreePath)lSelectedItems.get(j)).getLastPathComponent();
                                    TableColumn selected_column = (TableColumn)selected_treeNode.getUserObject();
                                    String selected_SASColumnName = selected_column.getName();
                                    for (int i = 0; i <= toItemsSize - 1; ++i) {
                                        TableColumn toItems_column;
                                        String toItems_SASColumnName;
                                        DefaultMutableTreeNode toItems_treeNode;
                                        if (lSelectedItems.get(j).equals(toItems.get(i))) {
                                            lSelectedItems.remove(j);
                                            continue block7;
                                        }
                                        if (!(toAdapter.getComponent() instanceof JList) || !((toItems_treeNode = (DefaultMutableTreeNode)((TreePath)toItems.get(i)).getLastPathComponent()).getUserObject() instanceof TableColumn) || !selected_SASColumnName.equalsIgnoreCase(toItems_SASColumnName = (toItems_column = (TableColumn)toItems_treeNode.getUserObject()).getName())) continue;
                                        dupNames.addElement(selected_SASColumnName);
                                        lSelectedItems.remove(j);
                                        continue block7;
                                    }
                                }
                            }
                            if (dupNames.size() > 0) {
                                if (fromAdapter instanceof JTreeDualSelectorAdapter) {
                                    String sTitle = bundle.getString("SQLQuickPropagateSelectorPanel.DuplicateColumns.Removed.Header.txt");
                                    MessageUtil.displayListMessage((String)sTitle, dupNames);
                                }
                                dupNames.clear();
                            }
                            if (lSelectedItems.size() > 0 && (this.copyModeEnabled && fromAdapter == this.sourceAdapter || !this.copyModeEnabled)) {
                                toAdapter.addItems(lSelectedItems);
                            }
                            if (!this.copyModeEnabled) {
                                index = index - selectedCount + 1;
                            }
                            if (index >= (currentCount = fromAdapter.getCount())) {
                                index = currentCount - 1;
                            }
                            fromAdapter.setSelectedIndex(index);
                        }
                    }
                }
            }
        }

        private boolean _DupFoundInSelectedItems(List lSelectedItems, String newName, int row) {
            if (newName.trim().length() == 0) {
                return false;
            }
            for (int i = row; i < lSelectedItems.size(); ++i) {
                TableColumn curr_column;
                String curr_SASColumnName;
                DefaultMutableTreeNode curr_treeNode = (DefaultMutableTreeNode)((TreePath)lSelectedItems.get(i)).getLastPathComponent();
                if (!(curr_treeNode.getUserObject() instanceof TableColumn) || (curr_SASColumnName = (curr_column = (TableColumn)curr_treeNode.getUserObject()).getName()).compareToIgnoreCase(newName) != 0 || i == row) continue;
                return true;
            }
            return false;
        }
    }

    protected class SQLTargetListCellRenderer
    extends DefaultListCellRenderer {
        protected SQLTargetListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = new JLabel();
            if (value instanceof TreePath) {
                TreePath path = (TreePath)value;
                TableColumn node = (TableColumn)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                WsCompoundIcon iconCompound = new WsCompoundIcon();
                iconCompound.setIconGap(1);
                String sType = WsColumnMetadataUtil.convertColumnTypeToView((String)node.getType());
                iconCompound.addIcon(WsColumnMetadataUtil.getColumnViewTypeIcon((String)sType));
                label.setText(node.getFullColumnName());
                label.setIcon((Icon)iconCompound);
                if (iconCompound.getIconCount() == 0) {
                    this.setIcon(null);
                } else {
                    this.setIcon((Icon)iconCompound);
                }
            }
            label.setOpaque(true);
            if (isSelected) {
                label.setBackground(SystemColor.textHighlight);
                label.setForeground(SystemColor.textHighlightText);
            } else {
                label.setBackground(SystemColor.window);
                label.setForeground(SystemColor.textText);
            }
            return label;
        }
    }
}

