/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.model.TransformationSourceColumnsTableModel;
import com.sas.wadmin.model.TransformationTargetColumnsTableModel;
import com.sas.wadmin.pfd.MappingUtil;
import com.sas.wadmin.transforms.sql.QueryDesignerPanel;
import com.sas.wadmin.transforms.sql.SQLExpressionActions;
import com.sas.wadmin.transforms.sql.SQLQuickPropagateSelectorPanel;
import com.sas.wadmin.transforms.sql.SQLSourceColumnsTableModel;
import com.sas.wadmin.transforms.sql.SQLTargetColumnsTableModel;
import com.sas.wadmin.transforms.sql.TableViewTreeModel;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.CaseStatement;
import com.sas.wadmin.transforms.sql.model.OperandInterface;
import com.sas.wadmin.transforms.sql.model.QueryChangeEvent;
import com.sas.wadmin.transforms.sql.model.QueryChangeListener;
import com.sas.wadmin.transforms.sql.model.ResultMapping;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.SimpleExpressionInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.model.TextOperand;
import com.sas.wadmin.visuals.MappingsPropertyTab;
import com.sas.wadmin.visuals.QuickPropagateSelectorPanel;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDropMenuTableCellEditor;
import com.sas.workspace.WsMapping;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableMappingsPanel;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;

public class SQLMappingsPropertyTab
extends MappingsPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(SQLMappingsPropertyTab.class);
    private QueryDesignerPanel m_pnlQueryDesigner;
    private List m_lSrcTableInterfaces;
    private TargetTable m_targetTableInterface;
    private SelectResults m_select;
    private QueryModelListener m_mdlQueryListener;

    public SQLMappingsPropertyTab(SelectResults selectResults, String sRole, String sSettingsKey, boolean bMultipleSources, boolean bMultipleTargets, boolean bExpressionsEnabled, boolean bGroupByEnabled, boolean bMultipleSourceColumnsEnabled, QueryDesignerPanel queryDesignerPanel) {
        this.m_pnlQueryDesigner = queryDesignerPanel;
        this.m_lSrcTableInterfaces = selectResults.getSourceTables();
        this.m_select = selectResults;
        this.m_targetTableInterface = this.m_select.getTargetTable();
        this.m_mdlQueryListener = this.createModelChangeListener();
        this.m_select.getSQLModel().addChangeListener(this.m_mdlQueryListener);
        ArrayList<DataTable> lSourceMetadataTables = new ArrayList<DataTable>(this.m_lSrcTableInterfaces.size());
        for (int i = 0; i < this.m_lSrcTableInterfaces.size(); ++i) {
            lSourceMetadataTables.add(((TableInterface)this.m_lSrcTableInterfaces.get(i)).getDataTable());
        }
        ArrayList<DataTable> lTargetTables = new ArrayList<DataTable>(1);
        lTargetTables.add(this.m_select.getTargetDataTable());
        this.construct(this.m_select.getSQLModel().getTransformationStep(), lSourceMetadataTables, lTargetTables, (AssociationList)this.m_select.getFeatureMaps(), sRole, sSettingsKey, bMultipleSources, bMultipleTargets, bExpressionsEnabled, bGroupByEnabled, bMultipleSourceColumnsEnabled);
        this.m_tblTarget.setDropTarget(new DropTarget((Component)((Object)this), new cDropTargetListener()));
        this.setHelpProduct("wdb");
        this.setHelpTopic("sql_mapping");
    }

    @Override
    protected TransformationSourceColumnsTableModel createSourceTableModel() {
        return new SQLSourceColumnsTableModel(this.m_select, this.m_lSrcTableInterfaces);
    }

    @Override
    protected TransformationTargetColumnsTableModel createTargetTableModel() {
        return new SQLTargetColumnsTableModel(this.m_select);
    }

    @Override
    protected void createMappingsPanel() {
        this.m_pnlMappings = new cSQLMappingsPanel(this.m_tblSource, this.m_tblTarget);
        this.initializeMappingsPanel();
    }

    @Override
    protected TableCellEditor createExpressionEditor() {
        return new cExpressionTableCellEditor();
    }

    protected QueryModelListener createModelChangeListener() {
        return new QueryModelListener();
    }

    protected JPopupMenu createExpressionPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.createChooseColumnsAction());
        menu.add((Action)this.createCaseAction());
        menu.add((Action)this.createSubqueryAction());
        menu.add((Action)this.createAdvancedAction());
        return menu;
    }

    @Override
    protected WsTableRowModelListener createTargetTableRowModelListener() {
        return new cTargetTableRowModelListener();
    }

    protected WsAbstractAction createChooseColumnsAction() {
        return new cChooseColumnsAction();
    }

    protected WsAbstractAction createCaseAction() {
        return new cCaseAction();
    }

    protected WsAbstractAction createSubqueryAction() {
        return new cSubqueryAction();
    }

    protected WsAbstractAction createAdvancedAction() {
        return new cAdvancedAction();
    }

    @Override
    protected JPopupMenu createTargetTablePopupMenu() {
        JPopupMenu mnuPop = new JPopupMenu();
        mnuPop.add(new JMenuItem((Action)this.m_actNewColumn));
        mnuPop.add(new JMenuItem((Action)this.m_actNewMapping));
        mnuPop.add(new JMenuItem((Action)this.m_actDeleteColumns));
        mnuPop.addSeparator();
        mnuPop.add(new JMenuItem((Action)this.m_actSelectAllColumns));
        mnuPop.addSeparator();
        mnuPop.add(new JMenuItem((Action)this.m_actImport));
        mnuPop.add(new JMenuItem((Action)this.m_actQuickPropagate));
        mnuPop.add(new JMenuItem((Action)this.m_actQuickMap));
        return mnuPop;
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_select.getSQLModel().removeChangeListener(this.m_mdlQueryListener);
    }

    protected void onAdvanced() {
        String newText;
        int row = this.m_tblTarget.getCurrentRow();
        int column = this.m_tblTarget.getCurrentColumn();
        this.m_tblTarget.stopCellEditing();
        int modelRow = this.m_tblTarget.convertRowIndexToModel(row);
        ResultMapping resultMapping = (ResultMapping)this.m_mdlTarget.getValueAt(modelRow, 15);
        OperandInterface currentExpression = resultMapping.getDerivedExpression();
        String currentText = "";
        if (currentExpression != null && currentExpression instanceof TextOperand) {
            currentText = ((TextOperand)currentExpression).getFullNamedText();
        }
        if ((newText = SQLExpressionActions.showExpressionBuilder(this.m_select, currentText, (ResultMapping)this.m_mdlTarget.getValueAt(modelRow, 15))) != null) {
            this.m_tblTarget.setValueAt((Object)newText, row, column);
            resultMapping.setDerivedExpression(new TextOperand((SimpleExpressionInterface)resultMapping, newText));
            this.setDataChanged(true);
        }
    }

    protected void onChooseColumns() {
        TableViewTreeModel mdlTableView = new TableViewTreeModel(this.m_select);
        String newText = SQLExpressionActions.showChooseColumnsDialog(mdlTableView);
        if (newText != null) {
            int currentColumn;
            int currentRow = this.m_tblTarget.getCurrentRow();
            WsDefaultCellEditor cellEditor = (WsDefaultCellEditor)this.m_tblTarget.getCellEditor(currentRow, currentColumn = this.m_tblTarget.getCurrentColumn());
            JComponent cellEditorComponent = cellEditor.getComponent();
            if (cellEditorComponent instanceof JTextComponent) {
                SQLExpressionActions.modifyOperand((JTextComponent)cellEditorComponent, newText);
            }
            int modelRow = this.m_tblTarget.convertRowIndexToModel(currentRow);
            ResultMapping resultMapping = (ResultMapping)this.m_mdlTarget.getValueAt(modelRow, 15);
            resultMapping.setRole("DERIVED");
            resultMapping.setDerivedExpression(new TextOperand((SimpleExpressionInterface)resultMapping, ((JTextComponent)cellEditorComponent).getText()));
            this.setDataChanged(true);
        }
    }

    @Override
    protected void onExpressionEdited(int iRow, String sExpression) {
        Object currentValue = this.m_mdlTarget.getValueAt(iRow, 1);
        if (!SQLTargetColumnsTableModel.CASE_LABEL.equals(currentValue) && !SQLTargetColumnsTableModel.SUBQUERY_LABEL.equals(currentValue)) {
            ResultMapping resultMapping = (ResultMapping)this.m_mdlTarget.getValueAt(iRow, 15);
            String trimmedExpression = sExpression.trim();
            if (trimmedExpression.length() == 0) {
                resultMapping.setRole("UNMAPPED");
                resultMapping.setDerivedExpression(null);
                resultMapping.clearSourceColumns();
            } else {
                resultMapping.setRole("DERIVED");
                TextOperand newOperand = new TextOperand((SimpleExpressionInterface)resultMapping, trimmedExpression);
                resultMapping.setDerivedExpression(newOperand);
            }
        }
        super.onExpressionEdited(iRow, sExpression);
    }

    @Override
    protected boolean autoMapColumnsFromExpression(int iTargetColumn, String sExpression, boolean bAllowCancel) {
        String sMappingType = (String)this.m_mdlTarget.getValueAt(iTargetColumn, 6);
        String sDerivedType = TransformationTargetColumnsTableModel.getViewMappingTypeString(2);
        if (!sMappingType.equals(sDerivedType)) {
            return true;
        }
        ResultMapping rMap = (ResultMapping)this.m_mdlTarget.getValueAt(iTargetColumn, 15);
        OperandInterface op = rMap.getDerivedExpression();
        if (op == null) {
            return true;
        }
        List lUsedColumns = op.getTableColumns();
        ArrayList<WsMapping> lUnusedMappings = new ArrayList<WsMapping>();
        List lMappings = this.m_pnlMappings.findMappingsForRow(iTargetColumn, false);
        int nMappings = lMappings.size();
        for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
            WsMapping mapping = (WsMapping)lMappings.get(iMapping);
            TableColumn oColumn = (TableColumn)this.m_mdlSource.getValueAt(mapping.getSource(), 9);
            int iUsedColumn = lUsedColumns.indexOf(oColumn);
            if (iUsedColumn != -1) {
                lUsedColumns.remove(iUsedColumn);
                continue;
            }
            lUnusedMappings.add(mapping);
        }
        if (lUsedColumns.size() > 0 || lUnusedMappings.size() > 0) {
            int eOptions;
            String sColumn = (String)this.m_mdlTarget.getValueAt(iTargetColumn, 0);
            String sMessage = bundle.formatString("SQLMappingsPropertyTab.MappingsDoNotMatchExpressionWarning.fmt", (Object)sColumn);
            int eAnswer = MessageUtil.displayMessage((String)sMessage, (int)2, (int)(eOptions = bAllowCancel ? 1 : 0));
            if (eAnswer == 1) {
                return true;
            }
            if (eAnswer != 0) {
                return false;
            }
            lMappings.clear();
            int nUsedColumns = lUsedColumns.size();
            for (int iUsedColumn = 0; iUsedColumn < nUsedColumns; ++iUsedColumn) {
                TableColumn oColumn = (TableColumn)lUsedColumns.get(iUsedColumn);
                int[] rows = this.m_mdlSource.findRows(9, oColumn);
                int ind = -1;
                if (rows.length > 0) {
                    ind = rows[0];
                }
                if (ind < 0) continue;
                WsMapping mapping = new WsMapping(ind, iTargetColumn);
                lMappings.add(mapping);
            }
            rMap.setSourceColumns(rMap.getDerivedExpression().getTableColumns());
            this.m_pnlMappings.removeMappings(lUnusedMappings);
            this.m_pnlMappings.addMappings(lMappings);
        }
        return true;
    }

    @Override
    protected void onNewColumn() {
        int insertIndex = this.m_tblTarget.getLastSelectedRow() + 1;
        super.onNewColumn();
        this.m_mdlTarget.updateColumn(insertIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDeleteColumns(int[] aColumnIndexes) {
        this.m_select.getSQLModel().setFireEventsEnabled(false);
        try {
            int i;
            ResultMapping[] aMappings = new ResultMapping[aColumnIndexes.length];
            for (i = 0; i < aColumnIndexes.length; ++i) {
                aMappings[i] = (ResultMapping)this.m_mdlTarget.getValueAt(aColumnIndexes[i], 15);
            }
            for (i = 0; i < aMappings.length; ++i) {
                ResultMapping resultMap = aMappings[i];
                TableColumn targetColumn = resultMap.getTargetColumn();
                this.m_targetTableInterface.removeTableColumn(targetColumn);
                this.m_select.removeMapping(aMappings[i]);
            }
            super.onDeleteColumns(aColumnIndexes);
            this.m_select.getSQLModel().setFireEventsEnabled(true);
        }
        finally {
            this.m_select.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void showQuickPropagateDialog() {
        block13: {
            this.m_select.getSQLModel().setFireEventsEnabled(false);
            try {
                if (!this.m_tblTarget.stopCellEditing()) {
                    return;
                }
                QuickPropagateSelectorPanel pnl = this.createQuickPropagatePanel();
                String sQuickPropagateDialogTitle = bundle.getString("SQLMappingsPropertyTab.QuickPropagateDialogTitle.txt");
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sQuickPropagateDialogTitle, true, (WAPanel)pnl);
                dlg.setResizable(true);
                dlg.setHelpProduct("wdb");
                dlg.setHelpTopic("quick_propagate_win");
                dlg.show();
                if (dlg.getReturnValue() != 1) break block13;
                int[] aSelectedRows = this.m_tblTarget.getSelectedRowsFromSelectedCells();
                int iInsertAfterRow = aSelectedRows.length == 0 ? this.m_tblTarget.getRowCount() - 1 : aSelectedRows[aSelectedRows.length - 1];
                int iFirstRow = iInsertAfterRow + 1;
                CompoundEdit undoMultiAdd = new CompoundEdit();
                undoMultiAdd.addEdit(this.m_tblTarget.createClearSelectionUndoable(false, true));
                Vector lColumns = pnl.getColumns();
                int nColumns = lColumns.size();
                ArrayList<String> lDuplicateColumns = new ArrayList<String>();
                ArrayList<TableColumn> oldColumns = new ArrayList<TableColumn>();
                ArrayList<Integer> newColumnIndex = new ArrayList<Integer>();
                for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                    TableColumn oColumn = (TableColumn)lColumns.get(iColumn);
                    if (((SQLTargetColumnsTableModel)this.m_mdlTarget).validateColumnNameUniqueness(oColumn, -1)) {
                        oldColumns.add(oColumn);
                        newColumnIndex.add(new Integer(iInsertAfterRow + 1));
                        this.insertForQuickPropagate(oColumn, iInsertAfterRow);
                        ++iInsertAfterRow;
                        continue;
                    }
                    lDuplicateColumns.add(oColumn.getName());
                }
                this.m_tblTarget.selectRows(iFirstRow, iInsertAfterRow);
                undoMultiAdd.addEdit(this.m_tblTarget.createSelectRowsUndoable(iFirstRow, iInsertAfterRow));
                undoMultiAdd.end();
                try {
                    if (MappingUtil.isAutoMapEnabled(this.m_oTS)) {
                        for (int i = 0; i < oldColumns.size(); ++i) {
                            int newIndex = (Integer)newColumnIndex.get(i);
                            int[] rows = ((SQLSourceColumnsTableModel)this.m_mdlSource).findRows(9, oldColumns.get(i));
                            if (rows.length <= 0) continue;
                            WsMapping map = new WsMapping(rows[0], newIndex);
                            this.addMappingToMappingPanel(map);
                        }
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                if (lDuplicateColumns.size() > 0) {
                    String sMessage = bundle.getString("SQLMappingsPropertyTab.DuplicateColumnsRemovedWarning.txt");
                    MessageUtil.displayListMessage((String)sMessage, lDuplicateColumns);
                }
            }
            finally {
                this.m_select.getSQLModel().setFireEventsEnabled(true);
            }
        }
    }

    protected void insertForQuickPropagate(TableColumn oColumn, int iInsertAfterRow) {
        List lValues = ((SQLTargetColumnsTableModel)this.m_mdlTarget).createRowValuesFromColumn(oColumn, iInsertAfterRow);
        this.m_tblTarget.undoableInsertRow(iInsertAfterRow, lValues);
    }

    protected QuickPropagateSelectorPanel createQuickPropagatePanel() {
        SQLQuickPropagateSelectorPanel pnl = new SQLQuickPropagateSelectorPanel(this.m_select);
        pnl.setPreferredSize(new Dimension(450, 400));
        return pnl;
    }

    @Override
    protected void showImportColumnsDialog() {
        this.m_select.getSQLModel().setFireEventsEnabled(false);
        ((SQLTargetColumnsTableModel)this.m_mdlTarget).setTableChangeEnable(false);
        try {
            super.showImportColumnsDialog();
            this.m_select.getSQLModel().setFireEventsEnabled(true);
        }
        finally {
            this.m_select.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
            ((SQLTargetColumnsTableModel)this.m_mdlTarget).setTableChangeEnable(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDeleteMappings(List lMappings) {
        this.m_select.getSQLModel().setFireEventsEnabled(false);
        try {
            for (int i = 0; i < lMappings.size(); ++i) {
                WsMapping wsMapping = (WsMapping)lMappings.get(i);
                int sourceIndex = wsMapping.getSource();
                TableColumn sourceColumn = (TableColumn)this.m_mdlSource.getValueAt(sourceIndex, 9);
                int targetIndex = wsMapping.getTarget();
                ResultMapping rMap = (ResultMapping)this.m_mdlTarget.getValueAt(targetIndex, 15);
                rMap.removeSourceColumn(sourceColumn);
            }
            this.m_select.getSQLModel().setFireEventsEnabled(true);
        }
        finally {
            this.m_select.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
        }
        super.onDeleteMappings(lMappings);
    }

    @Override
    protected void updateColumnInModelAt(int index) {
        TableColumn tColumn = (TableColumn)this.m_mdlTarget.getValueAt(index, 14);
        this.m_select.getTargetTable().getTableColumns().add(index, tColumn);
        this.m_mdlTarget.updateColumn(index);
    }

    @Override
    public void updateWorkspaceUIComponents(boolean active) {
        super.updateWorkspaceUIComponents(active);
        this.m_pnlQueryDesigner.updateCodegenActions(active);
    }

    @Override
    protected void updateFeatureMaps() throws MdException, RemoteException {
    }

    @Override
    protected void quickMap() {
        this.m_select.getSQLModel().setFireEventsEnabled(false);
        try {
            super.quickMap();
            this.m_select.getSQLModel().setFireEventsEnabled(true);
        }
        finally {
            this.m_select.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
        }
    }

    @Override
    protected void onNewMapping(int[] aSourceRows, int[] aTargetRows) {
        super.onNewMapping(aSourceRows, aTargetRows);
        this.addMappingToSelect(aSourceRows, aTargetRows);
    }

    protected void addMappingToSelect(int[] aSourceRows, int[] aTargetRows) {
        int targetIndex = aTargetRows[0];
        String targetName = (String)this.m_mdlTarget.getValueAt(targetIndex, 0);
        TableColumn targetColumn = (TableColumn)this.m_mdlTarget.getValueAt(targetIndex, 14);
        if (targetColumn == null) {
            targetColumn = new TableColumn(targetName, (AbstractTable)this.m_targetTableInterface);
            this.m_targetTableInterface.addTableColumn(targetIndex, targetColumn);
        }
        ResultMapping resultMapping = (ResultMapping)this.m_mdlTarget.getValueAt(targetIndex, 15);
        int sourceRowCount = aSourceRows.length;
        String sMappingType = resultMapping.getRole();
        String sUnMappedType = "UNMAPPED";
        ArrayList<Object> sourceColumns = new ArrayList<Object>(sourceRowCount);
        for (int i = 0; i < sourceRowCount; ++i) {
            int sourceIndex = aSourceRows[i];
            sourceColumns.add(this.m_mdlSource.getValueAt(sourceIndex, 9));
        }
        String mappingRole = "UNMAPPED";
        String sExpression = (String)this.m_mdlTarget.getValueAt(targetIndex, 1);
        if (sourceRowCount > 1 && sUnMappedType.equals(sMappingType)) {
            mappingRole = "DERIVED";
        } else if (sourceRowCount == 1 && sUnMappedType.equals(sMappingType)) {
            mappingRole = "ONETOONE";
        } else if (sExpression != null && sExpression.length() > 0) {
            mappingRole = "DERIVED";
        }
        resultMapping.setRole(mappingRole);
        resultMapping.setSourceColumns(sourceColumns);
    }

    @Override
    protected void addMappingToMappingPanel(WsMapping mapping) {
        super.addMappingToMappingPanel(mapping);
        int[] aSourceRows = new int[]{mapping.getSource()};
        int[] aTargetRows = new int[]{mapping.getTarget()};
        this.addMappingToSelect(aSourceRows, aTargetRows);
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        this.m_select.getSQLModel().setFireEventsEnabled(false);
        super.moveDataToView();
        this.m_select.getSQLModel().setFireEventsEnabled(true);
    }

    @Override
    protected void updateTableLabel(JLabel lblTable, List lDataTables, String sKey) {
        String sDataTable = lDataTables == null || lDataTables.isEmpty() ? "" : this.m_select.getTargetTable().getDataTableName();
        String sLabel = bundle.formatString("SQLMappingsPropertyTab." + sKey + "Table.fmt", (Object)sDataTable);
        lblTable.setText(sLabel);
    }

    @Override
    protected void createMappings() throws MdException, RemoteException {
        int nTargetColumns = this.m_mdlTarget.getRowCount();
        for (int iTargetColumn = 0; iTargetColumn < nTargetColumns; ++iTargetColumn) {
            ResultMapping rMap = (ResultMapping)this.m_mdlTarget.getValueAt(iTargetColumn, 15);
            if (rMap == null) continue;
            List alSourceColumns = rMap.getSourceColumns();
            int nSourceColumns = alSourceColumns.size();
            for (int iSourceColumn = 0; iSourceColumn < nSourceColumns; ++iSourceColumn) {
                TableColumn oSourceColumn = (TableColumn)alSourceColumns.get(iSourceColumn);
                int[] aRows = this.m_mdlSource.findRows(9, oSourceColumn);
                if (aRows.length < 1) continue;
                WsMapping map = new WsMapping(aRows[0], iTargetColumn, (Object)rMap);
                this.m_pnlMappings.addMapping(map);
            }
        }
    }

    private class QueryModelListener
    implements QueryChangeListener {
        private QueryModelListener() {
        }

        @Override
        public void queryChanged(QueryChangeEvent ev) {
            String sAction = ev.getAction();
            if ("AliasChanged".equals(sAction)) {
                TableInterface tInt = ev.getTable();
                if (SQLMappingsPropertyTab.this.m_select.getTargetTable().equals(tInt)) {
                    SQLMappingsPropertyTab.this.updateTableLabel(SQLMappingsPropertyTab.this.m_lblTarget, null, "Target");
                } else {
                    ((SQLSourceColumnsTableModel)SQLMappingsPropertyTab.this.m_mdlSource).updateSourceTableName(tInt);
                }
            }
        }
    }

    protected class cDropTargetListener
    implements DropTargetListener {
        protected cDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(0);
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            Point ptDrop = e.getLocation();
            Component c = SQLMappingsPropertyTab.this.m_tblTarget.getComponentAt(e.getLocation());
            int rowAtPoint = ((WsTable)c).rowAtPoint(ptDrop);
            int colAtPoint = ((WsTable)c).columnAtPoint(ptDrop);
            List l = this.getDraggedObjects(e.getCurrentDataFlavors());
            if (l != null && this.isValidDrop(l, rowAtPoint, colAtPoint)) {
                e.acceptDrag(e.getDropAction());
            } else {
                e.rejectDrag();
            }
            SQLMappingsPropertyTab.this.m_tblTarget.stopCellEditing();
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            block6: {
                Point ptDrop = e.getLocation();
                Component c = SQLMappingsPropertyTab.this.m_tblTarget.getComponentAt(e.getLocation());
                int rowAtPoint = ((WsTable)c).rowAtPoint(ptDrop);
                int colAtPoint = ((WsTable)c).columnAtPoint(ptDrop);
                List lObjects = this.getDraggedObjects(e.getCurrentDataFlavors());
                if (lObjects != null && this.isValidDrop(lObjects, rowAtPoint, colAtPoint)) {
                    try {
                        Transferable t = e.getTransferable();
                        if (t.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                            e.acceptDrop(e.getDropAction());
                            Vector dndObj = (Vector)t.getTransferData(DNDObject.dndObjectDataFlavor);
                            ((SQLTargetColumnsTableModel)SQLMappingsPropertyTab.this.m_mdlTarget).replaceOperand(dndObj, rowAtPoint, colAtPoint);
                            e.getDropTargetContext().dropComplete(true);
                            SQLMappingsPropertyTab.this.m_mdlTarget.fireTableCellUpdated(rowAtPoint, colAtPoint);
                            break block6;
                        }
                        e.rejectDrop();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    catch (UnsupportedFlavorException ufe) {
                        ufe.printStackTrace();
                    }
                } else {
                    e.rejectDrop();
                }
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public boolean isValidDrop(List lObjects, int row, int col) {
            if (row < 0) {
                return false;
            }
            if (col != 1) {
                return false;
            }
            if (lObjects.size() == 0) {
                return false;
            }
            for (int i = 0; i < lObjects.size(); ++i) {
                if (lObjects.get(i) instanceof String) continue;
                return false;
            }
            return true;
        }

        protected List getDraggedObjects(DataFlavor[] flavors) {
            for (int iFlavor = 0; iFlavor < flavors.length; ++iFlavor) {
                if (!(flavors[iFlavor] instanceof DNDObject.DNDObjectFlavor)) continue;
                DNDObject object = ((DNDObject.DNDObjectFlavor)flavors[iFlavor]).getData();
                return object.getObjects();
            }
            return null;
        }
    }

    protected class cSQLMappingsPanel
    extends WsTableMappingsPanel {
        public cSQLMappingsPanel(WsTable tblSource, WsTable tblTarget) {
            super(tblSource, tblTarget);
        }

        protected void onCreateMappings(List lMappings) {
            super.onCreateMappings(lMappings);
            int[] sourceRows = new int[lMappings.size()];
            int[] targetRows = new int[1];
            for (int i = 0; i < lMappings.size(); ++i) {
                WsMapping wsMapping = (WsMapping)lMappings.get(i);
                sourceRows[i] = wsMapping.getSource();
                if (i != 0) continue;
                targetRows[0] = wsMapping.getTarget();
            }
            SQLMappingsPropertyTab.this.addMappingToSelect(sourceRows, targetRows);
        }
    }

    protected class cExpressionTableCellEditor
    extends WsDropMenuTableCellEditor {
        public cExpressionTableCellEditor() {
            this.setDropMenu(SQLMappingsPropertyTab.this.createExpressionPopupMenu());
        }
    }

    protected class cTargetTableRowModelListener
    implements WsTableRowModelListener {
        protected cTargetTableRowModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rowDragged(TableRowModelEvent e) {
            if (!SQLMappingsPropertyTab.this.isEditable()) {
                return;
            }
            if (SQLMappingsPropertyTab.this.m_bEditableTargetTables) {
                SQLMappingsPropertyTab.this.m_select.getSQLModel().setFireEventsEnabled(false);
                try {
                    int from = SQLMappingsPropertyTab.this.m_tblTarget.convertRowIndexToModel(e.getToIndex());
                    TableColumn tColumn = (TableColumn)SQLMappingsPropertyTab.this.m_mdlTarget.getValueAt(from, 14);
                    SQLMappingsPropertyTab.this.m_select.getTargetTable().setColumnNumber(tColumn, e.getToIndex());
                }
                finally {
                    SQLMappingsPropertyTab.this.m_select.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
                }
                SQLMappingsPropertyTab.this.m_select.getSQLModel().fireChangeEvent("selectChanged");
                SQLMappingsPropertyTab.this.setDataChanged(true);
            }
        }

        public void rowsHidden(WsTableRowModelEvent e) {
        }

        public void rowsShown(WsTableRowModelEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rowsRemapped(ChangeEvent e) {
            if (!SQLMappingsPropertyTab.this.isEditable()) {
                return;
            }
            if (SQLMappingsPropertyTab.this.m_bEditableTargetTables) {
                SQLMappingsPropertyTab.this.m_select.getSQLModel().setFireEventsEnabled(false);
                try {
                    int size = SQLMappingsPropertyTab.this.m_mdlTarget.getRowCount();
                    TargetTable target = SQLMappingsPropertyTab.this.m_select.getTargetTable();
                    for (int i = 0; i < size; ++i) {
                        int x = SQLMappingsPropertyTab.this.m_tblTarget.convertRowIndexToModel(i);
                        TableColumn tColumn = (TableColumn)SQLMappingsPropertyTab.this.m_mdlTarget.getValueAt(x, 14);
                        target.setColumnNumber(tColumn, i);
                    }
                }
                finally {
                    SQLMappingsPropertyTab.this.m_select.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
                }
                SQLMappingsPropertyTab.this.m_select.getSQLModel().fireChangeEvent("selectChanged");
                SQLMappingsPropertyTab.this.setDataChanged(true);
            }
        }
    }

    protected class cChooseColumnsAction
    extends WsAbstractAction {
        public cChooseColumnsAction() {
            super(bundle, "SQLMappingsPropertyTab.ChooseColumns");
        }

        public void actionPerformed(ActionEvent e) {
            SQLMappingsPropertyTab.this.onChooseColumns();
        }
    }

    protected class cCaseAction
    extends WsAbstractAction {
        public cCaseAction() {
            super(bundle, "SQLMappingsPropertyTab.CASE");
        }

        public void actionPerformed(ActionEvent e) {
            CaseStatement caseStatement;
            int row = SQLMappingsPropertyTab.this.m_tblTarget.getCurrentRow();
            int column = SQLMappingsPropertyTab.this.m_tblTarget.getCurrentColumn();
            SQLMappingsPropertyTab.this.m_tblTarget.stopCellEditing();
            boolean newCase = true;
            int modelRow = SQLMappingsPropertyTab.this.m_tblTarget.convertRowIndexToModel(row);
            ResultMapping resultMapping = (ResultMapping)SQLMappingsPropertyTab.this.m_mdlTarget.getValueAt(modelRow, 15);
            OperandInterface oldExpression = resultMapping.getDerivedExpression();
            if (oldExpression == null || !(oldExpression instanceof CaseStatement)) {
                caseStatement = new CaseStatement();
                caseStatement.setSQLModel(SQLMappingsPropertyTab.this.m_select.getSQLModel());
                caseStatement.setParentQuery(SQLMappingsPropertyTab.this.m_select.getParentQuery());
                caseStatement.setParentClause(SQLMappingsPropertyTab.this.m_select);
            } else {
                caseStatement = (CaseStatement)oldExpression;
                newCase = false;
            }
            if (SQLExpressionActions.showCaseDialog(caseStatement, SQLMappingsPropertyTab.this.getWAUndoManager())) {
                resultMapping.setRole("DERIVED");
                resultMapping.setDerivedExpression(caseStatement);
                SQLMappingsPropertyTab.this.m_tblTarget.undoableSetValueAt((Object)caseStatement, row, column);
                SQLMappingsPropertyTab.this.setDataChanged(true);
            } else if (newCase) {
                caseStatement.dispose();
            }
        }
    }

    protected class cSubqueryAction
    extends WsAbstractAction {
        public cSubqueryAction() {
            super(bundle, "SQLMappingsPropertyTab.Subquery");
        }

        public void actionPerformed(ActionEvent e) {
            SubQuery subQuery;
            int row = SQLMappingsPropertyTab.this.m_tblTarget.getCurrentRow();
            int column = SQLMappingsPropertyTab.this.m_tblTarget.getCurrentColumn();
            SQLMappingsPropertyTab.this.m_tblTarget.stopCellEditing();
            int modelRow = SQLMappingsPropertyTab.this.m_tblTarget.convertRowIndexToModel(row);
            ResultMapping resultMapping = (ResultMapping)SQLMappingsPropertyTab.this.m_mdlTarget.getValueAt(modelRow, 15);
            OperandInterface oldExpression = resultMapping.getDerivedExpression();
            if (oldExpression != null && oldExpression instanceof SubQuery) {
                subQuery = (SubQuery)oldExpression;
            } else {
                subQuery = SQLMappingsPropertyTab.this.m_select.getParentQuery().addSubQuery();
                subQuery.setSQLModel(SQLMappingsPropertyTab.this.m_select.getSQLModel());
                subQuery.setParentQuery(SQLMappingsPropertyTab.this.m_select.getParentQuery());
                subQuery.setParentClause(SQLMappingsPropertyTab.this.m_select);
                resultMapping.setRole("DERIVED");
                resultMapping.setDerivedExpression(subQuery);
                SQLMappingsPropertyTab.this.m_tblTarget.undoableSetValueAt((Object)subQuery, row, column);
            }
            SQLExpressionActions.showSubquery(SQLMappingsPropertyTab.this.m_pnlQueryDesigner, subQuery);
        }
    }

    protected class cAdvancedAction
    extends WsAbstractAction {
        public cAdvancedAction() {
            super(bundle, "SQLMappingsPropertyTab.Advanced");
        }

        public void actionPerformed(ActionEvent e) {
            SQLMappingsPropertyTab.this.onAdvanced();
        }
    }
}

