/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.wadmin.transforms.sql.CasePanel;
import com.sas.wadmin.transforms.sql.ColumnSelectorDialog;
import com.sas.wadmin.transforms.sql.QueryDesignerPanel;
import com.sas.wadmin.transforms.sql.SQLExpressionBuilderTab;
import com.sas.wadmin.transforms.sql.TableViewTreeModel;
import com.sas.wadmin.transforms.sql.model.CaseStatement;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.ResultMapping;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class SQLExpressionActions {
    private static WAdminResource bundle = WAdminResource.getBundle(SQLExpressionActions.class);

    public static String showChooseColumnsDialog(TableViewTreeModel viewModel) {
        String[] names;
        ColumnSelectorDialog csDialog = new ColumnSelectorDialog(viewModel);
        csDialog.allowMultipleSelection();
        csDialog.setResizable(true);
        csDialog.show();
        if (csDialog.getReturnValue() == 1 && (names = csDialog.getSelectedTableColumnNames()) != null && names.length != 0) {
            return SQLExpressionActions.buildColumnsString(names);
        }
        return null;
    }

    public static boolean showCaseDialog(CaseStatement caseStatement, WAUndoManager waum) {
        CasePanel casePanel = new CasePanel(caseStatement);
        casePanel.setWAUndoManager(waum);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("CasePanel.Title.txt"), true);
        dialog.setMainPanel((WAPanel)casePanel);
        dialog.setResizable(true);
        dialog.show();
        return dialog.getReturnValue() == 1;
    }

    public static void showSubquery(QueryDesignerPanel designerPanel, SubQuery subQuery) {
        designerPanel.navigateToClause(subQuery);
    }

    public static String showExpressionBuilder(ClauseInterface clause, String initialText) {
        return SQLExpressionActions.showExpressionBuilder(clause, initialText, null);
    }

    public static String showExpressionBuilder(ClauseInterface clause, String initialText, ResultMapping rMap) {
        SQLExpressionBuilderTab expressionBuilderTab = new SQLExpressionBuilderTab(clause, rMap);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("ExpressionBuilder.Title.txt"), true);
        dialog.setMainPanel((WAPanel)expressionBuilderTab);
        dialog.setResizable(true);
        if (initialText != null) {
            expressionBuilderTab.setExpression(initialText);
        }
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            return expressionBuilderTab.getExpression();
        }
        return null;
    }

    protected static String buildColumnsString(String[] values) {
        StringBuffer sbText = new StringBuffer();
        int nOperands = values.length;
        for (int i = 0; i < nOperands; ++i) {
            sbText.append(values[i]);
            if (i >= nOperands - 1) continue;
            sbText.append(" ");
        }
        return sbText.toString();
    }

    public static void modifyOperand(JTextComponent cellEditor, String newText) {
        StringBuffer sbText = new StringBuffer(newText);
        String selText = cellEditor.getSelectedText();
        int caretPosition = cellEditor.getCaretPosition();
        int selectionStart = cellEditor.getSelectionStart();
        int selectionEnd = cellEditor.getSelectionEnd();
        try {
            if (selText != null) {
                if (selectionStart > 0 && cellEditor.getText(selectionStart - 1, 1) != " ") {
                    sbText.insert(0, " ");
                }
                if (selectionEnd < cellEditor.getText().length() && cellEditor.getText(selectionEnd, 1) != " ") {
                    sbText.append(" ");
                }
                cellEditor.replaceSelection(sbText.toString());
                cellEditor.requestFocus();
            } else {
                if (caretPosition > 0 && cellEditor.getText(caretPosition - 1, 1) != " ") {
                    sbText.insert(0, " ");
                }
                if (caretPosition < cellEditor.getText().length() && cellEditor.getText(caretPosition, 1) != " ") {
                    sbText.append(" ");
                }
                Document d = cellEditor.getDocument();
                d.insertString(caretPosition, sbText.toString(), null);
                cellEditor.requestFocus();
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }
}

