/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.wadmin.transforms.sql.model.ClauseType;
import com.sas.wadmin.transforms.sql.model.Join;
import com.sas.wadmin.transforms.sql.model.JoinType;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsTreeNode;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class QueryPaletteTreeModel
extends DefaultTreeModel {
    private static WAdminResource bundle = WAdminResource.getBundle(QueryPaletteTreeModel.class);

    public QueryPaletteTreeModel() {
        super((TreeNode)new WsTreeNode("Root"));
        this.initialize();
    }

    private void initialize() {
        WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
        WsTreeNode nodeSelect = new WsTreeNode(bundle.getString("QueryPaletteTreeModel.SelectClausesNode.txt"));
        WsTreeNode nodeJoins = new WsTreeNode(bundle.getString("QueryPaletteTreeModel.JoinsNode.txt"));
        nodeSelect.setDragSource(false);
        nodeJoins.setDragSource(false);
        this.insertNodeInto((MutableTreeNode)nodeSelect, (MutableTreeNode)nodeRoot, 0);
        this.insertNodeInto((MutableTreeNode)nodeJoins, (MutableTreeNode)nodeRoot, 1);
        this.insertNodeInto((MutableTreeNode)((Object)new ClauseTypeNode(ClauseType.WHERE, bundle.getImageIcon("QueryPaletteTreeModel.Where.image"))), (MutableTreeNode)nodeSelect, 0);
        this.insertNodeInto((MutableTreeNode)((Object)new ClauseTypeNode(ClauseType.GROUPBY, bundle.getImageIcon("QueryPaletteTreeModel.GroupBy.image"))), (MutableTreeNode)nodeSelect, 1);
        this.insertNodeInto((MutableTreeNode)((Object)new ClauseTypeNode(ClauseType.HAVING, bundle.getImageIcon("QueryPaletteTreeModel.Having.image"))), (MutableTreeNode)nodeSelect, 2);
        this.insertNodeInto((MutableTreeNode)((Object)new ClauseTypeNode(ClauseType.ORDERBY, bundle.getImageIcon("QueryPaletteTreeModel.OrderBy.image"))), (MutableTreeNode)nodeSelect, 3);
        ClauseTypeNode nodeSubQuery = new ClauseTypeNode(ClauseType.SUBQUERY, bundle.getImageIcon("QueryPaletteTreeModel.Select.image"));
        nodeSubQuery.setName(bundle.getString("QueryPaletteTreeModel.SubQueryNode.txt"));
        this.insertNodeInto((MutableTreeNode)((Object)nodeSubQuery), (MutableTreeNode)nodeSelect, 4);
        this.insertNodeInto((MutableTreeNode)((Object)new JoinTypeNode(JoinType.INNERJOIN)), (MutableTreeNode)nodeJoins, 0);
        this.insertNodeInto((MutableTreeNode)((Object)new JoinTypeNode(JoinType.FULLJOIN)), (MutableTreeNode)nodeJoins, 1);
        this.insertNodeInto((MutableTreeNode)((Object)new JoinTypeNode(JoinType.LEFTJOIN)), (MutableTreeNode)nodeJoins, 2);
        this.insertNodeInto((MutableTreeNode)((Object)new JoinTypeNode(JoinType.RIGHTJOIN)), (MutableTreeNode)nodeJoins, 3);
        this.insertNodeInto((MutableTreeNode)((Object)new JoinTypeNode(JoinType.CROSSJOIN)), (MutableTreeNode)nodeJoins, 4);
        this.insertNodeInto((MutableTreeNode)((Object)new JoinTypeNode(JoinType.UNIONJOIN)), (MutableTreeNode)nodeJoins, 5);
    }

    private static class ClauseTypeNode
    extends WsTreeNode {
        public ClauseTypeNode(ClauseType type, Icon icon) {
            super(type.getType(), icon);
            this.setDragSource(true);
            this.setDragObject(type);
        }
    }

    private static class JoinTypeNode
    extends WsTreeNode {
        private JoinType m_type;

        public JoinTypeNode(JoinType type) {
            super(type.getJoinType(), Join.getIcon(type.getJoinType()));
            this.m_type = type;
            this.setDragSource(true);
            this.setDragObject(type);
        }

        public String getJoinType() {
            return this.m_type.getJoinType();
        }
    }
}

