/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.sql.OrderByTableModel;
import com.sas.wadmin.transforms.sql.TableViewTreeModel;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.GroupBy;
import com.sas.wadmin.transforms.sql.model.GroupByColumn;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.visuals.properties.AbstractPropertiesModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.visuals.dualselector.DefaultSelectorTableModel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class GroupByTableModel
extends DefaultSelectorTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(OrderByTableModel.class);
    private static final String DEFAULTCOLUMNREFERENCE = GroupBy.DEFAULT_COLUMN_REFERENCE;
    protected static final int TABLE_COL = 0;
    protected static final int COLUMN_COL = 1;
    protected static final int COLUMN_REF_COL = 2;
    public static final int GROUPBYCOLUMN_COL = 3;
    private GroupBy m_groupBy;
    private List m_groupByColumns;

    public GroupByTableModel(GroupBy groupBy) {
        this.m_aColumns = new WsAbstractTableColumn[4];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("OrderByTableModel.TableName.txt"), 100);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("OrderByTableModel.ColumnName.txt"), 100);
        this.m_aColumns[2] = new cListTableColumn(2, bundle.getString("OrderByTableModel.ColumnRef.txt"), 75, GroupBy.getColumnReferenceTranslatedValues(), GroupBy.getColumnReferenceUnTranslatedValues(), DEFAULTCOLUMNREFERENCE);
        this.m_aColumns[3] = new WsMetadataTableColumn();
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1].setEditable(false);
        this.m_groupBy = groupBy;
    }

    protected List createRowValues(Object obj) {
        if (obj instanceof TableViewTreeModel.cColumnTreeNode) {
            String sColName = ((WsTreeNode)obj).getName();
            TableViewTreeModel.cColumnTreeNode columnTreeNode = (TableViewTreeModel.cColumnTreeNode)((WsTreeNode)obj);
            TableColumn selectedTableColumn = columnTreeNode.getTableColumn();
            AbstractTable selectedTable = columnTreeNode.getTable();
            String sTableName = selectedTable.getDataTableName();
            GroupByColumn groupByColumn = new GroupByColumn(selectedTableColumn, selectedTable, this.m_groupBy);
            this.m_groupBy.addGroupByColumn(groupByColumn);
            ArrayList<Object> lRowValues = new ArrayList<Object>();
            lRowValues.add(sTableName);
            lRowValues.add(sColName);
            lRowValues.add(DEFAULTCOLUMNREFERENCE);
            lRowValues.add(groupByColumn);
            return lRowValues;
        }
        if (obj instanceof List) {
            ArrayList lRowValues = new ArrayList();
            lRowValues = (ArrayList)obj;
            return lRowValues;
        }
        return null;
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToModel() throws MdException, RemoteException {
        super.clear();
        this.m_groupByColumns = this.m_groupBy.getGroupByColumns();
        for (int index = 0; index < this.m_groupByColumns.size(); ++index) {
            GroupByColumn groupByColumn = (GroupByColumn)this.m_groupByColumns.get(index);
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(groupByColumn.getTable().getDataTableName());
            row.add(groupByColumn.getTableColumn().getName());
            if (groupByColumn.getDisplayInteger()) {
                row.add("position");
            } else {
                row.add("name");
            }
            row.add(groupByColumn);
            this.m_lData.add(row);
            ++this.m_nRowInstances;
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_groupBy != null) {
            this.m_groupBy.moveDataToStore();
        }
    }

    public Object getRow(int iRow) {
        String sTable = (String)this.getValueAt(iRow, 0);
        String sName = (String)this.getValueAt(iRow, 1);
        String sRef = (String)this.getValueAt(iRow, 2);
        GroupByColumn groupByColumn = (GroupByColumn)this.getValueAt(iRow, 3);
        ArrayList<Object> lRowValues = new ArrayList<Object>();
        lRowValues.add(sTable);
        lRowValues.add(sName);
        lRowValues.add(sRef);
        lRowValues.add(groupByColumn);
        return lRowValues;
    }

    public void deleteRow(int iRow) {
        List lDeletedRowValues = (List)this.m_lData.remove(iRow);
        this.fireTableRowDeleted(iRow, lDeletedRowValues);
        this.m_groupBy.removeGroupByColumn(iRow);
    }

    public void clear() {
        super.clear();
        List groupByCols = this.m_groupBy.getGroupByColumns();
        int size = groupByCols.size();
        for (int i = size - 1; i > -1; --i) {
            this.m_groupBy.removeGroupByColumn((GroupByColumn)groupByCols.get(i));
        }
    }

    public void setRowValues(int iRow, List lRowValues) {
        List lData = (List)this.m_lData.get(iRow);
        lData.clear();
        lData.addAll(lRowValues);
        this.fireTableRowsUpdated(iRow, iRow);
        GroupByColumn groupByCol = (GroupByColumn)lRowValues.get(3);
        this.m_groupBy.moveGroupByColumn(this.m_groupBy.getIndexOfGroupByColumn(groupByCol), iRow);
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        List lRow = (List)this.m_lData.get(iRow);
        lRow.set(iCol, value);
        this.fireTableCellUpdated(iRow, iCol);
        GroupByColumn groupByColumn = (GroupByColumn)this.getValueAt(iRow, 3);
        if (iCol == 2) {
            groupByColumn.setDisplayInteger(((String)value).equals("position"));
        }
        this.m_groupBy.removeGroupByColumn(groupByColumn);
        this.m_groupBy.addGroupByColumn(iRow, groupByColumn);
    }

    public int getColumnCount() {
        return this.m_aColumns.length - 1;
    }

    protected class cListTableColumn
    extends WsEnumeratedTableColumn {
        protected List m_unTranslatedValues;
        protected List m_translatedValues;

        public cListTableColumn(int iModelIndex, String sName, int cxWidth, List translatedValues, List unTranslatedValues, String sDefault) {
            super(iModelIndex, sName, cxWidth, translatedValues.toArray(new String[translatedValues.size()]), sDefault);
            this.m_translatedValues = translatedValues;
            this.m_unTranslatedValues = unTranslatedValues;
        }

        public TableCellEditor createCellEditor() {
            return new AbstractPropertiesModel.DefaultListTableCellEditor(this.m_translatedValues, this.m_unTranslatedValues);
        }

        protected TableCellRenderer createCellRenderer() {
            return new AbstractPropertiesModel.DefaultListTableCellRenderer(this.m_translatedValues, this.m_unTranslatedValues);
        }
    }
}

