/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.etl.models.data.IPhysicalTable;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.wadmin.visuals.WASASNameDocument;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceUtil;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.rmi.RemoteException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.text.Document;

public class AliasNameDialog
extends MessageUtil.cMessageDialog {
    private static final WAdminResource bundle = WAdminResource.getBundle(AliasNameDialog.class);
    private WATextField m_txtField;
    private JLabel m_txtLabel;

    public AliasNameDialog() {
        super((JFrame)Workspace.getWorkspace(), bundle.getString("AliasNameDialog.Message.txt"), bundle.getString("AliasNameDialog.Title.txt"), 1, 2);
    }

    protected void layoutComponents() {
        this.m_txtField = new WATextField((Document)((Object)new WASASNameDocument()), "", 0);
        this.m_txtField.setMaxCharacters(32);
        this.m_txtLabel = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtField, (WAdminResource)bundle, (String)"AliasNameDialog.AliasField");
        Container pnlContents = this.getContentPane();
        pnlContents.setLayout(new GridBagLayout());
        pnlContents.add((Component)this.m_lblIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(7, 7, 7, 7), 0, 0));
        pnlContents.add((Component)this.m_txtMessage, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(7, 7, 7, 7), 0, 0));
        pnlContents.add((Component)this.m_txtLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 7, 7, 7), 0, 0));
        pnlContents.add((Component)this.m_txtField, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(7, 7, 7, 7), 0, 0));
        pnlContents.add((Component)this.m_pnlButtons, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 15, 0, new Insets(7, 0, 7, 0), 0, 0));
        this.pack();
    }

    public String getAliasText() {
        return this.m_txtField.getText();
    }

    public void dispose() {
        if (this.m_eReturn == 0 && !this.validateData()) {
            this.m_eReturn = -1;
            return;
        }
        super.dispose();
    }

    public void setDefault(PhysicalTable table) {
        try {
            String defaultText = WsMetadataNameUtil.getUniqueNameForType((String)"PhysicalTable", (String)table.getSASTableName());
            defaultText = defaultText.replaceAll(" ", "_");
            this.m_txtField.setText(defaultText);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void setDefault(IPhysicalTable table) {
        String defaultText = WsMetadataNameUtil.getUniqueNameForType((String)"PhysicalTable", (String)table.getSASTableName());
        defaultText = defaultText.replaceAll(" ", "_");
        this.m_txtField.setText(defaultText);
    }

    public boolean validateData() {
        if (this.m_txtField.getText().trim().length() == 0) {
            this.m_txtField.grabFocus();
            MessageUtil.displayMessage((String)bundle.getString("AliasNameDialog.AliasRequired.Error.txt"), (int)0);
            return false;
        }
        String text = this.m_txtField.getText();
        if (!Character.isLetter(text.charAt(0)) && !WASASNameDocument.getValidChars().contains(Character.toString(text.charAt(0)))) {
            this.m_txtField.grabFocus();
            MessageUtil.displayMessage((String)bundle.getString("AliasNameDialog.FirstLetterNotCharacter.Error.txt"), (int)0);
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isLetterOrDigit(text.charAt(i)) || WASASNameDocument.getValidChars().contains(Character.toString(text.charAt(i)))) continue;
            this.m_txtField.grabFocus();
            MessageUtil.displayMessage((String)bundle.getString("AliasNameDialog.SpecialCharacter.Error.txt"), (int)0);
            return false;
        }
        return true;
    }

    public int showDialog() {
        this.pack();
        WorkspaceUtil.centerOver((Window)((Object)this), (Component)Workspace.getWorkspace());
        this.show();
        return this.getReturn();
    }
}

