/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.CreateSelect;
import com.sas.wadmin.transforms.sql.model.From;
import com.sas.wadmin.transforms.sql.model.Join;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.model.Where;
import com.sas.wadmin.viewdata2.ViewDataView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsViewFactory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;

public class ActionFactory {
    private static WAdminResource bundle = WAdminResource.getBundle(ActionFactory.class);
    private static ActionFactory s_instance;

    private ActionFactory() {
    }

    public static ActionFactory getInstance() {
        if (s_instance == null) {
            s_instance = new ActionFactory();
        }
        return s_instance;
    }

    public Action[] createClauseActions(ClauseInterface clause, boolean bEditable) {
        if (clause instanceof Join) {
            return this.createJoinActions((Join)clause, bEditable);
        }
        if (clause instanceof SelectResults) {
            return this.createSelectActions((SelectResults)clause, bEditable);
        }
        DeleteClauseAction actDelete = new DeleteClauseAction(clause);
        if (!bEditable) {
            actDelete.setEnabled(false);
        }
        return new Action[]{actDelete};
    }

    public Action[] createSelectActions(SelectResults select, boolean bEditable) {
        Action[] aActions = new Action[]{new DeleteClauseAction(select), null, new DistinctAction(select), new SelectStarAction(select)};
        if (!bEditable) {
            this.disableActions(aActions);
        }
        return aActions;
    }

    public Action[] createJoinActions(Join join, boolean bEditable) {
        Action[] aActions = new Action[]{new SwapInputsAction(join), new DeleteJoinAction(join), null, new InnerJoinAction(join), new FullJoinAction(join), new LeftJoinAction(join), new RightJoinAction(join), new CrossJoinAction(join), new UnionJoinAction(join), null, new ImplicitAction(join), new ParenthesesAction(join)};
        if (!bEditable) {
            this.disableActions(aActions);
        }
        return aActions;
    }

    public Action[] createTableActions(TableInterface table, boolean bEditable) {
        if (table.isChangeViewSupported()) {
            return new Action[]{new PropertiesAction(table), new ViewDataAction(table), new CreateViewAction(table, bEditable), new DeleteTableAction(table, bEditable)};
        }
        return new Action[]{new PropertiesAction(table), new ViewDataAction(table), new DeleteTableAction(table, bEditable)};
    }

    public static void addActionsToPopupMenu(JPopupMenu menuPopup, Action[] aActions) {
        for (int iAction = 0; iAction < aActions.length; ++iAction) {
            if (aActions[iAction] == null) {
                menuPopup.addSeparator();
                continue;
            }
            if (aActions[iAction] instanceof WsAbstractToggleAction) {
                menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)((WsAbstractToggleAction)aActions[iAction])));
                continue;
            }
            menuPopup.add(aActions[iAction]);
        }
    }

    private void disableActions(Action[] aActions) {
        for (int iAction = 0; iAction < aActions.length; ++iAction) {
            if (aActions[iAction] == null) continue;
            aActions[iAction].setEnabled(false);
        }
    }

    private static class DeleteClauseAction
    extends WsAbstractAction {
        private ClauseInterface m_clause;

        public DeleteClauseAction(ClauseInterface clause) {
            super(bundle, "ActionFactory.Action.Delete", 258);
            this.m_clause = clause;
            this.setEnabled(!(clause instanceof SelectResults) && !(clause instanceof From) && !(clause instanceof CreateSelect) && !(clause instanceof SubQuery));
        }

        public void actionPerformed(ActionEvent ev) {
            if (this.m_clause instanceof Where && this.m_clause.getParentQuery().hasImplicitJoin() && ((Where)this.m_clause).getExpressions().size() > 0) {
                String sTitle = this.getText();
                String sMessage = bundle.getString("ActionFactory.Warning.DeleteWhereWithImplicitJoin.txt");
                int eAnswer = MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)2, (int)2);
                if (eAnswer != 0) {
                    return;
                }
            }
            this.m_clause.getParentQuery().removeClause(this.m_clause);
        }
    }

    private static class DistinctAction
    extends WsAbstractToggleAction {
        private SelectResults m_select;

        public DistinctAction(SelectResults select) {
            super(bundle, "ActionFactory.Action.SelectDistinct", 257);
            this.m_select = select;
            this.setSelected(select.useDistinct());
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_select.setUseDistinct(this.isSelected());
        }
    }

    private static class SelectStarAction
    extends WsAbstractToggleAction {
        private SelectResults m_select;

        public SelectStarAction(SelectResults select) {
            super(bundle, "ActionFactory.Action.SelectStar", 257);
            this.m_select = select;
            this.setSelected(select.useImplicit());
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_select.setUseImplicit(this.isSelected());
        }
    }

    private static class SwapInputsAction
    extends WsAbstractAction {
        private Join m_join;

        public SwapInputsAction(Join join) {
            super(bundle, "ActionFactory.Action.SwapInputs", 257);
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.swapLeftAndRightSides();
        }
    }

    private class DeleteJoinAction
    extends WsAbstractAction {
        private Join m_join;

        public DeleteJoinAction(Join join) {
            super(bundle, "ActionFactory.Action.Delete", 258);
            this.m_join = join;
            this.setEnabled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ev) {
            SourceTableInterface srcLeft = this.m_join.getLeftSide();
            SourceTableInterface srcRight = this.m_join.getRightSide();
            this.m_join.getSQLModel().setFireEventsEnabled(false);
            try {
                SourceTableInterface src;
                if (srcLeft == null) {
                    src = srcRight;
                } else if (srcRight == null) {
                    src = srcLeft;
                } else {
                    String sTitle = bundle.getString("ActionFactory.DeleteWhichInputTitle.txt");
                    DeleteWhichSidePanel pnl = new DeleteWhichSidePanel();
                    WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true);
                    dlg.setMainPanel((WAPanel)pnl);
                    dlg.setHelpButtonVisible(false);
                    dlg.show();
                    if (dlg.getReturnValue() != 1) {
                        return;
                    }
                    if (pnl.isDeleteLeftSelected()) {
                        srcLeft.remove();
                        src = srcRight;
                    } else if (pnl.isDeleteRightSelected()) {
                        srcRight.remove();
                        src = srcLeft;
                    } else {
                        srcRight.remove();
                        srcLeft.remove();
                        src = null;
                    }
                }
                Query query = this.m_join.getParentQuery();
                query.replaceSource(this.m_join, src);
                this.m_join.remove();
                this.m_join.getSQLModel().setFireEventsEnabled(true);
            }
            finally {
                this.m_join.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
            }
        }
    }

    private static class InnerJoinAction
    extends WsAbstractToggleAction {
        private Join m_join;

        public InnerJoinAction(Join join) {
            super(bundle, "ActionFactory.Action.InnerJoin", 256);
            this.setIcon(Join.getIcon("Inner"));
            this.setSelected(join.getJoinType().equals("Inner"));
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setJoinType("Inner");
        }
    }

    private static class FullJoinAction
    extends WsAbstractToggleAction {
        private Join m_join;

        public FullJoinAction(Join join) {
            super(bundle, "ActionFactory.Action.FullJoin", 256);
            this.setIcon(Join.getIcon("Full"));
            this.setSelected(join.getJoinType().equals("Full"));
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setJoinType("Full");
        }
    }

    private static class LeftJoinAction
    extends WsAbstractToggleAction {
        private Join m_join;

        public LeftJoinAction(Join join) {
            super(bundle, "ActionFactory.Action.LeftJoin", 256);
            this.setIcon(Join.getIcon("Left"));
            this.setSelected(join.getJoinType().equals("Left"));
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setJoinType("Left");
        }
    }

    private static class RightJoinAction
    extends WsAbstractToggleAction {
        private Join m_join;

        public RightJoinAction(Join join) {
            super(bundle, "ActionFactory.Action.RightJoin", 256);
            this.setIcon(Join.getIcon("Right"));
            this.setSelected(join.getJoinType().equals("Right"));
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setJoinType("Right");
        }
    }

    private static class CrossJoinAction
    extends WsAbstractToggleAction {
        private Join m_join;

        public CrossJoinAction(Join join) {
            super(bundle, "ActionFactory.Action.CrossJoin", 256);
            this.setIcon(Join.getIcon("Cross"));
            this.setSelected(join.getJoinType().equals("Cross"));
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setJoinType("Cross");
        }
    }

    private static class UnionJoinAction
    extends WsAbstractToggleAction {
        private Join m_join;

        public UnionJoinAction(Join join) {
            super(bundle, "ActionFactory.Action.UnionJoin", 256);
            this.setIcon(Join.getIcon("Union"));
            this.setSelected(join.getJoinType().equals("Union"));
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setJoinType("Union");
        }
    }

    private static class ImplicitAction
    extends WsAbstractToggleAction {
        private Join m_join;

        public ImplicitAction(Join join) {
            super(bundle, "ActionFactory.Action.Implicit", 257);
            this.m_join = join;
            this.setSelected(join.useImplicit());
            this.setEnabled(join.getJoinType().equals("Inner"));
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setUseImplicit(this.isSelected());
        }
    }

    private static class ParenthesesAction
    extends WsAbstractToggleAction {
        private Join m_join;

        public ParenthesesAction(Join join) {
            super(bundle, "ActionFactory.Action.Parentheses", 257);
            this.m_join = join;
            this.setSelected(join.useParentheses());
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setUseParentheses(this.isSelected());
        }
    }

    private class PropertiesAction
    extends WsAbstractAction {
        private TableInterface m_table;

        public PropertiesAction(TableInterface table) {
            super(bundle, "ActionFactory.Action.Properties", 258);
            this.setMenuSupportId("properties");
            this.m_table = table;
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                MdObjectStore store;
                try {
                    this.m_table.getSQLModel().moveDataToStore();
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                DataTable mdoTable = this.m_table.getDataTable();
                if (mdoTable.getCMetadataType().equals("WorkTable")) {
                    store = Workspace.getMdFactory().createObjectStore((MdStore)this.m_table.getSQLModel().getObjectStore(), "SQL: PhysicalTable Store");
                    store.setIsGotToServerForMetadata(false);
                } else {
                    store = Workspace.getMdFactory().createObjectStore(null, "SQL: PhysicalTable Store");
                }
                CMetadata newObject = Workspace.getMdFactory().createComplexMetadataObject(store, null, (CMetadata)mdoTable);
                WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.wadmin.visuals.", (String)"View");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    private class ViewDataAction
    extends WsAbstractAction {
        private TableInterface m_table;

        public ViewDataAction(TableInterface table) {
            super(bundle, "ActionFactory.Action.ViewData", 257);
            try {
                this.setMenuSupportId("viewdata");
                this.setHidable(true);
                this.m_table = table;
                this.setEnabled(this.m_table.getDataTable().getCMetadataType().equals("PhysicalTable") || this.canViewData());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        private boolean canViewData() {
            return this.m_table.getSQLModel().getViewWorkTables();
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                WsAppServer appServer = this.m_table.getSQLModel().getWsAppServer();
                HashMap<String, WsAppServer> map = new HashMap<String, WsAppServer>();
                if (appServer != null) {
                    map.put("AppServer", appServer);
                }
                try {
                    if (this.m_table instanceof TargetTable) {
                        ((TargetTable)this.m_table).moveDataToStore();
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                WsViewFactory.showView((CMetadata)this.m_table.getDataTable(), ViewDataView.class, map, (MdStore)this.m_table.getDataTable().getObjectStore());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    private class CreateViewAction
    extends WsAbstractToggleAction {
        private TableInterface m_table;

        public CreateViewAction(TableInterface table, boolean bEditable) {
            super(bundle, "ActionFactory.Action.CreateView", 257);
            this.m_table = table;
            this.setHidable(true);
            this.setEnabled(table.isChangeViewSupported() && bEditable);
            this.setSelected(table.isTableAView());
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_table.setIsTableAView(this.isSelected());
        }
    }

    private class DeleteTableAction
    extends WsAbstractAction {
        private TableInterface m_table;

        public DeleteTableAction(TableInterface table, boolean bEditable) {
            super(bundle, "ActionFactory.Action.Delete", 258);
            try {
                this.setMenuSupportId("delete");
                this.m_table = table;
                boolean bPhysical = table.getDataTable().getCMetadataType().equals("PhysicalTable");
                this.setEnabled(bEditable && bPhysical && table instanceof SourceTableInterface);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public void actionPerformed(ActionEvent ev) {
            String sTitle = this.getText();
            String sMessage = bundle.formatString("ActionFactory.Warning.Delete.txt", (Object)this.m_table.getDataTableName());
            int eAnswer = MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)2, (int)0);
            if (eAnswer != 0) {
                return;
            }
            this.m_table.remove();
        }
    }

    private class DeleteWhichSidePanel
    extends WAPanel {
        private WATextArea m_txtDescription;
        private JRadioButton m_rbnLeft;
        private JRadioButton m_rbnRight;
        private JRadioButton m_rbnBoth;

        public DeleteWhichSidePanel() {
            this.initialize();
        }

        protected void initialize() {
            this.m_txtDescription = new WATextArea();
            this.m_txtDescription.setBehavior(1);
            this.m_txtDescription.setAutosize(true);
            this.m_txtDescription.setColumns(30);
            this.m_txtDescription.setText(bundle.getString("ActionFactory.DeleteWhichInputDescription.txt"));
            this.m_rbnLeft = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"ActionFactory.RadioButton.DeleteLeftInput");
            this.m_rbnRight = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"ActionFactory.RadioButton.DeleteRightInput");
            this.m_rbnBoth = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"ActionFactory.RadioButton.DeleteBothInputs");
            ButtonGroup grp = new ButtonGroup();
            grp.add(this.m_rbnLeft);
            grp.add(this.m_rbnRight);
            grp.add(this.m_rbnBoth);
            this.m_rbnLeft.setSelected(true);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_txtDescription, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.add(this.m_rbnLeft, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_rbnRight, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_rbnBoth, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean isDeleteLeftSelected() {
            return this.m_rbnLeft.isSelected();
        }

        public boolean isDeleteRightSelected() {
            return this.m_rbnRight.isSelected();
        }

        public boolean isDeleteBothSelected() {
            return this.m_rbnBoth.isSelected();
        }
    }
}

