/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sort;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.ISortingTransform;
import com.sas.expressions.visuals.DataSourceNodeInterface;
import com.sas.expressions.visuals.DataValuesInterface;
import com.sas.expressions.visuals.DistinctValuesInterface;
import com.sas.expressions.visuals.FormattedValuesInterface;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsDefaultTreeModel;
import com.sas.workspace.tree.WsTreeModel;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SortColsByTreeModel
extends WsDefaultTreeModel {
    protected ISortingTransform m_sortModel;
    protected boolean m_bSourcesAppearFirst = true;
    protected boolean m_bShowSourcesOnly = false;
    protected boolean m_bSortColumns = false;
    protected int m_iUseColsFromTable;
    public static final int USE_SOURCE_TABLE = 0;
    public static final int USE_TARGET_TABLE = 1;
    public static final int TYPE_CHARACTER = 0;
    public static final int TYPE_NUMERIC = 1;

    public SortColsByTreeModel() {
        super(new WsTreeNode("Root"));
    }

    public SortColsByTreeModel(ISortingTransform sortTransformModel, int useColsFromTable) {
        super(new WsTreeNode(sortTransformModel.getName()));
        this.m_sortModel = sortTransformModel;
        this.m_iUseColsFromTable = useColsFromTable;
    }

    public ISortingTransform getSortModel() {
        return this.m_sortModel;
    }

    public void createModelListener() {
    }

    public void moveDataToModel() {
        cTargetTableNode targetTableNode = this.getRootTableNode();
        if (targetTableNode == null) {
            return;
        }
        targetTableNode.setSorted(false);
        this.removeAllChildrenFromTree(targetTableNode);
        this.setRoot((TreeNode)((Object)targetTableNode));
        this.addColumnNodes(targetTableNode);
    }

    public void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    protected cTargetTableNode getRootTableNode() {
        try {
            List<IDataObject> l_Tables = this.m_iUseColsFromTable == 0 ? Arrays.asList(this.m_sortModel.getDataSources()) : Arrays.asList(this.m_sortModel.getDataTargets());
            int iTables = 0;
            if (iTables < l_Tables.size()) {
                ITable oTable = (ITable)l_Tables.get(iTables);
                return new cTargetTableNode(oTable);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    public void addColumnNodes(cTargetTableNode targetTableNode) {
        targetTableNode.addChildren();
        targetTableNode.setHasExpanded(true);
    }

    public void createNewColumnNode(IColumn column, WsTreeNode parent) {
        if (parent.getTreeModel() == null) {
            parent.setTreeModel((WsTreeModel)this);
        }
        cColumnTreeNode colnode = new cColumnTreeNode(column, column.getTable());
        parent.addChild((WsTreeNode)colnode);
    }

    public void addListenersToTree(JTree tree) {
        tree.addTreeExpansionListener(this.createTreeExpansionListener());
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new cExpansionListener();
    }

    private void appendNode(WsTreeNode nodeChild, WsTreeNode nodeParent) {
        if (nodeParent.isSorted()) {
            this.addChild(nodeChild, nodeParent);
            return;
        }
        this.insertNodeInto((MutableTreeNode)nodeChild, (MutableTreeNode)nodeParent, nodeParent.getChildCount());
    }

    private void removeAllChildrenFromTree(WsTreeNode nodeParent) {
        int nChildren = nodeParent.getChildCount();
        if (nChildren <= 0) {
            return;
        }
        int[] aChildIndexes = new int[nChildren];
        Object[] aChildNodes = new TreeNode[nChildren];
        for (int iChild = 0; iChild < nChildren; ++iChild) {
            aChildIndexes[iChild] = iChild;
            aChildNodes[iChild] = nodeParent.getChildAt(iChild);
        }
        nodeParent.removeAllChildren();
        this.nodesWereRemoved((TreeNode)nodeParent, aChildIndexes, aChildNodes);
    }

    public void setSortColumns(boolean bSort) {
        if (this.m_bSortColumns == bSort) {
            return;
        }
        this.m_bSortColumns = bSort;
        this.reorderTableColumns((WsTreeNode)this.getRoot());
    }

    private void reorderTableColumns(WsTreeNode node) {
        if (node instanceof cTableNode) {
            node.setSorted(this.m_bSortColumns);
            if (node.hasExpanded()) {
                this.removeAllChildrenFromTree(node);
                node.setHasExpanded(false);
                node.addChildren();
                node.setHasExpanded(true);
            }
        } else {
            this.reorderTableColumns(node);
        }
    }

    protected class cTargetTableNode
    extends cTableNode {
        public cTargetTableNode(ITable targetTable) throws RemoteException {
            super(targetTable);
        }

        public void addChildren() {
            List<IColumn> l_Columns = Arrays.asList(this.getTable().getColumns());
            for (int iColumn = 0; iColumn < l_Columns.size(); ++iColumn) {
                IColumn oIColumn = l_Columns.get(iColumn);
                cColumnTreeNode columnNode = new cColumnTreeNode(oIColumn, this.m_table);
                SortColsByTreeModel.this.appendNode(columnNode, this);
            }
        }
    }

    protected class cColumnTreeNode
    extends WsTreeNode
    implements DataSourceNodeInterface {
        private IColumn m_oIColumn;
        private ITable m_table;

        public cColumnTreeNode(IColumn oColumn, ITable table) {
            super(oColumn.getName());
            this.m_oIColumn = oColumn;
            this.m_table = table;
            this.setDragSource(true);
            this.setAllowsChildren(false);
            this.setIcon(ColumnUIUtilities.getTypeIcon(oColumn));
            this.setUserObject(oColumn);
        }

        public void doDefaultAction() {
        }

        public ITable getTable() {
            return this.m_table;
        }

        public IColumn getTableColumn() {
            return this.m_oIColumn;
        }

        public DataValuesInterface getDataValuesInterface() {
            return null;
        }

        public DistinctValuesInterface getDistinctValuesInterface() {
            return null;
        }

        public FormattedValuesInterface getFormattedValuesInterface() {
            return null;
        }

        public String getInsertName() {
            return this.m_oIColumn.getName() + " ";
        }

        public String getDescription() {
            return this.m_oIColumn.getDescription();
        }

        public String getDisplayName() {
            return this.m_oIColumn.getName();
        }
    }

    protected class cExpansionListener
    implements TreeExpansionListener {
        protected cExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            WsTreeNode node = (WsTreeNode)e.getPath().getLastPathComponent();
            if (!node.hasExpanded()) {
                node.addChildren();
                node.setHasExpanded(true);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
        }
    }

    protected class cTableNode
    extends WsTreeNode {
        protected ITable m_table;

        public cTableNode(ITable table) throws RemoteException {
            super(table.getName());
            this.m_table = table;
            this.setAllowsChildren(true);
            SortColsByTreeModel.this.setAsksAllowsChildren(true);
            this.setDragSource(false);
            this.setSorted(SortColsByTreeModel.this.m_bSortColumns);
            this.setUserObject(table);
        }

        public void doDefaultAction() {
        }

        public ITable getTable() {
            return this.m_table;
        }
    }
}

