/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.scd;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.wadmin.visuals.common.ExpressionBuilderTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectedColumnPanel
extends JPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(SelectedColumnPanel.class);
    private JLabel m_lblTable;
    private WATextField m_txtTable;
    private JLabel m_lblColumn;
    private WATextField m_txtColumn;
    private JButton m_btnColumn;
    private JLabel m_lblExpression;
    private WATextField m_txtExpression;
    private JButton m_btnExpression;
    private WsAbstractAction m_actShowExpressionBuilder;
    private String m_sColumnSelectorDialogDescription;
    private String m_sColumnSelectorDialogTitle;
    private String m_sColumnSelectorDialogHelpTopic = "select_column_win";
    private IColumn m_column;
    private boolean m_bEditable;
    private IModel m_model;
    private List m_columnListeners;
    private List m_expressionListeners;
    private FocusListener m_expressionTextFieldFocusListener;
    private ActionListener m_btnListener;
    private ActionListener m_expressionTextFieldActionListener;

    public SelectedColumnPanel(IModel model) {
        this.m_model = model;
        this.m_columnListeners = new ArrayList();
        this.m_expressionListeners = new ArrayList();
        this.m_txtTable = new WATextField();
        this.m_txtTable.setEditable(false);
        this.m_lblTable = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtTable, (String)bundle.getString("SelectedColumnPanel.Table.txt"));
        this.m_txtColumn = new WATextField();
        this.m_txtColumn.setEditable(false);
        this.m_lblColumn = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtColumn, (String)bundle.getString("SelectedColumnPanel.Column.txt"));
        this.m_btnColumn = WsUIUtilities.createBrowseButton();
        this.m_btnListener = new cSelectListener();
        this.m_btnColumn.addActionListener(this.m_btnListener);
        this.m_btnColumn.setToolTipText(bundle.getString("SelectedColumnPanel.ColumnButton.ToolTip.txt"));
        this.m_txtExpression = new WATextField();
        this.m_lblExpression = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtExpression, (String)bundle.getString("SelectedColumnPanel.Expression.txt"));
        this.m_expressionTextFieldFocusListener = new ExpressionTextFieldFocusListener();
        this.m_txtExpression.addFocusListener(this.m_expressionTextFieldFocusListener);
        this.m_expressionTextFieldActionListener = new ExpressionTextFieldActionListener();
        this.m_txtExpression.addActionListener(this.m_expressionTextFieldActionListener);
        this.m_actShowExpressionBuilder = new ShowExpressionBuilderAction();
        this.m_btnExpression = WsUIUtilities.createBrowseButton();
        this.m_btnExpression.setAction((Action)this.m_actShowExpressionBuilder);
        this.m_btnExpression.setToolTipText(bundle.getString("SelectedColumnPanel.ExpressionButton.ToolTip.txt"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_lblTable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_txtTable, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_btnColumn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_lblColumn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_txtColumn, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_lblExpression, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_txtExpression, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_btnExpression, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setEditable(true);
    }

    public void setColumn(IColumn column) {
        if (this.m_column == column) {
            return;
        }
        this.m_column = column;
        if (column != null) {
            this.m_txtColumn.setText(column.getName());
            ITable table = column.getTable();
            if (table != null) {
                this.m_txtTable.setText(table.getName());
            }
        }
        this.notifyColumnListeners();
    }

    public IColumn getColumn() {
        return this.m_column;
    }

    public void setExpression(String expression) {
        if (this.m_txtExpression.getText() == expression) {
            return;
        }
        this.m_txtExpression.setText(expression);
        this.notifyExpressionListeners();
    }

    public String getExpression() {
        return this.m_txtExpression.getText();
    }

    public void setTableLabel(String sLabel, char mnem) {
        this.m_lblTable.setText(sLabel);
        this.m_lblTable.setDisplayedMnemonic(mnem);
    }

    public void setColumnLabel(String sLabel, char mnem) {
        this.m_lblColumn.setText(sLabel);
        this.m_lblColumn.setDisplayedMnemonic(mnem);
    }

    @Override
    public void setEnabled(boolean bEnabled) {
        this.m_lblTable.setEnabled(bEnabled);
        this.m_txtTable.setEnabled(bEnabled);
        this.m_btnColumn.setEnabled(bEnabled);
        this.m_lblColumn.setEnabled(bEnabled);
        this.m_txtColumn.setEnabled(bEnabled);
        this.m_lblExpression.setEnabled(bEnabled);
        this.m_txtExpression.setEnabled(bEnabled);
        this.m_btnExpression.setEnabled(bEnabled);
    }

    @Override
    public boolean isEnabled() {
        return this.m_lblTable.isEnabled();
    }

    public void setEditable(boolean bEditable) {
        this.m_bEditable = bEditable;
        this.m_btnColumn.setEnabled(bEditable && this.isEnabled());
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void setColumnButtonToolTip(String sToolTip) {
        this.m_btnColumn.setToolTipText(sToolTip);
    }

    public String getColumnButtonToolTip() {
        return this.m_btnColumn.getToolTipText();
    }

    public void setColumnSelectorDialogDescription(String sColumnSelectorDialogDescription) {
        this.m_sColumnSelectorDialogDescription = sColumnSelectorDialogDescription;
    }

    public String getColumnSelectorDialogDescription() {
        return this.m_sColumnSelectorDialogDescription;
    }

    public void setColumnSelectorDialogTitle(String sColumnSelectorDialogTitle) {
        this.m_sColumnSelectorDialogTitle = sColumnSelectorDialogTitle;
    }

    public String getColumnSelectorDialogTitle() {
        return this.m_sColumnSelectorDialogTitle;
    }

    public void setColumnSelectorDialogHelpTopic(String sColumnSelectorDialogHelpTopic) {
        this.m_sColumnSelectorDialogHelpTopic = sColumnSelectorDialogHelpTopic;
    }

    public void setExpressionButtonToolTip(String sToolTip) {
        this.m_btnExpression.setToolTipText(sToolTip);
    }

    public String getExpressionButtonToolTip() {
        return this.m_btnExpression.getToolTipText();
    }

    public void addColumnChangeListener(ChangeListener listener) {
        this.m_columnListeners.add(listener);
    }

    public void removeColumnChangeListener(ChangeListener listener) {
        this.m_columnListeners.remove(listener);
    }

    public void notifyColumnListeners() {
        for (int i = 0; i < this.m_columnListeners.size(); ++i) {
            ChangeListener listener = (ChangeListener)this.m_columnListeners.get(i);
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void addExpressionChangeListener(ChangeListener listener) {
        this.m_expressionListeners.add(listener);
    }

    public void removeExpressionChangeListener(ChangeListener listener) {
        this.m_expressionListeners.remove(listener);
    }

    public void notifyExpressionListeners() {
        for (int i = 0; i < this.m_expressionListeners.size(); ++i) {
            ChangeListener listener = (ChangeListener)this.m_expressionListeners.get(i);
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public void requestFocus() {
        this.m_txtTable.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IColumn convertSimpleObjectToColumn(SimpleObject object) {
        block9: {
            IColumn iColumn;
            block8: {
                IObject columnObject = this.m_model.getObject(object.getID());
                if (columnObject != null) {
                    return (IColumn)columnObject;
                }
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "SelectedColumnPanel.selectColumn");
                try {
                    IColumn column = this.m_model.getObjectFactory().createColumn(object.getID());
                    this.m_model.loadFromOMR((IOMRPersistable)column, Workspace.getMdFactory());
                    iColumn = column;
                    if (store == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (store != null) {
                            store.dispose();
                        }
                        throw throwable;
                    }
                    catch (RemoteException e) {
                        Workspace.handleRemoteException((RemoteException)e);
                        break block9;
                    }
                    catch (MdException e) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                    }
                }
                store.dispose();
            }
            return iColumn;
        }
        return null;
    }

    private String getTableNameForSimpleColumnObject(SimpleObject column) {
        try {
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><Column><Table/></Column><DataTable Name=\"\"/></Templates>");
            filter.setOMRFlags(-2147483628);
            String sKey = column.getID() + "/" + column.getMetadataType();
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            BrowseMetadataInterface lightweightColumn = server.browseFetch(sKey, (FilterInterface)filter);
            List lTables = (List)lightweightColumn.get("Table");
            if (lTables != null && !lTables.isEmpty()) {
                String tableName = ((BrowseMetadataInterface)lTables.get(0)).getName();
                return tableName;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        return null;
    }

    private ITable getTableForSimpleColumnObject(SimpleObject column) {
        try {
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><Column><Table/></Column><DataTable Name=\"\"/></Templates>");
            filter.setOMRFlags(-2147483628);
            String key = column.getID() + "/" + column.getMetadataType();
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            BrowseMetadataInterface lightweightColumn = server.browseFetch(key, (FilterInterface)filter);
            List tables = (List)lightweightColumn.get("Table");
            if (tables != null && !tables.isEmpty()) {
                String tableId = ((BrowseMetadataInterface)tables.get(0)).getReposId();
                String type = ((BrowseMetadataInterface)tables.get(0)).getNativeType();
                IPhysicalTable table = null;
                IObject object = null;
                if (type.equals("PhysicalTable")) {
                    object = this.m_model.getObject(tableId);
                    if (object != null) {
                        return (IPhysicalTable)object;
                    }
                    table = this.m_model.getObjectFactory().createPhysicalTable(tableId);
                    this.m_model.loadFromOMR((IOMRPersistable)table, Workspace.getMdFactory());
                    return table;
                }
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        return null;
    }

    public void saveSettingsAndCleanUp() {
        ChangeListener listener;
        int i;
        this.m_btnColumn.removeActionListener(this.m_btnListener);
        this.m_txtExpression.removeFocusListener(this.m_expressionTextFieldFocusListener);
        this.m_txtExpression.removeActionListener(this.m_expressionTextFieldActionListener);
        for (i = 0; i < this.m_columnListeners.size(); ++i) {
            listener = (ChangeListener)this.m_columnListeners.get(i);
            this.removeColumnChangeListener(listener);
        }
        for (i = 0; i < this.m_expressionListeners.size(); ++i) {
            listener = (ChangeListener)this.m_expressionListeners.get(i);
            this.removeExpressionChangeListener(listener);
        }
    }

    protected class cSelectListener
    implements ActionListener {
        protected cSelectListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            String sTitle = SelectedColumnPanel.this.m_sColumnSelectorDialogTitle;
            if (sTitle == null) {
                sTitle = bundle.getString("SelectedColumnPanel.DialogTitle.txt");
            }
            ObjectSelectorPanel pnlMain = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), 4, SelectedColumnPanel.this.m_sColumnSelectorDialogDescription);
            pnlMain.setVisibleTypes(new String[]{"Column", "Table", "Library"});
            pnlMain.setInventoryTypes(new String[]{"Table", "Library"});
            pnlMain.setSelectedObject((SimpleObject)SelectedColumnPanel.this.m_column);
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnlMain);
            dlg.setResizable(true);
            dlg.setHelpProduct("wdb");
            dlg.setHelpTopic(SelectedColumnPanel.this.m_sColumnSelectorDialogHelpTopic);
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                try {
                    SelectedColumnPanel.this.m_model.startCompoundUndoable();
                    SimpleObject object = pnlMain.getSelectedObject();
                    IColumn column = SelectedColumnPanel.this.convertSimpleObjectToColumn(object);
                    String tableName = SelectedColumnPanel.this.getTableNameForSimpleColumnObject((SimpleObject)column);
                    if (tableName != null) {
                        SelectedColumnPanel.this.m_txtTable.setText(tableName);
                    }
                    ITable table = SelectedColumnPanel.this.getTableForSimpleColumnObject((SimpleObject)column);
                    SelectedColumnPanel.this.setColumn(column);
                }
                finally {
                    SelectedColumnPanel.this.m_model.endCompoundUndoable();
                }
            }
        }
    }

    private class ExpressionTextFieldFocusListener
    implements FocusListener {
        private ExpressionTextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            SelectedColumnPanel.this.notifyExpressionListeners();
        }
    }

    private class ExpressionTextFieldActionListener
    implements ActionListener {
        private ExpressionTextFieldActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SelectedColumnPanel.this.notifyExpressionListeners();
        }
    }

    protected class ShowExpressionBuilderAction
    extends WsAbstractAction {
        public ShowExpressionBuilderAction() {
            this.putValue("Name", bundle.getString("SelectedColumnPanel.ExpressionButton.txt"));
        }

        public void actionPerformed(ActionEvent e) {
            String expression = SelectedColumnPanel.this.m_txtExpression.getText();
            ExpressionBuilderTab expressionBuilder = new ExpressionBuilderTab(new IColumn[0], new ITable[]{SelectedColumnPanel.this.getColumn().getTable()}, false);
            expressionBuilder.setExpression(expression);
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("SelectedColumnPanel.ExpressionBuilder.Title.txt"), true, (WAPanel)expressionBuilder);
            dialog.setResizable(true);
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                SelectedColumnPanel.this.setExpression(expressionBuilder.getExpression());
            }
            SelectedColumnPanel.this.m_txtExpression.requestFocus();
        }
    }
}

