/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.scd;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.scd.ISCDMaximumKeyGeneration;
import com.sas.etl.models.job.transforms.scd.ISCDType2TransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.scd.DefineMaxGeneratedKeyPanel;
import com.sas.wadmin.visuals.common.ExpressionBuilderTab;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GeneratedKeyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(GeneratedKeyTab.class);
    private WATextArea m_Description;
    private WAComboBox m_cbKeyColumn;
    private JLabel m_lKeyColumn;
    private JButton m_btnMaxKey;
    private JCheckBox m_cbRetainedKey;
    private JCheckBox m_cbRKUnique;
    private JPanel m_expressionPanel;
    private JLabel m_newRecordLabel;
    private WATextField m_newRecordTextField;
    private JButton m_newRecordButton;
    private JLabel m_chgRecordLabel;
    private WATextField m_changedRecordTextField;
    private JButton m_changedRecordButton;
    private WsAbstractAction m_actSelectColumn;
    private WsAbstractAction m_actMaxKey;
    private WsAbstractToggleAction m_actRetainedKey;
    private WsAbstractToggleAction m_actUniqueKey;
    private WsAbstractAction m_actNewRecord;
    private WsAbstractAction m_actChangedRecord;
    private ISCDType2TransformModel m_model;
    private boolean m_hasNoneSelected;
    private IModelListener m_modelListener;
    private FocusListener m_focusListener;
    private ActionListener m_actionListener;
    private static final String NONE = bundle.getString("GeneratedKeyTab.None.txt");

    public GeneratedKeyTab(ISCDType2TransformModel model) {
        this.m_model = model;
        this.initialize();
        this.setName(bundle.getString("GeneratedKeyTab.Name.txt"));
        this.setHelpProduct("wdb");
        this.setHelpTopic("generated_key_tab");
    }

    protected void initialize() {
        this.createActions();
        this.createListeners();
        this.createButtons();
        this.createGenerateKeyColumn();
        this.createExpressionPanel();
        this.layoutComponents();
    }

    protected void createButtons() {
        this.m_btnMaxKey = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actMaxKey);
    }

    protected void createGenerateKeyColumn() {
        this.m_Description = new WATextArea();
        this.m_Description.setBehavior(1);
        this.m_Description.setText(bundle.getString("GeneratedKeyTab.Desc.txt"));
        this.m_Description.setAutosize(true);
        this.m_cbKeyColumn = new WAComboBox();
        this.m_cbKeyColumn.setToolTipText(bundle.getString("GeneratedKeyTab.ColumnKey.Tooltip.txt"));
        this.m_lKeyColumn = new JLabel(bundle.getString("GeneratedKeyTab.ColumnKey.txt"));
        this.m_lKeyColumn.setDisplayedMnemonic(bundle.getString("GeneratedKeyTab.ColumnKey.mnem").charAt(0));
        this.m_lKeyColumn.setLabelFor((Component)this.m_cbKeyColumn);
        this.m_cbKeyColumn.addActionListener((ActionListener)this.m_actSelectColumn);
        this.m_cbRetainedKey = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actRetainedKey);
        this.m_cbRKUnique = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actUniqueKey);
    }

    protected void createExpressionPanel() {
        this.m_expressionPanel = new JPanel(new GridBagLayout());
        this.m_newRecordTextField = new WATextField();
        this.m_newRecordLabel = WsUIUtilities.createLabelForComponent((JComponent)this.m_newRecordTextField, (String)bundle.getString("GeneratedKeyTab.NewRecord.txt"));
        this.m_newRecordTextField.setToolTipText(bundle.getString("GeneratedKeyTab.NewRecord.Tooltip.txt"));
        this.m_newRecordTextField.addFocusListener(this.m_focusListener);
        this.m_newRecordTextField.addActionListener(this.m_actionListener);
        this.m_newRecordButton = WsUIUtilities.createBrowseButton();
        this.m_newRecordButton.setAction((Action)this.m_actNewRecord);
        this.m_newRecordButton.setToolTipText(bundle.getString("GeneratedKeyTab.NewRecordExpression.Tooltip.txt"));
        this.m_changedRecordTextField = new WATextField();
        this.m_chgRecordLabel = WsUIUtilities.createLabelForComponent((JComponent)this.m_changedRecordTextField, (String)bundle.getString("GeneratedKeyTab.ChangeRecord.txt"));
        this.m_changedRecordTextField.setToolTipText(bundle.getString("GeneratedKeyTab.NewRecord.Tooltip.txt"));
        this.m_changedRecordTextField.addFocusListener(this.m_focusListener);
        this.m_changedRecordTextField.addActionListener(this.m_actionListener);
        this.m_changedRecordButton = WsUIUtilities.createBrowseButton();
        this.m_changedRecordButton.setAction((Action)this.m_actChangedRecord);
        this.m_changedRecordButton.setToolTipText(bundle.getString("GeneratedKeyTab.ChangedRecordExpression.Tooltip.txt"));
        this.m_expressionPanel.add((Component)this.m_newRecordLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_expressionPanel.add((Component)this.m_newRecordTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_expressionPanel.add((Component)this.m_newRecordButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.m_expressionPanel.add((Component)this.m_chgRecordLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_expressionPanel.add((Component)this.m_changedRecordTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_expressionPanel.add((Component)this.m_changedRecordButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void createActions() {
        this.m_actSelectColumn = this.createComboBoxAction();
        this.m_actMaxKey = this.createMaxKeyAction();
        this.m_actRetainedKey = this.createRetainedKeyAction();
        this.m_actUniqueKey = this.createUniqueKeyAction();
        this.m_actNewRecord = this.createNewRecordAction();
        this.m_actChangedRecord = this.createChangedRecordAction();
    }

    protected void createListeners() {
        this.m_modelListener = this.createModelListener();
        this.m_model.getModel().addModelListener(this.m_modelListener);
        this.m_focusListener = new TextFieldFocusListener();
        this.m_actionListener = new TextFieldActionListener();
    }

    protected IModelListener createModelListener() {
        return new ModelListener();
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_Description, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_lKeyColumn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_cbKeyColumn, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel maxKeyPanel = new JPanel(new GridBagLayout());
        maxKeyPanel.add((Component)this.m_cbRetainedKey, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        maxKeyPanel.add((Component)this.m_btnMaxKey, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        maxKeyPanel.add((Component)this.m_cbRKUnique, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 5, 5), 0, 0));
        this.add(maxKeyPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_expressionPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        IColumn keyColumn = this.m_model.getGenerateKeyColumn();
        if (keyColumn == null) {
            return true;
        }
        if (keyColumn.getType() != 1) {
            MessageUtil.displayMessage((String)bundle.formatString("GeneratedKeyTab.ColumnNotNumeric.txt", (Object)keyColumn.getName()), (int)0);
            return false;
        }
        String newRecordExpression = this.m_newRecordTextField.getText();
        if (newRecordExpression == null || newRecordExpression.length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("GeneratedKeyTab.NewRecordExp.Error.txt"), (int)0);
            this.m_newRecordTextField.requestFocus();
            this.m_newRecordTextField.selectAll();
            return false;
        }
        String changedRecordExpression = this.m_changedRecordTextField.getText();
        if (!this.m_cbRetainedKey.isSelected() && changedRecordExpression.length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("GeneratedKeyTab.ChgRecordExp.Error.txt"), (int)0);
            this.m_changedRecordTextField.requestFocus();
            this.m_changedRecordTextField.selectAll();
            return false;
        }
        return true;
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        ITable[] targets = this.m_model.getTargetTables();
        if (targets == null || targets.length == 0) {
            this.setEditable(false);
            this.updateActions();
            return;
        }
        this.m_cbKeyColumn.removeAllItems();
        this.m_cbKeyColumn.addItem((Object)NONE);
        IColumn[] columns = targets[0].getColumns();
        for (int i = 0; i < columns.length; ++i) {
            this.m_cbKeyColumn.addItem((Object)new ColumnItem(columns[i]));
        }
        IColumn generatedKeyColumn = this.m_model.getGenerateKeyColumn();
        if (generatedKeyColumn != null) {
            this.m_cbKeyColumn.setSelectedItem((Object)new ColumnItem(generatedKeyColumn));
        } else {
            this.m_cbKeyColumn.setSelectedItem((Object)NONE);
        }
        ITextExpression newRecordExpression = this.m_model.getNewRecordGenKeyExpression();
        try {
            if (newRecordExpression != null) {
                this.m_newRecordTextField.setText(newRecordExpression.getText(null, targets[0].isQuoted()));
            }
        }
        catch (RemoteException e1) {
            Workspace.handleRemoteException((RemoteException)e1);
        }
        catch (CodegenException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (MdException e1) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
        }
        catch (BadServerDefinitionException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (BadLibraryDefinitionException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (ServerException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        ITextExpression changedRecordExpression = this.m_model.getChangedRecordGenKeyExpression();
        try {
            if (changedRecordExpression != null) {
                this.m_changedRecordTextField.setText(changedRecordExpression.getText(null, targets[0].isQuoted()));
            }
        }
        catch (RemoteException e1) {
            Workspace.handleRemoteException((RemoteException)e1);
        }
        catch (CodegenException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (MdException e1) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
        }
        catch (BadServerDefinitionException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (BadLibraryDefinitionException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (ServerException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        this.m_actRetainedKey.setSelected(this.m_model.isGenerateRetainedKey());
        this.m_actUniqueKey.setSelected(this.m_model.isGenerateUniqueRetainedKey());
        this.updateActions();
        this.setListeningForChanges(true);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
    }

    public void saveSettingsAndCleanUp() {
        this.m_model.getModel().removeModelListener(this.m_modelListener);
        this.m_newRecordTextField.removeFocusListener(this.m_focusListener);
        this.m_changedRecordTextField.removeFocusListener(this.m_focusListener);
        this.m_newRecordTextField.removeActionListener(this.m_actionListener);
        this.m_changedRecordTextField.removeActionListener(this.m_actionListener);
        super.saveSettingsAndCleanUp();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_cbKeyColumn.setEditable(false);
        this.m_newRecordTextField.setEditable(bEditable);
        this.m_changedRecordTextField.setEditable(bEditable);
        this.updateActions();
    }

    protected WsAbstractAction createComboBoxAction() {
        return new cComboBoxAction();
    }

    protected WsAbstractAction createMaxKeyAction() {
        return new cMaxKeyAction();
    }

    protected WsAbstractToggleAction createRetainedKeyAction() {
        return new RetainedKeyAction();
    }

    protected WsAbstractToggleAction createUniqueKeyAction() {
        return new UniqueKeyAction();
    }

    protected WsAbstractAction createNewRecordAction() {
        return new NewRecordAction();
    }

    protected WsAbstractAction createChangedRecordAction() {
        return new ChangedRecordAction();
    }

    protected void updateActions() {
        boolean bEditable = this.isEditable();
        this.m_cbKeyColumn.setEnabled(bEditable);
        this.m_cbRetainedKey.setEnabled(bEditable && this.hasGeneratedKey() && this.m_model.isTrackChangesByDates());
        this.m_actMaxKey.setEnabled(this.hasGeneratedKey());
        this.m_cbRKUnique.setEnabled(bEditable && this.hasGeneratedKey() && this.m_cbRetainedKey.isSelected());
        this.m_newRecordTextField.setEnabled(bEditable && this.hasGeneratedKey());
        this.m_actNewRecord.setEnabled(bEditable);
        this.m_changedRecordTextField.setEnabled(bEditable && this.hasGeneratedKey() && !this.m_cbRetainedKey.isSelected());
        this.m_actChangedRecord.setEnabled(bEditable && this.hasGeneratedKey() && !this.m_cbRetainedKey.isSelected());
    }

    protected boolean hasGeneratedKey() {
        Object object = this.m_cbKeyColumn.getSelectedItem();
        return object instanceof ColumnItem;
    }

    private class TextFieldFocusListener
    implements FocusListener {
        private TextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (event.getComponent() == GeneratedKeyTab.this.m_newRecordTextField) {
                GeneratedKeyTab.this.m_model.setNewRecordGenKeyExpressionText(GeneratedKeyTab.this.m_newRecordTextField.getText());
            } else if (event.getComponent() == GeneratedKeyTab.this.m_changedRecordTextField) {
                GeneratedKeyTab.this.m_model.setChangedRecordGenKeyExpressionText(GeneratedKeyTab.this.m_changedRecordTextField.getText());
            }
        }
    }

    private class TextFieldActionListener
    implements ActionListener {
        private TextFieldActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == GeneratedKeyTab.this.m_newRecordTextField) {
                GeneratedKeyTab.this.m_model.setNewRecordGenKeyExpressionText(GeneratedKeyTab.this.m_newRecordTextField.getText());
            } else if (event.getSource() == GeneratedKeyTab.this.m_changedRecordTextField) {
                GeneratedKeyTab.this.m_model.setChangedRecordGenKeyExpressionText(GeneratedKeyTab.this.m_changedRecordTextField.getText());
            }
        }
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            String type = event.getType();
            IObject object = event.getModelObject();
            if (type == "ModelController:UnknownChanges") {
                GeneratedKeyTab.this.moveDataToView();
                return;
            }
            if (type == "SCDType2TransformModel:GeneratedKeyColumnChanged") {
                if (object != GeneratedKeyTab.this.m_model) {
                    return;
                }
                IColumn maxKeyColumn = (IColumn)event.getData();
                if (maxKeyColumn != null) {
                    GeneratedKeyTab.this.m_cbKeyColumn.setSelectedItem((Object)new ColumnItem(maxKeyColumn));
                } else {
                    GeneratedKeyTab.this.m_cbKeyColumn.setSelectedItem((Object)NONE);
                }
            } else if (type == "SCDType2TransformModel:GenerateRetainedKeyChanged") {
                GeneratedKeyTab.this.m_actRetainedKey.setSelected(GeneratedKeyTab.this.m_model.isGenerateRetainedKey());
            } else if (type == "SCDType2TransformModel:GenerateUniqueRetainedKeyChanged") {
                GeneratedKeyTab.this.m_actUniqueKey.setSelected(GeneratedKeyTab.this.m_model.isGenerateUniqueRetainedKey());
            } else if (type == "SCDType2TransformModel:NewRecGenKeyExpressionChanged") {
                GeneratedKeyTab.this.m_newRecordTextField.setText(GeneratedKeyTab.this.m_model.getNewRecordGenKeyExpressionText());
            } else if (type == "SCDType2TransformModel:ChgRecGenKeyExpressionChanged") {
                GeneratedKeyTab.this.m_changedRecordTextField.setText(GeneratedKeyTab.this.m_model.getChangedRecordGenKeyExpressionText());
            } else if (type == "TextExpression:TextChanged") {
                if (object == GeneratedKeyTab.this.m_model.getNewRecordGenKeyExpression()) {
                    GeneratedKeyTab.this.m_newRecordTextField.setText(GeneratedKeyTab.this.m_model.getNewRecordGenKeyExpressionText());
                } else if (object == GeneratedKeyTab.this.m_model.getChangedRecordGenKeyExpression()) {
                    GeneratedKeyTab.this.m_changedRecordTextField.setText(GeneratedKeyTab.this.m_model.getChangedRecordGenKeyExpressionText());
                }
            }
            GeneratedKeyTab.this.updateActions();
        }
    }

    private class ColumnItem {
        private IColumn m_column;
        private String m_name;

        public ColumnItem(IColumn column) {
            this.m_column = column;
            this.m_name = this.m_column.getName();
        }

        public IColumn getColumn() {
            return this.m_column;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ColumnItem)) {
                return false;
            }
            ColumnItem item = (ColumnItem)object;
            return this.m_column.equals((Object)item.m_column);
        }

        public int hashcode() {
            return super.hashCode();
        }

        public String toString() {
            return this.m_name;
        }
    }

    protected class cComboBoxAction
    extends WsAbstractAction {
        protected cComboBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!GeneratedKeyTab.this.isListeningForChanges()) {
                return;
            }
            if (GeneratedKeyTab.this.hasGeneratedKey()) {
                ColumnItem item = (ColumnItem)GeneratedKeyTab.this.m_cbKeyColumn.getSelectedItem();
                GeneratedKeyTab.this.m_model.setGenerateKeyColumn(item.getColumn());
                if (GeneratedKeyTab.this.m_hasNoneSelected) {
                    GeneratedKeyTab.this.m_hasNoneSelected = false;
                    GeneratedKeyTab.this.m_newRecordTextField.setText("sum(NewMaxKey, 1)");
                    GeneratedKeyTab.this.m_changedRecordTextField.setText("sum(NewMaxKey, 1)");
                }
            } else {
                GeneratedKeyTab.this.m_model.setGenerateKeyColumn(null);
            }
            GeneratedKeyTab.this.updateActions();
        }
    }

    protected class cMaxKeyAction
    extends WsAbstractAction {
        public cMaxKeyAction() {
            super(bundle, "GeneratedKeyTab.MaxKey", false);
        }

        public void actionPerformed(ActionEvent e) {
            DefineMaxGeneratedKeyPanel keyGenPanel = new DefineMaxGeneratedKeyPanel((ISCDMaximumKeyGeneration)GeneratedKeyTab.this.m_model);
            ModelUIUtilities.showDialog((IObject)GeneratedKeyTab.this.m_model, bundle.getString("GeneratedKeyTab.MaxKeyGenerator.Title.txt"), keyGenPanel);
        }
    }

    protected class RetainedKeyAction
    extends WsAbstractToggleAction {
        public RetainedKeyAction() {
            super(bundle, "GeneratedKeyTab.RetainedKey", 0);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                GeneratedKeyTab.this.m_model.getModel().startCompoundUndoable();
                GeneratedKeyTab.this.m_model.setGenerateRetainedKey(GeneratedKeyTab.this.m_cbRetainedKey.isSelected());
            }
            finally {
                GeneratedKeyTab.this.m_model.getModel().endCompoundUndoable();
            }
        }
    }

    protected class UniqueKeyAction
    extends WsAbstractToggleAction {
        public UniqueKeyAction() {
            super(bundle, "GeneratedKeyTab.RKUniqueBusKey", 0);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                GeneratedKeyTab.this.m_model.getModel().startCompoundUndoable();
                GeneratedKeyTab.this.m_model.setGenerateUniqueRetainedKey(GeneratedKeyTab.this.m_cbRKUnique.isSelected());
            }
            finally {
                GeneratedKeyTab.this.m_model.getModel().endCompoundUndoable();
            }
        }
    }

    private class NewRecordAction
    extends WsAbstractAction {
        public NewRecordAction() {
            this.putValue("Name", bundle.getString("GeneratedKeyTab.Browse.txt"));
        }

        public void actionPerformed(ActionEvent e) {
            String expression = GeneratedKeyTab.this.m_newRecordTextField.getText();
            ExpressionBuilderTab expressionBuilder = new ExpressionBuilderTab(new IColumn[0], new ITable[]{GeneratedKeyTab.this.m_model.getTargetTables()[0]}, false);
            expressionBuilder.setExpression(expression);
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("SelectedColumnPanel.ExpressionBuilder.Title.txt"), true, (WAPanel)expressionBuilder);
            dialog.setResizable(true);
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                GeneratedKeyTab.this.m_model.setNewRecordGenKeyExpressionText(expressionBuilder.getExpression());
            }
            GeneratedKeyTab.this.m_newRecordTextField.setText(expressionBuilder.getExpression());
            GeneratedKeyTab.this.m_newRecordTextField.requestFocus();
        }
    }

    private class ChangedRecordAction
    extends WsAbstractAction {
        public ChangedRecordAction() {
            this.putValue("Name", bundle.getString("GeneratedKeyTab.Browse.txt"));
        }

        public void actionPerformed(ActionEvent e) {
            String expression = GeneratedKeyTab.this.m_changedRecordTextField.getText();
            ExpressionBuilderTab expressionBuilder = new ExpressionBuilderTab(new IColumn[0], new ITable[]{GeneratedKeyTab.this.m_model.getTargetTables()[0]}, false);
            expressionBuilder.setExpression(expression);
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("SelectedColumnPanel.ExpressionBuilder.Title.txt"), true, (WAPanel)expressionBuilder);
            dialog.setResizable(true);
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                GeneratedKeyTab.this.m_model.setChangedRecordGenKeyExpressionText(expressionBuilder.getExpression());
            }
            GeneratedKeyTab.this.m_changedRecordTextField.setText(expressionBuilder.getExpression());
            GeneratedKeyTab.this.m_changedRecordTextField.requestFocus();
        }
    }
}

