/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.scd;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.facttable.FactTableTransformModel;
import com.sas.etl.models.job.transforms.facttable.IFactTableMapping;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class FactTableTabTableModel
extends WsAbstractTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(FactTableTabTableModel.class);
    private static final String DISPLAY_MOVE_ROW_TO_ERROR_TABLE = bundle.getString("FactTableMappingPanel.MoveAct.txt");
    private static final String DISPLAY_ABORT_JOB = bundle.getString("FactTableMappingPanel.AbortAct.txt");
    private static final String DISPLAY_NONE = bundle.getString("FactTableMappingPanel.NoneAct.txt");
    public static final int SOURCE_COLUMN = 0;
    public static final int TARGET_COLUMN = 1;
    public static final int LOOKUP_TABLE = 2;
    public static final int LOOKUP_BK_COLUMN = 3;
    public static final int LOOKUP_GK_COLUMN = 4;
    public static final int ACTION_COLUMN = 5;
    public static final int FACT_MAPPING_COLUMN = 6;
    private static final int VISIBLE_COLUMNS = 6;
    private static final int HIDDEN_COLUMNS = 1;
    private static final int COLUMNNAME_WIDTH = 150;
    private FactTableTransformModel m_xfmFact;
    private IModelListener m_lsrModel;

    public FactTableTabTableModel(FactTableTransformModel factTransform) {
        if (factTransform == null) {
            throw new IllegalArgumentException("Fact Table tab cannot be created for a null transform");
        }
        this.m_xfmFact = factTransform;
        this.m_lsrModel = new ModelListener();
        this.m_xfmFact.getModel().addModelListener(this.m_lsrModel);
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumns()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("FactTableModel.SrcColumn.name.txt"), 150);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("FactTableModel.TgtColumn.name.txt"), 150);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("FactTableModel.DimTable.name.txt"), 150);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("FactTableModel.BKColumn.name.txt"), 150);
        this.m_aColumns[3].setEditable(false);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("FactTableModel.GKColumn.name.txt"), 150);
        this.m_aColumns[4].setEditable(false);
        this.m_aColumns[5] = new WsStringTableColumn(5, bundle.getString("FactTableModel.Action.name.txt"), 150);
        this.m_aColumns[5].setEditable(false);
        this.m_aColumns[6] = new WsMetadataTableColumn();
    }

    public int getColumnCount() {
        return 6;
    }

    public int getHiddenColumns() {
        return 1;
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.clear();
        IFactTableMapping[] aFactMappings = this.m_xfmFact.getFactTableMappings();
        if (aFactMappings == null) {
            return;
        }
        for (int i = 0; i < aFactMappings.length; ++i) {
            this.addFactMapping(aFactMappings[i]);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void dispose() {
        this.m_xfmFact.getModel().removeModelListener(this.m_lsrModel);
    }

    private void addFactMapping(IFactTableMapping factMapping) {
        this.insertRow(this.getRowCount() - 1, this.getRowValues(factMapping));
    }

    private void removeFactMapping(IFactTableMapping factMapping) {
        this.deleteRow(this.getRowIndex(factMapping));
    }

    private List getRowValues(IFactTableMapping factMapping) {
        ArrayList<String> lValues = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumns());
        String sUnavailableAction = factMapping.getAction();
        String sUnavailableActionDisplay = "Abort job".equals(sUnavailableAction) ? DISPLAY_ABORT_JOB : ("None".equals(sUnavailableAction) ? DISPLAY_NONE : DISPLAY_MOVE_ROW_TO_ERROR_TABLE);
        lValues.add(factMapping.getSourceColumn().getName());
        lValues.add(factMapping.getTargetColumn().getName());
        IColumn translationSourceColumn = factMapping.getTranslationSourceColumn();
        IColumn translationTargetColumn = factMapping.getTranslationTargetColumn();
        if (translationSourceColumn != null && translationTargetColumn != null) {
            ITable table = translationSourceColumn.getTable();
            if (table != null) {
                lValues.add(table.getName());
            } else {
                lValues.add(bundle.getString("FactTableTabTableModel.Missing.txt"));
            }
            lValues.add(factMapping.getTranslationSourceColumn().getName());
            lValues.add(factMapping.getTranslationTargetColumn().getName());
        } else {
            lValues.add(bundle.getString("FactTableTabTableModel.Missing.txt"));
            lValues.add(bundle.getString("FactTableTabTableModel.Missing.txt"));
            lValues.add(bundle.getString("FactTableTabTableModel.Missing.txt"));
        }
        lValues.add(sUnavailableActionDisplay);
        lValues.add((String)factMapping);
        return lValues;
    }

    public int getRowIndex(IFactTableMapping factMapping) {
        for (int i = 0; i < this.m_lData.size(); ++i) {
            List lValues = (List)this.m_lData.get(i);
            if (!factMapping.equals(lValues.get(6))) continue;
            return i;
        }
        return -1;
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent e) {
            IFactTableMapping factMapping;
            int rowIndex;
            IObject obj = e.getModelObject();
            String sType = e.getType();
            if (FactTableTabTableModel.this.m_xfmFact.equals((Object)obj)) {
                Object removedObject;
                if ("MappingsContainer:MappingAdded".equals(sType)) {
                    Object addedObject = e.getData();
                    if (addedObject instanceof IFactTableMapping) {
                        FactTableTabTableModel.this.addFactMapping((IFactTableMapping)addedObject);
                    }
                } else if ("MappingsContainer:MappingRemoved".equals(sType) && (removedObject = e.getData()) instanceof IFactTableMapping) {
                    FactTableTabTableModel.this.removeFactMapping((IFactTableMapping)removedObject);
                }
            } else if (obj instanceof IFactTableMapping && ("Mapping:SourceColumnAdded".equals(sType) || "Mapping:TargetColumnAdded".equals(sType) || "IFactTableMapping:ActionChanged".equals(sType) || "IFactTableMapping:TranslationMappingChanged".equals(sType)) && (rowIndex = FactTableTabTableModel.this.getRowIndex(factMapping = (IFactTableMapping)obj)) > -1) {
                FactTableTabTableModel.this.setRowValues(rowIndex, FactTableTabTableModel.this.getRowValues(factMapping));
            }
        }
    }
}

