/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.impl.BasePhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.queues.impl.CommonQueueTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.rio.MVAResultSet;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.visuals.common.CodeGenerationEnvironmentFactory;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class QueueMessageOptionsTab2
extends WAPropertyTab {
    private static WAdminResource m_bundle = WAdminResource.getBundle(QueueMessageOptionsTab2.class);
    private WAPanel m_pnlMessagePanel;
    private CommonQueueTransformModel m_queueModel;
    private JRadioButton m_rbText;
    private JRadioButton m_rbTable;
    private JRadioButton m_rbFile;
    private WATextField m_wtfText;
    private WATextField m_wtfMacroName;
    private WATextField m_wtfFile;
    private WAIntTextField m_itfMessageLength;
    private JLabel m_lblMsgLength;
    private WsAppServer m_defaultAppserver;
    private JButton m_btnBrowseFile;
    private JButton m_btnAdvanced;
    private WsAbstractAction m_actBrowseFile;
    private WsAbstractAction m_actAdvanced;
    private static final String RB_FILE = "r2win";
    private static final String RB_TABLE = "r2mvs";
    private static final String RB_TEXT = "r2unx";
    private static final String RADIO_BUTTON_KEY = "QueueMessageOptionsTab.RadioButton_KEY";
    private IModelListener m_lsnrModel;

    public QueueMessageOptionsTab2(CommonQueueTransformModel model) {
        this.m_queueModel = model;
        this.m_lsnrModel = new ModelListener();
        model.getModel().addModelListener(this.m_lsnrModel);
        this.setName(m_bundle.getString("QueueWriterTransformationStepView.MessageOptions.Title.txt"));
        this.setHelpTopic("queue_options_tab");
        this.initialize();
    }

    protected void initialize() {
        WAPanel mainPanel = new WAPanel();
        mainPanel.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlMessagePanel = new WAPanel();
        this.m_pnlMessagePanel.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlMessagePanel.setBorder((Border)WsUIUtilities.createTitledBorder((String)m_bundle.getString("QueueMessageOptionsTab.Messagepanel.Title.txt")));
        if (!this.m_queueModel.isReader()) {
            this.m_rbText = WsUIUtilities.createRadioButton((WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.TextToQueue");
            this.m_rbTable = WsUIUtilities.createRadioButton((WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.TableToQueue");
            this.m_rbFile = WsUIUtilities.createRadioButton((WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.FileToQueue");
        } else {
            this.m_rbText = WsUIUtilities.createRadioButton((WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.TextFromQueue");
            this.m_rbTable = WsUIUtilities.createRadioButton((WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.TableFromQueue");
            this.m_rbFile = WsUIUtilities.createRadioButton((WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.FileFromQueue");
        }
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.m_rbText);
        grp.add(this.m_rbTable);
        grp.add(this.m_rbFile);
        cItemListener itemListener = new cItemListener();
        this.m_rbText.addItemListener(itemListener);
        this.m_rbTable.addItemListener(itemListener);
        this.m_rbFile.addItemListener(itemListener);
        cFocusListener focusListener = new cFocusListener();
        if (!this.m_queueModel.isReader()) {
            this.m_wtfText = new WATextField();
            this.m_wtfText.setMaxCharacters(Short.MAX_VALUE);
            this.m_wtfText.addFocusListener((FocusListener)focusListener);
        } else {
            this.m_wtfMacroName = new WATextField();
            this.m_wtfMacroName.setMaxCharacters(32);
            this.m_wtfMacroName.addFocusListener((FocusListener)focusListener);
        }
        this.m_actBrowseFile = new cFileBrowseAction();
        this.m_actAdvanced = new cAdvanced();
        this.m_btnBrowseFile = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actBrowseFile);
        this.m_btnAdvanced = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAdvanced);
        this.m_wtfFile = new WATextField();
        this.m_wtfFile.setMaxCharacters(255);
        this.m_wtfFile.addFocusListener((FocusListener)focusListener);
        this.m_pnlMessagePanel.add((Component)this.m_rbText, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlMessagePanel.add((Component)this.m_rbTable, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlMessagePanel.add((Component)this.m_rbFile, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (!this.m_queueModel.isReader()) {
            this.m_wtfText.setToolTipText(m_bundle.getString("QueueMessageOptionsTab.TextMessageSend.tip"));
            this.m_pnlMessagePanel.add((Component)this.m_wtfText, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_wtfFile.setToolTipText(m_bundle.getString("QueueMessageOptionsTab.FileNameToQueue.tip"));
        } else {
            this.m_wtfMacroName.setToolTipText(m_bundle.getString("QueueMessageOptionsTab.MacroVariable.ToolTip.txt"));
            this.m_pnlMessagePanel.add((Component)this.m_wtfMacroName, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_wtfFile.setToolTipText(m_bundle.getString("QueueMessageOptionsTab.FileNameFromQueue.tip"));
        }
        this.m_pnlMessagePanel.add((Component)this.m_wtfFile, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlMessagePanel.add((Component)this.m_btnBrowseFile, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_itfMessageLength = new WAIntTextField();
        this.m_itfMessageLength.setText("256");
        this.m_itfMessageLength.addFocusListener((FocusListener)focusListener);
        WATextField temp = new WATextField("1234567890");
        this.m_itfMessageLength.setPreferredSize(temp.getPreferredSize());
        this.m_rbText.setSelected(this.m_queueModel.isTextMessage());
        this.m_rbTable.setSelected(this.m_queueModel.isTableMessage());
        this.m_rbFile.setSelected(this.m_queueModel.isFileMessage());
        this.m_lblMsgLength = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_itfMessageLength, (WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.Label.MessageLength");
        WAPanel panel2 = new WAPanel();
        panel2.setLayout((LayoutManager)new GridBagLayout());
        panel2.add((Component)this.m_lblMsgLength, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel2.add((Component)this.m_itfMessageLength, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel2.add((Component)this.m_btnAdvanced, (Object)new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 12, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.setLayout(new BorderLayout());
        mainPanel.add((Component)this.m_pnlMessagePanel, (Object)new GridBagConstraints(0, 0, 1, 3, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        if (!this.m_queueModel.isReader()) {
            mainPanel.add((Component)panel2, (Object)new GridBagConstraints(0, 3, 1, 2, 0.0, 0.0, 18, 2, new Insets(10, 5, 10, 0), 0, 0));
            mainPanel.add((Component)new WAPanel(), (Object)new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 0, 0), 0, 0));
        } else {
            mainPanel.add((Component)panel2, (Object)new GridBagConstraints(0, 5, 1, 2, 0.0, 0.0, 18, 1, new Insets(10, 5, 10, 0), 0, 0));
            mainPanel.add((Component)new WAPanel(), (Object)new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 0, 0), 0, 0));
        }
        this.add((Component)mainPanel, "Center");
    }

    public void actionPerformed(ActionEvent evt) {
        String text = this.m_wtfText.getText();
        this.m_wtfText.setText(text + "XYZ");
        this.m_wtfText.selectAll();
        this.m_wtfText.setCaretPosition(this.m_wtfText.getDocument().getLength());
    }

    public void populateStore() {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_itfMessageLength.setValue(this.m_queueModel.getMessageLength());
        this.m_rbText.setSelected(this.m_queueModel.isTextMessage());
        this.m_rbTable.setSelected(this.m_queueModel.isTableMessage());
        this.m_rbFile.setSelected(this.m_queueModel.isFileMessage());
        this.m_wtfFile.setText(this.m_queueModel.getFileName());
        if (!this.m_queueModel.isReader()) {
            this.m_wtfText.setText(this.m_queueModel.getTextContent());
        } else {
            this.m_wtfMacroName.setText(this.m_queueModel.getMacroVariable());
        }
        if (this.m_queueModel.isReader() && this.m_wtfMacroName.getText().length() == 0) {
            this.m_wtfMacroName.setText("etls_qms");
        }
        if (this.m_itfMessageLength.getValue() == 0) {
            this.m_itfMessageLength.setValue(256);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_queueModel.setMessageLength(this.m_itfMessageLength.getValue());
        if (this.m_rbText.isSelected()) {
            this.m_queueModel.setQueueTypeAsText();
        } else if (this.m_rbTable.isSelected()) {
            this.m_queueModel.setQueueTypeAsTable();
        } else if (this.m_rbFile.isSelected()) {
            this.m_queueModel.setQueueTypeAsFile();
        }
        this.m_queueModel.setFileName(this.m_wtfFile.getText());
        if (!this.m_queueModel.isReader()) {
            this.m_queueModel.setTextContent(this.m_wtfText.getText());
        } else {
            this.m_queueModel.setMacroVariable(this.m_wtfMacroName.getText());
        }
    }

    public void setRadioButtonSelection() {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        String sSelection = appDefaults.getPropertyString(RADIO_BUTTON_KEY, "");
        if (sSelection.length() == 0 || sSelection.compareTo(RB_FILE) == 0) {
            this.m_rbFile.setSelected(true);
        } else if (sSelection.compareTo(RB_TABLE) == 0) {
            this.m_rbTable.setSelected(true);
        } else if (sSelection.compareTo(RB_TEXT) == 0) {
            this.m_rbText.setSelected(true);
        }
    }

    public boolean validateData() {
        String msgString;
        int iValue;
        int iValue2;
        if (this.m_itfMessageLength.getText().length() > 0) {
            if (this.m_itfMessageLength.getValue() > Short.MAX_VALUE) {
                MessageUtil.displayMessage((String)m_bundle.getString("QueueMessageOptions.Exceeds32767.txt"), (int)0);
                this.m_itfMessageLength.requestFocus();
                return false;
            }
            if (this.m_itfMessageLength.getValue() == 0) {
                MessageUtil.displayMessage((String)m_bundle.getString("QueueMessageOptions.Equals0.txt"), (int)0);
                this.m_itfMessageLength.requestFocus();
                return false;
            }
        }
        if (this.m_rbFile.isSelected() && this.m_wtfFile.getText().length() == 0 && (iValue2 = MessageUtil.displayMessage((String)m_bundle.getString("QueueMessageOptions.FilenameBlank.txt"), (String)m_bundle.getString("QueueMessageOptions.FilenameBlank.Title.txt"), (int)2, (int)0)) == 0) {
            this.m_wtfFile.requestFocus();
            return false;
        }
        if (this.m_wtfText != null && this.m_rbText.isSelected() && this.m_wtfText.getText().length() == 0 && (iValue2 = MessageUtil.displayMessage((String)m_bundle.getString("QueueMessageOptions.MessageBlank.txt"), (String)m_bundle.getString("QueueMessageOptions.MessageNotSpecified.Title.txt"), (int)2, (int)0)) == 0) {
            this.m_wtfText.requestFocus();
            return false;
        }
        if (this.m_wtfText != null && this.m_rbText.isSelected() && this.m_wtfText.getText().length() > this.m_itfMessageLength.getValue() && (iValue = MessageUtil.displayMessage((String)(msgString = m_bundle.formatString("QueueMessageOptions.InsuffLength.fmt.txt", (Object)Integer.toString(this.m_itfMessageLength.getValue()), (Object)Integer.toString(this.m_wtfText.getText().length()))), (String)m_bundle.getString("QueueMessageOptions.InsufficientLength.Title.txt"), (int)2, (int)0)) == 0) {
            this.m_itfMessageLength.setText(Integer.toString(this.m_wtfText.getText().length()));
            this.m_itfMessageLength.requestFocus();
            return false;
        }
        if (this.m_wtfMacroName != null && this.m_rbText.isSelected() && this.m_wtfMacroName.getText().length() == 0) {
            MessageUtil.displayMessage((String)m_bundle.getString("QueueMessageOptions.MacroVariableBlank.txt"), (String)m_bundle.getString("QueueMessageOptions.MacroVariableBlank.Title.txt"), (int)0);
            this.m_wtfMacroName.requestFocus();
            return false;
        }
        return true;
    }

    protected void showSASLogDialog(String sMessage, WsAppServer wsAppServer) {
        int choice = MessageUtil.displayMessage((String)sMessage, (int)0, (int)0);
        if (choice == 0) {
            String sTitle = m_bundle.getString("QueueMessageOptionsTab.Title.Log.txt");
            SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), sTitle, true, wsAppServer);
            dlg.show();
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        if (this.m_pnlMessagePanel != null) {
            this.m_pnlMessagePanel.setEditable(bEditable);
        }
        if (this.m_wtfText != null) {
            this.m_wtfText.setEditable(bEditable);
        }
        if (this.m_wtfMacroName != null) {
            this.m_wtfMacroName.setEditable(bEditable);
        }
        if (this.m_wtfFile != null) {
            this.m_wtfFile.setEditable(bEditable);
        }
        if (this.m_itfMessageLength != null) {
            this.m_itfMessageLength.setEditable(bEditable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMessagePropertiesForTableColumns(IPhysicalTable oTable) throws BadServerDefinitionException, BadLibraryDefinitionException {
        IServer server;
        List lQueueFormats;
        block31: {
            if (this.m_queueModel.hasAllQueueColumnFormats((ITable)oTable)) {
                return;
            }
            lQueueFormats = null;
            IModel model = this.m_queueModel.getModel();
            String serverID = WsAppServer.getDefaultAppServerFQID();
            if (serverID == null || serverID.length() == 0) {
                MessageUtil.displayMessage((String)"No default app server.  Please set default appserver", (int)0);
                return;
            }
            server = (IServer)model.getObject(serverID);
            try {
                if (server != null) break block31;
                server = model.getObjectFactory().createServer(serverID);
                OMRAdapter omr = new OMRAdapter(model, Workspace.getMdFactory(), "acquireServer");
                model.setUndoSupported(false);
                try {
                    omr.populateFor((IOMRPersistable)server);
                    server.loadFromOMR(omr);
                }
                catch (MdException mdException) {
                }
                finally {
                    model.setUndoSupported(true);
                    omr.dispose();
                }
            }
            catch (RemoteException omr) {
                // empty catch block
            }
        }
        if (this.getWsAppServer() == null || oTable.isQuoted()) {
            try {
                lQueueFormats = this.getColumnWidths((ITable)oTable);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        } else {
            try {
                lQueueFormats = this.getColumnWidths(oTable, server);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (SQLException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (WsAppServerCodeException e) {
                this.showSASLogDialog(m_bundle.getString("QueueMessageOptionsTab.Error.SASCode.txt"), this.getWsAppServer());
            }
            catch (WsAppServerFailException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (WsAppServerLibraryException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (GenericError e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (CodegenException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (ServerException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }
        if (lQueueFormats == null) {
            try {
                lQueueFormats = this.getColumnWidths((ITable)oTable);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        IColumn[] aIColumn = null;
        aIColumn = oTable.getColumns();
        for (int iColumn = 0; iColumn < aIColumn.length; ++iColumn) {
            IColumn oIColumn = aIColumn[iColumn];
            if (this.m_queueModel.hasColumnFormats(oIColumn)) continue;
            ArrayList list = null;
            for (int iQCols = 0; iQCols < lQueueFormats.size(); ++iQCols) {
                list = (ArrayList)lQueueFormats.get(iQCols);
                if (oIColumn.getColumnName(false).compareToIgnoreCase((String)list.get(0)) == 0) break;
            }
            if (oIColumn == null) {
                return;
            }
            String sWidth = (String)list.get(1);
            StringBuffer sb = new StringBuffer();
            sb.append("CHAR");
            sb.append(",,");
            sb.append(sWidth);
            this.m_queueModel.addColumnFormats(oIColumn, "CHAR", sWidth, sb.toString());
        }
    }

    public List getColumnWidths(ITable oTable) throws MdException, RemoteException {
        ArrayList alColumnWidths = new ArrayList(50);
        IColumn[] aIColumns = oTable.getColumns();
        for (int colNum = 0; colNum < aIColumns.length; ++colNum) {
            ArrayList<String> alRow = new ArrayList<String>(2);
            IColumn oColumn = aIColumns[colNum];
            alRow.add(oColumn.getColumnName(false));
            int sasColumnLength = oColumn.getLength();
            alRow.add(Integer.toString(sasColumnLength));
            alColumnWidths.add(alRow);
        }
        return alColumnWidths;
    }

    public List getColumnWidths(IPhysicalTable oITable, IServer server) throws MdException, RemoteException, SQLException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException, GenericError, BadServerDefinitionException, BadLibraryDefinitionException, ServerException, CodegenException {
        StringBuffer sbSource = new StringBuffer(300);
        CodeGenerationEnvironmentFactory factory = CodeGenerationEnvironmentFactory.getInstance();
        WsAppServer wsAppServer = this.getWsAppServer();
        ICodeGenerationEnvironment codeGenerationEnvironment = factory.createCodeGenerationEnvironment(this.m_queueModel.getJob(), server);
        String tableName = oITable.getFullNameQuotedAsNeeded(server, oITable.isQuoted(), false);
        wsAppServer.submitSASCode(oITable.getAccessPath(codeGenerationEnvironment, false, null).toString());
        if (wsAppServer.doesTableExist(oITable.getLibref(server), oITable.getSASTableName(), oITable.isQuoted())) {
            if (oITable.isSpecialCharacters()) {
                sbSource.append("option VALIDVARNAME = ANY VALIDMEMNAME = EXTEND;\n\n");
            }
            sbSource.append("%let dsn=");
            sbSource.append(tableName);
            sbSource.append(";\n\n");
            sbSource.append("proc contents data=&dsn out=etls_cols(keep=name);\n");
            sbSource.append("run;\n\n");
            sbSource.append("data _null_;\n");
            sbSource.append("set etls_cols end=eof;\n");
            sbSource.append("if _n_=1 then call execute('data etls_fmtwidths;set &dsn;length name $32;keep name width;');\n");
            sbSource.append("call execute('name=\"'||trim(name)||'\";'); \n");
            sbSource.append("call execute('width=vformatw('||trim(name)||');');\n");
            sbSource.append("call execute('output;'); \n");
            sbSource.append("if eof then call execute('stop;run;');\n");
            sbSource.append("run;\n");
            sbSource.append(this.genTableDelete("work", "etls_cols"));
            Workspace.getDefaultLogger().debug((Object)sbSource.toString());
            wsAppServer.submitSASCode(sbSource.toString());
            ArrayList alColumnWidths = (ArrayList)this.readColumnWidthsFromDataset("etls_fmtwidths", wsAppServer);
            wsAppServer.closeSQLConnection();
            wsAppServer.submitSASCode(this.genTableDelete("work", "etls_fmtwidths"));
            if (alColumnWidths.isEmpty()) {
                return this.getColumnWidths((ITable)oITable);
            }
            return alColumnWidths;
        }
        return this.getColumnWidths((ITable)oITable);
    }

    protected static String getLibRef(ITable oTable, WsAppServer wsAppServer) throws MdException, RemoteException {
        ILibrary library = QueueMessageOptionsTab2.getLibrary(oTable, wsAppServer);
        if (library != null) {
            return library.getLibref();
        }
        return null;
    }

    public static ILibrary getLibrary(ITable oTable, WsAppServer wsAppServer) throws MdException, RemoteException {
        BasePhysicalTable oBasePhysicaltable = (BasePhysicalTable)oTable;
        ILibrary oILibrary = oBasePhysicaltable.getLibrary();
        return oILibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IServer acquireModelForSASAppServer(IObject table) {
        String sID;
        IModel model = table.getModel();
        IServer server = (IServer)model.getObject(sID = this.getWsAppServer().getServerFQID());
        if (server != null) {
            return server;
        }
        try {
            server = model.getObjectFactory().createServer(sID);
            OMRAdapter omr = new OMRAdapter(model, Workspace.getMdFactory(), "acquireServer");
            model.setUndoSupported(false);
            try {
                omr.populateFor((IOMRPersistable)server);
                server.loadFromOMR(omr);
                IServer iServer = server;
                return iServer;
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                return null;
            }
            finally {
                model.setUndoSupported(true);
                omr.dispose();
                if (this.getWsAppServer() != null) {
                    this.getWsAppServer().dispose();
                }
            }
        }
        catch (RemoteException ex2) {
            Workspace.handleRemoteException((RemoteException)ex2);
        }
        return null;
    }

    public WsAppServer getWsAppServer() {
        if (this.m_defaultAppserver != null) {
            return this.m_defaultAppserver;
        }
        this.m_defaultAppserver = WsAppServer.createDefaultAppServer((boolean)true);
        if (this.m_defaultAppserver == null) {
            return null;
        }
        try {
            this.m_defaultAppserver.open();
        }
        catch (WsAppServerFailException failException) {
            return null;
        }
        return this.m_defaultAppserver;
    }

    private void cleanUp() {
        if (this.m_defaultAppserver != null) {
            this.m_defaultAppserver.close();
            this.m_defaultAppserver.dispose();
            this.m_defaultAppserver = null;
        }
    }

    private List readColumnWidthsFromDataset(String tabName, WsAppServer wsAppServer) throws SQLException, WsAppServerFailException {
        ResultSetMetaData m_metadata = null;
        int colCount = 0;
        ArrayList alColumns = new ArrayList(50);
        String submitStmt = "select * from " + tabName;
        MVAResultSet rsltSet = wsAppServer.submitSQLStatement(submitStmt);
        if (m_metadata == null) {
            m_metadata = rsltSet.getMetaData();
            colCount = m_metadata.getColumnCount();
        }
        while (rsltSet.next()) {
            ArrayList<String> alRow = new ArrayList<String>(colCount);
            for (int i = 1; i <= colCount; ++i) {
                String value = rsltSet.getString(i).trim();
                alRow.add(value);
            }
            alColumns.add(alRow);
        }
        try {
            rsltSet.close();
        }
        catch (SQLException se) {
            MessageUtil.displayMessage((String)se.getLocalizedMessage());
        }
        return alColumns;
    }

    public String genTableDelete(String lib, String tableName) {
        StringBuffer sbDeleteSyntax = new StringBuffer(200);
        sbDeleteSyntax.append("proc datasets lib = ");
        sbDeleteSyntax.append(lib);
        sbDeleteSyntax.append(" nolist nowarn memtype = (data view);\n");
        sbDeleteSyntax.append("   delete ");
        sbDeleteSyntax.append(tableName);
        sbDeleteSyntax.append(";\n");
        sbDeleteSyntax.append("quit;\n\n");
        return sbDeleteSyntax.toString();
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType.compareToIgnoreCase("QueueTransformModel:QueueTypeChanged") == 0) {
                String sQueueType = QueueMessageOptionsTab2.this.m_queueModel.getQueueType();
                if (sQueueType.compareTo("TEXT") == 0) {
                    if (!QueueMessageOptionsTab2.this.m_rbText.isSelected()) {
                        QueueMessageOptionsTab2.this.m_rbText.setSelected(true);
                    }
                } else if (sQueueType.compareTo("TABLE") == 0) {
                    if (!QueueMessageOptionsTab2.this.m_rbTable.isSelected()) {
                        QueueMessageOptionsTab2.this.m_rbTable.setSelected(true);
                    }
                } else if (sQueueType.compareTo("FILE") == 0 && !QueueMessageOptionsTab2.this.m_rbFile.isSelected()) {
                    QueueMessageOptionsTab2.this.m_rbFile.setSelected(true);
                }
            } else if (sType.compareToIgnoreCase("QueueTransformModel:MessageLengthChanged") == 0) {
                QueueMessageOptionsTab2.this.m_itfMessageLength.setValue(QueueMessageOptionsTab2.this.m_queueModel.getMessageLength());
            } else if (sType.compareToIgnoreCase("QueueTransformModel:StoredTextChanged") == 0) {
                if (QueueMessageOptionsTab2.this.m_queueModel.isWriter()) {
                    QueueMessageOptionsTab2.this.m_wtfText.setText(QueueMessageOptionsTab2.this.m_queueModel.getTextContent());
                }
            } else if (sType.compareToIgnoreCase("QueueTransformModel:FileNameChanged") == 0) {
                QueueMessageOptionsTab2.this.m_wtfFile.setText(QueueMessageOptionsTab2.this.m_queueModel.getFileName());
            } else if (sType.compareToIgnoreCase("QueueTransformModel:MacroVariableChanged") == 0 && QueueMessageOptionsTab2.this.m_queueModel.isReader()) {
                QueueMessageOptionsTab2.this.m_wtfMacroName.setText(QueueMessageOptionsTab2.this.m_queueModel.getMacroVariable());
            }
        }
    }

    private class cItemListener
    implements ItemListener {
        private cItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JRadioButton rbn = (JRadioButton)e.getSource();
            boolean bSelected = rbn.isSelected();
            IPhysicalTable sourceOrTargetTable = QueueMessageOptionsTab2.this.m_queueModel.getConnectedSourceOrTargetTable();
            if (sourceOrTargetTable == null) {
                QueueMessageOptionsTab2.this.m_rbTable.setEnabled(false);
                if (QueueMessageOptionsTab2.this.m_rbTable.isSelected()) {
                    QueueMessageOptionsTab2.this.m_rbText.setSelected(true);
                }
            } else {
                QueueMessageOptionsTab2.this.m_rbTable.setEnabled(true);
            }
            if (rbn == QueueMessageOptionsTab2.this.m_rbTable && rbn.isSelected()) {
                if (QueueMessageOptionsTab2.this.m_itfMessageLength != null) {
                    QueueMessageOptionsTab2.this.m_itfMessageLength.setEnabled(false);
                }
            } else if (QueueMessageOptionsTab2.this.m_itfMessageLength != null) {
                QueueMessageOptionsTab2.this.m_itfMessageLength.setEnabled(true);
            }
            if (rbn == QueueMessageOptionsTab2.this.m_rbText && rbn.isSelected()) {
                if (!QueueMessageOptionsTab2.this.m_queueModel.isTextMessage()) {
                    QueueMessageOptionsTab2.this.m_queueModel.setQueueTypeAsText();
                }
                if (!QueueMessageOptionsTab2.this.m_queueModel.isReader()) {
                    QueueMessageOptionsTab2.this.m_wtfText.setEnabled(bSelected);
                } else {
                    QueueMessageOptionsTab2.this.m_wtfMacroName.setEnabled(bSelected);
                }
                if (QueueMessageOptionsTab2.this.m_itfMessageLength != null) {
                    QueueMessageOptionsTab2.this.m_itfMessageLength.setEnabled(true);
                }
            } else if (rbn == QueueMessageOptionsTab2.this.m_rbTable && rbn.isSelected()) {
                if (!QueueMessageOptionsTab2.this.m_queueModel.isTableMessage()) {
                    QueueMessageOptionsTab2.this.m_queueModel.setQueueTypeAsTable();
                }
                if (sourceOrTargetTable != null) {
                    try {
                        QueueMessageOptionsTab2.this.createMessagePropertiesForTableColumns(sourceOrTargetTable);
                    }
                    catch (BadServerDefinitionException e1) {
                        MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                        e1.printStackTrace();
                    }
                    catch (BadLibraryDefinitionException e1) {
                        MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                        e1.printStackTrace();
                    }
                }
            } else if (rbn == QueueMessageOptionsTab2.this.m_rbFile && rbn.isSelected()) {
                if (!QueueMessageOptionsTab2.this.m_queueModel.isFileMessage()) {
                    QueueMessageOptionsTab2.this.m_queueModel.setQueueTypeAsFile();
                }
                QueueMessageOptionsTab2.this.m_wtfFile.setEnabled(bSelected);
                QueueMessageOptionsTab2.this.m_btnBrowseFile.setEnabled(bSelected);
                if (sourceOrTargetTable != null && QueueMessageOptionsTab2.this.m_wtfFile.getText().trim().length() < 1) {
                    QueueMessageOptionsTab2.this.m_wtfFile.setText(QueueMessageOptionsTab2.this.m_queueModel.getFileCorrespondingToTable(sourceOrTargetTable));
                }
            }
        }
    }

    private class cFocusListener
    implements FocusListener {
        private cFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            if (arg0.getComponent() == QueueMessageOptionsTab2.this.m_wtfText) {
                QueueMessageOptionsTab2.this.m_queueModel.setTextContent(QueueMessageOptionsTab2.this.m_wtfText.getText());
            } else if (arg0.getComponent() == QueueMessageOptionsTab2.this.m_itfMessageLength) {
                QueueMessageOptionsTab2.this.m_queueModel.setMessageLength(QueueMessageOptionsTab2.this.m_itfMessageLength.getValue());
            } else if (arg0.getComponent() == QueueMessageOptionsTab2.this.m_wtfFile) {
                QueueMessageOptionsTab2.this.m_queueModel.setFileName(QueueMessageOptionsTab2.this.m_wtfFile.getText());
            } else if (arg0.getComponent() == QueueMessageOptionsTab2.this.m_wtfMacroName) {
                QueueMessageOptionsTab2.this.m_queueModel.setMacroVariable(QueueMessageOptionsTab2.this.m_wtfMacroName.getText());
            }
        }
    }

    private class cFileBrowseAction
    extends WsAbstractAction {
        public cFileBrowseAction() {
            super(m_bundle, "QueueMessageOptionsTab.Action.FileBrowse", false, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                QueueMessageOptionsTab2.this.setCursor(Cursor.getPredefinedCursor(3));
                WsAppServer m_wsAppServer = WsAppServer.createDefaultAppServer();
                if (m_wsAppServer.getOperatingSystem().equalsIgnoreCase("OS")) {
                    MessageUtil.displayMessage((String)m_bundle.getString("QueueMessageOptionsTab.Error.UnableToBrowse.txt"), (int)0);
                    return;
                }
                LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
                mapFileTypes.put(m_bundle.getString("QueueMessageOptionsTab.AllFileTypes.txt"), "*");
                String sSelectedFile = m_wsAppServer.promptForFilename(m_bundle.getString("QueueMessageOptionsTab.RemoteFileSelector.Title.txt"), "", mapFileTypes);
                if (sSelectedFile != null && sSelectedFile.length() > 0) {
                    QueueMessageOptionsTab2.this.m_wtfFile.setText(sSelectedFile);
                }
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
            catch (WsAppServerFailException wsfe) {
                MessageUtil.displayMessage((String)wsfe.getLocalizedMessage(), (int)0);
            }
            finally {
                QueueMessageOptionsTab2.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private class cAdvanced
    extends WsAbstractAction {
        public cAdvanced() {
            super(m_bundle, "QueueMessageOptionsTab.Action.Advanced", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            String sAdvancedSettingsTitle = m_bundle.getString("QueueMessageOptionsTab.AdvancedSettings.Title.txt");
            boolean bWebSphere = !QueueMessageOptionsTab2.this.m_queueModel.getMQSystem().equals("MSMQ");
            boolean bWriter = !QueueMessageOptionsTab2.this.m_queueModel.isReader();
            String sHelpTopic = "";
            if (bWebSphere && bWriter) {
                sHelpTopic = "advanced_wswrite";
            } else if (bWebSphere && !bWriter) {
                sHelpTopic = "advanced_wsread";
            } else if (!bWebSphere && bWriter) {
                sHelpTopic = "advanced_mqwrite";
            } else if (!bWebSphere && !bWriter) {
                sHelpTopic = "advanced_mqread";
            }
            try {
                OptionsTab tab = new OptionsTab(QueueMessageOptionsTab2.this.m_queueModel.getMessageOptionModel(), sHelpTopic, true);
                tab.setPreferredSize(new Dimension(400, 500));
                cAdvancedOptions dlg = new cAdvancedOptions((Frame)Workspace.getWorkspace(), sAdvancedSettingsTitle, true, (WAPanel)tab);
                dlg.setResizable(true);
                dlg.setHelpProduct("wdb");
                if (QueueMessageOptionsTab2.this.m_pnlMessagePanel != null) {
                    dlg.setEditable(QueueMessageOptionsTab2.this.m_pnlMessagePanel.isEditable());
                }
                dlg.show();
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
            }
            catch (ServiceException e1) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)e1);
            }
            catch (ServerConnectionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage());
            }
            catch (FileNotFoundException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage());
            }
            catch (MdException e1) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
            }
            catch (ParserConfigurationException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage());
            }
            catch (SAXException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage());
            }
            catch (IOException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage());
            }
        }
    }

    private class cAdvancedOptions
    extends WAStandardDialog {
        public cAdvancedOptions(Frame frmOwner, String sTitle, boolean bModal, WAPanel pnlMain) {
            super(frmOwner, sTitle, bModal, pnlMain);
        }

        protected boolean validateData() {
            if (!super.validateData()) {
                return false;
            }
            QueueMessageOptionsTab2.this.m_queueModel.loadOptions();
            HashMap hashmap = QueueMessageOptionsTab2.this.m_queueModel.getOptions();
            String sCorrelidHex = "";
            if (hashmap.containsKey("CORRELID")) {
                sCorrelidHex = (String)hashmap.get("CORRELID");
            }
            String sCorrelidChar = "";
            if (hashmap.containsKey("CORRELID_CHAR")) {
                sCorrelidChar = (String)hashmap.get("CORRELID_CHAR");
            }
            String sComputedCorrelidHex = null;
            if (sCorrelidChar.length() > 0) {
                QueueMessageOptionsTab2.this.m_queueModel;
                sComputedCorrelidHex = CommonQueueTransformModel.toHexString((String)sCorrelidChar);
            }
            if (sComputedCorrelidHex != null) {
                String msgString;
                int iValue;
                if (sCorrelidHex.length() == 0) {
                    this.setCorrelidHex(sComputedCorrelidHex);
                } else if (sCorrelidHex.compareTo(sComputedCorrelidHex) != 0 && (iValue = MessageUtil.displayMessage((String)(msgString = m_bundle.messageString("QueueMacroUserOptionsPanel.CORRELID.Mismatch.fmt.txt", (Object)sCorrelidHex, (Object)sComputedCorrelidHex, (Object)sCorrelidChar)), (String)m_bundle.getString("QueueMacroUserOptionsPanel.CORRELID.Mismatch.title.txt"), (int)2, (int)0)) == 0) {
                    this.setCorrelidHex(sComputedCorrelidHex);
                }
            }
            return true;
        }

        public String getCorrelidHex() throws RemoteException, ServiceException, ServerConnectionException, FileNotFoundException, MdException, ParserConfigurationException, SAXException, IOException {
            String sCorrelID = "";
            IPromptDefinitionValue[] promptDefinitions = QueueMessageOptionsTab2.this.m_queueModel.getPromptDefinitionValues();
            for (int i = 0; i < promptDefinitions.length; ++i) {
                IPromptDefinitionValue promptDefinitionValue = promptDefinitions[i];
                if (promptDefinitionValue.getName().compareToIgnoreCase("CORRELID") != 0) continue;
                return (String)promptDefinitions[i].getValue();
            }
            return sCorrelID;
        }

        public void setCorrelidHex(String sCorrelidHex) {
            try {
                IPromptDefinitionValue[] promptDefinitions = QueueMessageOptionsTab2.this.m_queueModel.getPromptDefinitionValues();
                for (int i = 0; i < promptDefinitions.length; ++i) {
                    IPromptDefinitionValue promptDefinitionValue = promptDefinitions[i];
                    if (promptDefinitionValue.getName().compareToIgnoreCase("CORRELID") != 0) continue;
                    promptDefinitions[i].setValue((Object)sCorrelidHex);
                }
            }
            catch (RemoteException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                e.printStackTrace();
            }
            catch (ServiceException e) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)e);
                e.printStackTrace();
            }
            catch (ServerConnectionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                e.printStackTrace();
            }
            catch (MdException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                e.printStackTrace();
            }
            catch (SAXException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                e.printStackTrace();
            }
            catch (IOException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                e.printStackTrace();
            }
        }
    }
}

