/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.metadata.remote.impl.FileImpl;
import com.sas.rio.MVAResultSet;
import com.sas.wadmin.transforms.queues.QueueModel;
import com.sas.wadmin.transforms.queues.QueueUtil;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public final class QueueMessageOptionsTab
extends WAPropertyTab {
    private static WAdminResource m_bundle = WAdminResource.getBundle(QueueMessageOptionsTab.class);
    private TransformationStep m_mdTS;
    private WAPanel m_pnlMessagePanel;
    private QueueModel m_queueModel;
    private JRadioButton m_rbText;
    private JRadioButton m_rbTable;
    private JRadioButton m_rbFile;
    private WATextField m_wtfText;
    private WATextField m_wtfMacroName;
    private WATextField m_wtfFile;
    private WAIntTextField m_itfMessageLength;
    private JLabel m_lblMsgLength;
    private JButton m_btnBrowseFile;
    private JButton m_btnAdvanced;
    private WsAbstractAction m_actBrowseFile;
    private WsAbstractAction m_actAdvanced;
    private static final String RB_FILE = "r2win";
    private static final String RB_TABLE = "r2mvs";
    private static final String RB_TEXT = "r2unx";
    private static final String RADIO_BUTTON_KEY = "QueueMessageOptionsTab.RadioButton_KEY";

    public QueueMessageOptionsTab(QueueModel model) {
        this.m_queueModel = model;
        this.setHelpTopic("queue_options_tab");
        this.initialize();
    }

    protected void initialize() {
        this.m_mdTS = this.m_queueModel.getStep();
        WAPanel mainPanel = new WAPanel();
        mainPanel.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlMessagePanel = new WAPanel();
        this.m_pnlMessagePanel.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlMessagePanel.setBorder((Border)WsUIUtilities.createTitledBorder((String)m_bundle.getString("QueueMessageOptionsTab.Messagepanel.Title.txt")));
        if (!this.m_queueModel.isReader()) {
            this.m_rbText = WsUIUtilities.createRadioButton((WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.TextToQueue");
            this.m_rbTable = WsUIUtilities.createRadioButton((WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.TableToQueue");
            this.m_rbFile = WsUIUtilities.createRadioButton((WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.FileToQueue");
        } else {
            this.m_rbText = WsUIUtilities.createRadioButton((WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.TextFromQueue");
            this.m_rbTable = WsUIUtilities.createRadioButton((WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.TableFromQueue");
            this.m_rbFile = WsUIUtilities.createRadioButton((WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.FileFromQueue");
        }
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.m_rbText);
        grp.add(this.m_rbTable);
        grp.add(this.m_rbFile);
        cItemListener itemListener = new cItemListener();
        this.m_rbText.addItemListener(itemListener);
        this.m_rbTable.addItemListener(itemListener);
        this.m_rbFile.addItemListener(itemListener);
        if (!this.m_queueModel.isReader()) {
            this.m_wtfText = new WATextField();
            this.m_wtfText.setMaxCharacters(Short.MAX_VALUE);
        } else {
            this.m_wtfMacroName = new WATextField();
            this.m_wtfMacroName.setMaxCharacters(32);
        }
        this.m_actBrowseFile = new cFileBrowseAction();
        this.m_actAdvanced = new cAdvanced();
        this.m_btnBrowseFile = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actBrowseFile);
        this.m_btnAdvanced = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAdvanced);
        this.m_wtfFile = new WATextField();
        this.m_wtfFile.setMaxCharacters(255);
        this.m_pnlMessagePanel.add((Component)this.m_rbText, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlMessagePanel.add((Component)this.m_rbTable, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlMessagePanel.add((Component)this.m_rbFile, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (!this.m_queueModel.isReader()) {
            this.m_wtfText.setToolTipText(m_bundle.getString("QueueMessageOptionsTab.TextMessageSend.tip"));
            this.m_pnlMessagePanel.add((Component)this.m_wtfText, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_wtfFile.setToolTipText(m_bundle.getString("QueueMessageOptionsTab.FileNameToQueue.tip"));
        } else {
            this.m_wtfMacroName.setToolTipText(m_bundle.getString("QueueMessageOptionsTab.MacroVariable.ToolTip.txt"));
            this.m_pnlMessagePanel.add((Component)this.m_wtfMacroName, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_wtfFile.setToolTipText(m_bundle.getString("QueueMessageOptionsTab.FileNameFromQueue.tip"));
        }
        this.m_pnlMessagePanel.add((Component)this.m_wtfFile, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlMessagePanel.add((Component)this.m_btnBrowseFile, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_rbFile.setSelected(true);
        this.m_rbTable.setSelected(true);
        this.m_rbText.setSelected(true);
        this.m_itfMessageLength = new WAIntTextField();
        this.m_itfMessageLength.setText("256");
        this.m_itfMessageLength.setPreferredSize(new Dimension(80, 20));
        this.m_lblMsgLength = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_itfMessageLength, (WAdminResource)m_bundle, (String)"QueueMessageOptionsTab.Label.MessageLength");
        WAPanel panel2 = new WAPanel();
        panel2.setLayout((LayoutManager)new GridBagLayout());
        panel2.add((Component)this.m_lblMsgLength, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel2.add((Component)this.m_itfMessageLength, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel2.add((Component)this.m_btnAdvanced, (Object)new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 12, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.setLayout(new BorderLayout());
        mainPanel.add((Component)this.m_pnlMessagePanel, (Object)new GridBagConstraints(0, 0, 1, 3, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        if (!this.m_queueModel.isReader()) {
            mainPanel.add((Component)panel2, (Object)new GridBagConstraints(0, 3, 1, 2, 0.0, 0.0, 18, 2, new Insets(10, 5, 10, 0), 0, 0));
            mainPanel.add((Component)new WAPanel(), (Object)new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 0, 0), 0, 0));
        } else {
            mainPanel.add((Component)panel2, (Object)new GridBagConstraints(0, 5, 1, 2, 0.0, 0.0, 18, 1, new Insets(10, 5, 10, 0), 0, 0));
            mainPanel.add((Component)new WAPanel(), (Object)new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 0, 0), 0, 0));
        }
        this.add((Component)mainPanel, "Center");
    }

    public void populateStore() {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_queueModel.moveDataToModel();
        this.m_itfMessageLength.setValue(this.m_queueModel.getMessageLength());
        this.m_rbText.setSelected(this.m_queueModel.isTextMessage());
        this.m_rbTable.setSelected(this.m_queueModel.isTableMessage());
        this.m_rbFile.setSelected(this.m_queueModel.isFileMessage());
        this.m_wtfFile.setText(this.m_queueModel.getFileName());
        if (!this.m_queueModel.isReader()) {
            this.m_wtfText.setText(this.m_queueModel.getTextContent());
        } else {
            this.m_wtfMacroName.setText(this.m_queueModel.getMacroVariable());
        }
        if (this.m_queueModel.isReader() && this.m_wtfMacroName.getText().length() == 0) {
            this.m_wtfMacroName.setText("etls_qms");
        }
        if (this.m_itfMessageLength.getValue() == 0) {
            this.m_itfMessageLength.setValue(256);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_queueModel.setMessageLength(this.m_itfMessageLength.getValue());
        this.m_queueModel.setTextMessage(this.m_rbText.isSelected());
        this.m_queueModel.setTableMessage(this.m_rbTable.isSelected());
        this.m_queueModel.setFileMessage(this.m_rbFile.isSelected());
        this.m_queueModel.setFileName(this.m_wtfFile.getText());
        if (!this.m_queueModel.isReader()) {
            this.m_queueModel.setTextContent(this.m_wtfText.getText());
        } else {
            this.m_queueModel.setMacroVariable(this.m_wtfMacroName.getText());
        }
        this.m_queueModel.moveDataToStore();
    }

    public void setRadioButtonSelection() {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        String sSelection = appDefaults.getPropertyString(RADIO_BUTTON_KEY, "");
        if (sSelection.length() == 0 || sSelection.compareTo(RB_FILE) == 0) {
            this.m_rbFile.setSelected(true);
        } else if (sSelection.compareTo(RB_TABLE) == 0) {
            this.m_rbTable.setSelected(true);
        } else if (sSelection.compareTo(RB_TEXT) == 0) {
            this.m_rbText.setSelected(true);
        }
    }

    public boolean validateData() {
        String msgString;
        int iValue;
        int iValue2;
        if (this.m_itfMessageLength.getText().length() > 0) {
            if (this.m_itfMessageLength.getValue() > Short.MAX_VALUE) {
                MessageUtil.displayMessage((String)m_bundle.getString("QueueMessageOptions.Exceeds32767.txt"), (int)0);
                this.m_itfMessageLength.requestFocus();
                return false;
            }
            if (this.m_itfMessageLength.getValue() == 0) {
                MessageUtil.displayMessage((String)m_bundle.getString("QueueMessageOptions.Equals0.txt"), (int)0);
                this.m_itfMessageLength.requestFocus();
                return false;
            }
        }
        if (this.m_rbFile.isSelected() && this.m_wtfFile.getText().length() == 0 && (iValue2 = MessageUtil.displayMessage((String)m_bundle.getString("QueueMessageOptions.FilenameBlank.txt"), (String)m_bundle.getString("QueueMessageOptions.FilenameBlank.Title.txt"), (int)2, (int)0)) == 0) {
            this.m_wtfFile.requestFocus();
            return false;
        }
        if (this.m_wtfText != null && this.m_rbText.isSelected() && this.m_wtfText.getText().length() == 0 && (iValue2 = MessageUtil.displayMessage((String)m_bundle.getString("QueueMessageOptions.MessageBlank.txt"), (String)m_bundle.getString("QueueMessageOptions.MessageNotSpecified.Title.txt"), (int)2, (int)0)) == 0) {
            this.m_wtfText.requestFocus();
            return false;
        }
        if (this.m_wtfText != null && this.m_rbText.isSelected() && this.m_wtfText.getText().length() > this.m_itfMessageLength.getValue() && (iValue = MessageUtil.displayMessage((String)(msgString = m_bundle.formatString("QueueMessageOptions.InsuffLength.fmt.txt", (Object)Integer.toString(this.m_itfMessageLength.getValue()), (Object)Integer.toString(this.m_wtfText.getText().length()))), (String)m_bundle.getString("QueueMessageOptions.InsufficientLength.Title.txt"), (int)2, (int)0)) == 0) {
            this.m_itfMessageLength.setText(Integer.toString(this.m_wtfText.getText().length()));
            this.m_itfMessageLength.requestFocus();
            return false;
        }
        if (this.m_wtfMacroName != null && this.m_rbText.isSelected() && this.m_wtfMacroName.getText().length() == 0) {
            MessageUtil.displayMessage((String)m_bundle.getString("QueueMessageOptions.MacroVariableBlank.txt"), (String)m_bundle.getString("QueueMessageOptions.MacroVariableBlank.Title.txt"), (int)0);
            this.m_wtfMacroName.requestFocus();
            return false;
        }
        return true;
    }

    private void createMessagePropertiesForTableColumns(DataTable dataTable) {
        boolean bExistProperties = true;
        try {
            Column oColumn;
            AssociationList alColumns = dataTable.getColumns();
            for (int iColumn = 0; iColumn < alColumns.size() && (bExistProperties = QueueUtil.hasMessageProperties(oColumn = (Column)alColumns.get(iColumn))); ++iColumn) {
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (bExistProperties) {
            return;
        }
        List lQueueFormats = null;
        WsAppServer wsAppServer = null;
        if (!(dataTable instanceof WorkTable)) {
            try {
                wsAppServer = QueueUtil.getWsAppServerForDataTable(dataTable);
            }
            catch (ViewDataException oColumn) {
                // empty catch block
            }
        }
        try {
            lQueueFormats = this.getColumnWidths(dataTable);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        AssociationList alColumns = null;
        try {
            alColumns = dataTable.getColumns();
            for (int iColumn = 0; iColumn < alColumns.size(); ++iColumn) {
                Column oColumn = (Column)alColumns.get(iColumn);
                if (QueueUtil.hasMessageProperties(oColumn)) continue;
                ArrayList list = null;
                for (int iQCols = 0; iQCols < lQueueFormats.size(); ++iQCols) {
                    list = (ArrayList)lQueueFormats.get(iQCols);
                    if (oColumn.getSASColumnName().compareToIgnoreCase((String)list.get(0)) == 0) break;
                }
                if (oColumn == null) {
                    return;
                }
                String sWidth = (String)list.get(1);
                StringBuffer sb = new StringBuffer();
                sb.append("CHAR");
                sb.append(",,");
                sb.append(sWidth);
                QueueUtil.addMessagePropertiesToColumn(oColumn, "CHAR", sWidth, sb.toString());
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public List getColumnWidths(DataTable dataTable) throws MdException, RemoteException {
        ArrayList alColumnWidths = new ArrayList(50);
        AssociationList lColumns = dataTable.getColumns();
        for (int colNum = 0; colNum < lColumns.size(); ++colNum) {
            ArrayList<String> alRow = new ArrayList<String>(2);
            Column oColumn = (Column)lColumns.get(colNum);
            alRow.add(oColumn.getSASColumnName());
            int sasColumnLength = oColumn.getSASColumnLength();
            alRow.add(Integer.toString(sasColumnLength));
            alColumnWidths.add(alRow);
        }
        return alColumnWidths;
    }

    public List getColumnWidths(DataTable dataTable, WsAppServer wsAppServer) throws MdException, RemoteException, SQLException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException, GenericError {
        String tableName = DBMSNamesUtil.getQuotedString((String)((PhysicalTable)dataTable).getSASTableName(), (DataTable)dataTable);
        StringBuffer sbSource = new StringBuffer(300);
        SASLibrary library = (SASLibrary)dataTable.getTablePackage();
        LibraryUtil.interactiveAccessPath((SASLibrary)library, (WsAppServer)wsAppServer);
        String filename = wsAppServer.getPathToFile(QueueUtil.getLibRef(dataTable, wsAppServer), ((PhysicalTable)dataTable).getSASTableName()) + ".sas7bdat";
        if (wsAppServer.doesFileExist(filename)) {
            sbSource.append("%let dsn=");
            sbSource.append(tableName);
            sbSource.append(";\n\n");
            sbSource.append("proc contents data=&dsn out=etls_cols(keep=name);\n");
            sbSource.append("run;\n\n");
            sbSource.append("data _null_;\n");
            sbSource.append("set etls_cols end=eof;\n");
            sbSource.append("if _n_=1 then call execute('data etls_fmtwidths;set &dsn;length name $32;keep name width;');\n");
            sbSource.append("call execute('name=\"'||trim(name)||'\";'); \n");
            sbSource.append("call execute('width=vformatw('||trim(name)||');');\n");
            sbSource.append("call execute('output;'); \n");
            sbSource.append("if eof then call execute('stop;run;');\n");
            sbSource.append("run;\n");
            sbSource.append(this.genTableDelete("work", "etls_cols"));
            Workspace.getDefaultLogger().debug((Object)sbSource.toString());
            wsAppServer.submitSASCode(sbSource.toString());
            ArrayList alColumnWidths = (ArrayList)this.readColumnWidthsFromDataset("etls_fmtwidths", wsAppServer);
            wsAppServer.closeSQLConnection();
            wsAppServer.submitSASCode(this.genTableDelete("work", "etls_fmtwidths"));
            return alColumnWidths;
        }
        return this.getColumnWidths(dataTable);
    }

    private List readColumnWidthsFromDataset(String tabName, WsAppServer wsAppServer) throws SQLException, WsAppServerFailException {
        ResultSetMetaData m_metadata = null;
        int colCount = 0;
        ArrayList alColumns = new ArrayList(50);
        String submitStmt = "select * from " + tabName;
        MVAResultSet rsltSet = wsAppServer.submitSQLStatement(submitStmt);
        if (m_metadata == null) {
            m_metadata = rsltSet.getMetaData();
            colCount = m_metadata.getColumnCount();
        }
        while (rsltSet.next()) {
            ArrayList<String> alRow = new ArrayList<String>(colCount);
            for (int i = 1; i <= colCount; ++i) {
                String value = rsltSet.getString(i).trim();
                alRow.add(value);
            }
            alColumns.add(alRow);
        }
        try {
            rsltSet.close();
        }
        catch (SQLException se) {
            MessageUtil.displayMessage((String)se.getLocalizedMessage());
        }
        return alColumns;
    }

    public String genTableDelete(String lib, String tableName) {
        StringBuffer sbDeleteSyntax = new StringBuffer(200);
        sbDeleteSyntax.append("proc datasets lib = ");
        sbDeleteSyntax.append(lib);
        sbDeleteSyntax.append(" nolist nowarn memtype = (data view);\n");
        sbDeleteSyntax.append("   delete ");
        sbDeleteSyntax.append(tableName);
        sbDeleteSyntax.append(";\n");
        sbDeleteSyntax.append("quit;\n\n");
        return sbDeleteSyntax.toString();
    }

    protected void showSASLogDialog(String sMessage, WsAppServer wsAppServer) {
        int choice = MessageUtil.displayMessage((String)sMessage, (int)0, (int)0);
        if (choice == 0) {
            String sTitle = m_bundle.getString("QueueMessageOptionsTab.Title.Log.txt");
            SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), sTitle, true, wsAppServer);
            dlg.show();
        }
    }

    public DataTable getConnectedSourceOrTargetTable() {
        block7: {
            if (!this.m_queueModel.isReader()) {
                try {
                    return QueueUtil.getWriterSourceTable(this.m_mdTS);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                    break block7;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                    break block7;
                }
            }
            try {
                return QueueUtil.getReaderTargetTable(this.m_mdTS);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return null;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        if (this.m_pnlMessagePanel != null) {
            this.m_pnlMessagePanel.setEditable(bEditable);
        }
        if (this.m_wtfText != null) {
            this.m_wtfText.setEditable(bEditable);
        }
        if (this.m_wtfMacroName != null) {
            this.m_wtfMacroName.setEditable(bEditable);
        }
        if (this.m_wtfFile != null) {
            this.m_wtfFile.setEditable(bEditable);
        }
        if (this.m_itfMessageLength != null) {
            this.m_itfMessageLength.setEditable(bEditable);
        }
    }

    private class cItemListener
    implements ItemListener {
        private cItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JRadioButton rbn = (JRadioButton)e.getSource();
            boolean bSelected = rbn.isSelected();
            DataTable sourceOrTargetTable = QueueMessageOptionsTab.this.getConnectedSourceOrTargetTable();
            if (sourceOrTargetTable == null) {
                QueueMessageOptionsTab.this.m_rbTable.setEnabled(false);
                if (QueueMessageOptionsTab.this.m_rbTable.isSelected()) {
                    QueueMessageOptionsTab.this.m_rbText.setSelected(true);
                }
            } else {
                QueueMessageOptionsTab.this.m_rbTable.setEnabled(true);
            }
            if (rbn == QueueMessageOptionsTab.this.m_rbTable) {
                if (QueueMessageOptionsTab.this.m_itfMessageLength != null) {
                    QueueMessageOptionsTab.this.m_itfMessageLength.setEnabled(false);
                }
            } else if (QueueMessageOptionsTab.this.m_itfMessageLength != null) {
                QueueMessageOptionsTab.this.m_itfMessageLength.setEnabled(true);
            }
            if (rbn == QueueMessageOptionsTab.this.m_rbText) {
                if (!QueueMessageOptionsTab.this.m_queueModel.isReader()) {
                    QueueMessageOptionsTab.this.m_wtfText.setEnabled(bSelected);
                } else {
                    QueueMessageOptionsTab.this.m_wtfMacroName.setEnabled(bSelected);
                }
            } else if (rbn == QueueMessageOptionsTab.this.m_rbTable) {
                if (sourceOrTargetTable != null && Workspace.getWorkspace().isObjectEditable((CMetadata)sourceOrTargetTable)) {
                    QueueMessageOptionsTab.this.createMessagePropertiesForTableColumns(sourceOrTargetTable);
                }
            } else if (rbn == QueueMessageOptionsTab.this.m_rbFile) {
                QueueMessageOptionsTab.this.m_wtfFile.setEnabled(bSelected);
                QueueMessageOptionsTab.this.m_btnBrowseFile.setEnabled(bSelected);
                if (sourceOrTargetTable != null) {
                    try {
                        RelationalSchema schema = sourceOrTargetTable.getTablePackage();
                        if (!(schema instanceof SASLibrary)) {
                            return;
                        }
                        SASLibrary library = (SASLibrary)schema;
                        if (library.getUsingPackages().get(0) instanceof Directory) {
                            String directory = ((Directory)library.getUsingPackages().get(0)).getDirectoryName();
                            String filename = ((PhysicalTable)sourceOrTargetTable).getSASTableName();
                            StringBuffer sbPath = new StringBuffer();
                            sbPath.append(directory);
                            if (directory.indexOf("\\") >= 0) {
                                sbPath.append("\\");
                            } else {
                                sbPath.append("/");
                            }
                            sbPath.append(filename);
                            sbPath.append(".sas7bdat");
                            if (QueueMessageOptionsTab.this.m_wtfFile.getText().trim().length() < 1) {
                                QueueMessageOptionsTab.this.m_wtfFile.setText(sbPath.toString());
                            }
                        } else if (library.getUsingPackages().get(0) instanceof FileImpl) {
                            String filename = ((FileImpl)library.getUsingPackages().get(0)).getFileName();
                            if (QueueMessageOptionsTab.this.m_wtfFile.getText().trim().length() < 1) {
                                QueueMessageOptionsTab.this.m_wtfFile.setText(filename);
                            }
                        }
                    }
                    catch (MdException mde) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                }
            }
        }
    }

    private class cFileBrowseAction
    extends WsAbstractAction {
        public cFileBrowseAction() {
            super(m_bundle, "QueueMessageOptionsTab.Action.FileBrowse", false, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                QueueMessageOptionsTab.this.setCursor(Cursor.getPredefinedCursor(3));
                WsAppServer m_wsAppServer = WsAppServer.createDefaultAppServer();
                if (m_wsAppServer.getOperatingSystem().equalsIgnoreCase("OS")) {
                    MessageUtil.displayMessage((String)m_bundle.getString("QueueMessageOptionsTab.Error.UnableToBrowse.txt"), (int)0);
                    return;
                }
                LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
                mapFileTypes.put(m_bundle.getString("QueueMessageOptionsTab.AllFileTypes.txt"), "*");
                String sSelectedFile = m_wsAppServer.promptForFilename(m_bundle.getString("QueueMessageOptionsTab.RemoteFileSelector.Title.txt"), "", mapFileTypes);
                if (sSelectedFile != null && sSelectedFile.length() > 0) {
                    QueueMessageOptionsTab.this.m_wtfFile.setText(sSelectedFile);
                }
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
            catch (WsAppServerFailException wsfe) {
                MessageUtil.displayMessage((String)wsfe.getLocalizedMessage(), (int)0);
            }
            finally {
                QueueMessageOptionsTab.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private class cAdvanced
    extends WsAbstractAction {
        public cAdvanced() {
            super(m_bundle, "QueueMessageOptionsTab.Action.Advanced", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            String sAdvancedSettingsTitle = m_bundle.getString("QueueMessageOptionsTab.AdvancedSettings.Title.txt");
            boolean bWebSphere = !QueueMessageOptionsTab.this.m_queueModel.getQueueType().equals("MSMQ");
            boolean bWriter = !QueueMessageOptionsTab.this.m_queueModel.isReader();
            String sHelpTopic = "";
            if (bWebSphere && bWriter) {
                sHelpTopic = "advanced_wswrite";
            } else if (bWebSphere && !bWriter) {
                sHelpTopic = "advanced_wsread";
            } else if (!bWebSphere && bWriter) {
                sHelpTopic = "advanced_mqwrite";
            } else if (!bWebSphere && !bWriter) {
                sHelpTopic = "advanced_mqread";
            }
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sAdvancedSettingsTitle, true);
            dlg.setResizable(true);
            dlg.setHelpProduct("wdb");
            if (QueueMessageOptionsTab.this.m_pnlMessagePanel != null) {
                dlg.setEditable(QueueMessageOptionsTab.this.m_pnlMessagePanel.isEditable());
            }
            dlg.show();
        }
    }
}

