/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.wadmin.model.ColumnsTableModel2;
import com.sas.wadmin.transforms.queues.QueueUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractPopulateOnDemandTableColumn;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;

public class QueueColumnsModel
extends WsAbstractTableModel {
    private static WAdminResource bundleY = WAdminResource.getBundle(ColumnsTableModel2.class);
    public static final int NAME_COL = 0;
    public static final int DESC_COL = 1;
    public static final int LENGTH_COL = 2;
    public static final int TYPE_COL = 3;
    public static final int ROLE_COL = 4;
    public static final int SORT_COL = 5;
    public static final int INFORMAT_COL = 6;
    public static final int FORMAT_COL = 7;
    public static final int NULL_COL = 8;
    public static final int BEGINPOS_COL = 9;
    public static final int ENDPOS_COL = 10;
    public static final int MSGTYPE_COL = 11;
    public static final int MSGLENGTH_COL = 12;
    public static final int MSGFORMAT_COL = 13;
    public static final int KEY_COL = 14;
    public static final int NOTES_COL = 15;
    public static final int EXTATTR_COL = 16;
    public static final int ACTUAL_COL = 17;
    protected static final int W_NAME_COL = 175;
    protected static final int W_DESC_COL = 225;
    protected static final int W_LENGTH_COL = 50;
    protected static final int W_TYPE_COL = 75;
    protected static final int W_ROLE_COL = 100;
    protected static final int W_SORT_COL = 100;
    protected static final int W_INFORMAT_COL = 100;
    protected static final int W_FORMAT_COL = 100;
    protected static final int W_NULLABLE_COL = 100;
    protected static final int W_BEGINPOS_COL = 50;
    protected static final int W_ENDPOS_COL = 50;
    protected static final int W_MSGTYPE_COL = 100;
    protected static final int W_MSGLENGTH_COL = 50;
    protected static final int W_MSGFORMAT_COL = 100;
    protected static final int TOTAL_COLS = 14;
    protected static final int TOTAL_HIDDEN_COLS = 4;
    public static final String CHAR = "CHAR";
    public static final String SHORT = "SHORT";
    public static final String LONG = "LONG";
    public static final String DOUBLE = "DOUBLE";
    protected DataTable m_oTable;
    protected AssociationList m_alColumns;
    protected int[] m_aRowMappings;
    protected boolean m_overlappingColumns;
    protected cBeginPositionTableColumn m_tableColumnBegin;
    protected cEndPositionTableColumn m_tableColumnEnd;

    public QueueColumnsModel(boolean bQueueWriter) {
        this.createColumnDefinitions(bQueueWriter);
    }

    protected void createColumnDefinitions(boolean bQueueWriter) {
        String[] saTypes = WsColumnMetadataUtil.getViewTypes();
        String[] saRoles = this.loadRoleValues();
        String[] saSorts = this.loadSortValues();
        String[] saMessageTypes = this.loadMessageTypeValues();
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundleY.getString("ColumnsTableModel2.Name.txt"), 175, 32);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundleY.getString("ColumnsTableModel2.Description.txt"), 225, 200);
        this.m_aColumns[2] = new WsIntegerTableColumn(2, bundleY.getString("ColumnsTableModel2.Length.txt"), 50, 8, 1, Integer.MAX_VALUE);
        this.m_aColumns[3] = new WsEnumeratedTableColumn(3, bundleY.getString("ColumnsTableModel2.Type.txt"), 75, saTypes);
        this.m_aColumns[4] = new WsEnumeratedTableColumn(4, bundleY.getString("ColumnsTableModel2.Role.txt"), 100, saRoles, saRoles[4]);
        this.m_aColumns[5] = new WsEnumeratedTableColumn(5, bundleY.getString("ColumnsTableModel2.Sort.txt"), 100, saSorts, saSorts[5]);
        this.m_aColumns[6] = this.createInformatsTableColumn();
        this.m_aColumns[7] = this.createFormatsTableColumn();
        this.m_aColumns[8] = new WsBooleanTableColumn(8, bundleY.getString("ColumnsTableModel2.Nullable.txt"), 100, true);
        this.m_aColumns[9] = this.createBeginPositionTableColumn();
        this.m_aColumns[10] = this.createEndPositionTableColumn();
        this.m_aColumns[14] = new WsBooleanTableColumn(14, null, 0, false);
        this.m_aColumns[15] = new WsBooleanTableColumn(15, null, 0, false);
        this.m_aColumns[16] = new WsBooleanTableColumn(16, null, 0, false);
        this.m_aColumns[17] = new WsMetadataTableColumn();
        this.m_aColumns[11] = new WsEnumeratedTableColumn(11, bundleY.getString("QueueColumnsTableModel.MsgType.txt"), 100, saMessageTypes, saMessageTypes[3]);
        this.m_aColumns[12] = new WsIntegerTableColumn(12, bundleY.getString("QueueColumnsTableModel.MsgLength.txt"), 50, 8, 1, Integer.MAX_VALUE);
        this.m_aColumns[13] = new WsStringTableColumn(13, bundleY.getString("QueueColumnsTableModel.MsgFormat.txt"), 100, 200);
        boolean bEditable = true;
        if (bQueueWriter) {
            bEditable = false;
        }
        this.m_aColumns[0].setEditable(bEditable);
        this.m_aColumns[1].setEditable(bEditable);
        this.m_aColumns[2].setEditable(bEditable);
        this.m_aColumns[3].setEditable(bEditable);
        this.m_aColumns[4].setEditable(bEditable);
        this.m_aColumns[5].setEditable(bEditable);
        this.m_aColumns[6].setEditable(bEditable);
        this.m_aColumns[7].setEditable(bEditable);
        this.m_aColumns[8].setEditable(bEditable);
        this.m_aColumns[9].setEditable(bEditable);
        this.m_aColumns[10].setEditable(bEditable);
    }

    protected WsAbstractTableColumn createInformatsTableColumn() {
        return new cInformatsTableColumn();
    }

    protected WsAbstractTableColumn createFormatsTableColumn() {
        return new cFormatsTableColumn();
    }

    protected WsAbstractTableColumn createBeginPositionTableColumn() {
        this.m_tableColumnBegin = new cBeginPositionTableColumn();
        return this.m_tableColumnBegin;
    }

    protected WsAbstractTableColumn createEndPositionTableColumn() {
        this.m_tableColumnEnd = new cEndPositionTableColumn();
        return this.m_tableColumnEnd;
    }

    protected String[] loadMessageTypeValues() {
        String[] saMessageTypes = new String[]{CHAR, SHORT, LONG, DOUBLE};
        return saMessageTypes;
    }

    protected String[] loadRoleValues() {
        String[] saRoles = new String[]{bundleY.getString("ColumnsTableModel2.Class.txt"), bundleY.getString("ColumnsTableModel2.Id.txt"), bundleY.getString("ColumnsTableModel2.Statistic.txt"), bundleY.getString("ColumnsTableModel2.Default.txt"), bundleY.getString("ColumnsTableModel2.None.txt")};
        return saRoles;
    }

    protected String[] loadSortValues() {
        String[] saSorts = new String[]{bundleY.getString("CommonTableModel.Ascending.notrans"), bundleY.getString("CommonTableModel.Descending.notrans"), bundleY.getString("CommonTableModel.AscFormatted.notrans"), bundleY.getString("CommonTableModel.DscFormatted.notrans"), bundleY.getString("CommonTableModel.DSOrder.notrans"), bundleY.getString("CommonTableModel.None.txt")};
        return saSorts;
    }

    public void setMetadataTable(DataTable oTable) {
        this.m_oTable = oTable;
    }

    public DataTable getMetadataTable() {
        return this.m_oTable;
    }

    public void setColumnsAssociationList(AssociationList alColumns) {
        this.m_alColumns = alColumns;
    }

    public AssociationList getColumnsAssociationList() {
        return this.m_alColumns;
    }

    public void setRowMappings(int[] aRowMappings) {
        this.m_aRowMappings = aRowMappings;
    }

    public int[] getRowMappings() {
        return this.m_aRowMappings;
    }

    public boolean isCellEditable(int iRow, int iCol) {
        String sValue = this.getValueAt(iRow, 11).toString();
        if (iCol == 12 && sValue.compareToIgnoreCase(CHAR) != 0) {
            return false;
        }
        return this.m_aColumns[iCol].isEditable();
    }

    public int getColumnCount() {
        return 14;
    }

    public int getHiddenColumnCount() {
        return 4;
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        block8: {
            String sType;
            block7: {
                super.setValueAt(value, iRow, iCol);
                if (iCol == 11) break block7;
                if (iCol != 12) break block8;
            }
            if ((sType = (String)this.getValueAt(iRow, 11)).equals(SHORT) || sType.equals(LONG) || sType.equals(DOUBLE)) {
                this.m_aColumns[12].setEditable(false);
                super.setValueAt((Object)"", iRow, 12);
                String sMsgFormat = (String)this.getValueAt(iRow, 11);
                super.setValueAt((Object)sMsgFormat, iRow, 13);
            } else {
                this.m_aColumns[12].setEditable(true);
                String sMsgLength = this.getValueAt(iRow, 12).toString();
                if (sMsgLength.length() == 0) {
                    super.setValueAt(this.getValueAt(iRow, 2), iRow, 12);
                }
                String sMsgFormat = this.getValueAt(iRow, 11) + ",," + this.getValueAt(iRow, 12);
                super.setValueAt((Object)sMsgFormat, iRow, 13);
            }
        }
        if (iCol == 3 || iCol == 14 || iCol == 15 || iCol == 16) {
            this.fireTableCellUpdated(iRow, 0);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_oTable == null) {
            return;
        }
        if (!this.m_oTable.isNewObject()) {
            ArrayList<String> lAssocs = new ArrayList<String>();
            StringBuffer sbTemplate = new StringBuffer("<Templates>");
            lAssocs.add("Columns");
            sbTemplate.append("<Column><Keys/><Notes/><Extensions/><Documents/></Column>");
            if (this.m_oTable.getCMetadataType().equals("PhysicalTable") || this.m_oTable.getCMetadataType().equals("WorkTable")) {
                lAssocs.add("Indexes");
                lAssocs.add("TablePackage");
                sbTemplate.append("<Index><Columns/><Options/></Index><DatabaseSchema><DeployedComponents/></DatabaseSchema>");
            }
            sbTemplate.append("</Templates>");
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_oTable, null, lAssocs, sbTemplate.toString(), 12, true);
        }
        this.m_alColumns = this.m_oTable.getColumns();
        this.setStorePopulated(true);
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.clear();
        if (this.m_alColumns == null) {
            return;
        }
        int nRows = this.m_alColumns.size();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            Column oColumn = (Column)this.m_alColumns.get(iRow);
            this.m_lData.add(this.getRowValuesForColumn(oColumn));
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        int iColumn;
        int nColumns = this.m_alColumns.size();
        ArrayList<Object> alOldColumns = new ArrayList<Object>(nColumns);
        for (iColumn = 0; iColumn < nColumns; ++iColumn) {
            alOldColumns.add(this.m_alColumns.get(iColumn));
        }
        this.m_alColumns.removeAllElements();
        String sNone = bundleY.getString("ColumnsTableModel2.None.txt");
        String sNoneFmt = WsColumnMetadataUtil.NONE;
        int nRows = this.m_lData.size();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            Integer iEnd;
            Integer iBegin;
            Boolean bNullable;
            int iNullable;
            Integer iLength;
            String sInformat;
            String sFormat;
            String sSort;
            iColumn = this.m_aRowMappings != null ? this.m_aRowMappings[iRow] : iRow;
            Column oColumn = (Column)this.getValueAt(iColumn, 17);
            String sName = (String)this.getValueAt(iColumn, 0);
            if (!sName.equals(oColumn.getSASColumnName())) {
                oColumn.setSASColumnName(sName);
                oColumn.setName(sName);
            }
            String sDescription = (String)this.getValueAt(iColumn, 1);
            if (!oColumn.getDesc().equals(sDescription)) {
                oColumn.setDesc(sDescription);
            }
            String sViewType = (String)this.getValueAt(iColumn, 3);
            WsColumnMetadataUtil.updateType((Column)oColumn, (String)sViewType);
            String sSummary = (String)this.getValueAt(iColumn, 4);
            if (sSummary.equalsIgnoreCase(sNone)) {
                sSummary = "";
            }
            if (!oColumn.getSummaryRole().equals(sSummary)) {
                oColumn.setSummaryRole(sSummary);
            }
            if ((sSort = (String)this.getValueAt(iColumn, 5)).equalsIgnoreCase(sNone)) {
                sSort = "";
            }
            if (!oColumn.getSortOrder().equals(sSort)) {
                oColumn.setSortOrder(sSort);
            }
            if ((sFormat = (String)this.getValueAt(iColumn, 7)).equalsIgnoreCase(sNoneFmt)) {
                sFormat = "";
            }
            if (!oColumn.getSASFormat().equals(sFormat)) {
                oColumn.setSASFormat(sFormat);
            }
            if ((sInformat = (String)this.getValueAt(iColumn, 6)).equalsIgnoreCase(sNoneFmt)) {
                sInformat = "";
            }
            if (!oColumn.getSASInformat().equals(sInformat)) {
                oColumn.setSASInformat(sInformat);
            }
            if ((iLength = (Integer)this.getValueAt(iColumn, 2)).intValue() != oColumn.getSASColumnLength()) {
                oColumn.setSASColumnLength(iLength.intValue());
            }
            int n = iNullable = (bNullable = (Boolean)this.getValueAt(iColumn, 8)) != false ? 1 : 0;
            if (oColumn.getIsNullable() != iNullable) {
                oColumn.setIsNullable(iNullable);
            }
            if ((iBegin = (Integer)this.getValueAt(iColumn, 9)).intValue() != oColumn.getBeginPosition()) {
                oColumn.setBeginPosition(iBegin.intValue());
            }
            if ((iEnd = (Integer)this.getValueAt(iColumn, 10)).intValue() != oColumn.getEndPosition()) {
                oColumn.setEndPosition(iEnd.intValue());
            }
            this.saveMessageFormats(oColumn, iColumn);
            this.m_alColumns.add((Object)oColumn);
            if (!alOldColumns.contains(oColumn)) continue;
            alOldColumns.remove(oColumn);
        }
        MdObjectStore store = (MdObjectStore)this.m_oTable.getObjectStore();
        nColumns = alOldColumns.size();
        for (iColumn = 0; iColumn < nColumns; ++iColumn) {
            Column oColumn = (Column)alOldColumns.get(iColumn);
            store.removeObjectFromStore((CMetadata)oColumn, "<Column><Extensions/><SourceFeatureMaps/><TargetFeatureMaps/><PropertySets><SetProperties/><Properties/></PropertySets></Column>");
        }
    }

    public void saveMessageFormats(Column oColumn, int iColumn) throws MdException, RemoteException {
        PropertyHandler propertyHandler = QueueUtil.getMessagePropertyHandler(oColumn);
        if (propertyHandler == null) {
            return;
        }
        String sMsgType = "";
        if (propertyHandler.getSpecificProperty("ETLS_QCOL_TYPE") != null) {
            sMsgType = propertyHandler.getSpecificProperty("ETLS_QCOL_TYPE").getDefaultValue();
        }
        String sMsgLength = null;
        if (propertyHandler.getSpecificProperty("ETLS_QCOL_LENGTH") != null) {
            sMsgLength = propertyHandler.getSpecificProperty("ETLS_QCOL_LENGTH").getDefaultValue();
        }
        String sMsgFormat = "";
        if (propertyHandler.getSpecificProperty("ETLS_QCOL_FORMAT") != null) {
            sMsgFormat = propertyHandler.getSpecificProperty("ETLS_QCOL_FORMAT").getDefaultValue();
        }
        String sMsgTypeNew = (String)this.getValueAt(iColumn, 11);
        String sMsgLengthNew = this.getValueAt(iColumn, 12).toString();
        String sMsgFormatNew = (String)this.getValueAt(iColumn, 13);
        if (!sMsgType.equals(sMsgTypeNew)) {
            propertyHandler.setSpecificProperty("ETLS_QCOL_TYPE", sMsgTypeNew);
        }
        if (sMsgLength == null || !sMsgLength.equals(sMsgLengthNew)) {
            propertyHandler.setSpecificProperty("ETLS_QCOL_LENGTH", sMsgLengthNew);
        }
        if (!sMsgFormat.equals(sMsgFormatNew)) {
            propertyHandler.setSpecificProperty("ETLS_QCOL_FORMAT", sMsgFormatNew);
        } else if (!sMsgType.equals(sMsgTypeNew) || !sMsgLength.equals(sMsgLengthNew)) {
            sMsgFormatNew = sMsgTypeNew + ",," + sMsgLengthNew;
            propertyHandler.setSpecificProperty("ETLS_QCOL_FORMAT", sMsgFormatNew);
        }
    }

    public int findColumnsRow(Column oColumn) {
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            if (!oColumn.equals(this.getValueAt(iRow, 17))) continue;
            return iRow;
        }
        return -1;
    }

    public List getRowValuesForColumn(Column oColumn) throws MdException, RemoteException {
        String sNone = bundleY.getString("ColumnsTableModel2.None.txt");
        String sNoneFmt = WsColumnMetadataUtil.NONE;
        String sType = WsColumnMetadataUtil.getColumnViewTypeString((Column)oColumn);
        String sRole = oColumn.getSummaryRole();
        String sSort = oColumn.getSortOrder();
        String sInformat = oColumn.getSASInformat();
        String sFormat = oColumn.getSASFormat();
        int iNullable = oColumn.getIsNullable();
        ArrayList<Object> lRowValues = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
        lRowValues.add(oColumn.getSASColumnName());
        lRowValues.add(oColumn.getDesc());
        lRowValues.add(new Integer(oColumn.getSASColumnLength()));
        lRowValues.add(sType);
        lRowValues.add(sRole.length() == 0 ? sNone : sRole);
        lRowValues.add(sSort.length() == 0 ? sNone : sSort);
        lRowValues.add(sInformat.length() == 0 ? sNoneFmt : sInformat);
        lRowValues.add(sFormat.length() == 0 ? sNoneFmt : sFormat);
        lRowValues.add(iNullable == 1);
        lRowValues.add(new Integer(oColumn.getBeginPosition()));
        lRowValues.add(new Integer(oColumn.getEndPosition()));
        String[] messageFormats = QueueUtil.getColumnMessageFormats(oColumn);
        lRowValues.add(messageFormats[0]);
        lRowValues.add(messageFormats[1]);
        lRowValues.add(messageFormats[2]);
        lRowValues.add(!oColumn.getKeys().isEmpty());
        lRowValues.add(!oColumn.getNotes().isEmpty() || !oColumn.getDocuments().isEmpty());
        lRowValues.add(!oColumn.getExtensions().isEmpty());
        lRowValues.add(oColumn);
        return lRowValues;
    }

    public void setBeginPosition(int iRow, int begin) {
        this.setValueAt(new Integer(begin), iRow, 9);
    }

    public int getBeginPosition(int iRow) {
        return (Integer)this.getValueAt(iRow, 9);
    }

    public void setEndPosition(int iRow, int end) {
        this.setValueAt(new Integer(end), iRow, 10);
    }

    public int getEndPosition(int iRow) {
        return (Integer)this.getValueAt(iRow, 10);
    }

    public void setLength(int iRow, int length) {
        this.setValueAt(new Integer(length), iRow, 2);
    }

    public int getLength(int iRow) {
        return (Integer)this.getValueAt(iRow, 2);
    }

    protected class cInformatsTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public cInformatsTableColumn() {
            super(6, bundleY.getString("ColumnsTableModel2.Informat.txt"), 100, bundleY.getString("ColumnsTableModel2.None.txt"));
            this.setEditorEditable(true);
        }

        public void populate(JTable tbl, int row, int col) {
            String sType = (String)QueueColumnsModel.this.getValueAt(row = ((WsTable)tbl).convertRowIndexToModel(row), 3);
            if (WsColumnMetadataUtil.isColumnViewTypeCharacter((String)sType)) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterInformats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericInformats());
            }
        }
    }

    protected class cFormatsTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public cFormatsTableColumn() {
            super(7, bundleY.getString("ColumnsTableModel2.Format.txt"), 100, bundleY.getString("ColumnsTableModel2.None.txt"));
            this.setEditorEditable(true);
        }

        public void populate(JTable tbl, int row, int col) {
            String sType = (String)QueueColumnsModel.this.getValueAt(row = ((WsTable)tbl).convertRowIndexToModel(row), 3);
            if (WsColumnMetadataUtil.isColumnViewTypeCharacter((String)sType)) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterFormats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericFormats());
            }
        }
    }

    protected class cBeginPositionTableColumn
    extends WsIntegerTableColumn {
        protected boolean m_overlap;

        public cBeginPositionTableColumn() {
            super(9, bundleY.getString("ColumnsTableModel2.BeginPosition.txt"), 50, 0);
        }

        public void setOverlapColumns(boolean overlap) {
            this.m_overlap = overlap;
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (this.m_overlap) {
                return true;
            }
            int begin = (Integer)oValue;
            if (iRow != 0 && begin <= QueueColumnsModel.this.getEndPosition(iRow - 1)) {
                String sMessage = bundleY.getString("ColumnsTableModel2.Error.BeginPositionTooSmall.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            if (begin < 1) {
                String sMessage = bundleY.getString("ColumnsTableModel2.Error.BeginPositionLessThan1.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            if (begin > QueueColumnsModel.this.getEndPosition(iRow)) {
                String sMessage = bundleY.getString("ColumnsTableModel2.Error.BeginPositionTooLarge.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }

    protected class cEndPositionTableColumn
    extends WsIntegerTableColumn {
        private boolean m_overlap;

        public cEndPositionTableColumn() {
            super(10, bundleY.getString("ColumnsTableModel2.EndPosition.txt"), 50, 0);
        }

        public void setOverlapColumns(boolean overlap) {
            this.m_overlap = overlap;
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (this.m_overlap) {
                return true;
            }
            int end = (Integer)oValue;
            if (end < QueueColumnsModel.this.getBeginPosition(iRow)) {
                String sMessage = bundleY.getString("ColumnsTableModel2.Error.EndPositionTooSmall.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            if (iRow < QueueColumnsModel.this.getRowCount() - 1 && end >= QueueColumnsModel.this.getBeginPosition(iRow + 1)) {
                String sMessage = bundleY.getString("ColumnsTableModel2.Error.EndPositionTooLarge.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }
}

