/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.codegen.CodeConditionOptionsUtil;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.transforms.queues.MQCONN;
import com.sas.wadmin.transforms.queues.MQINQ;
import com.sas.wadmin.transforms.queues.MQMAP;
import com.sas.wadmin.transforms.queues.MQMD;
import com.sas.wadmin.transforms.queues.MQOD;
import com.sas.wadmin.transforms.queues.MQOPEN;
import com.sas.wadmin.transforms.queues.MQOptionsLoader;
import com.sas.wadmin.transforms.queues.MQPMO;
import com.sas.wadmin.transforms.queues.MQPUT;
import com.sas.wadmin.transforms.queues.MQROOT;
import com.sas.wadmin.transforms.queues.MQSETPARMS;
import com.sas.wadmin.transforms.queues.QueueModel;
import com.sas.wadmin.transforms.queues.QueueUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;

public class IBMWSQWriterCodegen {
    private static WAdminResource bundle = WAdminResource.getBundle(IBMWSQWriterCodegen.class);

    public static void codegen(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        QueueModel model = new QueueModel((TransformationStep)classifierMap.getSteps().get(0), "IBMWSMQ", false);
        model.moveDataToModel();
        if (!QueueUtil.hasQueue(classifierMap, true)) {
            throw new CodegenException(bundle.getString("IBMWSQWriterCodegen.NoTargetQueue.msg.txt"));
        }
        IBMWSQWriterCodegen.doUWProcess(cgReq, classifierMap, "PreProcess");
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)classifierMap);
        OP.setUsePropertySet(true);
        MQOptionsLoader hmUserInputLoader = new MQOptionsLoader(classifierMap, true);
        HashMap hmUserInput = hmUserInputLoader.getOptions();
        MQROOT.setMQGlobalVariables(cgReq, hmUserInput);
        MQROOT.setDefaultMacroOptions(hmUserInput);
        if (model.isTextMessage()) {
            IBMWSQWriterCodegen.writeTextToQueue(cgReq, classifierMap, model, hmUserInput);
        } else if (model.isTableMessage()) {
            IBMWSQWriterCodegen.writeTableToQueue(cgReq, classifierMap, hmUserInput);
        } else if (model.isFileMessage()) {
            IBMWSQWriterCodegen.writeFileToQueueV51(cgReq, classifierMap, hmUserInput);
        } else {
            model.setMessageLength(256);
            model.setTextMessage(true);
            model.moveDataToStore();
            model.moveDataToModel();
            hmUserInputLoader = new MQOptionsLoader(classifierMap, true);
            hmUserInput = hmUserInputLoader.getOptions();
            IBMWSQWriterCodegen.writeTextToQueue(cgReq, classifierMap, model, hmUserInput);
        }
        IBMWSQWriterCodegen.doUWProcess(cgReq, classifierMap, "PostProcess");
        cgReq.genRCSetCall("&syserr");
        if (cgReq.getJobStatus()) {
            cgReq.addCommentLine("* Comment Line for Job status;\n");
            cgReq.addSourceCode("%let etls_recordsBefore = 0; \n");
        }
        IBMWSQWriterCodegen.genCodeConditionCheck(cgReq, classifierMap);
    }

    private static void writeTextToQueue(CodegenRequest cgReq, ClassifierMap cm, QueueModel model, HashMap hmUserInput) throws MdException, RemoteException {
        QueueUtil.textMessageToMacroVariable(cgReq, model);
        cgReq.addSourceCode("data _null_;\n");
        cgReq.indent();
        MQROOT mqROOT = new MQROOT(cgReq, true, hmUserInput);
        mqROOT.addLengthForParametersAndOptions();
        cgReq.addSourceCode("etls_inplength = length(symget('");
        cgReq.addSourceCode("etls_msg");
        cgReq.addSourceCode("'));\n");
        cgReq.addSourceCode("\n");
        cgReq.addCommentLine(bundle.getString("IBMWSQWriterCodegen.CheckMessageTrunc.Comment.notrans"));
        cgReq.addSourceCode("if (etls_inplength >");
        cgReq.addSourceCode((String)hmUserInput.get("etls_message_length"));
        cgReq.addSourceCode(") then\ndo;\n");
        cgReq.indent();
        cgReq.genPutStatement(bundle.getString("IBMWSQWriterCodegen.MsgLengthInput.put.notrans") + (String)hmUserInput.get("etls_message_length"), "NOTE:");
        cgReq.genPutStatement(bundle.getString("IBMWSQWriterCodegen.MsgLengthMinimum.put.notrans"), "NOTE:", "etls_inplength", false);
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        MQCONN mqconn = new MQCONN(cgReq, true, hmUserInput);
        MQOD mqod = new MQOD(cgReq, true, hmUserInput);
        MQOPEN mqopen = new MQOPEN(cgReq, true, hmUserInput);
        mqopen.setOption(MQOPEN.OUTPUT);
        MQINQ mqinq = new MQINQ(cgReq, false, hmUserInput);
        if (mqinq.isOn()) {
            mqopen.setOption(MQOPEN.INQUIRE);
        }
        MQPMO mqpmo = new MQPMO(cgReq, true, hmUserInput);
        MQMD mqmd = new MQMD(cgReq, true, hmUserInput);
        mqmd.readFromTransformationInput();
        MQMAP mqmap = new MQMAP(cgReq, true, hmUserInput);
        mqmap.setDescriptors();
        MQSETPARMS mqsetparms = new MQSETPARMS(cgReq, true, hmUserInput);
        mqsetparms.addMessageDescriptor();
        MQPUT mqput = new MQPUT(cgReq, true, hmUserInput);
        mqconn.generateLengthStatements();
        mqod.generateLengthStatements();
        mqopen.generateLengthStatements();
        mqpmo.generateLengthStatements();
        mqmd.generateLengthStatements();
        mqmap.generateLengthStatements();
        mqsetparms.generateLengthStatements();
        mqput.generateLengthStatements();
        if (mqinq.isOn()) {
            mqinq.generateLengthStatements();
        }
        mqconn.generateAssignmentStatements();
        mqconn.generateFunctionCall();
        mqod.generateAssignmentStatements();
        mqod.generateFunctionCall();
        mqopen.generateAssignmentStatements();
        mqopen.generateFunctionCall();
        mqpmo.generateAssignmentStatements();
        mqpmo.generateFunctionCall();
        mqmd.generateAssignmentStatements();
        mqmd.generateFunctionCall();
        mqmap.generateAssignmentStatements();
        mqmap.generateFunctionCall();
        mqsetparms.generateAssignmentStatements();
        mqsetparms.generateFunctionCall();
        mqput.generateAssignmentStatements();
        mqput.generateFunctionCall();
        if (mqinq.isOn()) {
            mqinq.generateAssignmentStatements();
            mqinq.generateFunctionCall();
        }
        cgReq.addSourceCode("etls_mqexit");
        cgReq.addSourceCode(":\n");
        mqROOT.generateSyncPointCode();
        mqROOT.freeHandles();
        if (mqROOT.isDebugModeOn()) {
            mqROOT.beginDebug();
            cgReq.genPutStatement(bundle.getString("IBMWSQWriterCodegen.MsgWrittenToQueue.put.notrans"), "NOTE:", "etls_read", false);
            mqROOT.endDebug();
        }
        cgReq.unIndent();
        cgReq.addSourceCode("run;\n");
        if (mqROOT.isDebugModeOn()) {
            mqROOT.addTags();
        }
    }

    private static void writeTableToQueue(CodegenRequest cgReq, ClassifierMap cm, HashMap hmUserInput) throws MdException, RemoteException {
        DataTable sourceTable = cgReq.getSourceTable(cm);
        PhysicalTableCG sourceTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceTable);
        boolean bNeedQuotes = cgReq.getQuoting();
        String sourceTableName = sourceTableCG.getDataLocation(cgReq);
        AssociationList sourceColumnList = sourceTable.getColumns();
        if (sourceColumnList.size() == 0) {
            String msgString = bundle.formatString("IBMWSQReader.TableWithNoColumns.exception.fmt.txt", (Object)sourceTableName);
            throw new MdException(msgString);
        }
        ArrayList messageList = (ArrayList)QueueUtil.buildMessageColumnsList(sourceTable);
        cgReq.addSourceCode("data _null_;\n").indent();
        cgReq.addSourceCode("set ");
        cgReq.addSourceCode(sourceTableName);
        cgReq.addSourceCode(" end=etls_last;\n");
        MQROOT mqROOT = new MQROOT(cgReq, true, hmUserInput);
        mqROOT.addLengthForParametersAndOptions();
        MQCONN mqconn = new MQCONN(cgReq, true, hmUserInput);
        MQOD mqod = new MQOD(cgReq, true, hmUserInput);
        MQOPEN mqopen = new MQOPEN(cgReq, true, hmUserInput);
        mqopen.setOption("OUTPUT");
        MQINQ mqinq = new MQINQ(cgReq, false, hmUserInput);
        if (mqinq.isOn()) {
            mqopen.setOption(MQOPEN.INQUIRE);
        }
        MQPMO mqpmo = new MQPMO(cgReq, true, hmUserInput);
        MQMAP mqmap = new MQMAP(cgReq, true, hmUserInput);
        mqmap.setDescriptors(messageList);
        MQSETPARMS mqsetparms = new MQSETPARMS(cgReq, true, hmUserInput);
        mqsetparms.addDescriptor(messageList);
        mqsetparms.setQuoteCols(bNeedQuotes);
        MQMD mqmd = new MQMD(cgReq, true, hmUserInput);
        mqmd.readFromTransformationInput();
        MQPUT mqput = new MQPUT(cgReq, true, hmUserInput);
        mqconn.generateLengthStatements();
        mqod.generateLengthStatements();
        mqopen.generateLengthStatements();
        mqpmo.generateLengthStatements();
        mqmap.generateLengthStatements();
        mqsetparms.generateLengthStatements();
        mqmd.generateLengthStatements();
        mqput.generateLengthStatements();
        if (mqinq.isOn()) {
            mqinq.generateLengthStatements();
        }
        mqROOT.generateRetainStatement();
        cgReq.addSourceCode("if _N_=1 then \ndo;\n");
        cgReq.indent();
        mqconn.generateAssignmentStatements();
        mqconn.generateFunctionCall();
        mqod.generateAssignmentStatements();
        mqod.generateFunctionCall();
        mqopen.generateAssignmentStatements();
        mqopen.generateFunctionCall();
        mqpmo.generateAssignmentStatements();
        mqpmo.generateFunctionCall();
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        mqmap.generateAssignmentStatements();
        mqmap.generateFunctionCall();
        mqsetparms.generateAssignmentStatements();
        mqsetparms.generateFunctionCall();
        mqmd.generateAssignmentStatements();
        mqmd.generateFunctionCall();
        mqput.generateAssignmentStatements();
        mqput.generateFunctionCall();
        mqROOT.freeDataHandles(hmUserInput);
        cgReq.addSourceCode("etls_mqexit");
        cgReq.addSourceCode(":\n");
        mqROOT.generateMQBACKCode();
        cgReq.addSourceCode("if etls_last then \ndo;");
        cgReq.indent();
        mqROOT.generateSyncPointCode();
        if (mqinq.isOn()) {
            mqinq.generateAssignmentStatements();
            mqinq.generateFunctionCall();
        }
        mqROOT.freeHandles();
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        cgReq.addSourceCode("if etls_compcode>0 then STOP;\n");
        cgReq.unIndent();
        cgReq.addSourceCode("run;\n");
        if (mqROOT.isDebugModeOn()) {
            mqROOT.addTags();
        }
    }

    private static void writeFileToQueueV51(CodegenRequest cgReq, ClassifierMap cm, HashMap hmUserInput) throws MdException, RemoteException {
        String sGroupMessages = (String)hmUserInput.get("GROUP_MESSAGES");
        boolean bGroupMessages = true;
        if (sGroupMessages != null && sGroupMessages.compareToIgnoreCase("NO") == 0) {
            bGroupMessages = false;
        }
        MQROOT mqROOT = new MQROOT(cgReq, true, hmUserInput);
        if (bGroupMessages) {
            MQROOT.setV51SendMacroVars(cgReq, hmUserInput);
        }
        cgReq.addSourceCode("data _null_;\n").indent();
        cgReq.addSourceCode("length etls_correlid $ 48;\n");
        cgReq.addSourceCode("length etls_correlid2 $ 48;\n");
        cgReq.addSourceCode("length etls_msgbuf $ ");
        cgReq.addSourceCode((String)hmUserInput.get("etls_message_length"));
        cgReq.addSourceCode(";\n");
        cgReq.addSourceCode("length etls_ui_correlid $48;\n");
        if (hmUserInput.containsKey(MQMD.CORRELID)) {
            cgReq.addSourceCode("etls_ui_correlid=upcase('");
            cgReq.addSourceCode((String)hmUserInput.get(MQMD.CORRELID));
            cgReq.addSourceCode("');\n");
        } else {
            cgReq.addSourceCode("etls_ui_correlid=\"\";\n");
        }
        if (!bGroupMessages) {
            cgReq.addSourceCode("length etls_lencorrid 3.;\n");
            cgReq.addSourceCode("etls_lencorrid =length(etls_ui_correlid);\n");
        }
        mqROOT.addLengthForParametersAndOptions();
        String sFileName = (String)hmUserInput.get("etls_filename");
        if (sFileName == null || sFileName.length() == 0) {
            throw new CodegenException(bundle.getString("IBMWSQWriterCodegen.NoFileSpecified.msg.txt"));
        }
        cgReq.addCommentLine("Write file to queue");
        cgReq.addSourceCode("infile \"");
        cgReq.addSourceCode(sFileName.trim());
        cgReq.addSourceCode("\" recfm=f lrecl=1 end=eof;\n");
        mqROOT.assignMacroVariable("SASVAR_BUFFSIZE", "etls_buffsize", (String)hmUserInput.get("etls_message_length"), false);
        MQCONN mqconn = new MQCONN(cgReq, true, hmUserInput);
        MQOD mqod = new MQOD(cgReq, true, hmUserInput);
        MQOPEN mqopen = new MQOPEN(cgReq, true, hmUserInput);
        mqopen.setOption("OUTPUT");
        MQINQ mqinq = new MQINQ(cgReq, false, hmUserInput);
        if (mqinq.isOn()) {
            mqopen.setOption(MQOPEN.INQUIRE);
        }
        MQPMO mqpmo = new MQPMO(cgReq, true, hmUserInput);
        if (bGroupMessages) {
            mqpmo.setOption(MQPMO.NEW_MSGID);
            mqpmo.setOption(MQPMO.LOGICAL_ORDER);
        }
        MQMD mqmd = new MQMD(cgReq, true, hmUserInput);
        mqmd.readFromTransformationInput();
        if (bGroupMessages) {
            mqmd.setValue(MQMD.MSGFLAGS, "&group");
        }
        MQMAP mqmap = new MQMAP(cgReq, true, hmUserInput);
        mqmap.setDescriptors();
        MQSETPARMS mqsetparms = new MQSETPARMS(cgReq, true, hmUserInput);
        mqsetparms.addDescriptorForFileWrite();
        MQMD mqmd2 = new MQMD(cgReq, false, hmUserInput);
        mqmd2.setMQMDVersion("2");
        mqmd2.setAction("SET");
        if (bGroupMessages) {
            mqmd2.setValue(MQMD.MSGFLAGS, "&group + &last_group");
        } else {
            mqmd2.setParameter(MQMD.MSGID);
            mqmd2.setParameter(MQMD.CORRELID);
            mqmd2.setValue(MQMD.MSGID, "");
            mqmd2.setValue(MQMD.CORRELID, (String)hmUserInput.get(MQMD.CORRELID));
            mqmd2.setCharacterQuoting(MQMD.CORRELID, true);
        }
        MQPUT mqput = new MQPUT(cgReq, true, hmUserInput);
        mqconn.generateLengthStatements();
        mqod.generateLengthStatements();
        mqopen.generateLengthStatements();
        mqpmo.generateLengthStatements();
        mqmd.generateLengthStatements();
        mqmap.generateLengthStatements();
        mqsetparms.generateLengthStatements();
        mqput.generateLengthStatements();
        if (mqinq.isOn()) {
            mqinq.generateLengthStatements();
        }
        mqconn.generateAssignmentStatements();
        mqconn.generateFunctionCall();
        mqod.generateAssignmentStatements();
        mqod.generateFunctionCall();
        mqopen.generateAssignmentStatements();
        mqopen.generateFunctionCall();
        mqpmo.generateAssignmentStatements();
        mqpmo.generateFunctionCall();
        mqmd.generateAssignmentStatements();
        mqmd.generateFunctionCall();
        mqmap.generateAssignmentStatements();
        mqmap.generateFunctionCall();
        String sCorrelid = (String)hmUserInput.get(MQMD.CORRELID);
        if (sCorrelid == null) {
            sCorrelid = "";
        }
        if (sCorrelid.length() > 0) {
            cgReq.addSourceCode("\n");
            cgReq.addSourceCode("etls_correlid=etls_ui_correlid;\n");
        }
        cgReq.addSourceCode("\n");
        if (!bGroupMessages) {
            cgReq.addSourceCode("etls_seqno = 0;\n");
            cgReq.addSourceCode("\n");
        }
        cgReq.addSourceCode("i=0;\n");
        cgReq.addSourceCode("do until(eof);\n").indent();
        cgReq.addCommentLine("Read a byte at a time");
        cgReq.addSourceCode("input x $char1.;\n");
        cgReq.addSourceCode("i+1;\n");
        cgReq.addSourceCode("substr(etls_msgbuf,i,1) = x;\n");
        cgReq.addSourceCode("if( i = &etls_buffSize or eof ) then \ndo;\n");
        cgReq.indent();
        cgReq.addSourceCode("if (eof) then \ndo;\n");
        cgReq.indent();
        cgReq.addSourceCode("etls_desc=\"CHAR,,\" || put(i,6.);\n");
        cgReq.addSourceCode("call mqmap(etls_hmap, etls_qrc, etls_desc);\n");
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        cgReq.addSourceCode("\n");
        mqsetparms.generateAssignmentStatements();
        mqsetparms.generateFunctionCall();
        cgReq.addSourceCode("\n");
        cgReq.addCommentLine(bundle.getString("IBMWSQWriterCodegen.GenerateMsgid.Comment.notrans"));
        mqmd2.generateAssignmentStatements();
        if (bGroupMessages) {
            cgReq.addSourceCode("if ( eof ) then \ndo;\n");
            cgReq.indent();
        } else {
            cgReq.addCommentLine(bundle.getString("IBMWSQWriterCodegen.AddSequenceNumber.Comment.notrans"));
            cgReq.addSourceCode("etls_seqstr = put(etls_seqno, hex4.);\n");
            cgReq.addSourceCode("substr(etls_correlid2,etls_lencorrid+1,4) = etls_seqstr;\n");
            cgReq.addSourceCode("etls_seqno+1;\n");
        }
        mqmd2.generateFunctionCall();
        cgReq.addSourceCode("\n");
        if (bGroupMessages) {
            cgReq.unIndent();
            cgReq.addSourceCode("end;\n");
        }
        mqput.generateAssignmentStatements();
        mqput.generateFunctionCall();
        if (mqinq.isOn()) {
            mqinq.generateAssignmentStatements();
            mqinq.generateFunctionCall();
        }
        cgReq.addSourceCode("\n");
        cgReq.addCommentLine(bundle.getString("IBMWSQWriterCodegen.MQFREE.Comment.notrans"));
        cgReq.addSourceCode("\n");
        cgReq.addSourceCode("call mqfree(");
        cgReq.addSourceCode("etls_hdata");
        cgReq.addSourceCode(");\n");
        cgReq.addSourceCode("\n");
        cgReq.addCommentLine(bundle.getString("IBMWSQWriterCodegen.ResetMsgBuffer.Comment.notrans"));
        cgReq.addSourceCode("i=0;\n");
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        cgReq.addSourceCode("\n");
        cgReq.addSourceCode("etls_mqexit");
        cgReq.addSourceCode(":\n");
        mqROOT.generateSyncPointCode();
        mqROOT.freeHandles();
        cgReq.unIndent();
        cgReq.addSourceCode("run;\n").unIndent();
        if (mqROOT.isDebugModeOn()) {
            mqROOT.addTags();
        }
    }

    private static void doUWProcess(CodegenRequest cgReq, ClassifierMap cm, String type) throws MdException, RemoteException {
        AssociationList transList;
        AssociationList stepList = cm.getSteps(false);
        TransformationStep ts = null;
        if (stepList != null) {
            if (stepList.size() > 0) {
                ts = (TransformationStep)stepList.get(0);
            }
        } else {
            return;
        }
        if (type.equals("PreProcess")) {
            transList = ts.getTransformationSources();
        } else if (type.equals("PostProcess")) {
            transList = ts.getTransformationTargets();
        } else {
            return;
        }
        for (int i = 0; i < transList.size(); ++i) {
            Transformation step;
            Root root = (Root)transList.get(i);
            if (!(root instanceof Transformation) || !(step = (Transformation)root).getTransformRole().equals(type)) continue;
            if (step.getIsActive() != 1) break;
            cgReq.genUWC((AbstractTransformation)step, true);
            break;
        }
    }

    private static void genCodeConditionCheck(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        TransformationStep oStep = (TransformationStep)classifierMap.getSteps(false).get(0);
        AssociationList alTriggeredEvents = oStep.getTriggeredEvents();
        if (alTriggeredEvents.isEmpty()) {
            return;
        }
        cgReq.addCommentLine(bundle.getString("Codegen.RCCheck.msg.txt"));
        cgReq.addSourceCode("%macro etls_sqlRcCheck; \n\n").indent();
        for (int iEvent = 0; iEvent < alTriggeredEvents.size(); ++iEvent) {
            Event lEvent = (Event)alTriggeredEvents.get(iEvent);
            if (lEvent.getPropertySets().size() <= 0) {
                throw new CodegenException(bundle.getString("ReturnCodeCheck.NoPropertySets.msg.txt"));
            }
            String eventRole = lEvent.getEventRole();
            if (!eventRole.equals("Condition1") && !eventRole.equals("Condition2") && !eventRole.equals("Condition3")) continue;
            String lEventCondition = lEvent.getCondition().trim();
            cgReq.addSourceCode(lEventCondition + "\n");
            cgReq.addSourceCode("%do; \n\n").indent();
            PropertySet lTruePropertySet = CodeConditionOptionsUtil.getActionsPropertySet(lEvent, true);
            AssociationList lTrueProperties = lTruePropertySet.getSetProperties();
            for (int iAction = 0; iAction < lTrueProperties.size(); ++iAction) {
                Property oAction = (Property)lTrueProperties.get(iAction);
                cgReq.addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(oAction, (AbstractTransformation)oStep));
            }
            cgReq.unIndent().addSourceCode("%end; \n\n");
        }
        cgReq.unIndent().addSourceCode("%mend etls_sqlRcCheck; \n").addSourceCode("%etls_sqlRcCheck; \n\n");
    }
}

