/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.oraclebulkloader;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.OracleBulkTableLoaderTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.oraclebulkloader.OracleNameValueComboBoxModel;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class OracleBulkTableLoaderLoadTechniquePropertyTab
extends WAPropertyTab {
    private static final WAdminResource m_bundle = WAdminResource.getBundle(OracleBulkTableLoaderLoadTechniquePropertyTab.class);
    private WAComboBox m_cmbLoadMethod;
    private JCheckBox m_chkDisableConstraint;
    private JCheckBox m_chkRecreateIndex;
    private JCheckBox m_chkGatherTableStatistics;
    protected OracleBulkTableLoaderTransformModel m_model;
    private OracleNameValueComboBoxModel m_mdlLoadMethod;
    private OracleBulkTableLoaderModelListener m_listener;
    private ActionListener m_cmbLoadMethodListener = null;
    private ActionListener m_chkDisableConstraintListener = null;
    private ActionListener m_chkRecreateIndexListener = null;
    private ActionListener m_chkGatherTableStatisticsListener = null;

    public OracleBulkTableLoaderLoadTechniquePropertyTab(OracleBulkTableLoaderTransformModel obj) {
        this.setName(m_bundle.getString("TableLoaderTransformAdapter.LoadTechniquePropertyTab.Title.txt"));
        this.m_model = obj;
        this.m_listener = new OracleBulkTableLoaderModelListener();
        this.m_model.getModel().addModelListener((IModelListener)this.m_listener);
        this.m_mdlLoadMethod = this.getLoadMethodModel(this.m_model);
        this.setHelpProduct("wdb");
        this.setHelpTopic("load_technique_oracle_bulk");
        this.initialize();
        this.initializeLayout();
        this.initializeModels();
    }

    protected OracleNameValueComboBoxModel createNewComboModel(String name, boolean sorted) {
        return new OracleNameValueComboBoxModel(m_bundle, "OracleBulkTableLoaderTransformAdapter." + name, sorted);
    }

    protected OracleNameValueComboBoxModel getLoadMethodModel(OracleBulkTableLoaderTransformModel model) {
        OracleNameValueComboBoxModel loadMethod = this.createNewComboModel("LoadMethod", false);
        List loadMethods = model.getLoadMethods();
        for (int i = 0; i < loadMethods.size(); ++i) {
            String methodName = (String)loadMethods.get(i);
            loadMethod.addItem(methodName);
        }
        return loadMethod;
    }

    public void initialize() {
        this.m_cmbLoadMethod = new WAComboBox();
        this.m_cmbLoadMethodListener = new cLoadMethodListener();
        this.m_cmbLoadMethod.addActionListener(this.m_cmbLoadMethodListener);
        this.listenForDataChangesTo((JComboBox)this.m_cmbLoadMethod);
        this.m_chkDisableConstraint = WsUIUtilities.createCheckBox((WAdminResource)m_bundle, (String)"OracleBulkTableLoader.DisableConstraints", (int)5);
        this.m_chkRecreateIndex = WsUIUtilities.createCheckBox((WAdminResource)m_bundle, (String)"OracleBulkTableLoader.ReplaceIndexes", (int)5);
        this.m_chkGatherTableStatistics = WsUIUtilities.createCheckBox((WAdminResource)m_bundle, (String)"OracleBulkTableLoader.GatherStatistics", (int)5);
        this.m_chkDisableConstraintListener = new cDisableConstraintsCheckListener();
        this.m_chkDisableConstraint.addActionListener(this.m_chkDisableConstraintListener);
        this.listenForDataChangesTo(this.m_chkDisableConstraint);
        this.m_chkRecreateIndexListener = new cRecreateIndexesCheckListener();
        this.m_chkRecreateIndex.addActionListener(this.m_chkRecreateIndexListener);
        this.listenForDataChangesTo(this.m_chkRecreateIndex);
        this.m_chkGatherTableStatisticsListener = new cGatherStatisticsCheckListener();
        this.m_chkGatherTableStatistics.addActionListener(this.m_chkGatherTableStatisticsListener);
        this.listenForDataChangesTo(this.m_chkGatherTableStatistics);
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        JPanel emptyPanel = new JPanel();
        this.add(this.createLoadMethodPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createCheckboxPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createResetPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(emptyPanel, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel createLoadMethodPanel() {
        JLabel lblLoadMethod = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbLoadMethod, (WAdminResource)m_bundle, (String)"TableLoader.LoadStyle");
        WAPanel panel = new WAPanel();
        panel.setLayout((LayoutManager)new GridBagLayout());
        panel.add((Component)lblLoadMethod, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        panel.add((Component)this.m_cmbLoadMethod, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    protected JPanel createCheckboxPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add((Component)this.m_chkRecreateIndex, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.m_chkDisableConstraint, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.m_chkGatherTableStatistics, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected JPanel createResetPanel() {
        JButton btnReset = WsUIUtilities.createTextButton((WsAbstractAction)new cResetDefaultsAction());
        JPanel panel = new JPanel();
        panel.add(btnReset);
        return panel;
    }

    private void initializeModels() {
        this.setListeningForChanges(false);
        this.m_cmbLoadMethod.setModel((ComboBoxModel)this.m_mdlLoadMethod);
        this.handleLoadMethodChanged();
        this.handleDisableConstraintsChanged();
        this.handleRecreateIndexesChanged();
        this.handleGatherTableStatisticsChanged();
        this.setListeningForChanges(true);
    }

    public void setEditable(boolean bEditable) {
        bEditable = bEditable && this.m_model.getDataTargetsCount() > 0;
        this.m_cmbLoadMethod.setEnabled(bEditable);
        this.m_chkDisableConstraint.setEnabled(bEditable);
        this.m_chkRecreateIndex.setEnabled(bEditable);
        this.m_chkGatherTableStatistics.setEnabled(bEditable);
        if (this.m_model.getDataTargetsCount() > 0) {
            // empty if block
        }
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_model.getModel().removeModelListener((IModelListener)this.m_listener);
        this.m_cmbLoadMethod.removeActionListener(this.m_cmbLoadMethodListener);
        this.m_chkDisableConstraint.removeActionListener(this.m_chkDisableConstraintListener);
        this.m_chkRecreateIndex.removeActionListener(this.m_chkRecreateIndexListener);
        this.m_chkGatherTableStatistics.removeActionListener(this.m_chkGatherTableStatisticsListener);
    }

    public boolean validateData() {
        return true;
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        this.setEditable(this.isEnabled());
        this.setDataChanged(false);
        this.setListeningForChanges(true);
    }

    private void resetToDefaultValues() {
        this.m_model.resetModelDefaults();
    }

    protected void handleModelChanged(ModelEvent ev) {
        String type = ev.getType();
        if (type.equals("OracleBulkTableLoaderTransformModel:LoadMethodChanged")) {
            Workspace.getDefaultLogger().debug((Object)"Load method changed event");
            this.handleLoadMethodChanged();
            return;
        }
        if (type.equals("OracleBulkTableLoaderTransformModel:DisableConstraintsChanged")) {
            Workspace.getDefaultLogger().debug((Object)"Disable constraints changed event");
            this.handleDisableConstraintsChanged();
            return;
        }
        if (type.equals("OracleBulkTableLoaderTransformModel:RecreateIndexesChanged")) {
            Workspace.getDefaultLogger().debug((Object)"Recreate indexes changed event");
            this.handleRecreateIndexesChanged();
            return;
        }
        if (type.equals("OracleBulkTableLoaderTransformModel:GatherTableStatisticsChanged")) {
            Workspace.getDefaultLogger().debug((Object)"Gather Table Statistics changed event");
            this.handleGatherTableStatisticsChanged();
            return;
        }
    }

    protected void handleLoadMethodChanged() {
        this.m_mdlLoadMethod.setSelectedValue(this.m_model.getLoadMethod());
    }

    protected void handleRecreateIndexesChanged() {
        this.m_chkRecreateIndex.setSelected(this.m_model.isRecreateIndexesChecked());
    }

    protected void handleDisableConstraintsChanged() {
        this.m_chkDisableConstraint.setSelected(this.m_model.isDisableConstraintsChecked());
    }

    protected void handleGatherTableStatisticsChanged() {
        this.m_chkGatherTableStatistics.setSelected(this.m_model.isGatherTableStatisticsChecked());
    }

    private class OracleBulkTableLoaderModelListener
    implements IModelListener {
        private OracleBulkTableLoaderModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (!OracleBulkTableLoaderLoadTechniquePropertyTab.this.isListeningForChanges()) {
                return;
            }
            String type = ev.getType();
            if (type == "ModelController:UnknownChanges") {
                OracleBulkTableLoaderLoadTechniquePropertyTab.this.moveDataToView();
                return;
            }
            IObject object = ev.getModelObject();
            if (object != OracleBulkTableLoaderLoadTechniquePropertyTab.this.m_model) {
                return;
            }
            OracleBulkTableLoaderLoadTechniquePropertyTab.this.handleModelChanged(ev);
        }
    }

    private class cLoadMethodListener
    implements ActionListener {
        private cLoadMethodListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String value = ((OracleNameValueComboBoxModel)OracleBulkTableLoaderLoadTechniquePropertyTab.this.m_cmbLoadMethod.getModel()).getSelectedValue();
            if (value.length() > 0) {
                OracleBulkTableLoaderLoadTechniquePropertyTab.this.m_model.setLoadMethod(value);
            }
        }
    }

    private class cDisableConstraintsCheckListener
    implements ActionListener {
        private cDisableConstraintsCheckListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            boolean val = OracleBulkTableLoaderLoadTechniquePropertyTab.this.m_chkDisableConstraint.isSelected();
            OracleBulkTableLoaderLoadTechniquePropertyTab.this.m_model.setDisableConstraintsChecked(val);
        }
    }

    private class cRecreateIndexesCheckListener
    implements ActionListener {
        private cRecreateIndexesCheckListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            boolean val = OracleBulkTableLoaderLoadTechniquePropertyTab.this.m_chkRecreateIndex.isSelected();
            OracleBulkTableLoaderLoadTechniquePropertyTab.this.m_model.setRecreateIndexesChecked(val);
        }
    }

    private class cGatherStatisticsCheckListener
    implements ActionListener {
        private cGatherStatisticsCheckListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            boolean val = OracleBulkTableLoaderLoadTechniquePropertyTab.this.m_chkGatherTableStatistics.isSelected();
            OracleBulkTableLoaderLoadTechniquePropertyTab.this.m_model.setGatherTableStatisticsChecked(val);
        }
    }

    private class cResetDefaultsAction
    extends WsAbstractAction {
        public cResetDefaultsAction() {
            super(m_bundle, "TableLoader.Reset");
        }

        public void actionPerformed(ActionEvent event) {
            OracleBulkTableLoaderLoadTechniquePropertyTab.this.resetToDefaultValues();
        }
    }

    private class cListCellRenderer
    extends DefaultListCellRenderer {
        private cListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            WsCompoundIcon iconCompound = new WsCompoundIcon();
            iconCompound.setIconGap(1);
            IColumn icol = (IColumn)value;
            this.setText(icol.getName());
            int type = icol.getType();
            String sType = WsColumnMetadataUtil.getDataNumericType();
            if (type == 0) {
                sType = WsColumnMetadataUtil.getDataCharacterType();
            }
            iconCompound.addIcon(WsColumnMetadataUtil.getColumnTypeIcon((String)sType));
            if (iconCompound.getIconCount() == 0) {
                this.setIcon(null);
            } else {
                this.setIcon((Icon)iconCompound);
            }
            return this;
        }
    }
}

