/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.lookup.visuals;

import com.sas.etl.models.data.IColumn;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsColumnMetadataUtil;
import javax.swing.Icon;

class TempColumn {
    private static WAdminResource bundle = WAdminResource.getBundle(TempColumn.class);
    public static final String SOURCE_ROW = "etls_source_row";
    public static final String LOOKUP_TABLE = "etls_lookup_table";
    public static final String EXCEPTION_CONDITION = "etls_exception_cond";
    public static final String EXCEPTION_ACTION = "etls_exception_action";
    private String m_sDisplayName;
    private String m_sDesc;
    private String m_sName;
    private int m_iSASType;
    private int m_iLength;

    public TempColumn(String sColumnType) {
        this.m_sName = sColumnType;
        if (sColumnType.equals(SOURCE_ROW)) {
            this.m_sDisplayName = bundle.getString("TempColumn.SourceRowColumnName.txt");
            this.m_sDesc = bundle.getString("TempColumn.SourceRowColumnDesc.txt");
            this.m_iSASType = 1;
            this.m_iLength = 8;
        } else if (sColumnType.equals(LOOKUP_TABLE)) {
            this.m_sDisplayName = bundle.getString("TempColumn.LookupTableColumnName.txt");
            this.m_sDesc = bundle.getString("TempColumn.LookupTableColumnDesc.txt");
            this.m_iSASType = 0;
            this.m_iLength = 41;
        } else if (sColumnType.equals(EXCEPTION_CONDITION)) {
            this.m_sDisplayName = bundle.getString("TempColumn.ExceptionConditionColumnName.txt");
            this.m_sDesc = bundle.getString("TempColumn.ExceptionConditionColumnDesc.txt");
            this.m_iSASType = 0;
            this.m_iLength = 32;
        } else if (sColumnType.equals(EXCEPTION_ACTION)) {
            this.m_sDisplayName = bundle.getString("TempColumn.ExceptionActionColumnName.txt");
            this.m_sDesc = bundle.getString("TempColumn.ExceptionActionColumnDesc.txt");
            this.m_iSASType = 0;
            this.m_iLength = 32;
        }
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.m_sName;
    }

    public int getType() {
        return this.m_iSASType;
    }

    public int getLength() {
        return this.m_iLength;
    }

    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    public Icon getIcon() {
        return WsColumnMetadataUtil.getColumnTypeIcon((int)this.m_iSASType);
    }

    public String getToolTip() {
        return this.m_sDesc;
    }

    public void setColumnAttributes(IColumn column) {
        column.setName(this.m_sName);
        column.setDescription(this.m_sDesc);
        column.setType(this.m_iSASType);
        column.setLength(this.m_iLength);
    }

    public boolean equals(IColumn column) {
        return this.m_sName.equals(column.getName()) && this.m_iSASType == column.getType() && this.m_iLength == column.getLength();
    }

    public int hashcode() {
        return super.hashCode();
    }
}

