/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.lookup.visuals;

import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.transforms.lookup.LookupMapping;
import com.sas.etl.models.job.transforms.lookup.LookupTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class LookupTableModel
extends WsAbstractTableModel {
    private WAdminResource bundle = WAdminResource.getBundle(LookupTableModel.class);
    private static final int METADATA_NAME_COLUMN = 0;
    private static final int PHYSICAL_NAME_COLUMN = 1;
    private static final int METADATA_DESC_COLUMN = 2;
    private static final int LOOKUP_MAPPING = 3;
    private static final int VISIBLE_COLUMNS = 3;
    private static final int HIDDEN_COLUMNS = 1;
    private static final int COLUMN_WIDTH = 200;
    private LookupTransformModel m_lookup;

    public LookupTableModel(LookupTransformModel lookup) {
        this.m_lookup = lookup;
        this.createColumnDefinitions();
    }

    public void setLookupModel(LookupTransformModel lookup) {
        this.m_lookup = lookup;
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, this.bundle.getString("LookupTableModel.MDNameColumn.name.txt"), 200);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new WsStringTableColumn(1, this.bundle.getString("LookupTableModel.PhysNameColumn.name.txt"), 200);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2] = new WsStringTableColumn(2, this.bundle.getString("LookupTableModel.MDDescColumn.name.txt"), 200);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3] = new WsMetadataTableColumn();
    }

    public void populateStore() {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    public void moveDataToModel() throws MdException, RemoteException {
        if (this.m_lookup == null) {
            return;
        }
        this.clear();
        List lLookupMappings = this.m_lookup.getLookupMappings();
        for (int iMapping = 0; iMapping < lLookupMappings.size(); ++iMapping) {
            LookupMapping lookupMapping = (LookupMapping)lLookupMappings.get(iMapping);
            IPhysicalTable lookupTable = lookupMapping.getLookupTable();
            String sTableName = lookupTable.getName();
            String sPhysicalName = lookupTable.getSASTableName();
            ILibrary library = lookupTable.getLibrary();
            if (library != null) {
                sPhysicalName = library.getName() + "." + sPhysicalName;
            }
            String sTableDesc = lookupTable.getDescription();
            ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
            alRow.add(sTableName);
            alRow.add(sPhysicalName);
            alRow.add(sTableDesc);
            alRow.add((String)lookupMapping);
            this.m_lData.add(alRow);
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() {
    }

    public int getColumnCount() {
        return 3;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public LookupMapping getLookupMapping(int iRow) {
        return (LookupMapping)this.getValueAt(iRow, 3);
    }
}

