/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.lookup.visuals;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.job.transforms.lookup.LookupTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.lookup.visuals.ChooseColumnsPanel;
import com.sas.wadmin.transforms.lookup.visuals.TempColumn;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.TransformUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class ErrorsTab
extends WAPropertyTab {
    public static final int ERROR_TABLE = 0;
    public static final int EXCEPTION_TABLE = 1;
    private static final String[] arrLimitActionTypes = new String[]{"Abort_the_job", "Abort_the_step", "Ignore_all_remaining_errors"};
    private static WAdminResource bundle = WAdminResource.getBundle(ErrorsTab.class);
    private LookupTransformModel m_lookup;
    private IPhysicalTable m_errorTable;
    private IPhysicalTable m_exceptionTable;
    private JCheckBox m_cbErrorTable;
    private JButton m_btnErrorColumns;
    private JCheckBox m_cbExceptionTable;
    private JButton m_btnExceptionColumns;
    private JCheckBox m_cbErrorLimit;
    private WAIntTextField m_tfErrorLimit;
    private WAComboBox m_cmbLimitAction;
    private WsAbstractAction m_actErrorColumns;
    private WsAbstractAction m_actExceptionColumns;

    public ErrorsTab(LookupTransformModel lookup) {
        this.m_lookup = lookup;
        this.setName(bundle.getString("ErrorsTab.Title.txt"));
        this.setHelpProduct("wdb");
        this.setHelpTopic("errors_tab");
        this.initialize();
    }

    protected void initialize() {
        this.m_actErrorColumns = new cChooseErrorColumnsAction("ErrorsTab.actErrorColumns");
        this.m_actExceptionColumns = new cChooseExceptionColumnsAction("ErrorsTab.actExceptionColumns");
        this.m_cbErrorTable = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ErrorsTab.cbErrorTable");
        this.m_cbExceptionTable = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ErrorsTab.cbExceptionTable");
        this.m_cbErrorLimit = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ErrorsTab.cbErrorLimit");
        this.m_btnErrorColumns = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actErrorColumns);
        this.m_btnExceptionColumns = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actExceptionColumns);
        this.m_tfErrorLimit = new WAIntTextField(false);
        this.m_tfErrorLimit.setPreferredSize(new Dimension(75, 20));
        JLabel lblErrorLimit = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_tfErrorLimit, (WAdminResource)bundle, (String)"ErrorsTab.lblErrorLimit");
        this.m_cmbLimitAction = new WAComboBox();
        this.m_cmbLimitAction.addItem((Object)bundle.getString("ErrorsTab.Abort_the_job.txt"));
        this.m_cmbLimitAction.addItem((Object)bundle.getString("ErrorsTab.Abort_the_step.txt"));
        this.m_cmbLimitAction.addItem((Object)bundle.getString("ErrorsTab.Ignore_all_remaining_errors.txt"));
        JLabel lblLimitAction = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbLimitAction, (WAdminResource)bundle, (String)"ErrorsTab.lblLimitAction");
        this.m_cbErrorTable.addActionListener(new cErrorCheckBoxActionListener());
        this.m_cbExceptionTable.addActionListener(new cExceptionCheckBoxActionListener());
        this.m_cbErrorLimit.addActionListener(new cErrorLimitCheckBoxActionListener());
        this.listenForDataChangesTo(this.m_cbErrorTable);
        this.listenForDataChangesTo(this.m_cbExceptionTable);
        this.listenForDataChangesTo(this.m_cbErrorLimit);
        this.listenForDataChangesTo((JTextComponent)this.m_tfErrorLimit);
        this.listenForDataChangesTo((JComboBox)this.m_cmbLimitAction);
        this.setLayout(new GridBagLayout());
        this.add(this.m_cbErrorTable, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_btnErrorColumns, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 18, 0, new Insets(10, 35, 0, 0), 0, 0));
        this.add(this.m_cbExceptionTable, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 18, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add(this.m_btnExceptionColumns, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 18, 0, new Insets(10, 35, 0, 0), 0, 0));
        this.add(this.m_cbErrorLimit, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 18, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add(lblErrorLimit, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 35, 0, 0), 0, 0));
        this.add((Component)this.m_tfErrorLimit, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add(lblLimitAction, new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 35, 0, 0), 0, 0));
        this.add((Component)this.m_cmbLimitAction, new GridBagConstraints(1, 6, 1, 1, 0.0, 1.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(2, 6, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (this.hasDataChanged()) {
            return;
        }
        this.setListeningForChanges(false);
        this.m_errorTable = this.m_lookup.getErrorTable();
        if (this.m_errorTable != null) {
            this.m_cbErrorTable.setSelected(true);
        } else {
            this.m_btnErrorColumns.setEnabled(false);
        }
        this.m_exceptionTable = this.m_lookup.getExceptionTable();
        if (this.m_exceptionTable != null) {
            this.m_cbExceptionTable.setSelected(true);
        } else {
            this.m_btnExceptionColumns.setEnabled(false);
        }
        this.m_cmbLimitAction.setSelectedItem((Object)bundle.getString("ErrorsTab." + this.m_lookup.getErrorLimitAction() + ".txt"));
        int iErrorLimit = this.m_lookup.getErrorLimit();
        if (iErrorLimit > -1) {
            this.m_cbErrorLimit.setSelected(true);
            this.m_tfErrorLimit.setValue(iErrorLimit);
        } else {
            this.m_tfErrorLimit.setEditable(false);
            this.m_cmbLimitAction.setEnabled(false);
        }
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_lookup.setErrorLimit(this.m_cbErrorLimit.isSelected() ? this.m_tfErrorLimit.getValue() : -1);
        this.m_lookup.setErrorLimitAction(arrLimitActionTypes[this.m_cmbLimitAction.getSelectedIndex()]);
        this.updateTables();
    }

    private void updateTables() {
        if (this.m_cbErrorTable.isSelected()) {
            if (this.m_errorTable != this.m_lookup.getErrorTable()) {
                this.m_lookup.setErrorTable(this.m_errorTable);
            }
        } else if (this.m_lookup.getErrorTable() != null) {
            this.m_lookup.setErrorTable(null);
        }
        if (this.m_cbExceptionTable.isSelected()) {
            if (this.m_exceptionTable != this.m_lookup.getExceptionTable()) {
                this.m_lookup.setExceptionTable(this.m_exceptionTable);
            }
        } else if (this.m_lookup.getExceptionTable() != null) {
            this.m_lookup.setExceptionTable(null);
        }
    }

    public boolean validateData() {
        int iMessageChoice;
        if (this.m_cbErrorLimit.isSelected() && this.m_tfErrorLimit.getText().length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("ErrorsTab.EmptyErrorLimit.txt"), (int)0);
            this.m_tfErrorLimit.requestFocus();
            return false;
        }
        String sMessage = null;
        if (this.m_lookup.getErrorTable() != null && !this.m_cbErrorTable.isSelected()) {
            sMessage = bundle.getString("ErrorsTab.RemoveErrorTable.msg.txt");
        }
        if (this.m_lookup.getExceptionTable() != null && !this.m_cbExceptionTable.isSelected()) {
            sMessage = sMessage == null ? bundle.getString("ErrorsTab.RemoveExceptionTable.msg.txt") : bundle.getString("ErrorsTab.RemoveBothTables.msg.txt");
        }
        return sMessage == null || (iMessageChoice = MessageUtil.displayMessage((String)sMessage, (String)bundle.getString("ErrorsTab.RemoveTables.title.txt"), (int)1, (int)0)) != 1;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_cbErrorTable.setEnabled(bEditable);
        this.m_cbExceptionTable.setEnabled(bEditable);
        this.m_cbErrorLimit.setEnabled(bEditable);
        this.m_tfErrorLimit.setEditable(bEditable);
        this.m_cmbLimitAction.setEnabled(bEditable);
    }

    private IWorkTable createErrorWorkTable() {
        IWorkTable errorTable = this.m_lookup.getModel().getObjectFactory().createNewWorkTable(this.m_lookup.getID());
        errorTable.setName(bundle.getString("ErrorsTab.ErrorTableName.txt"));
        errorTable.setSASTableName(TransformUtil.createWorkTableName());
        this.addDefaultErrorColumns(errorTable);
        return errorTable;
    }

    private IWorkTable createExceptionWorkTable() {
        IWorkTable exceptionTable = this.m_lookup.getModel().getObjectFactory().createNewWorkTable(this.m_lookup.getID());
        exceptionTable.setName(bundle.getString("ErrorsTab.ExceptionTableName.txt"));
        exceptionTable.setSASTableName(TransformUtil.createWorkTableName());
        this.addDefaultExceptionColumns(exceptionTable);
        return exceptionTable;
    }

    private void addDefaultErrorColumns(IWorkTable errorTable) {
        errorTable.addColumn(this.createColumn(new TempColumn("etls_source_row"), (IPhysicalTable)errorTable));
        IPhysicalTable sourceTable = this.m_lookup.getSourceTable();
        if (sourceTable != null) {
            IColumn[] aSourceColumns = sourceTable.getColumns();
            for (int i = 0; i < aSourceColumns.length; ++i) {
                IColumn newColumn = this.m_lookup.getModel().getObjectFactory().createNewColumn(errorTable.getID());
                aSourceColumns[i].copy(newColumn);
                errorTable.addColumn(newColumn);
            }
        }
    }

    private void addDefaultExceptionColumns(IWorkTable exceptionTable) {
        exceptionTable.addColumn(this.createColumn(new TempColumn("etls_source_row"), (IPhysicalTable)exceptionTable));
        exceptionTable.addColumn(this.createColumn(new TempColumn("etls_lookup_table"), (IPhysicalTable)exceptionTable));
        exceptionTable.addColumn(this.createColumn(new TempColumn("etls_exception_cond"), (IPhysicalTable)exceptionTable));
        exceptionTable.addColumn(this.createColumn(new TempColumn("etls_exception_action"), (IPhysicalTable)exceptionTable));
    }

    private IColumn createColumn(TempColumn tempColumn, IPhysicalTable table) {
        IColumn newColumn = this.m_lookup.getModel().getObjectFactory().createNewColumn(table.getID());
        tempColumn.setColumnAttributes(newColumn);
        return newColumn;
    }

    private boolean launchChooseColumnsDialog(IPhysicalTable table, int iTableType) {
        ChooseColumnsPanel pnlChooseColumns = new ChooseColumnsPanel(this.m_lookup, table, iTableType);
        String sTitle = iTableType == 0 ? bundle.getString("ErrorsTab.ChooseErrorColumns.txt") : bundle.getString("ErrorsTab.ChooseExceptionColumns.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnlChooseColumns);
        dlg.setEditable(this.m_bEditable);
        dlg.setResizable(true);
        dlg.show();
        if (dlg.getReturnValue() == 1) {
            this.setDataChanged(true);
            return true;
        }
        return false;
    }

    private class cChooseErrorColumnsAction
    extends WsAbstractAction {
        public cChooseErrorColumnsAction(String sResourceKey) {
            super(bundle, sResourceKey, false);
        }

        public void actionPerformed(ActionEvent e) {
            ErrorsTab.this.launchChooseColumnsDialog(ErrorsTab.this.m_errorTable, 0);
        }
    }

    private class cChooseExceptionColumnsAction
    extends WsAbstractAction {
        public cChooseExceptionColumnsAction(String sResourceKey) {
            super(bundle, sResourceKey, false);
        }

        public void actionPerformed(ActionEvent e) {
            ErrorsTab.this.launchChooseColumnsDialog(ErrorsTab.this.m_exceptionTable, 1);
        }
    }

    private class cErrorCheckBoxActionListener
    implements ActionListener {
        private cErrorCheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ErrorsTab.this.setDataChanged(true);
            boolean bSelected = ((JCheckBox)e.getSource()).isSelected();
            ErrorsTab.this.m_btnErrorColumns.setEnabled(bSelected);
            if (bSelected && ErrorsTab.this.m_errorTable == null) {
                ErrorsTab.this.m_errorTable = (IPhysicalTable)ErrorsTab.this.createErrorWorkTable();
            }
        }
    }

    private class cExceptionCheckBoxActionListener
    implements ActionListener {
        private cExceptionCheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ErrorsTab.this.setDataChanged(true);
            boolean bSelected = ((JCheckBox)e.getSource()).isSelected();
            ErrorsTab.this.m_btnExceptionColumns.setEnabled(bSelected);
            if (bSelected && ErrorsTab.this.m_exceptionTable == null) {
                ErrorsTab.this.m_exceptionTable = (IPhysicalTable)ErrorsTab.this.createExceptionWorkTable();
            }
        }
    }

    private class cErrorLimitCheckBoxActionListener
    implements ActionListener {
        private cErrorLimitCheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ErrorsTab.this.setDataChanged(true);
            boolean bSelected = ((JCheckBox)e.getSource()).isSelected();
            ErrorsTab.this.m_tfErrorLimit.setEditable(bSelected);
            ErrorsTab.this.m_cmbLimitAction.setEnabled(bSelected);
        }
    }
}

