/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.infomap;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.transforms.infomap.InfoMapHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;

public class InfoMapFiltersTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = new WAdminResource(InfoMapFiltersTableModel.class);
    public static final int NAME_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    public static final int DESCR_COLUMN = 2;
    public static final int EXTENSION_COLUMN = 3;
    public static final int EXPRESSION_COLUMN = 1;
    protected static final int NAME_WIDTH = 100;
    protected static final int VALUE_WIDTH = 100;
    protected static final int DESCR_WIDTH = 200;
    protected static final int TOTAL_COLS = 3;
    protected static final int TOTAL_HIDDEN_COLS = 1;
    protected Root m_metadata;
    protected int[] m_aRowMappings;

    public InfoMapFiltersTableModel() {
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("InfoMapFiltersTableModel.Name.txt"), 100, 60);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("InfoMapFiltersTableModel.Value.txt"), 100, 1024);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("InfoMapFiltersTableModel.Description.txt"), 200, 200);
        this.m_aColumns[3] = new WsMetadataTableColumn();
    }

    public void setMetadataObject(Root oData) {
        this.m_metadata = oData;
    }

    public Root getMetadataObject() {
        return this.m_metadata;
    }

    public void setRowMappings(int[] aRowMappings) {
        this.m_aRowMappings = aRowMappings;
    }

    public int[] getRowMappings() {
        return this.m_aRowMappings;
    }

    public int getColumnCount() {
        return 3;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public String validateFilterExpressions() {
        String filterName = null;
        int nRows = this.m_lData.size();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            int iProperty = this.m_aRowMappings != null ? this.m_aRowMappings[iRow] : iRow;
            String sName = (String)this.getValueAt(iProperty, 0);
            String vName = (String)this.getValueAt(iProperty, 1);
            if (vName.trim().length() > 0) continue;
            filterName = sName;
            break;
        }
        return filterName;
    }

    public void populateStore() throws MdException, RemoteException {
        Vector<String> lAssociations = new Vector<String>();
        lAssociations.add("PropertySets");
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_metadata, null, lAssociations, null, 8, true);
    }

    public void moveDataToModel() throws MdException, RemoteException {
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        AssociationList alPropertySets = this.m_metadata.getPropertySets();
        AssociationList allProperties = null;
        for (int i = 0; i < alPropertySets.size(); ++i) {
            PropertySet propertySet = (PropertySet)alPropertySets.get(i);
            if (!propertySet.getSetRole().equalsIgnoreCase(InfoMapHandler.PROPERTYSET_ROLE_FILTER)) continue;
            allProperties = propertySet.getProperties();
            break;
        }
        int iRow = 0;
        if (allProperties != null) {
            nRows = allProperties.size();
            for (iRow = 0; iRow < nRows; ++iRow) {
                Property oProperty = (Property)allProperties.get(iRow);
                ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
                alRow.add(oProperty.getName());
                alRow.add(oProperty.getDefaultValue());
                alRow.add(oProperty.getDesc());
                alRow.add((String)oProperty);
                this.m_lData.add(alRow);
            }
        }
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        AssociationList allPropertySets = this.m_metadata.getPropertySets(false);
        PropertySet filtersPropertySet = null;
        for (int i = 0; i < allPropertySets.size() && !(filtersPropertySet = (PropertySet)allPropertySets.get(i)).getSetRole().equalsIgnoreCase(InfoMapHandler.PROPERTYSET_ROLE_FILTER); ++i) {
            filtersPropertySet = null;
        }
        if (filtersPropertySet == null) {
            filtersPropertySet = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_metadata.getObjectStore(), InfoMapHandler.PROPERTYSET_ROLE_FILTER, "PropertySet", this.m_metadata.getRepositoryID());
            filtersPropertySet.setSetRole(InfoMapHandler.PROPERTYSET_ROLE_FILTER);
            allPropertySets.add((Object)filtersPropertySet);
            this.m_metadata.setPropertySets(allPropertySets);
        }
        AssociationList allProperties = filtersPropertySet.getProperties();
        int nProperties = allProperties.size();
        ArrayList allOldProperties = new ArrayList(nProperties);
        allOldProperties.addAll(allProperties);
        allProperties.removeAllElements();
        int nRows = this.m_lData.size();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            int iProperty = this.m_aRowMappings != null ? this.m_aRowMappings[iRow] : iRow;
            String sName = (String)this.getValueAt(iProperty, 0);
            Property oProperty = (Property)this.getValueAt(iProperty, 3);
            if (oProperty == null) {
                oProperty = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_metadata.getObjectStore(), sName, "Property", this.m_metadata.getRepositoryID());
                PropertyType oPropertyType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_metadata.getObjectStore(), "String", "PropertyType", this.m_metadata.getRepositoryID());
                oPropertyType.setSQLType(12);
                oProperty.setName(sName);
                oProperty.setOwningType(oPropertyType);
                this.setValueAt(oProperty, iProperty, 3);
            } else if (!oProperty.getName().equals(sName)) {
                oProperty.setName(sName);
            }
            String sValue = (String)this.getValueAt(iProperty, 1);
            if (!oProperty.getDefaultValue().equals(sValue)) {
                oProperty.setDefaultValue(sValue);
            }
            String sDescr = (String)this.getValueAt(iProperty, 2);
            if (!oProperty.getDesc().equals(sDescr)) {
                oProperty.setDesc(sDescr);
            }
            allProperties.add((Object)oProperty);
            if (!allOldProperties.contains(oProperty)) continue;
            allOldProperties.remove(oProperty);
        }
        filtersPropertySet.setProperties(allProperties);
        MdObjectStore store = (MdObjectStore)this.m_metadata.getObjectStore();
        for (int i = 0; i < allOldProperties.size(); ++i) {
            Property deleteProperty = (Property)allOldProperties.get(i);
            store.deleteObject((CMetadata)deleteProperty);
        }
    }
}

