/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.hpf;

import com.sas.workspace.WAdminResource;
import javax.swing.DefaultListModel;

public class NameValueListModel
extends DefaultListModel {
    private static WAdminResource bundle = WAdminResource.getBundle(NameValueListModel.class);
    private String m_bundleKey;
    private boolean m_bSorted = false;

    public NameValueListModel(String bundleKey, boolean sorted) {
        this.m_bundleKey = bundleKey;
        this.m_bSorted = sorted;
    }

    public NameValueListModel addItem(String value) {
        if (this.containsItem(value)) {
            return this;
        }
        NameValueObject object = new NameValueObject(value, bundle.getString(this.m_bundleKey + "." + value + ".desc.txt"));
        if (this.m_bSorted) {
            int x;
            int iElement;
            String sObject = object.toString();
            int nElements = this.getSize();
            for (iElement = 0; iElement < nElements && (x = sObject.compareToIgnoreCase(this.getElementAt(iElement).toString())) >= 0; ++iElement) {
            }
            super.insertElementAt(object, iElement);
        } else {
            super.addElement(object);
        }
        return this;
    }

    public void removeItem(String value) {
        for (int i = 0; i < this.getSize(); ++i) {
            NameValueObject n = (NameValueObject)this.get(i);
            if (!n.getValue().equals(value)) continue;
            this.removeElementAt(i);
        }
    }

    private boolean containsItem(String value) {
        for (int i = 0; i < this.getSize(); ++i) {
            NameValueObject n = (NameValueObject)this.get(i);
            if (!n.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public String getValue(int i) {
        return ((NameValueObject)this.get(i)).getValue();
    }

    public String getBundleKey() {
        return this.m_bundleKey;
    }

    public void setBundleKey(String key) {
        this.m_bundleKey = key;
    }

    private class NameValueObject {
        private String m_name;
        private String m_value;

        public NameValueObject(String value, String name) {
            this.m_name = !value.equals(name) ? name + " (" + value + ")" : value;
            this.m_value = value;
        }

        public String toString() {
            return this.m_name;
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }
    }
}

