/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.fork;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.wadmin.transforms.fork.ForkPropertyHandler;
import com.sas.wadmin.transforms.fork.ForkSourceColumnsTableModel;
import com.sas.wadmin.transforms.fork.ForkUtil;
import com.sas.wadmin.transforms.fork.ParameterColumnsTableModel;
import com.sas.wadmin.visuals.ColumnsTableNameCellRenderer;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsMapping;
import com.sas.workspace.WsObjectListModelEvent;
import com.sas.workspace.WsObjectListModelListener;
import com.sas.workspace.WsObjectSelectionEvent;
import com.sas.workspace.WsObjectSelectionListener;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableMappingsPanel;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.undo.UndoManager;

public class ParameterMappingPropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ParameterMappingPropertyTab.class);
    private static final boolean g_bGotoServer = true;
    public static final String ROW_NUMBER_COLUMN = "_n_";
    private static final int MIN_TABLE_WIDTH = 100;
    private static final int MIN_TABLE_HEIGHT = 150;
    private static final int PREF_TABLE_WIDTH = 200;
    private static final int PREF_TABLE_HEIGHT = 200;
    private static final int MIN_MAPPINGS_WIDTH = 100;
    private static final int MIN_MAPPINGS_HEIGHT = 150;
    private static final int PREF_MAPPINGS_WIDTH = 100;
    private static final int PREF_MAPPINGS_HEIGHT = 200;
    private WAUndoManager m_TargetTableUndoManager = new WAUndoManager();
    private TransformationStep m_metadata;
    private ClassifierMap m_classifierMap;
    private boolean m_bMultipleSourceColumnsEnabled = false;
    private ForkPropertyHandler m_propertyHandler;
    private ForkSourceColumnsTableModel m_mdlSource;
    private ParameterColumnsTableModel m_mdlTarget;
    private static final String SOURCE_SETTINGS_KEY = "ParameterMappingPropertyTab.Source.SourceTable";
    private static final String TARGET_SETTINGS_KEY = "ParameterMappingPropertyTab.Target.TargetTable";
    public static final String PARAMETER_PROPERTY_SET = "PARAMETERPROPERTYSET";
    private WsTable m_tblSource;
    private WsTable m_tblTarget;
    private JScrollPane m_scrSource;
    private JScrollPane m_scrTarget;
    private JLabel m_lblSource;
    private JLabel m_lblTarget;
    private WsTableMappingsPanel m_pnlMappings;
    private JButton m_btnExpand;
    private JButton m_btnCollapse;
    private ListSelectionListener m_lsnrTableSelection;
    private TableModelListener m_lsnrTargetTableModel;
    private WsTableRowModelListener m_lsnrTargetTableRowModel;
    private WsObjectListModelListener m_lsnrMappingsModel;
    private WsObjectSelectionListener m_lsnrMappingsSelection;
    private WsPopupMenuRequestListener m_lsnrSourceTablePopup;
    private WsPopupMenuRequestListener m_lsnrTargetTablePopup;
    private WsPopupMenuRequestListener m_lsnrMappingsPanelPopup;
    private WsAbstractAction m_actNewMapping;
    private WsAbstractAction m_actCommonDelete;
    private WsAbstractAction m_actDeleteMappings;
    private WsAbstractAction m_actSelectAll;
    private WsAbstractAction m_actSelectAllColumns;
    private WsAbstractAction m_actQuickMap;
    private WsAbstractAction m_actExpand;
    private WsAbstractAction m_actCollapse;
    protected boolean m_bIgnoreActionUpdates;
    protected boolean m_bExpanded;

    public ParameterMappingPropertyTab(TransformationStep metadata) {
        this.m_metadata = metadata;
        this.setHelpTopic("fork_params_map_tab");
        this.initialize();
    }

    protected void initialize() {
        this.createActions();
        this.createListeners();
        this.createSourceTable();
        this.createTargetTable();
        this.createMappingsPanel();
        this.createExpandCollapseComponents();
        this.setLayout(new GridBagLayout());
        this.layoutComponentsNormal();
    }

    protected void createMappingsPanel() {
        this.m_pnlMappings = new WsTableMappingsPanel(this.m_tblSource, this.m_tblTarget);
        this.m_pnlMappings.setPreferredSize(new Dimension(100, 200));
        this.m_pnlMappings.setMinimumSize(new Dimension(100, 150));
        this.m_pnlMappings.getMappingsModel().addObjectListModelListener(this.m_lsnrMappingsModel);
        this.m_pnlMappings.getSelectionModel().addObjectSelectionListener(this.m_lsnrMappingsSelection);
        this.m_pnlMappings.setPopupMenuRequestListener(this.m_lsnrMappingsPanelPopup);
        this.m_pnlMappings.setAutoSelectEnabled(true);
    }

    protected void createActions() {
        this.m_actNewMapping = new cNewMappingAction();
        this.m_actCommonDelete = new cCommonDeleteAction();
        this.m_actDeleteMappings = new cDeleteMappingsAction();
        this.m_actSelectAll = new cSelectAllAction();
        this.m_actQuickMap = new cQuickMapAction();
        this.m_actExpand = new cExpandAction();
        this.m_actCollapse = new cCollapseAction();
    }

    protected void createListeners() {
        this.m_lsnrTableSelection = new cTableSelectionListener();
        this.m_lsnrMappingsModel = new cMappingsModelListener();
        this.m_lsnrMappingsSelection = new cMappingsSelectionListener();
        this.m_lsnrMappingsPanelPopup = new cMappingsPanelPopupMenuRequestListener();
        this.m_lsnrSourceTablePopup = new cMappingsPanelSourceTablePopupMenuRequestListener();
        this.m_lsnrTargetTablePopup = new cMappingsPanelTargetTablePopupMenuRequestListener();
    }

    protected void createSourceTable() {
        this.m_mdlSource = new ForkSourceColumnsTableModel();
        this.m_mdlSource.setTransformationStep(this.m_metadata);
        this.m_tblSource = new WsTable((WsAbstractTableModel)this.m_mdlSource);
        this.m_tblSource.setName("Source");
        this.removeSourceTableColumns();
        this.m_tblSource.getSelectionModel().addListSelectionListener(this.m_lsnrTableSelection);
        this.m_tblSource.setEditable(false);
        this.m_tblSource.setMultipleSelectionDragEnabled(this.m_bMultipleSourceColumnsEnabled);
        this.m_tblSource.setTablePopupMenuRequestListener(this.m_lsnrSourceTablePopup);
        this.m_tblSource.setViewportPopupMenuRequestListener(this.m_lsnrSourceTablePopup);
        this.m_tblSource.getActionMap().put(this.m_actSelectAll, (Action)this.m_actSelectAll);
        this.m_tblSource.getActionMap().put(this.m_actDeleteMappings, (Action)this.m_actDeleteMappings);
        this.m_tblSource.getInputMap().put(KeyStroke.getKeyStroke(65, 2), this.m_actSelectAll);
        this.m_tblSource.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDeleteMappings);
        ColumnsTableNameCellRenderer rdrColumnName = new ColumnsTableNameCellRenderer();
        rdrColumnName.setTypeColumnIndex(4);
        int iColumnName = this.m_tblSource.convertColumnIndexToView(0);
        TableColumn colColumnName = this.m_tblSource.getColumnModel().getColumn(iColumnName);
        colColumnName.setCellRenderer((TableCellRenderer)((Object)rdrColumnName));
        this.m_tblSource.restoreSettings(SOURCE_SETTINGS_KEY);
        this.m_scrSource = new JScrollPane((Component)this.m_tblSource);
        this.m_scrSource.setMinimumSize(new Dimension(100, 150));
        this.m_scrSource.setPreferredSize(new Dimension(200, 200));
        String tableName = "";
        try {
            this.populateStore();
            if (!this.m_classifierMap.getClassifierSources().isEmpty()) {
                tableName = ((PhysicalTable)this.m_classifierMap.getClassifierSources().get(0)).getSASTableName();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_lblSource = new JLabel(bundle.formatString("ParameterMappingPropertyTab.SourceTable.txt", (Object)tableName));
        this.m_lblSource.setDisplayedMnemonic(bundle.getString("ParameterMappingPropertyTab.SourceTable.mnem").charAt(0));
        this.m_lblSource.setLabelFor((Component)this.m_tblSource);
        Dimension dimLabel = this.m_lblSource.getPreferredSize();
        this.m_lblSource.setMinimumSize(new Dimension(100, dimLabel.height));
        this.m_lblSource.setPreferredSize(new Dimension(200, dimLabel.height));
    }

    protected void createTargetTable() {
        this.m_mdlTarget = new ParameterColumnsTableModel(this.m_classifierMap);
        this.m_mdlTarget.addTableModelListener(this.m_lsnrTargetTableModel);
        this.m_tblTarget = new WsTable((WsAbstractTableModel)this.m_mdlTarget);
        this.m_tblTarget.setName("Target");
        this.m_tblTarget.setMultipleSelectionDragEnabled(true);
        this.m_tblTarget.setUndoManager((UndoManager)this.m_TargetTableUndoManager);
        this.m_tblTarget.setTablePopupMenuRequestListener(this.m_lsnrTargetTablePopup);
        this.m_tblTarget.setViewportPopupMenuRequestListener(this.m_lsnrTargetTablePopup);
        this.m_tblTarget.getSelectionModel().addListSelectionListener(this.m_lsnrTableSelection);
        ((WsDefaultTableRowModel)this.m_tblTarget.getRowModel()).addRowModelListener(this.m_lsnrTargetTableRowModel);
        this.m_tblTarget.getActionMap().put(this.m_actSelectAllColumns, (Action)this.m_actSelectAllColumns);
        this.m_tblTarget.getInputMap().put(KeyStroke.getKeyStroke(65, 2), this.m_actSelectAllColumns);
        this.m_tblTarget.restoreSettings(TARGET_SETTINGS_KEY);
        this.m_scrTarget = new JScrollPane((Component)this.m_tblTarget);
        this.m_scrTarget.setMinimumSize(new Dimension(100, 150));
        this.m_scrTarget.setPreferredSize(new Dimension(200, 200));
        this.m_lblTarget = new JLabel(bundle.getString("ParameterMappingPropertyTab.Parameter.txt"));
        this.m_lblTarget.setDisplayedMnemonic(bundle.getString("ParameterMappingPropertyTab.Parameter.mnem").charAt(0));
        this.m_lblTarget.setLabelFor((Component)this.m_tblTarget);
        Dimension dimLabel = this.m_lblTarget.getPreferredSize();
        this.m_lblTarget.setMinimumSize(new Dimension(100, dimLabel.height));
        this.m_lblTarget.setPreferredSize(new Dimension(200, dimLabel.height));
    }

    protected void removeSourceTableColumns() {
        this.removeColumn(this.m_tblSource, 2);
        this.removeColumn(this.m_tblSource, 3);
    }

    protected void createExpandCollapseComponents() {
        this.m_btnExpand = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actExpand);
        this.m_btnCollapse = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actCollapse);
    }

    protected void removeColumn(WsTable tbl, int iModelColumn) {
        int iViewColumn = tbl.convertColumnIndexToView(iModelColumn);
        if (iViewColumn != -1) {
            tbl.removeColumn(tbl.getColumnModel().getColumn(iViewColumn));
        }
    }

    public void populateStore() throws MdException, RemoteException {
        AssociationList transList;
        if (this.isStorePopulated()) {
            return;
        }
        if (!this.m_metadata.isNewObject()) {
            String sTemplate = "<Templates>";
            sTemplate = sTemplate + "<ClassifierMap><ClassifierSources/><ClassifierTargets/><SourceSpecifications/><FeatureMaps/></ClassifierMap>";
            sTemplate = sTemplate + "<Select><ClassifierSources/><ClassifierTargets/><FeatureMaps/><GroupByForSelect/></Select>";
            sTemplate = sTemplate + "<DataTable><Columns/></DataTable>";
            sTemplate = sTemplate + "<WorkTable><Columns/></WorkTable>";
            sTemplate = sTemplate + "<PhysicalTable><Columns/></PhysicalTable>";
            sTemplate = sTemplate + "<FeatureMap><FeatureSources/><FeatureTargets/><SourceCode/></FeatureMap>";
            sTemplate = sTemplate + "<GroupByClause><Columns/></GroupByClause>";
            sTemplate = sTemplate + "<MiningResult><Extensions/><TransformationSources/><TransformationTargets/><SourceCode/></MiningResult>";
            sTemplate = sTemplate + "</Templates>";
            Vector<String> vComplexAttrs = new Vector<String>();
            vComplexAttrs.add("Transformations");
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_metadata, null, vComplexAttrs, sTemplate, 12);
        }
        if (!(transList = this.m_metadata.getTransformations(false)).isEmpty()) {
            this.m_classifierMap = (ClassifierMap)transList.get(0);
            this.m_propertyHandler = new ForkPropertyHandler((Root)this.m_classifierMap, PARAMETER_PROPERTY_SET, true);
            this.setStorePopulated(true);
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_tblTarget.cancelCellEditing();
        this.setListeningForChanges(false);
        this.m_pnlMappings.removeAllMappings();
        this.m_mdlSource.moveDataToModel();
        ArrayList innerSteps = new ArrayList();
        ForkUtil.getNextSteps(this.m_metadata, innerSteps);
        this.m_mdlTarget.setInnerSteps(innerSteps);
        this.m_mdlTarget.moveDataToModel();
        for (int iTargetColumn = 0; iTargetColumn < this.m_mdlTarget.getRowCount(); ++iTargetColumn) {
            Property prop = (Property)this.m_mdlTarget.getValueAt(iTargetColumn, 4);
            if (prop == null) continue;
            if (!prop.getDefaultValue().equalsIgnoreCase(ROW_NUMBER_COLUMN)) {
                List alSourceColumns = this.m_propertyHandler.getPropertyColumns(prop.getPropertyRole());
                if (alSourceColumns == null) continue;
                for (int iSourceColumn = 0; iSourceColumn < alSourceColumns.size(); ++iSourceColumn) {
                    Column oSourceColumn = (Column)alSourceColumns.get(iSourceColumn);
                    int[] aRows = this.m_mdlSource.findRows(8, oSourceColumn);
                    if (aRows.length < 1) continue;
                    WsMapping map = new WsMapping(aRows[0], iTargetColumn, (Object)prop);
                    this.m_pnlMappings.addMapping(map);
                }
                continue;
            }
            int[] aRows = this.m_mdlSource.findRows(0, ROW_NUMBER_COLUMN);
            if (aRows.length < 1) continue;
            WsMapping map = new WsMapping(aRows[0], iTargetColumn, (Object)prop);
            this.m_pnlMappings.addMapping(map);
        }
        this.updateActions();
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        Property prop;
        if (!this.hasDataChanged()) {
            return;
        }
        List mappings = this.m_pnlMappings.getMappings();
        ArrayList<Property> mappedProperties = new ArrayList<Property>();
        for (int i = 0; i < mappings.size(); ++i) {
            WsMapping mapping = (WsMapping)mappings.get(i);
            String attrName = "OPTION." + ((PromptDefinitionInterface)this.m_mdlTarget.getValueAt(mapping.getTarget(), 5)).getPromptName();
            prop = (Property)mapping.getDataObject();
            if (!ROW_NUMBER_COLUMN.equalsIgnoreCase((String)this.m_mdlSource.getValueAt(mapping.getSource(), 0))) {
                prop = this.m_propertyHandler.setPropertyColumn((MdObjectStore)this.m_metadata.getObjectStore(), prop, attrName, (Column)this.m_mdlSource.getValueAt(mapping.getSource(), 8));
            } else {
                this.m_propertyHandler.setSpecificProperty(attrName, ROW_NUMBER_COLUMN, attrName, "", 1, null);
                prop = this.m_propertyHandler.getSpecificProperty(attrName);
            }
            mappedProperties.add(prop);
        }
        AssociationList allProperties = this.m_propertyHandler.getPropertyList();
        ArrayList<Object> propsToDelete = new ArrayList<Object>();
        if (allProperties != null) {
            for (int i = 0; i < allProperties.size(); ++i) {
                if (mappedProperties.contains(allProperties.get(i))) continue;
                prop = (Property)allProperties.get(i);
                propsToDelete.add(prop);
                for (int j = 0; j < prop.getSpecTargetTransformations().size(); ++j) {
                    propsToDelete.add(prop.getSpecTargetTransformations().get(j));
                }
            }
        }
        ((MdObjectStore)this.m_metadata.getObjectStore()).removeObjectsFromStore(propsToDelete);
        this.setDataChanged(false);
    }

    public boolean validateData() {
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.m_tblSource.saveSettings(SOURCE_SETTINGS_KEY);
        this.m_tblTarget.saveSettings(TARGET_SETTINGS_KEY);
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_pnlMappings.setDraggingFromSourceTableEnabled(editable);
        this.m_pnlMappings.setDraggingFromTargetTableEnabled(editable);
        this.m_tblTarget.setEditable(editable);
        this.updateActions();
    }

    protected void quickMap() {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        ArrayList<WsQuickMapColumn> lTargets = new ArrayList<WsQuickMapColumn>();
        for (int iTarget = 0; iTarget < this.m_tblTarget.getRowCount(); ++iTarget) {
            int iRow = this.m_tblTarget.convertRowIndexToModel(iTarget);
            String sName = (String)this.m_mdlTarget.getValueAt(iRow, 1);
            Integer iModelRow = new Integer(iRow);
            WsQuickMapColumn col = new WsQuickMapColumn(sName, iModelRow);
            lTargets.add(col);
        }
        ArrayList<WsQuickMapColumn> lSources = new ArrayList<WsQuickMapColumn>();
        for (int iSource = 0; iSource < this.m_tblSource.getRowCount(); ++iSource) {
            int iRow = this.m_tblSource.convertRowIndexToModel(iSource);
            String sName = (String)this.m_mdlSource.getValueAt(iRow, 0);
            Integer iModelRow = new Integer(iRow);
            WsQuickMapColumn col = new WsQuickMapColumn(sName, iModelRow);
            lSources.add(col);
        }
        List lMappings = ParameterMappingPropertyTab.quickMap(lSources, lTargets, false);
        this.m_pnlMappings.setAutoSelectEnabled(false);
        int nMappings = lMappings.size();
        for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
            WsMapping mapping = (WsMapping)lMappings.get(iMapping);
            WsQuickMapColumn colSource = (WsQuickMapColumn)lSources.get(mapping.getSource());
            WsQuickMapColumn colTarget = (WsQuickMapColumn)lTargets.get(mapping.getTarget());
            mapping.setSource(((Integer)colSource.getUserValue()).intValue());
            mapping.setTarget(((Integer)colTarget.getUserValue()).intValue());
            if (this.m_pnlMappings.mappingExists(mapping)) continue;
            this.m_pnlMappings.addMapping(mapping);
        }
        this.m_pnlMappings.setAutoSelectEnabled(true);
        this.m_pnlMappings.autoSelectFromMappings();
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void removeComponents() {
        if (!this.m_bExpanded) {
            this.remove(this.m_btnExpand);
        } else {
            this.remove(this.m_btnCollapse);
        }
        this.remove(this.m_lblSource);
        this.remove(this.m_scrSource);
        this.remove((Component)this.m_pnlMappings);
        this.remove(this.m_lblTarget);
        this.remove(this.m_scrTarget);
    }

    protected void layoutComponentsNormal() {
        this.add(this.m_lblSource, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_scrSource, new GridBagConstraints(0, 3, 1, 1, 0.5, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_btnExpand, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_pnlMappings, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblTarget, new GridBagConstraints(2, 2, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_scrTarget, new GridBagConstraints(2, 3, 1, 1, 0.5, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    protected void layoutComponentsExpanded() {
        this.add(this.m_btnCollapse, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblTarget, new GridBagConstraints(2, 2, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_scrTarget, new GridBagConstraints(2, 3, 1, 1, 0.5, 1.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
    }

    protected static List quickMap(List lSourceColumns, List lTargetColumns, boolean bAllowMultipleMappings) {
        ArrayList<WsMapping> lMappings = new ArrayList<WsMapping>();
        int nTargetColumns = lTargetColumns.size();
        int nSourceColumns = lSourceColumns.size();
        block0: for (int iTargetColumn = 0; iTargetColumn < nTargetColumns; ++iTargetColumn) {
            WsQuickMapColumn colTarget = (WsQuickMapColumn)lTargetColumns.get(iTargetColumn);
            for (int iSourceColumn = 0; iSourceColumn < nSourceColumns; ++iSourceColumn) {
                WsQuickMapColumn colSource = (WsQuickMapColumn)lSourceColumns.get(iSourceColumn);
                if (!colSource.getColumnName().equalsIgnoreCase(colTarget.getColumnName())) continue;
                lMappings.add(new WsMapping(iSourceColumn, iTargetColumn));
                if (!bAllowMultipleMappings) continue block0;
            }
        }
        return lMappings;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNewMapping.setActive(bActive);
        this.m_actCommonDelete.setActive(bActive);
        this.m_actSelectAll.setActive(bActive);
        this.m_actQuickMap.setActive(bActive);
    }

    protected void updateActions() {
        int iSelectedTargetRow;
        if (this.m_bIgnoreActionUpdates) {
            return;
        }
        boolean bEditable = this.isEditable();
        boolean bFirst = false;
        boolean bLast = false;
        boolean bNoMappings = true;
        int[] aSelectedSourceRows = this.m_tblSource.getSelectedRowsFromSelectedCells();
        int[] aSelectedTargetRows = this.m_tblTarget.getSelectedRowsFromSelectedCells();
        int nSelectedSourceRows = aSelectedSourceRows.length;
        int nSelectedTargetRows = aSelectedTargetRows.length;
        int nTargetRows = this.m_mdlTarget.getRowCount();
        int nSourceRows = this.m_tblSource.getRowCount();
        for (iSelectedTargetRow = 0; iSelectedTargetRow < nSelectedTargetRows; ++iSelectedTargetRow) {
            int iTarget = aSelectedTargetRows[iSelectedTargetRow];
            if (iTarget == 0) {
                bFirst = true;
            }
            if (iTarget == nTargetRows - 1) {
                bLast = true;
            }
            if (bFirst && bLast) break;
        }
        if (nSelectedTargetRows == 1) {
            this.m_tblSource.convertRowIndexesToModel(aSelectedSourceRows);
            this.m_tblTarget.convertRowIndexesToModel(aSelectedTargetRows);
            WsMapping map = new WsMapping(0, aSelectedTargetRows[0]);
            for (int iSelectedSourceRow = 0; iSelectedSourceRow < nSelectedSourceRows; ++iSelectedSourceRow) {
                map.setSource(aSelectedSourceRows[iSelectedSourceRow]);
                if (!this.m_pnlMappings.mappingExists(map)) continue;
                bNoMappings = false;
                break;
            }
        }
        int nMappings = this.m_pnlMappings.getMappingsCount();
        int nSelectedMappings = this.m_pnlMappings.getSelectedMappings().size();
        boolean targetMapped = false;
        for (int i = 0; i < nMappings; ++i) {
            if (((WsMapping)this.m_pnlMappings.getMappings().get(i)).getTarget() != iSelectedTargetRow) continue;
            targetMapped = true;
        }
        boolean bNewMapping = !targetMapped && (this.m_bMultipleSourceColumnsEnabled ? nSelectedSourceRows >= 1 : nSelectedSourceRows == 1);
        this.m_actNewMapping.setEnabled(bEditable && bNewMapping && nSelectedTargetRows == 1 && bNoMappings);
        this.m_actDeleteMappings.setEnabled(bEditable && nSelectedMappings > 0);
        this.m_actCommonDelete.setEnabled(this.m_actDeleteMappings.isEnabled());
        this.m_actSelectAll.setEnabled(bEditable && nMappings >= 1);
        this.m_actQuickMap.setEnabled(bEditable && nSourceRows > 0);
    }

    private class cNewMappingAction
    extends WsAbstractAction {
        public cNewMappingAction() {
            super(bundle, "ParameterMappingPropertyTab.NewMapping", true);
            this.setMenuSupportId("newmapping");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSourceRows = ParameterMappingPropertyTab.this.m_tblSource.getSelectedRowsFromSelectedCells();
            int[] aTargetRows = ParameterMappingPropertyTab.this.m_tblTarget.getSelectedRowsFromSelectedCells();
            if (aTargetRows.length == 0) {
                return;
            }
            int iTargetModelRow = ParameterMappingPropertyTab.this.m_tblTarget.convertRowIndexToModel(aTargetRows[0]);
            int nSourceRows = aSourceRows.length;
            for (int iSourceRow = 0; iSourceRow < nSourceRows; ++iSourceRow) {
                int iSourceModelRow = ParameterMappingPropertyTab.this.m_tblSource.convertRowIndexToModel(aSourceRows[iSourceRow]);
                if (ParameterMappingPropertyTab.this.m_pnlMappings.mappingExists(iSourceModelRow, iTargetModelRow)) continue;
                ParameterMappingPropertyTab.this.m_pnlMappings.addMapping(iSourceModelRow, iTargetModelRow);
                ParameterMappingPropertyTab.this.m_pnlMappings.selectMapping(iSourceModelRow, iTargetModelRow);
            }
        }
    }

    private class cCommonDeleteAction
    extends WsAbstractAction {
        public cCommonDeleteAction() {
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            if (ParameterMappingPropertyTab.this.m_actDeleteMappings.isEnabled()) {
                ParameterMappingPropertyTab.this.m_actDeleteMappings.actionPerformed(e);
            }
        }
    }

    private class cDeleteMappingsAction
    extends WsAbstractAction {
        public cDeleteMappingsAction() {
            super(bundle, "ParameterMappingPropertyTab.DeleteMappings", true);
        }

        public void actionPerformed(ActionEvent e) {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            ParameterMappingPropertyTab.this.m_bIgnoreActionUpdates = true;
            ParameterMappingPropertyTab.this.m_pnlMappings.setAutoSelectEnabled(false);
            try {
                List lMappings = ParameterMappingPropertyTab.this.m_pnlMappings.getSelectedMappings();
                ParameterMappingPropertyTab.this.m_pnlMappings.removeMappings(lMappings);
            }
            finally {
                ParameterMappingPropertyTab.this.m_pnlMappings.setAutoSelectEnabled(true);
                ParameterMappingPropertyTab.this.m_pnlMappings.autoSelectFromMappings();
                ParameterMappingPropertyTab.this.m_bIgnoreActionUpdates = false;
                ParameterMappingPropertyTab.this.updateActions();
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class cSelectAllAction
    extends WsAbstractAction {
        public cSelectAllAction() {
            super(bundle, "ParameterMappingPropertyTab.SelectAll");
            this.setMenuSupportId("selectall");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                ParameterMappingPropertyTab.this.m_bIgnoreActionUpdates = true;
                ParameterMappingPropertyTab.this.m_pnlMappings.setAutoSelectEnabled(false);
                ParameterMappingPropertyTab.this.m_pnlMappings.selectAllMappings();
            }
            finally {
                ParameterMappingPropertyTab.this.m_pnlMappings.setAutoSelectEnabled(true);
                ParameterMappingPropertyTab.this.m_pnlMappings.autoSelectFromMappings();
                ParameterMappingPropertyTab.this.m_bIgnoreActionUpdates = false;
                ParameterMappingPropertyTab.this.updateActions();
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class cQuickMapAction
    extends WsAbstractAction {
        public cQuickMapAction() {
            super(bundle, "ParameterMappingPropertyTab.QuickMap", true);
            this.setMenuSupportId("quickmap");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            ParameterMappingPropertyTab.this.m_bIgnoreActionUpdates = true;
            ParameterMappingPropertyTab.this.quickMap();
            ParameterMappingPropertyTab.this.m_bIgnoreActionUpdates = false;
            ParameterMappingPropertyTab.this.updateActions();
        }
    }

    private class cExpandAction
    extends WsAbstractAction {
        public cExpandAction() {
            super(bundle, "ParameterMappingPropertyTab.Expand", true);
        }

        public void actionPerformed(ActionEvent e) {
            ParameterMappingPropertyTab.this.m_tblSource.clearSelection();
            ParameterMappingPropertyTab.this.m_pnlMappings.deselectAllMappings();
            ParameterMappingPropertyTab.this.removeComponents();
            ParameterMappingPropertyTab.this.m_bExpanded = true;
            ParameterMappingPropertyTab.this.updateActions();
            ParameterMappingPropertyTab.this.layoutComponentsExpanded();
            ParameterMappingPropertyTab.this.revalidate();
            ParameterMappingPropertyTab.this.repaint();
        }
    }

    private class cCollapseAction
    extends WsAbstractAction {
        public cCollapseAction() {
            super(bundle, "ParameterMappingPropertyTab.Collapse", true);
        }

        public void actionPerformed(ActionEvent e) {
            ParameterMappingPropertyTab.this.removeComponents();
            ParameterMappingPropertyTab.this.m_bExpanded = false;
            ParameterMappingPropertyTab.this.updateActions();
            ParameterMappingPropertyTab.this.layoutComponentsNormal();
            ParameterMappingPropertyTab.this.revalidate();
            ParameterMappingPropertyTab.this.repaint();
        }
    }

    private class cTableSelectionListener
    implements ListSelectionListener {
        private cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ParameterMappingPropertyTab.this.updateActions();
        }
    }

    private class cMappingsModelListener
    implements WsObjectListModelListener {
        private cMappingsModelListener() {
        }

        public void objectAdded(WsObjectListModelEvent e) {
            if (ParameterMappingPropertyTab.this.m_pnlMappings.isDragging()) {
                return;
            }
            if (!ParameterMappingPropertyTab.this.isListeningForChanges()) {
                return;
            }
            WsMapping map = (WsMapping)e.getObject();
            int iTarget = map.getTarget();
            int nMappings = ParameterMappingPropertyTab.this.m_pnlMappings.findMappingsForRow(iTarget, false).size();
            if (nMappings <= 1) {
                ParameterMappingPropertyTab.this.setDataChanged(true);
                ParameterMappingPropertyTab.this.m_pnlMappings.selectMapping(map);
            } else {
                MessageUtil.displayMessage((String)bundle.getString("ParameterMappingPropertyTab.MultipleMappingsError.txt"), (int)0);
                final WsMapping mapFinal = map;
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        ParameterMappingPropertyTab.this.m_pnlMappings.removeMapping(mapFinal);
                    }
                };
                SwingUtilities.invokeLater(run);
            }
        }

        public void objectRemoved(WsObjectListModelEvent e) {
            if (ParameterMappingPropertyTab.this.m_pnlMappings.isDragging()) {
                return;
            }
            if (ParameterMappingPropertyTab.this.isListeningForChanges()) {
                ParameterMappingPropertyTab.this.setDataChanged(true);
            }
        }
    }

    private class cMappingsSelectionListener
    implements WsObjectSelectionListener {
        private cMappingsSelectionListener() {
        }

        public void objectChangedSelection(WsObjectSelectionEvent e) {
            ParameterMappingPropertyTab.this.updateActions();
        }
    }

    private class cMappingsPanelPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private cMappingsPanelPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPop = new JPopupMenu();
            mnuPop.add(new JMenuItem((Action)ParameterMappingPropertyTab.this.m_actNewMapping));
            mnuPop.add(new JMenuItem((Action)ParameterMappingPropertyTab.this.m_actDeleteMappings));
            mnuPop.addSeparator();
            mnuPop.add(new JMenuItem((Action)ParameterMappingPropertyTab.this.m_actSelectAll));
            mnuPop.addSeparator();
            mnuPop.add(new JMenuItem((Action)ParameterMappingPropertyTab.this.m_actQuickMap));
            mnuPop.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private class cMappingsPanelSourceTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private cMappingsPanelSourceTablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPop = new JPopupMenu();
            mnuPop.add(new JMenuItem((Action)ParameterMappingPropertyTab.this.m_actNewMapping));
            mnuPop.add(new JMenuItem((Action)ParameterMappingPropertyTab.this.m_actDeleteMappings));
            mnuPop.addSeparator();
            mnuPop.add(new JMenuItem((Action)ParameterMappingPropertyTab.this.m_actSelectAll));
            mnuPop.addSeparator();
            mnuPop.add(new JMenuItem((Action)ParameterMappingPropertyTab.this.m_actQuickMap));
            mnuPop.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private class cMappingsPanelTargetTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private cMappingsPanelTargetTablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPop = new JPopupMenu();
            mnuPop.add(new JMenuItem((Action)ParameterMappingPropertyTab.this.m_actNewMapping));
            mnuPop.add(new JMenuItem((Action)ParameterMappingPropertyTab.this.m_actDeleteMappings));
            mnuPop.addSeparator();
            mnuPop.add(new JMenuItem((Action)ParameterMappingPropertyTab.this.m_actSelectAll));
            mnuPop.addSeparator();
            mnuPop.add(new JMenuItem((Action)ParameterMappingPropertyTab.this.m_actQuickMap));
            mnuPop.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private class WsQuickMapColumn {
        private String m_strName;
        private Object m_oUserValue;

        public WsQuickMapColumn(String sName, Object userValue) {
            this.m_strName = sName;
            this.m_oUserValue = userValue;
        }

        public String getColumnName() {
            return this.m_strName;
        }

        public Object getUserValue() {
            return this.m_oUserValue;
        }
    }
}

