/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.edmflow;

import com.sas.etl.models.data.edmflow.IEDMFlowVersion;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.swing.visuals.tableview.TableRowModelListener;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;

public class EDMFlowVersionSelectorDialog
extends WAStandardDialog {
    private static final WAdminResource bundle = WAdminResource.getBundle(EDMFlowVersionSelectorDialog.class);
    private static final int VISIBLE_COLUMNS = 1;
    private static final int HIDDEN_COLUMNS = 1;
    private static final int VERSION_COLUMN = 0;
    private static final int OBJECT_COLUMN = 1;
    private IEDMFlowVersion[] m_arrVersions;
    private VersionSelectorTableModel m_tableModel;
    private WsTable m_table;
    private WATextField m_txtVersion;
    private TableRowModelListener m_versionTableSelectionListener;
    private IEDMFlowVersion selectedVersion;

    public EDMFlowVersionSelectorDialog(IEDMFlowVersion[] versions) {
        super((Frame)Workspace.getWorkspace(), bundle.getString("EDMFlowVersionSelectorDialog.title.txt"), true);
        this.m_arrVersions = versions;
        this.m_versionTableSelectionListener = new VersionTableRowModelListener();
        this.addMainPanel();
        this.setHelpProduct("wdb");
        this.setHelpTopic("version_selector");
    }

    private void addMainPanel() {
        this.m_txtVersion = new WATextField();
        this.m_txtVersion.setToolTipText(bundle.getString("VersionSelectorDialog.TextField.SelectedVersion.ToolTip.txt"));
        this.m_txtVersion.setEditable(false);
        JLabel lblSelectedVersion = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtVersion, (String)bundle.getString("VersionSelectorDialog.Label.SelectedVersion.txt"));
        JButton btnClear = new JButton((Action)((Object)new cClearAction()));
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new BorderLayout(5, 5));
        selectPanel.add((Component)lblSelectedVersion, "West");
        selectPanel.add((Component)btnClear, "East");
        selectPanel.add((Component)this.m_txtVersion, "Center");
        this.m_tableModel = new VersionSelectorTableModel();
        this.m_table = new WsTable((WsAbstractTableModel)this.m_tableModel);
        this.m_table.setColumnsReorderable(false);
        this.m_table.setCellSelectionEnabled(false);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setViewportPopupMenuEnabled(false);
        this.m_table.setColumnHeaderPopupMenuEnabled(false);
        this.m_table.setOriginPopupMenuEnabled(false);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.setSelectionMode(0);
        this.m_table.hideColumn(1);
        this.m_table.setAutoResizeMode(1);
        this.m_table.setRowHeaderVisible(false);
        this.m_table.setDefaultAction((Action)new cDefaultAction());
        this.m_table.getRowModel().addRowModelListener(this.m_versionTableSelectionListener);
        JScrollPane tablePanel = new JScrollPane((Component)this.m_table);
        tablePanel.setPreferredSize(new Dimension(400, 300));
        JLabel lblVersions = WsUIUtilities.createLabelForComponent((JComponent)this.m_table, (String)bundle.getString("VersionSelectorDialog.Label.AvailableVersions.txt"));
        WAPanel panel = new WAPanel();
        panel.setLayout((LayoutManager)new GridBagLayout());
        panel.add((Component)lblVersions, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)tablePanel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)selectPanel, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.setMainPanel(panel);
        if (this.m_arrVersions != null) {
            try {
                this.m_tableModel.moveDataToModel();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected boolean onOK() {
        if (this.m_table.getSelectedRow() >= 0) {
            this.selectedVersion = this.m_arrVersions[this.m_table.convertRowIndexToModel(this.m_table.getSelectedRow())];
        }
        return super.onOK();
    }

    public IEDMFlowVersion getSelectedVersion() {
        return this.selectedVersion;
    }

    private class VersionTableRowModelListener
    implements TableRowModelListener {
        private VersionTableRowModelListener() {
        }

        public void rowMoved(TableRowModelEvent e) {
        }

        public void rowMarginChanged(ChangeEvent e) {
        }

        public void rowSelectionChanged(ListSelectionEvent e) {
            if (EDMFlowVersionSelectorDialog.this.m_table.getSelectedRow() >= 0) {
                EDMFlowVersionSelectorDialog.this.m_txtVersion.setText(EDMFlowVersionSelectorDialog.this.m_arrVersions[EDMFlowVersionSelectorDialog.this.m_table.convertRowIndexToModel(EDMFlowVersionSelectorDialog.this.m_table.getSelectedRow())].getVersion().toString());
            }
        }
    }

    protected class cClearAction
    extends WsAbstractAction {
        public cClearAction() {
            super(bundle, "VersionSelectorDialog.Action.Clear", 0);
        }

        public void actionPerformed(ActionEvent e) {
            EDMFlowVersionSelectorDialog.this.m_txtVersion.setText("");
        }
    }

    private class VersionSelectorTableModel
    extends WsAbstractTableModel {
        public VersionSelectorTableModel() {
            this.m_aColumns = new WsAbstractTableColumn[2];
            this.m_aColumns[0] = new WsStringTableColumn(0, 250);
            this.m_aColumns[0].setEditable(false);
            this.m_aColumns[1] = new WsObjectTableColumn();
            this.m_aColumns[1].setModelIndex(1);
        }

        public void populateStore() throws MdException, RemoteException {
            throw new UnsupportedOperationException("populateStore not implemented.  Model does not use a store");
        }

        public void moveDataToModel() throws MdException, RemoteException {
            this.clear();
            if (EDMFlowVersionSelectorDialog.this.m_arrVersions == null) {
                return;
            }
            for (int index = 0; index < EDMFlowVersionSelectorDialog.this.m_arrVersions.length; ++index) {
                String version = EDMFlowVersionSelectorDialog.this.m_arrVersions[index].getVersion().toString();
                ArrayList<String> row = new ArrayList<String>();
                row.add(version);
                row.add((String)EDMFlowVersionSelectorDialog.this.m_arrVersions[index]);
                this.m_lData.add(row);
                ++this.m_nRowInstances;
            }
            this.fireTableModelPopulated();
        }

        public boolean validateData() {
            return true;
        }

        public int getColumnCount() {
            return this.m_aColumns.length;
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }
    }

    private class cDefaultAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ev.getSource() == EDMFlowVersionSelectorDialog.this.m_btnOk) {
                if (EDMFlowVersionSelectorDialog.this.onOK()) {
                    EDMFlowVersionSelectorDialog.this.dispose();
                }
            } else if (EDMFlowVersionSelectorDialog.this.m_table.getSelectedRow() >= 0 && EDMFlowVersionSelectorDialog.this.onOK()) {
                EDMFlowVersionSelectorDialog.this.dispose();
            }
        }
    }
}

