/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationTableModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.util.List;

public class DataValidationInvalidTableModel
extends DataValidationTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationInvalidTableModel.class);
    static final int NUM_VISIBLE_COLUMNS = 6;
    static final int NUM_HIDDEN_COLUMNS = 5;
    private static final String m_translatedYes = bundle.getString("DataValidationInvalidTableModel.Yes.txt");
    private static final String m_translatedNo = bundle.getString("DataValidationInvalidTableModel.No.txt");
    static final int INVALID_COLUMN_NAME_INDEX = 0;
    static final int INVALID_LOOKUP_TABLE_NAME_INDEX = 1;
    static final int INVALID_LOOKUP_COLUMN_NAME_INDEX = 2;
    static final int INVALID_BLANKS_INDEX = 3;
    static final int INVALID_ACTION_INDEX = 4;
    static final int INVALID_EXPRESSION_INDEX = 5;
    static final int INVALID_CHANGE_INDEX = 6;
    static final int INVALID_COLUMN_INDEX = 7;
    static final int INVALID_LOOKUP_TABLE_INDEX = 8;
    static final int INVALID_LOOKUP_COLUMN_INDEX = 9;
    static final int INVALID_DVR_INDEX = 10;
    static final int INVALID_NUM_VALUES = 11;
    public IModelListener m_lsnrModel = new ModelListener();

    public DataValidationInvalidTableModel(DataValidationTransformModel DVTransformModel) {
        super(DVTransformModel);
        this.m_DVTransformModel.getModel().addModelListener(this.m_lsnrModel);
    }

    @Override
    public void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("DataValidationTableModel.Column.label.txt"), 150);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("DataValidationTableModel.LookupTable.label.txt"), 150);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("DataValidationTableModel.LookupColumn.label.txt"), 150);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("DataValidationTableModel.Blanks.label.txt"), 150);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("DataValidationTableModel.Invalid.Action.label.txt"), 150);
        this.m_aColumns[5] = new WsStringTableColumn(5, bundle.getString("DataValidationTableModel.Expression.label.txt"), 150);
        this.m_aColumns[6] = new WsMetadataTableColumn();
        this.m_aColumns[7] = new WsMetadataTableColumn();
        this.m_aColumns[8] = new WsMetadataTableColumn();
        this.m_aColumns[9] = new WsMetadataTableColumn();
        this.m_aColumns[10] = new WsObjectTableColumn();
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3].setEditable(false);
        this.m_aColumns[4].setEditable(false);
        this.m_aColumns[5].setEditable(false);
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getHiddenColumnCount() {
        return 5;
    }

    @Override
    public String getValidationType() {
        return "Invalid";
    }

    @Override
    public void moveDataToModel() {
        this.clear();
        List lDVRs = this.m_DVTransformModel.getModelList(this.getValidationType());
        for (int recNum = 0; recNum < lDVRs.size(); ++recNum) {
            DataValidationRecord oDVR = (DataValidationRecord)lDVRs.get(recNum);
            this.m_lData.add(this.createRowValues(oDVR));
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
    }

    @Override
    public List addRowValues(DataValidationRecord oDVR, List lRowValues) {
        return DataValidationInvalidTableModel.getRowValuesFromValidationRecord(oDVR, lRowValues);
    }

    public static String getBlanksTranslatedValue(String value) {
        if (value.equals("Yes")) {
            return m_translatedYes;
        }
        return m_translatedNo;
    }

    public static List getRowValuesFromValidationRecord(DataValidationRecord oDVR, List lRowValues) {
        lRowValues.set(7, oDVR.getColumn_FM1());
        lRowValues.set(0, oDVR.getColumn_FM1_Name());
        lRowValues.set(9, oDVR.getLookupColumn_FM2());
        if (oDVR.getLookupColumn_FM2() != null) {
            lRowValues.set(2, oDVR.getLookupColumn_FM2().getName());
            lRowValues.set(8, oDVR.getLookupColumn_FM2().getTable());
            lRowValues.set(1, oDVR.getLookupColumn_FM2().getTable().getName());
        }
        lRowValues.set(3, oDVR.getProperty_FM1_DefVal());
        lRowValues.set(4, oDVR.getAction());
        lRowValues.set(5, oDVR.getExpression());
        lRowValues.set(10, oDVR);
        return lRowValues;
    }

    @Override
    public void dispose() {
        this.m_DVTransformModel.getModel().removeModelListener(this.m_lsnrModel);
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                DataValidationInvalidTableModel.this.moveDataToModel();
            } else if (obj == DataValidationInvalidTableModel.this.m_DVTransformModel) {
                if (sType == "DVR:InvalidTypeDataValidationRecordAdded") {
                    DataValidationInvalidTableModel.this.addDVR((DataValidationRecord)ev.getData());
                } else if (sType == "DVR:InvalidTypeDataValidationRecordMoved") {
                    DataValidationInvalidTableModel.this.removeDVR((DataValidationRecord)ev.getData());
                    DataValidationInvalidTableModel.this.addDVR((DataValidationRecord)ev.getData());
                } else if (sType == "DVR:InvalidTypeDataValidationRecordRemoved") {
                    DataValidationInvalidTableModel.this.removeDVR((DataValidationRecord)ev.getData());
                }
            }
        }
    }
}

